/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.gui.book.widget;

import com.github.alexmodguy.alexscaves.client.gui.book.widget.BookWidget;
import com.github.alexmodguy.alexscaves.client.gui.book.widget.ItemWidget;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexthe666.citadel.recipe.SpecialRecipeInGuideBook;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class CraftingRecipeWidget
extends BookWidget {
    @Expose
    @SerializedName(value="recipe_id")
    private String recipeId;
    @Expose
    private boolean sepia;
    @Expose(serialize=false, deserialize=false)
    private Recipe recipe;
    private static final int GRID_TEXTURE_SIZE = 64;
    @Expose(serialize=false, deserialize=false)
    private boolean smelting = false;
    private static final ResourceLocation CRAFTING_GRID_TEXTURE = new ResourceLocation("alexscaves", "textures/gui/book/crafting_grid.png");
    private static final ResourceLocation SMELTING_GRID_TEXTURE = new ResourceLocation("alexscaves", "textures/gui/book/smelting_grid.png");

    public CraftingRecipeWidget(int displayPage, String recipeId, boolean sepia, int x, int y, float scale) {
        super(displayPage, BookWidget.Type.CRAFTING_RECIPE, x, y, scale);
        this.recipeId = recipeId;
        this.sepia = sepia;
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, float partialTicks, boolean onFlippingPage) {
        if (this.recipe == null && this.recipeId != null) {
            this.recipe = this.getRecipeByName(this.recipeId);
            if (this.recipe instanceof AbstractCookingRecipe) {
                this.smelting = true;
            }
        }
        if (this.recipe != null) {
            float itemScale = 16.0f;
            float playerTicks = Minecraft.m_91087_().f_91074_.f_19797_;
            VertexConsumer vertexconsumer = bufferSource.m_6299_(ACRenderTypes.getBookWidget(this.smelting ? SMELTING_GRID_TEXTURE : CRAFTING_GRID_TEXTURE, this.sepia));
            poseStack.m_85836_();
            poseStack.m_252880_((float)this.getX(), (float)this.getY(), 0.0f);
            poseStack.m_85841_(this.getScale(), this.getScale(), 1.0f);
            poseStack.m_85836_();
            poseStack.m_85841_(1.5f, 1.5f, 1.0f);
            PoseStack.Pose posestack$pose = poseStack.m_85850_();
            Matrix4f matrix4f = posestack$pose.m_252922_();
            Matrix3f matrix3f = posestack$pose.m_252943_();
            float scaledU1 = 0.859375f;
            float scaledV1 = 0.578125f;
            float texWidth = 27.5f;
            float texHeight = 18.5f;
            vertexconsumer.m_252986_(matrix4f, -texWidth, -texHeight, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, texWidth, -texHeight, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(scaledU1, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_7421_(0.0f, scaledV1).m_5752_();
            vertexconsumer.m_252986_(matrix4f, texWidth, texHeight, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(scaledU1, scaledV1).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, -texWidth, texHeight, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, scaledV1).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_7421_(scaledU1, 0.0f).m_5752_();
            poseStack.m_85849_();
            if (this.smelting) {
                poseStack.m_85836_();
                poseStack.m_252880_(43.0f, -15.0f, 0.0f);
                poseStack.m_85841_(1.35f, 1.35f, 1.0f);
                ItemWidget.renderItem(this.recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()), poseStack, bufferSource, this.sepia, itemScale * 1.25f);
                poseStack.m_85849_();
                Ingredient ing = (Ingredient)this.recipe.m_7527_().get(0);
                ItemStack stack = ItemStack.f_41583_;
                if (!ing.m_43947_()) {
                    if (ing.m_43908_().length > 1) {
                        int currentIndex = (int)(playerTicks / 20.0f % (float)ing.m_43908_().length);
                        stack = ing.m_43908_()[currentIndex];
                    } else {
                        stack = ing.m_43908_()[0];
                    }
                }
                poseStack.m_85836_();
                poseStack.m_252880_(-27.5f, -12.5f, 0.0f);
                ItemWidget.renderItem(stack, poseStack, bufferSource, this.sepia, itemScale);
                poseStack.m_85849_();
            } else {
                poseStack.m_85836_();
                poseStack.m_252880_(57.0f, 2.0f, 0.0f);
                poseStack.m_85841_(1.35f, 1.35f, 1.0f);
                ItemWidget.renderItem(this.recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()), poseStack, bufferSource, this.sepia, itemScale * 1.25f);
                poseStack.m_85849_();
                NonNullList ingredients = this.recipe instanceof SpecialRecipeInGuideBook ? ((SpecialRecipeInGuideBook)this.recipe).getDisplayIngredients() : this.recipe.m_7527_();
                NonNullList displayedStacks = NonNullList.m_122779_();
                int width = 3;
                int height = 3;
                Recipe recipe = this.recipe;
                if (recipe instanceof ShapedRecipe) {
                    ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                    width = shapedRecipe.m_44220_();
                    height = shapedRecipe.m_44221_();
                }
                int renderY = 0;
                int renderX = 0;
                for (int i = 0; i < ingredients.size(); ++i) {
                    Ingredient ing = (Ingredient)ingredients.get(i);
                    ItemStack stack = ItemStack.f_41583_;
                    if (!ing.m_43947_()) {
                        if (ing.m_43908_().length > 1) {
                            int currentIndex = (int)(playerTicks / 20.0f % (float)ing.m_43908_().length);
                            stack = ing.m_43908_()[currentIndex];
                        } else {
                            stack = ing.m_43908_()[0];
                        }
                    }
                    if (i % width == 0) {
                        if (i != 0) {
                            ++renderY;
                        }
                        renderX = 0;
                    } else {
                        ++renderX;
                    }
                    if (!stack.m_41619_()) {
                        poseStack.m_85836_();
                        poseStack.m_252880_(-33.0f + (float)renderX * 18.75f, -18.5f + (float)renderY * 19.5f, 0.0f);
                        ItemWidget.renderItem(stack, poseStack, bufferSource, this.sepia, itemScale);
                        poseStack.m_85849_();
                    }
                    displayedStacks.add(i, (Object)stack);
                }
            }
            poseStack.m_85849_();
        }
    }

    private Recipe getRecipeByName(String registryName) {
        try {
            RecipeManager manager = Minecraft.m_91087_().f_91073_.m_7465_();
            if (manager.m_44043_(new ResourceLocation(registryName)).isPresent()) {
                return (Recipe)manager.m_44043_(new ResourceLocation(registryName)).get();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

