/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.upgrade;

import com.rekindled.embers.api.event.EmberEvent;
import com.rekindled.embers.api.event.UpgradeEvent;
import com.rekindled.embers.api.upgrades.UpgradeContext;
import com.rekindled.embers.particle.GlowParticleOptions;
import com.rekindled.embers.upgrade.DefaultUpgradeProvider;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class HeatExchangerUpgrade
extends DefaultUpgradeProvider {
    public static double multitplier = 0.9;
    public static double bonus = 300.0;

    public HeatExchangerUpgrade(BlockEntity tile) {
        super(new ResourceLocation("embers", "heat_exchanger"), tile);
    }

    @Override
    public int getPriority() {
        return -90;
    }

    @Override
    public double transformEmberProduction(BlockEntity tile, double ember, int distance, int count) {
        return ember * multitplier + bonus;
    }

    @Override
    public void throwEvent(BlockEntity tile, List<UpgradeContext> upgrades, UpgradeEvent event, int distance, int count) {
        Level level;
        EmberEvent emberEvent;
        if (event instanceof EmberEvent && (emberEvent = (EmberEvent)event).getType() == EmberEvent.EnumType.PRODUCE && (level = tile.m_58904_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)new GlowParticleOptions(GlowParticleOptions.EMBER_COLOR, new Vec3(0.0, 1.0E-6, 0.0), 2.0f, 40), (double)this.tile.m_58899_().m_123341_() + 0.5, (double)this.tile.m_58899_().m_123342_() + 0.5, (double)this.tile.m_58899_().m_123343_() + 0.5, 40, (double)0.12f, (double)0.12f, (double)0.12f, 0.0);
        }
    }
}

