/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.rekindled.embers.recipe.FluidIngredient;
import com.rekindled.embers.recipe.IStampingRecipe;
import com.rekindled.embers.recipe.StampingContext;
import com.rekindled.embers.util.Misc;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;

public class StampingRecipe
implements IStampingRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    public final ResourceLocation id;
    public final Ingredient stamp;
    public final Ingredient input;
    public final FluidIngredient fluid;
    public final Either<ItemStack, TagAmount> output;

    public StampingRecipe(ResourceLocation id, Ingredient stamp, Ingredient input, FluidIngredient fluid, TagAmount output) {
        this(id, stamp, input, fluid, (Either<ItemStack, TagAmount>)Either.right((Object)output));
    }

    public StampingRecipe(ResourceLocation id, Ingredient stamp, Ingredient input, FluidIngredient fluid, ItemStack output) {
        this(id, stamp, input, fluid, (Either<ItemStack, TagAmount>)Either.left((Object)output));
    }

    public StampingRecipe(ResourceLocation id, Ingredient stamp, Ingredient input, FluidIngredient fluid, Either<ItemStack, TagAmount> output) {
        this.id = id;
        this.stamp = stamp;
        this.input = input;
        this.fluid = fluid;
        this.output = output;
    }

    public boolean matches(StampingContext context, Level pLevel) {
        for (int i = 0; i < context.m_6643_(); ++i) {
            if (!this.input.test(context.m_8020_(i))) continue;
            return this.stamp.test(context.stamp) && this.fluid.test(context.fluids.getFluidInTank(0));
        }
        return false;
    }

    @Override
    public ItemStack getOutput(RecipeWrapper context) {
        return this.getResultItem();
    }

    public ItemStack assemble(StampingContext context, RegistryAccess registry) {
        for (int i = 0; i < context.m_6643_(); ++i) {
            if (!this.input.test(context.m_8020_(i))) continue;
            context.m_7407_(i, 1);
            break;
        }
        for (FluidStack stack : this.fluid.getAllFluids()) {
            if (!this.fluid.test(context.fluids.drain(stack, IFluidHandler.FluidAction.SIMULATE))) continue;
            context.fluids.drain(stack, IFluidHandler.FluidAction.EXECUTE);
            break;
        }
        return this.getOutput(context);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Override
    public ItemStack getResultItem() {
        if (this.output.left().isPresent()) {
            return ((ItemStack)this.output.left().get()).m_41777_();
        }
        return new ItemStack((ItemLike)Misc.getTaggedItem(((TagAmount)this.output.right().get()).tag), ((TagAmount)this.output.right().get()).amount);
    }

    @Override
    public FluidIngredient getDisplayInputFluid() {
        return this.fluid;
    }

    @Override
    public Ingredient getDisplayInput() {
        return this.input;
    }

    @Override
    public Ingredient getDisplayStamp() {
        return this.stamp;
    }

    public static class Serializer
    implements RecipeSerializer<StampingRecipe> {
        public StampingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonObject outputJson;
            Ingredient stamp = Ingredient.m_43917_((JsonElement)json.get("stamp"));
            Ingredient input = Ingredient.f_43901_;
            FluidIngredient fluid = FluidIngredient.EMPTY;
            if (json.has("input")) {
                input = Ingredient.m_43917_((JsonElement)json.get("input"));
            }
            if (json.has("fluid")) {
                fluid = FluidIngredient.deserialize(json, "fluid");
            }
            if ((outputJson = GsonHelper.m_13930_((JsonObject)json, (String)"output")).has("tag")) {
                TagAmount output = new TagAmount((TagKey<Item>)ItemTags.create((ResourceLocation)new ResourceLocation(GsonHelper.m_13906_((JsonObject)outputJson, (String)"tag"))), GsonHelper.m_13824_((JsonObject)outputJson, (String)"count", (int)1));
                return new StampingRecipe(recipeId, stamp, input, fluid, output);
            }
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)outputJson);
            return new StampingRecipe(recipeId, stamp, input, fluid, output);
        }

        @Nullable
        public StampingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient stamp = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            FluidIngredient fluid = FluidIngredient.read(buffer);
            if (buffer.readBoolean()) {
                TagAmount output = new TagAmount((TagKey<Item>)ItemTags.create((ResourceLocation)buffer.m_130281_()), buffer.readInt());
                return new StampingRecipe(recipeId, stamp, input, fluid, output);
            }
            ItemStack output = buffer.m_130267_();
            return new StampingRecipe(recipeId, stamp, input, fluid, output);
        }

        public void toNetwork(FriendlyByteBuf buffer, StampingRecipe recipe) {
            recipe.stamp.m_43923_(buffer);
            recipe.input.m_43923_(buffer);
            recipe.fluid.write(buffer);
            if (recipe.output.right().isPresent()) {
                buffer.writeBoolean(true);
                buffer.m_130085_(((TagAmount)recipe.output.right().get()).tag.f_203868_());
                buffer.writeInt(((TagAmount)recipe.output.right().get()).amount);
            } else {
                buffer.writeBoolean(false);
                buffer.writeItemStack((ItemStack)recipe.output.left().get(), false);
            }
        }
    }

    public static class TagAmount {
        public TagKey<Item> tag;
        public int amount;

        public TagAmount(TagKey<Item> tag, int amount) {
            this.tag = tag;
            this.amount = amount;
        }
    }
}

