/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.item;

import com.rekindled.embers.ConfigManager;
import com.rekindled.embers.api.event.EmberProjectileEvent;
import com.rekindled.embers.api.event.ItemVisualEvent;
import com.rekindled.embers.api.item.IProjectileWeapon;
import com.rekindled.embers.api.projectile.EffectArea;
import com.rekindled.embers.api.projectile.EffectDamage;
import com.rekindled.embers.api.projectile.IProjectilePreset;
import com.rekindled.embers.api.projectile.ProjectileFireball;
import com.rekindled.embers.damage.DamageEmber;
import com.rekindled.embers.datagen.EmbersDamageTypes;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.particle.GlowParticleOptions;
import com.rekindled.embers.util.EmberInventoryUtil;
import com.rekindled.embers.util.Misc;
import java.awt.Color;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.joml.Vector3f;

public class CinderStaffItem
extends Item
implements IProjectileWeapon {
    public static boolean soundPlaying = false;
    public static Random rand = new Random();

    public CinderStaffItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (!level.f_46443_) {
            double charge = (double)Math.min((Integer)ConfigManager.CINDER_STAFF_MAX_CHARGE.get(), this.m_8105_(stack) - timeLeft) / (double)((Integer)ConfigManager.CINDER_STAFF_MAX_CHARGE.get()).intValue();
            Vec3 launchPos = CinderStaffItem.getLaunchPos(entity);
            float damage = (float)Math.max(charge * (Double)ConfigManager.CINDER_STAFF_DAMAGE.get(), 0.5);
            float size = (float)Math.max(charge * (Double)ConfigManager.CINDER_STAFF_SIZE.get(), 0.5);
            float aoeSize = (float)(charge * (Double)ConfigManager.CINDER_STAFF_AOE_SIZE.get());
            int lifetime = charge >= 0.06 ? (Integer)ConfigManager.CINDER_STAFF_LIFETIME.get() : 5;
            Function<Entity, DamageSource> damageSource = e -> new DamageEmber((Holder<DamageType>)((Registry)level.m_9598_().m_6632_(Registries.f_268580_).get()).m_246971_(EmbersDamageTypes.EMBER_KEY), (Entity)e, (Entity)entity);
            EffectArea effect = new EffectArea(new EffectDamage(damage, damageSource, 1, 1.0), aoeSize, false);
            ProjectileFireball fireball = new ProjectileFireball((Entity)entity, launchPos, entity.m_20154_().m_82490_(0.85), size, lifetime, effect);
            EmberProjectileEvent event = new EmberProjectileEvent(entity, stack, charge, fireball);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                for (IProjectilePreset projectile : event.getProjectiles()) {
                    projectile.shoot(level);
                }
            }
            SoundEvent sound = charge * (Double)ConfigManager.CINDER_STAFF_DAMAGE.get() >= 10.0 ? (SoundEvent)EmbersSounds.FIREBALL_BIG.get() : (charge * (Double)ConfigManager.CINDER_STAFF_DAMAGE.get() >= 1.0 ? (SoundEvent)EmbersSounds.FIREBALL.get() : (SoundEvent)EmbersSounds.CINDER_STAFF_FAIL.get());
            level.m_6263_(null, launchPos.f_82479_, launchPos.f_82480_, launchPos.f_82481_, sound, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        stack.m_41784_().m_128356_("lastUse", level.m_46467_());
        entity.m_6674_(entity.m_7655_());
        entity.m_5810_();
    }

    public void m_5929_(Level level, LivingEntity player, ItemStack stack, int count) {
        double charge;
        if (!(!stack.m_41782_() || stack.m_41783_().m_128454_("lastUse") + (long)((Integer)ConfigManager.CINDER_STAFF_COOLDOWN.get()).intValue() <= level.m_46467_() || player instanceof Player && ((Player)player).m_7500_())) {
            player.m_5810_();
        }
        boolean fullCharge = (charge = (double)Math.min((Integer)ConfigManager.CINDER_STAFF_MAX_CHARGE.get(), this.m_8105_(stack) - count) / (double)((Integer)ConfigManager.CINDER_STAFF_MAX_CHARGE.get()).intValue()) >= 1.0;
        ItemVisualEvent event = new ItemVisualEvent(player, Misc.handToSlot(player.m_7655_()), stack, new Color(255, 64, 16), fullCharge ? (SoundEvent)EmbersSounds.CINDER_STAFF_LOOP.get() : null, 1.0f, 1.0f, "charge");
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.hasSound()) {
            if (!soundPlaying) {
                if (level.m_5776_()) {
                    EmbersSounds.playItemSoundClient(player, this, event.getSound(), SoundSource.PLAYERS, true, event.getVolume(), event.getPitch());
                }
                soundPlaying = true;
            }
        } else {
            soundPlaying = false;
        }
        if (event.hasParticles()) {
            Color color = event.getColor();
            Vec3 launchPos = CinderStaffItem.getLaunchPos(player);
            GlowParticleOptions options = new GlowParticleOptions(new Vector3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f), (float)(charge * (Double)ConfigManager.CINDER_STAFF_SIZE.get() / 2.0), 24);
            for (int i = 0; i < 4; ++i) {
                level.m_7106_((ParticleOptions)options, (double)((float)launchPos.f_82479_ + (rand.nextFloat() * 0.1f - 0.05f)), (double)((float)launchPos.f_82480_ + (rand.nextFloat() * 0.1f - 0.05f)), (double)((float)launchPos.f_82481_ + (rand.nextFloat() * 0.1f - 0.05f)), 0.0, 1.0E-6, 0.0);
            }
        }
    }

    public static Vec3 getLaunchPos(LivingEntity entity) {
        float spawnDistance = 2.0f;
        Vec3 eyesPos = entity.m_146892_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BlockHitResult traceResult = CinderStaffItem.m_41435_((Level)entity.m_9236_(), (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (traceResult.m_6662_() == HitResult.Type.BLOCK) {
                spawnDistance = (float)Math.min((double)spawnDistance, traceResult.m_82450_().m_82554_(eyesPos));
            }
        }
        Vec3 look = entity.m_20154_().m_82549_(entity.m_20289_(1.0f).m_82490_(0.2));
        double handmod = entity.m_7655_() == InteractionHand.MAIN_HAND ? 1.0 : -1.0;
        return new Vec3(entity.m_20185_() + look.f_82479_ * (double)spawnDistance + (handmod *= entity.m_5737_() == HumanoidArm.RIGHT ? 1.0 : -1.0) * ((double)entity.m_20205_() / 1.5) * Math.sin(Math.toRadians(-entity.m_6080_() - 90.0f)), entity.m_20186_() + (double)entity.m_20192_() + look.f_82480_ * (double)spawnDistance, entity.m_20189_() + look.f_82481_ * (double)spawnDistance + handmod * ((double)entity.m_20205_() / 1.5) * Math.cos(Math.toRadians(-entity.m_6080_() - 90.0f)));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !ItemStack.m_41728_((ItemStack)oldStack, (ItemStack)newStack);
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41782_() || stack.m_41783_().m_128454_("lastUse") + (long)((Integer)ConfigManager.CINDER_STAFF_COOLDOWN.get()).intValue() <= level.m_46467_() || player.m_7500_()) {
            if (EmberInventoryUtil.getEmberTotal(player) >= (Double)ConfigManager.CINDER_STAFF_COST.get() || player.m_7500_()) {
                EmberInventoryUtil.removeEmber(player, (Double)ConfigManager.CINDER_STAFF_COST.get());
                player.m_6672_(hand);
                if (level.m_5776_()) {
                    EmbersSounds.playItemSoundClient((LivingEntity)player, this, (SoundEvent)EmbersSounds.CINDER_STAFF_CHARGE.get(), SoundSource.PLAYERS, false, 1.0f, 1.0f);
                } else {
                    EmbersSounds.playItemSound((LivingEntity)player, this, (SoundEvent)EmbersSounds.CINDER_STAFF_CHARGE.get(), SoundSource.PLAYERS, false, 1.0f, 1.0f);
                }
                return InteractionResultHolder.m_19096_((Object)stack);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }
}

