/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.entity;

import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.power.IEmberCapability;
import com.rekindled.embers.api.power.IEmberPacketReceiver;
import com.rekindled.embers.entity.EmberProjectileEntity;
import com.rekindled.embers.particle.GlowParticleOptions;
import com.rekindled.embers.particle.StarParticleOptions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EmberPacketEntity
extends Entity {
    public BlockPos pos = new BlockPos(0, 0, 0);
    public BlockPos dest = new BlockPos(0, 0, 0);
    public double value = 0.0;
    public static final EntityDataAccessor<Integer> lifetime = SynchedEntityData.m_135353_(EmberProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public EmberPacketEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_20242_(true);
        this.m_20331_(true);
        this.f_19794_ = true;
    }

    public void initCustom(BlockPos pos, BlockPos dest, double vx, double vy, double vz, double value) {
        this.m_6027_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        this.m_20334_(vx, vy, vz);
        this.dest = dest;
        this.pos = pos;
        this.value = value;
    }

    public void setLifetime(int time) {
        this.m_20088_().m_135381_(lifetime, (Object)time);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(lifetime, (Object)80);
    }

    protected void m_7378_(CompoundTag nbt) {
        if (nbt.m_128441_("destX")) {
            this.dest = new BlockPos(nbt.m_128451_("destX"), nbt.m_128451_("destY"), nbt.m_128451_("destZ"));
        }
        this.value = nbt.m_128459_("value");
        this.m_20088_().m_135381_(lifetime, (Object)nbt.m_128451_("lifetime"));
    }

    protected void m_7380_(CompoundTag nbt) {
        if (this.dest != null) {
            nbt.m_128405_("destX", this.dest.m_123341_());
            nbt.m_128405_("destY", this.dest.m_123342_());
            nbt.m_128405_("destZ", this.dest.m_123343_());
        }
        nbt.m_128347_("value", this.value);
        nbt.m_128405_("lifetime", ((Integer)this.m_20088_().m_135370_(lifetime)).intValue());
    }

    public void m_8119_() {
        Level level;
        int lifetime = (Integer)this.m_20088_().m_135370_(EmberPacketEntity.lifetime);
        this.m_20088_().m_135381_(EmberPacketEntity.lifetime, (Object)(lifetime - 1));
        if (lifetime == 79 && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)new StarParticleOptions(GlowParticleOptions.EMBER_COLOR, 3.5f + 0.5f * this.f_19796_.m_188501_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 12, (double)(0.0125f * (this.f_19796_.m_188501_() - 0.5f)), (double)(0.0125f * (this.f_19796_.m_188501_() - 0.5f)), (double)(0.0125f * (this.f_19796_.m_188501_() - 0.5f)), 0.0);
        }
        if (--lifetime <= 0) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (!this.m_213877_()) {
            Vec3 oldPosition = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
            if (this.dest.m_123341_() != 0 || this.dest.m_123342_() != 0 || this.dest.m_123343_() != 0) {
                double targetX = (double)this.dest.m_123341_() + 0.5;
                double targetY = (double)this.dest.m_123342_() + 0.5;
                double targetZ = (double)this.dest.m_123343_() + 0.5;
                Vec3 targetVector = new Vec3(targetX - this.m_20185_(), targetY - this.m_20186_(), targetZ - this.m_20189_());
                double length = targetVector.m_82553_();
                targetVector = targetVector.m_82490_(0.3 / length);
                double weight = 0.0;
                if (length <= 3.0) {
                    weight = 0.9 * ((3.0 - length) / 3.0);
                }
                this.m_20334_((0.9 - weight) * this.m_20184_().f_82479_ + (0.1 + weight) * targetVector.f_82479_, (0.9 - weight) * this.m_20184_().f_82480_ + (0.1 + weight) * targetVector.f_82480_, (0.9 - weight) * this.m_20184_().f_82481_ + (0.1 + weight) * targetVector.f_82481_);
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            BlockPos pos = this.m_20183_();
            if (this.m_20185_() > (double)pos.m_123341_() + 0.25 && this.m_20185_() < (double)pos.m_123341_() + 0.75 && this.m_20186_() > (double)pos.m_123342_() + 0.25 && this.m_20186_() < (double)pos.m_123342_() + 0.75 && this.m_20189_() > (double)pos.m_123343_() + 0.25 && this.m_20189_() < (double)pos.m_123343_() + 0.75) {
                this.affectTileEntity(this.m_9236_().m_8055_(this.m_20183_()), this.m_9236_().m_7702_(this.m_20183_()));
            }
            if (this.m_9236_().m_5776_() && lifetime != 80) {
                double deltaX = this.m_20185_() - oldPosition.f_82479_;
                double deltaY = this.m_20186_() - oldPosition.f_82480_;
                double deltaZ = this.m_20189_() - oldPosition.f_82481_;
                double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 20.0);
                for (double i = 0.0; i < dist; i += 1.0) {
                    double coeff = i / dist;
                    this.m_9236_().m_7106_((ParticleOptions)GlowParticleOptions.EMBER, oldPosition.f_82479_ + deltaX * coeff, oldPosition.f_82480_ + deltaY * coeff, oldPosition.f_82481_ + deltaZ * coeff, (double)(0.125f * (this.f_19796_.m_188501_() - 0.5f)), (double)(0.125f * (this.f_19796_.m_188501_() - 0.5f)), (double)(0.125f * (this.f_19796_.m_188501_() - 0.5f)));
                }
            }
        }
    }

    public void affectTileEntity(BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof IEmberPacketReceiver && (Integer)this.m_20088_().m_135370_(lifetime) > 1 && ((IEmberPacketReceiver)blockEntity).onReceive(this)) {
            IEmberCapability capability = (IEmberCapability)blockEntity.getCapability(EmbersCapabilities.EMBER_CAPABILITY).orElse(null);
            if (capability != null) {
                capability.addAmount(this.value, true);
                blockEntity.m_6596_();
            }
            this.m_20334_(0.0, 0.0, 0.0);
            this.m_20088_().m_135381_(lifetime, (Object)2);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

