/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.datagen;

import com.google.common.collect.ImmutableList;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.compat.curios.CuriosCompat;
import com.rekindled.embers.datagen.EmbersBlockTags;
import com.rekindled.embers.datagen.EmbersFluidTags;
import com.rekindled.embers.datagen.EmbersItemTags;
import com.rekindled.embers.recipe.AlchemyRecipeBuilder;
import com.rekindled.embers.recipe.AnvilAugmentRecipeBuilder;
import com.rekindled.embers.recipe.AnvilAugmentRemoveRecipe;
import com.rekindled.embers.recipe.AnvilBreakdownRecipe;
import com.rekindled.embers.recipe.AnvilRepairMateriaRecipe;
import com.rekindled.embers.recipe.AnvilRepairRecipe;
import com.rekindled.embers.recipe.AugmentIngredient;
import com.rekindled.embers.recipe.BoilingRecipeBuilder;
import com.rekindled.embers.recipe.BoringRecipeBuilder;
import com.rekindled.embers.recipe.CatalysisCombustionRecipeBuilder;
import com.rekindled.embers.recipe.EmberActivationRecipeBuilder;
import com.rekindled.embers.recipe.GaseousFuelRecipeBuilder;
import com.rekindled.embers.recipe.GemSocketRecipeBuilder;
import com.rekindled.embers.recipe.GemUnsocketRecipe;
import com.rekindled.embers.recipe.GenericRecipeBuilder;
import com.rekindled.embers.recipe.HeatIngredient;
import com.rekindled.embers.recipe.MeltingRecipeBuilder;
import com.rekindled.embers.recipe.MetalCoefficientRecipeBuilder;
import com.rekindled.embers.recipe.MixingRecipeBuilder;
import com.rekindled.embers.recipe.StampingRecipeBuilder;
import com.rekindled.embers.util.ConsumerWrapperBuilder;
import com.rekindled.embers.util.MeltingBonus;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.DifferenceIngredient;
import net.minecraftforge.common.crafting.IntersectionIngredient;
import net.minecraftforge.common.crafting.conditions.AndCondition;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;

public class EmbersRecipes
extends RecipeProvider
implements IConditionBuilder {
    public static String boringFolder = "boring";
    public static String activationFolder = "ember_activation";
    public static String meltingFolder = "melting";
    public static String stampingFolder = "stamping";
    public static String mixingFolder = "mixing";
    public static String coefficientFolder = "metal_coefficient";
    public static String alchemyFolder = "alchemy";
    public static String boilingFolder = "boiling";
    public static String gaseousFuelFolder = "gas_fuel";
    public static String catalysisFolder = "catalysis";
    public static String combustionFolder = "combustion";
    public static String anvilFolder = "dawnstone_anvil";

    public EmbersRecipes(PackOutput gen) {
        super(gen);
    }

    public void m_245200_(Consumer<FinishedRecipe> consumer) {
        BoringRecipeBuilder.create((Item)RegistryManager.EMBER_CRYSTAL.get()).folder(boringFolder).dimension(Level.f_46428_.m_135782_()).require(EmbersBlockTags.WORLD_BOTTOM, 3).weight(20).maxHeight(-57).save(consumer);
        BoringRecipeBuilder.create((Item)RegistryManager.EMBER_SHARD.get()).folder(boringFolder).dimension(Level.f_46428_.m_135782_()).require(EmbersBlockTags.WORLD_BOTTOM, 3).weight(60).maxHeight(-57).save(consumer);
        BoringRecipeBuilder.create((Item)RegistryManager.EMBER_GRIT.get()).folder(boringFolder).dimension(Level.f_46428_.m_135782_()).require(EmbersBlockTags.WORLD_BOTTOM, 3).weight(20).maxHeight(-57).save(consumer);
        BoringRecipeBuilder.create((Item)RegistryManager.EMBER_CRYSTAL.get()).folder(boringFolder + "/nether").dimension(Level.f_46429_.m_135782_()).require(EmbersBlockTags.WORLD_BOTTOM, 3).weight(20).maxHeight(7).save(consumer);
        BoringRecipeBuilder.create((Item)RegistryManager.EMBER_SHARD.get()).folder(boringFolder + "/nether").dimension(Level.f_46429_.m_135782_()).require(EmbersBlockTags.WORLD_BOTTOM, 3).weight(60).maxHeight(7).save(consumer);
        BoringRecipeBuilder.create((Item)RegistryManager.EMBER_GRIT.get()).folder(boringFolder + "/nether").dimension(Level.f_46429_.m_135782_()).require(EmbersBlockTags.WORLD_BOTTOM, 3).weight(20).maxHeight(7).save(consumer);
        BoringRecipeBuilder.create(Items.f_41832_).folder(boringFolder).require((TagKey<Block>)Tags.Blocks.GRAVEL, 5).chance(0.9).weight(50).type((RecipeSerializer)RegistryManager.EXCAVATION_SERIALIZER.get()).save(consumer);
        BoringRecipeBuilder.create(Items.f_42484_).folder(boringFolder).require((TagKey<Block>)Tags.Blocks.GRAVEL, 5).chance(1.0).weight(5).type((RecipeSerializer)RegistryManager.EXCAVATION_SERIALIZER.get()).save(consumer);
        BoringRecipeBuilder.create(Items.f_42452_).folder(boringFolder).require(EmbersBlockTags.SNOW, 5).chance(0.9).weight(50).type((RecipeSerializer)RegistryManager.EXCAVATION_SERIALIZER.get()).save(consumer);
        EmberActivationRecipeBuilder.create((Item)RegistryManager.EMBER_CRYSTAL.get()).folder(activationFolder).ember(2400).save(consumer);
        EmberActivationRecipeBuilder.create((Item)RegistryManager.EMBER_SHARD.get()).folder(activationFolder).ember(400).save(consumer);
        EmberActivationRecipeBuilder.create((Item)RegistryManager.EMBER_GRIT.get()).folder(activationFolder).ember(0).save(consumer);
        EmberActivationRecipeBuilder.create((Item)RegistryManager.EMBER_CRYSTAL_CLUSTER.get()).folder(activationFolder).ember(4400).save(consumer);
        this.fullOreRecipes("lead", (ImmutableList<ItemLike>)ImmutableList.of((Object)((ItemLike)RegistryManager.LEAD_ORE_ITEM.get()), (Object)((ItemLike)RegistryManager.DEEPSLATE_LEAD_ORE_ITEM.get()), (Object)((ItemLike)RegistryManager.RAW_LEAD.get())), (Fluid)RegistryManager.MOLTEN_LEAD.FLUID.get(), (Item)RegistryManager.RAW_LEAD.get(), (Item)RegistryManager.RAW_LEAD_BLOCK_ITEM.get(), (Item)RegistryManager.LEAD_BLOCK_ITEM.get(), (Item)RegistryManager.LEAD_INGOT.get(), (Item)RegistryManager.LEAD_NUGGET.get(), (Item)RegistryManager.LEAD_PLATE.get(), consumer, MeltingBonus.SILVER);
        this.fullOreRecipes("silver", (ImmutableList<ItemLike>)ImmutableList.of((Object)((ItemLike)RegistryManager.SILVER_ORE_ITEM.get()), (Object)((ItemLike)RegistryManager.DEEPSLATE_SILVER_ORE_ITEM.get()), (Object)((ItemLike)RegistryManager.RAW_SILVER.get())), (Fluid)RegistryManager.MOLTEN_SILVER.FLUID.get(), (Item)RegistryManager.RAW_SILVER.get(), (Item)RegistryManager.RAW_SILVER_BLOCK_ITEM.get(), (Item)RegistryManager.SILVER_BLOCK_ITEM.get(), (Item)RegistryManager.SILVER_INGOT.get(), (Item)RegistryManager.SILVER_NUGGET.get(), (Item)RegistryManager.SILVER_PLATE.get(), consumer, MeltingBonus.LEAD);
        this.fullMetalRecipes("dawnstone", (Fluid)RegistryManager.MOLTEN_DAWNSTONE.FLUID.get(), (Item)RegistryManager.DAWNSTONE_BLOCK_ITEM.get(), (Item)RegistryManager.DAWNSTONE_INGOT.get(), (Item)RegistryManager.DAWNSTONE_NUGGET.get(), (Item)RegistryManager.DAWNSTONE_PLATE.get(), consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_151052_).m_126130_("XXX").m_126130_("XXX").m_126130_("XXX").m_206416_(Character.valueOf('X'), this.itemTag("forge", "nuggets/copper")).m_126132_("has_nugget", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "nuggets/copper"))).m_126140_(consumer, EmbersRecipes.getResource("copper_nugget_to_ingot"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.COPPER_NUGGET.get()), (int)9).m_206419_(this.itemTag("forge", "ingots/copper")).m_126145_("").m_126132_("has_ingot", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "ingots/copper"))).m_126140_(consumer, EmbersRecipes.getResource("copper_ingot_to_nugget"));
        this.plateHammerRecipe("iron", (Item)RegistryManager.IRON_PLATE.get(), consumer);
        this.plateHammerRecipe("copper", (Item)RegistryManager.COPPER_PLATE.get(), consumer);
        this.fullOreMeltingStampingRecipes("iron", (Fluid)RegistryManager.MOLTEN_IRON.FLUID.get(), consumer, MeltingBonus.NICKEL, MeltingBonus.ALUMINUM, MeltingBonus.COPPER);
        this.fullOreMeltingStampingRecipes("gold", (Fluid)RegistryManager.MOLTEN_GOLD.FLUID.get(), consumer, MeltingBonus.SILVER);
        this.fullOreMeltingStampingRecipes("copper", (Fluid)RegistryManager.MOLTEN_COPPER.FLUID.get(), consumer, MeltingBonus.GOLD);
        this.fullOreMeltingStampingRecipes("nickel", (Fluid)RegistryManager.MOLTEN_NICKEL.FLUID.get(), consumer, MeltingBonus.IRON);
        this.fullOreMeltingStampingRecipes("tin", (Fluid)RegistryManager.MOLTEN_TIN.FLUID.get(), consumer, MeltingBonus.LEAD);
        this.fullOreMeltingStampingRecipes("aluminum", (Fluid)RegistryManager.MOLTEN_ALUMINUM.FLUID.get(), consumer, MeltingBonus.IRON);
        this.fullOreMeltingStampingRecipes("zinc", (Fluid)RegistryManager.MOLTEN_ZINC.FLUID.get(), consumer, MeltingBonus.TIN, MeltingBonus.IRON);
        this.fullOreMeltingStampingRecipes("platinum", (Fluid)RegistryManager.MOLTEN_PLATINUM.FLUID.get(), consumer, MeltingBonus.GOLD);
        this.fullOreMeltingStampingRecipes("uranium", (Fluid)RegistryManager.MOLTEN_URANIUM.FLUID.get(), consumer, MeltingBonus.LEAD);
        this.fullMeltingStampingRecipes("bronze", (Fluid)RegistryManager.MOLTEN_BRONZE.FLUID.get(), consumer);
        this.fullMeltingStampingRecipes("electrum", (Fluid)RegistryManager.MOLTEN_ELECTRUM.FLUID.get(), consumer);
        this.fullMeltingStampingRecipes("brass", (Fluid)RegistryManager.MOLTEN_BRASS.FLUID.get(), consumer);
        this.fullMeltingStampingRecipes("constantan", (Fluid)RegistryManager.MOLTEN_CONSTANTAN.FLUID.get(), consumer);
        this.fullMeltingStampingRecipes("invar", (Fluid)RegistryManager.MOLTEN_INVAR.FLUID.get(), consumer);
        MeltingRecipeBuilder.create(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42049_, Items.f_42050_})).id(new ResourceLocation("embers", meltingFolder + "/soul_crude")).output((Fluid)RegistryManager.SOUL_CRUDE.FLUID.get(), 100).save(consumer);
        MeltingRecipeBuilder.create(Items.f_42452_).id(new ResourceLocation("embers", meltingFolder + "/snow_melting")).output((Fluid)Fluids.f_76193_, 250).save(consumer);
        StampingRecipeBuilder.create((Item)RegistryManager.EMBER_GRIT.get()).domain("embers").folder(stampingFolder).stamp((ItemLike)RegistryManager.FLAT_STAMP.get()).input((ItemLike)RegistryManager.EMBER_SHARD.get()).save(ConsumerWrapperBuilder.wrap().build(consumer));
        StampingRecipeBuilder.create(new ItemStack((ItemLike)RegistryManager.EMBER_SHARD.get(), 6)).domain("embers").folder(stampingFolder).stamp((ItemLike)RegistryManager.FLAT_STAMP.get()).input((ItemLike)RegistryManager.EMBER_CRYSTAL.get()).save(ConsumerWrapperBuilder.wrap().build(consumer));
        StampingRecipeBuilder.create(new ItemStack((ItemLike)RegistryManager.ASH.get(), 8)).domain("embers").folder(stampingFolder).stamp((ItemLike)RegistryManager.FLAT_STAMP.get()).input((ItemLike)RegistryManager.ALCHEMICAL_WASTE.get()).save(ConsumerWrapperBuilder.wrap().build(consumer));
        StampingRecipeBuilder.create(new ItemStack((ItemLike)Items.f_42593_, 4)).domain("embers").folder(stampingFolder).stamp((ItemLike)RegistryManager.FLAT_STAMP.get()).input((TagKey<Item>)Tags.Items.RODS_BLAZE).save(ConsumerWrapperBuilder.wrap().build(consumer));
        StampingRecipeBuilder.create(Items.f_41830_).domain("embers").folder(stampingFolder).stamp((ItemLike)RegistryManager.FLAT_STAMP.get()).input(new ItemLike[]{Items.f_41832_}).save(ConsumerWrapperBuilder.wrap().build(consumer));
        StampingRecipeBuilder.create((Item)RegistryManager.IRON_ASPECTUS.get()).domain("embers").folder(stampingFolder).stamp((ItemLike)RegistryManager.INGOT_STAMP.get()).input((ItemLike)RegistryManager.EMBER_SHARD.get()).fluid(this.fluidTag("forge", "molten_iron"), 90).save(ConsumerWrapperBuilder.wrap().build(consumer));
        StampingRecipeBuilder.create((Item)RegistryManager.COPPER_ASPECTUS.get()).domain("embers").folder(stampingFolder).stamp((ItemLike)RegistryManager.INGOT_STAMP.get()).input((ItemLike)RegistryManager.EMBER_SHARD.get()).fluid(this.fluidTag("forge", "molten_copper"), 90).save(ConsumerWrapperBuilder.wrap().build(consumer));
        StampingRecipeBuilder.create((Item)RegistryManager.LEAD_ASPECTUS.get()).domain("embers").folder(stampingFolder).stamp((ItemLike)RegistryManager.INGOT_STAMP.get()).input((ItemLike)RegistryManager.EMBER_SHARD.get()).fluid(this.fluidTag("forge", "molten_lead"), 90).save(ConsumerWrapperBuilder.wrap().build(consumer));
        StampingRecipeBuilder.create((Item)RegistryManager.SILVER_ASPECTUS.get()).domain("embers").folder(stampingFolder).stamp((ItemLike)RegistryManager.INGOT_STAMP.get()).input((ItemLike)RegistryManager.EMBER_SHARD.get()).fluid(this.fluidTag("forge", "molten_silver"), 90).save(ConsumerWrapperBuilder.wrap().build(consumer));
        StampingRecipeBuilder.create((Item)RegistryManager.DAWNSTONE_ASPECTUS.get()).domain("embers").folder(stampingFolder).stamp((ItemLike)RegistryManager.INGOT_STAMP.get()).input((ItemLike)RegistryManager.EMBER_SHARD.get()).fluid(this.fluidTag("forge", "molten_dawnstone"), 90).save(ConsumerWrapperBuilder.wrap().build(consumer));
        MixingRecipeBuilder.create((Fluid)RegistryManager.MOLTEN_DAWNSTONE.FLUID.get(), 4).folder(mixingFolder).input(EmbersFluidTags.MOLTEN_COPPER, 2).input(EmbersFluidTags.MOLTEN_GOLD, 2).save(consumer);
        MixingRecipeBuilder.create((Fluid)RegistryManager.MOLTEN_BRONZE.FLUID.get(), 4).folder(mixingFolder).input(EmbersFluidTags.MOLTEN_COPPER, 3).input(EmbersFluidTags.MOLTEN_TIN, 1).save(ConsumerWrapperBuilder.wrap().addCondition(this.tagReal(this.itemTag("forge", "ingots/bronze"))).build(consumer));
        MixingRecipeBuilder.create((Fluid)RegistryManager.MOLTEN_ELECTRUM.FLUID.get(), 4).folder(mixingFolder).input(EmbersFluidTags.MOLTEN_SILVER, 2).input(EmbersFluidTags.MOLTEN_GOLD, 2).save(ConsumerWrapperBuilder.wrap().addCondition(this.tagReal(this.itemTag("forge", "ingots/electrum"))).build(consumer));
        MixingRecipeBuilder.create((Fluid)RegistryManager.MOLTEN_BRASS.FLUID.get(), 4).folder(mixingFolder).input(EmbersFluidTags.MOLTEN_COPPER, 2).input(EmbersFluidTags.MOLTEN_ZINC, 2).save(ConsumerWrapperBuilder.wrap().addCondition(this.tagReal(this.itemTag("forge", "ingots/brass"))).build(consumer));
        MixingRecipeBuilder.create((Fluid)RegistryManager.MOLTEN_CONSTANTAN.FLUID.get(), 4).folder(mixingFolder).input(EmbersFluidTags.MOLTEN_COPPER, 2).input(EmbersFluidTags.MOLTEN_NICKEL, 2).save(ConsumerWrapperBuilder.wrap().addCondition(this.tagReal(this.itemTag("forge", "ingots/constantan"))).build(consumer));
        MixingRecipeBuilder.create((Fluid)RegistryManager.MOLTEN_INVAR.FLUID.get(), 3).folder(mixingFolder).input(EmbersFluidTags.MOLTEN_IRON, 2).input(EmbersFluidTags.MOLTEN_NICKEL, 1).save(ConsumerWrapperBuilder.wrap().addCondition(this.tagReal(this.itemTag("forge", "ingots/invar"))).build(consumer));
        MixingRecipeBuilder.create((Fluid)RegistryManager.DWARVEN_OIL.FLUID.get(), 10).id(new ResourceLocation("embers", mixingFolder + "/dwarven_oil_steam")).input((Fluid)RegistryManager.SOUL_CRUDE.FLUID.get(), 5).input(EmbersFluidTags.STEAM, 20).save(consumer);
        MixingRecipeBuilder.create((Fluid)RegistryManager.DWARVEN_OIL.FLUID.get(), 30).id(new ResourceLocation("embers", mixingFolder + "/dwarven_oil")).input((Fluid)RegistryManager.SOUL_CRUDE.FLUID.get(), 10).input((Fluid)RegistryManager.DWARVEN_GAS.FLUID.get(), 5).save(consumer);
        MetalCoefficientRecipeBuilder.create(EmbersBlockTags.DAWNSTONE_BLOCK).domain("embers").folder(coefficientFolder).coefficient(1.5).save(consumer);
        MetalCoefficientRecipeBuilder.create(EmbersBlockTags.LEAD_BLOCK).domain("embers").folder(coefficientFolder).coefficient(2.625).save(consumer);
        MetalCoefficientRecipeBuilder.create(EmbersBlockTags.BRONZE_BLOCK).domain("embers").folder(coefficientFolder).coefficient(2.625).save(ConsumerWrapperBuilder.wrap().addCondition(this.tagReal(EmbersBlockTags.BRONZE_BLOCK)).build(consumer));
        MetalCoefficientRecipeBuilder.create((TagKey<Block>)Tags.Blocks.STORAGE_BLOCKS_IRON).domain("embers").folder(coefficientFolder).coefficient(2.625).save(consumer);
        MetalCoefficientRecipeBuilder.create(EmbersBlockTags.NICKEL_BLOCK).domain("embers").folder(coefficientFolder).coefficient(2.85).save(ConsumerWrapperBuilder.wrap().addCondition(this.tagReal(EmbersBlockTags.NICKEL_BLOCK)).build(consumer));
        MetalCoefficientRecipeBuilder.create(EmbersBlockTags.TIN_BLOCK).domain("embers").folder(coefficientFolder).coefficient(2.85).save(ConsumerWrapperBuilder.wrap().addCondition(this.tagReal(EmbersBlockTags.TIN_BLOCK)).build(consumer));
        MetalCoefficientRecipeBuilder.create(EmbersBlockTags.ALUMINUM_BLOCK).domain("embers").folder(coefficientFolder).coefficient(2.85).save(ConsumerWrapperBuilder.wrap().addCondition(this.tagReal(EmbersBlockTags.ALUMINUM_BLOCK)).build(consumer));
        MetalCoefficientRecipeBuilder.create(EmbersBlockTags.SILVER_BLOCK).domain("embers").folder(coefficientFolder).coefficient(3.0).save(consumer);
        MetalCoefficientRecipeBuilder.create(EmbersBlockTags.ELECTRUM_BLOCK).domain("embers").folder(coefficientFolder).coefficient(3.0).save(ConsumerWrapperBuilder.wrap().addCondition(this.tagReal(EmbersBlockTags.ELECTRUM_BLOCK)).build(consumer));
        MetalCoefficientRecipeBuilder.create(EmbersBlockTags.PRISTINE_COPPER).domain("embers").folder(coefficientFolder).coefficient(3.0).save(consumer);
        MetalCoefficientRecipeBuilder.create(EmbersBlockTags.EXPOSED_COPPER).domain("embers").folder(coefficientFolder).coefficient(2.5).save(consumer);
        MetalCoefficientRecipeBuilder.create(EmbersBlockTags.WEATHERED_COPPER).domain("embers").folder(coefficientFolder).coefficient(2.0).save(consumer);
        MetalCoefficientRecipeBuilder.create(EmbersBlockTags.OXIDIZED_COPPER).domain("embers").folder(coefficientFolder).coefficient(1.5).save(consumer);
        MetalCoefficientRecipeBuilder.create((TagKey<Block>)Tags.Blocks.STORAGE_BLOCKS_GOLD).domain("embers").folder(coefficientFolder).coefficient(3.0).save(consumer);
        AlchemyRecipeBuilder.create(new ItemStack((ItemLike)Items.f_42048_, 4)).tablet((ItemLike)RegistryManager.EMBER_GRIT.get()).domain("embers").folder(alchemyFolder).inputs(new ItemLike[]{Items.f_42594_, Items.f_42594_, Items.f_42594_, Items.f_42594_}).aspects(EmbersItemTags.COPPER_ASPECTUS, EmbersItemTags.IRON_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create(new ItemStack((ItemLike)Items.f_42049_, 4)).tablet((ItemLike)RegistryManager.ASH.get()).domain("embers").folder(alchemyFolder).inputs(new ItemLike[]{Items.f_41830_, Items.f_41830_, Items.f_41830_, Items.f_41830_}).aspects(EmbersItemTags.COPPER_ASPECTUS, EmbersItemTags.IRON_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create(new ItemStack((ItemLike)RegistryManager.ARCHAIC_BRICK.get(), 5)).tablet((ItemLike)RegistryManager.ARCHAIC_BRICK.get()).folder(alchemyFolder).inputs(new ItemLike[]{Items.f_42049_, Items.f_42461_, Items.f_42461_}).aspects(EmbersItemTags.IRON_ASPECTUS, EmbersItemTags.SILVER_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.ANCIENT_MOTIVE_CORE.get()).tablet((ItemLike)RegistryManager.EMBER_SHARD.get()).folder(alchemyFolder).inputs((ItemLike)RegistryManager.ARCHAIC_BRICK.get(), (ItemLike)RegistryManager.ARCHAIC_BRICK.get(), (ItemLike)RegistryManager.ARCHAIC_BRICK.get()).aspects(EmbersItemTags.DAWNSTONE_ASPECTUS, EmbersItemTags.LEAD_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.CODEBREAKING_SLATE.get()).tablet((ItemLike)RegistryManager.EMBER_GRIT.get()).folder(alchemyFolder).inputs((ItemLike)RegistryManager.CAMINITE_PLATE.get(), (ItemLike)RegistryManager.ARCHAIC_BRICK.get(), (ItemLike)RegistryManager.ARCHAIC_BRICK.get()).aspects(EmbersItemTags.COPPER_ASPECTUS, EmbersItemTags.LEAD_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.ASHEN_FABRIC.get()).tablet((TagKey<Item>)ItemTags.f_13167_).folder(alchemyFolder).inputs(EmbersItemTags.ASH_DUST, EmbersItemTags.ASH_DUST, Tags.Items.STRING, Tags.Items.STRING).aspects(EmbersItemTags.IRON_ASPECTUS, EmbersItemTags.LEAD_ASPECTUS, EmbersItemTags.DAWNSTONE_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.EMBER_CRYSTAL_CLUSTER.get()).tablet((ItemLike)RegistryManager.EMBER_CRYSTAL.get()).folder(alchemyFolder).inputs(Ingredient.m_204132_((TagKey)Tags.Items.GUNPOWDER), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RegistryManager.EMBER_SHARD.get()}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RegistryManager.EMBER_SHARD.get()}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RegistryManager.EMBER_SHARD.get()})).aspects(EmbersItemTags.COPPER_ASPECTUS, EmbersItemTags.IRON_ASPECTUS, EmbersItemTags.DAWNSTONE_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.WILDFIRE_CORE.get()).tablet((ItemLike)RegistryManager.ANCIENT_MOTIVE_CORE.get()).folder(alchemyFolder).inputs(Ingredient.m_204132_(EmbersItemTags.DAWNSTONE_INGOT), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RegistryManager.EMBER_CRYSTAL_CLUSTER.get()}), Ingredient.m_204132_(EmbersItemTags.DAWNSTONE_INGOT), Ingredient.m_204132_(EmbersItemTags.COPPER_PLATE)).aspects(EmbersItemTags.COPPER_ASPECTUS, EmbersItemTags.IRON_ASPECTUS, EmbersItemTags.SILVER_ASPECTUS, EmbersItemTags.DAWNSTONE_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.TYRFING.get()).tablet((ItemLike)RegistryManager.LEAD_TOOLS.SWORD.get()).folder(alchemyFolder).inputs(Tags.Items.STORAGE_BLOCKS_COAL, Tags.Items.OBSIDIAN, EmbersItemTags.LEAD_INGOT, EmbersItemTags.LEAD_INGOT).aspects(EmbersItemTags.LEAD_ASPECTUS, EmbersItemTags.SILVER_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create(new ItemStack((ItemLike)RegistryManager.ISOLATED_MATERIA.get(), 4)).tablet((TagKey<Item>)Tags.Items.INGOTS_IRON).folder(alchemyFolder).inputs(Ingredient.m_204132_((TagKey)Tags.Items.GEMS_QUARTZ), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42461_}), Ingredient.m_204132_((TagKey)Tags.Items.GEMS_LAPIS)).aspects(EmbersItemTags.COPPER_ASPECTUS, EmbersItemTags.IRON_ASPECTUS, EmbersItemTags.LEAD_ASPECTUS, EmbersItemTags.SILVER_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.CATALYTIC_PLUG.get()).tablet(EmbersItemTags.SILVER_INGOT).folder(alchemyFolder).inputs(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RegistryManager.FLUID_PIPE.get()}), Ingredient.m_204132_((TagKey)Tags.Items.GLASS_SILICA), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RegistryManager.FLUID_PIPE.get()})).aspects(EmbersItemTags.DAWNSTONE_ASPECTUS, EmbersItemTags.SILVER_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.COPPER_CRYSTAL_SEED.ITEM.get()).tablet(EmbersItemTags.CRYSTAL_SEEDS).folder(alchemyFolder).inputs(Tags.Items.INGOTS_COPPER, Tags.Items.INGOTS_COPPER, Tags.Items.INGOTS_COPPER).aspects(EmbersItemTags.IRON_ASPECTUS, EmbersItemTags.COPPER_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.IRON_CRYSTAL_SEED.ITEM.get()).tablet(EmbersItemTags.CRYSTAL_SEEDS).folder(alchemyFolder).inputs(Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_IRON).aspects(EmbersItemTags.IRON_ASPECTUS, EmbersItemTags.SILVER_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.GOLD_CRYSTAL_SEED.ITEM.get()).tablet(EmbersItemTags.CRYSTAL_SEEDS).folder(alchemyFolder).inputs(Tags.Items.INGOTS_GOLD, Tags.Items.INGOTS_GOLD, Tags.Items.INGOTS_GOLD).aspects(EmbersItemTags.IRON_ASPECTUS, EmbersItemTags.DAWNSTONE_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.LEAD_CRYSTAL_SEED.ITEM.get()).tablet(EmbersItemTags.CRYSTAL_SEEDS).folder(alchemyFolder).inputs(EmbersItemTags.LEAD_INGOT, EmbersItemTags.LEAD_INGOT, EmbersItemTags.LEAD_INGOT).aspects(EmbersItemTags.IRON_ASPECTUS, EmbersItemTags.LEAD_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.SILVER_CRYSTAL_SEED.ITEM.get()).tablet(EmbersItemTags.CRYSTAL_SEEDS).folder(alchemyFolder).inputs(EmbersItemTags.SILVER_INGOT, EmbersItemTags.SILVER_INGOT, EmbersItemTags.SILVER_INGOT).aspects(EmbersItemTags.IRON_ASPECTUS, EmbersItemTags.SILVER_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.NICKEL_CRYSTAL_SEED.ITEM.get()).tablet(EmbersItemTags.CRYSTAL_SEEDS).folder(alchemyFolder).inputs(EmbersItemTags.NICKEL_INGOT, EmbersItemTags.NICKEL_INGOT, EmbersItemTags.NICKEL_INGOT).aspects(EmbersItemTags.IRON_ASPECTUS, EmbersItemTags.LEAD_ASPECTUS).save(ConsumerWrapperBuilder.wrap().addCondition((ICondition)new AndCondition(new ICondition[]{this.tagReal(EmbersItemTags.NICKEL_INGOT), this.tagReal(EmbersItemTags.NICKEL_NUGGET)})).build(consumer));
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.TIN_CRYSTAL_SEED.ITEM.get()).tablet(EmbersItemTags.CRYSTAL_SEEDS).folder(alchemyFolder).inputs(EmbersItemTags.TIN_INGOT, EmbersItemTags.TIN_INGOT, EmbersItemTags.TIN_INGOT).aspects(EmbersItemTags.IRON_ASPECTUS, EmbersItemTags.SILVER_ASPECTUS).save(ConsumerWrapperBuilder.wrap().addCondition((ICondition)new AndCondition(new ICondition[]{this.tagReal(EmbersItemTags.TIN_INGOT), this.tagReal(EmbersItemTags.TIN_NUGGET)})).build(consumer));
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.ALUMINUM_CRYSTAL_SEED.ITEM.get()).tablet(EmbersItemTags.CRYSTAL_SEEDS).folder(alchemyFolder).inputs(EmbersItemTags.ALUMINUM_INGOT, EmbersItemTags.ALUMINUM_INGOT, EmbersItemTags.ALUMINUM_INGOT).aspects(EmbersItemTags.IRON_ASPECTUS, EmbersItemTags.COPPER_ASPECTUS).save(ConsumerWrapperBuilder.wrap().addCondition((ICondition)new AndCondition(new ICondition[]{this.tagReal(EmbersItemTags.ALUMINUM_INGOT), this.tagReal(EmbersItemTags.ALUMINUM_NUGGET)})).build(consumer));
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.ZINC_CRYSTAL_SEED.ITEM.get()).tablet(EmbersItemTags.CRYSTAL_SEEDS).folder(alchemyFolder).inputs(EmbersItemTags.ZINC_INGOT, EmbersItemTags.ZINC_INGOT, EmbersItemTags.ZINC_INGOT).aspects(EmbersItemTags.IRON_ASPECTUS, EmbersItemTags.LEAD_ASPECTUS).save(ConsumerWrapperBuilder.wrap().addCondition((ICondition)new AndCondition(new ICondition[]{this.tagReal(EmbersItemTags.ZINC_INGOT), this.tagReal(EmbersItemTags.ZINC_NUGGET)})).build(consumer));
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.INFLICTOR_GEM.get()).tablet((TagKey<Item>)Tags.Items.GEMS_DIAMOND).folder(alchemyFolder).inputs(EmbersItemTags.DAWNSTONE_INGOT, ItemTags.f_13160_, ItemTags.f_13160_, ItemTags.f_13160_).aspects(EmbersItemTags.DAWNSTONE_ASPECTUS, EmbersItemTags.SILVER_ASPECTUS, EmbersItemTags.LEAD_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create(new ItemStack((ItemLike)RegistryManager.ADHESIVE.get(), 6)).tablet(new ItemLike[]{Items.f_42461_}).folder(alchemyFolder).inputs(new ItemLike[]{Items.f_42499_, Items.f_42499_}).aspects(EmbersItemTags.IRON_ASPECTUS, EmbersItemTags.LEAD_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.GLIMMER_CRYSTAL.get()).tablet((TagKey<Item>)Tags.Items.GEMS_QUARTZ).folder(alchemyFolder).inputs(Ingredient.m_204132_((TagKey)Tags.Items.GUNPOWDER), Ingredient.m_204132_((TagKey)Tags.Items.GUNPOWDER), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RegistryManager.EMBER_SHARD.get()}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RegistryManager.EMBER_SHARD.get()})).aspects(EmbersItemTags.COPPER_ASPECTUS, EmbersItemTags.DAWNSTONE_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.ENTROPIC_ENUMERATOR.get()).tablet((ItemLike)RegistryManager.ASHEN_TILE.get()).folder(alchemyFolder).inputs(Tags.Items.INGOTS_COPPER, Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_GOLD, EmbersItemTags.LEAD_INGOT, EmbersItemTags.SILVER_INGOT, EmbersItemTags.DAWNSTONE_INGOT).aspects(EmbersItemTags.LEAD_ASPECTUS, EmbersItemTags.DAWNSTONE_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.BLASTING_CORE.get()).tablet((TagKey<Item>)Tags.Items.GUNPOWDER).folder(alchemyFolder).inputs(EmbersItemTags.IRON_PLATE, EmbersItemTags.IRON_PLATE, EmbersItemTags.IRON_PLATE, Tags.Items.INGOTS_COPPER).aspects(EmbersItemTags.COPPER_ASPECTUS, EmbersItemTags.IRON_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.FLAME_BARRIER.get()).tablet((ItemLike)RegistryManager.EMBER_CRYSTAL.get()).folder(alchemyFolder).inputs(EmbersItemTags.DAWNSTONE_PLATE, EmbersItemTags.DAWNSTONE_PLATE, EmbersItemTags.DAWNSTONE_PLATE, EmbersItemTags.SILVER_INGOT).aspects(EmbersItemTags.DAWNSTONE_ASPECTUS, EmbersItemTags.SILVER_ASPECTUS, EmbersItemTags.COPPER_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.ELDRITCH_INSIGNIA.get()).tablet((ItemLike)RegistryManager.ARCHAIC_CIRCUIT.get()).folder(alchemyFolder).inputs(ItemTags.f_13160_, EmbersItemTags.ARCHAIC_BRICK, ItemTags.f_13160_, EmbersItemTags.ARCHAIC_BRICK).aspects(EmbersItemTags.DAWNSTONE_ASPECTUS, EmbersItemTags.LEAD_ASPECTUS, EmbersItemTags.IRON_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.INTELLIGENT_APPARATUS.get()).tablet(EmbersItemTags.COPPER_PLATE).folder(alchemyFolder).inputs(Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_COPPER), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RegistryManager.ARCHAIC_CIRCUIT.get()}), Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_COPPER), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RegistryManager.ARCHAIC_CIRCUIT.get()})).aspects(EmbersItemTags.COPPER_ASPECTUS, EmbersItemTags.LEAD_ASPECTUS, EmbersItemTags.SILVER_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.FOCAL_LENS.get()).tablet((ItemLike)RegistryManager.EMBER_CRYSTAL.get()).folder(alchemyFolder).inputs(EmbersItemTags.DAWNSTONE_PLATE, EmbersItemTags.SILVER_PLATE, EmbersItemTags.DAWNSTONE_PLATE, EmbersItemTags.SILVER_PLATE).aspects(EmbersItemTags.COPPER_ASPECTUS, EmbersItemTags.SILVER_ASPECTUS, EmbersItemTags.DAWNSTONE_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.SHIFTING_SCALES.get()).tablet((ItemLike)RegistryManager.ASHEN_FABRIC.get()).folder(alchemyFolder).inputs(EmbersItemTags.LEAD_PLATE, EmbersItemTags.LEAD_PLATE, EmbersItemTags.LEAD_PLATE, EmbersItemTags.LEAD_PLATE, EmbersItemTags.LEAD_PLATE).aspects(EmbersItemTags.LEAD_ASPECTUS, EmbersItemTags.IRON_ASPECTUS, EmbersItemTags.SILVER_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create((ItemLike)RegistryManager.WINDING_GEARS.get()).tablet(EmbersItemTags.DAWNSTONE_INGOT).folder(alchemyFolder).inputs(EmbersItemTags.DAWNSTONE_PLATE, EmbersItemTags.DAWNSTONE_PLATE, EmbersItemTags.DAWNSTONE_PLATE, EmbersItemTags.DAWNSTONE_PLATE).aspects(EmbersItemTags.COPPER_ASPECTUS, EmbersItemTags.DAWNSTONE_ASPECTUS).save(consumer);
        AlchemyRecipeBuilder.create((ItemLike)CuriosCompat.NONBELEIVER_AMULET.get()).tablet((ItemLike)CuriosCompat.ASHEN_AMULET.get()).folder(alchemyFolder).inputs((ItemLike)RegistryManager.ELDRITCH_INSIGNIA.get(), (ItemLike)RegistryManager.ARCHAIC_CIRCUIT.get(), (ItemLike)RegistryManager.ARCHAIC_BRICK.get(), (ItemLike)RegistryManager.ARCHAIC_CIRCUIT.get()).aspects(EmbersItemTags.DAWNSTONE_ASPECTUS, EmbersItemTags.SILVER_ASPECTUS, EmbersItemTags.LEAD_ASPECTUS, EmbersItemTags.IRON_ASPECTUS).save(ConsumerWrapperBuilder.wrap().addCondition((ICondition)new ModLoadedCondition("curios")).build(consumer));
        AlchemyRecipeBuilder.create((ItemLike)CuriosCompat.EXPLOSION_CHARM.get()).tablet((ItemLike)RegistryManager.EMBER_CRYSTAL_CLUSTER.get()).folder(alchemyFolder).inputs(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RegistryManager.ARCHAIC_BRICK.get()}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RegistryManager.ARCHAIC_BRICK.get()}), Ingredient.m_204132_((TagKey)Tags.Items.LEATHER), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RegistryManager.ARCHAIC_BRICK.get()})).aspects(EmbersItemTags.DAWNSTONE_ASPECTUS, EmbersItemTags.SILVER_ASPECTUS, EmbersItemTags.COPPER_ASPECTUS, EmbersItemTags.IRON_ASPECTUS).save(ConsumerWrapperBuilder.wrap().addCondition((ICondition)new ModLoadedCondition("curios")).build(consumer));
        AlchemyRecipeBuilder.create((ItemLike)CuriosCompat.EXPLOSION_PEDESTAL_ITEM.get()).tablet((ItemLike)RegistryManager.ALCHEMY_PEDESTAL_ITEM.get()).folder(alchemyFolder).inputs((ItemLike)CuriosCompat.EXPLOSION_CHARM.get()).aspects(EmbersItemTags.SILVER_ASPECTUS).save(ConsumerWrapperBuilder.wrap().addCondition((ICondition)new ModLoadedCondition("curios")).build(consumer));
        BoilingRecipeBuilder.create((Fluid)RegistryManager.STEAM.FLUID.get(), 5).folder(boilingFolder).input((TagKey<Fluid>)FluidTags.f_13131_, 1).save(consumer);
        BoilingRecipeBuilder.create((Fluid)RegistryManager.DWARVEN_GAS.FLUID.get(), 1).folder(boilingFolder).input((Fluid)RegistryManager.DWARVEN_OIL.FLUID.get(), 1).save(consumer);
        GaseousFuelRecipeBuilder.create(new ResourceLocation("embers", "steam")).input(EmbersFluidTags.STEAM, 1).folder(gaseousFuelFolder).burnTime(1).powerMultiplier(2.0).save(consumer);
        GaseousFuelRecipeBuilder.create((Fluid)RegistryManager.DWARVEN_GAS.FLUID.get(), 1).folder(gaseousFuelFolder).burnTime(5).powerMultiplier(2.5).save(consumer);
        CatalysisCombustionRecipeBuilder.create((Item)RegistryManager.EMBER_GRIT.get()).catalysis().folder(catalysisFolder).multiplier(2.0).burnTime(400).save(consumer);
        CatalysisCombustionRecipeBuilder.create((TagKey<Item>)Tags.Items.GUNPOWDER).catalysis().domain("embers").folder(catalysisFolder).multiplier(3.0).burnTime(400).save(consumer);
        CatalysisCombustionRecipeBuilder.create((TagKey<Item>)Tags.Items.DUSTS_GLOWSTONE).catalysis().domain("embers").folder(catalysisFolder).multiplier(4.0).burnTime(400).save(consumer);
        CatalysisCombustionRecipeBuilder.create((TagKey<Item>)ItemTags.f_13160_).combustion().domain("embers").folder(combustionFolder).multiplier(2.0).burnTime(400).save(consumer);
        CatalysisCombustionRecipeBuilder.create((TagKey<Item>)Tags.Items.INGOTS_NETHER_BRICK).combustion().domain("embers").folder(combustionFolder).multiplier(3.0).burnTime(400).save(consumer);
        CatalysisCombustionRecipeBuilder.create(Items.f_42593_).combustion().domain("embers").folder(combustionFolder).multiplier(4.0).burnTime(400).save(consumer);
        GenericRecipeBuilder.create(new AnvilRepairRecipe(new ResourceLocation("embers", anvilFolder + "/tool_repair"))).save(consumer);
        GenericRecipeBuilder.create(new AnvilRepairMateriaRecipe(new ResourceLocation("embers", anvilFolder + "/tool_materia_repair"))).save(consumer);
        GenericRecipeBuilder.create(new AnvilBreakdownRecipe(new ResourceLocation("embers", anvilFolder + "/tool_breakdown"))).save(consumer);
        GenericRecipeBuilder.create(new AnvilAugmentRemoveRecipe(new ResourceLocation("embers", anvilFolder + "/tool_augment_remove"))).save(consumer);
        AnvilAugmentRecipeBuilder.create(RegistryManager.CORE_AUGMENT).folder(anvilFolder).tool((Ingredient)HeatIngredient.of(Ingredient.m_204132_(EmbersItemTags.AUGMENTABLE), true)).input((ItemLike)RegistryManager.ANCIENT_MOTIVE_CORE.get()).save(consumer);
        AnvilAugmentRecipeBuilder.create(RegistryManager.TINKER_LENS_AUGMENT).folder(anvilFolder).tool((Ingredient)AugmentIngredient.of((Ingredient)DifferenceIngredient.of((Ingredient)Ingredient.m_204132_(EmbersItemTags.AUGMENTABLE_HELMETS), (Ingredient)Ingredient.m_204132_(EmbersItemTags.TINKER_LENS_HELMETS)), RegistryManager.TINKER_LENS_AUGMENT, true)).input((ItemLike)RegistryManager.TINKER_LENS.get()).save(consumer);
        AnvilAugmentRecipeBuilder.create(RegistryManager.SMOKY_LENS_AUGMENT).folder(anvilFolder).tool((Ingredient)AugmentIngredient.of(IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(EmbersItemTags.AUGMENTABLE_HELMETS), Ingredient.m_204132_(EmbersItemTags.TINKER_LENS_HELMETS)}), RegistryManager.SMOKY_LENS_AUGMENT, true)).input((ItemLike)RegistryManager.SMOKY_TINKER_LENS.get()).save(consumer);
        AnvilAugmentRecipeBuilder.create(RegistryManager.SUPERHEATER_AUGMENT).folder(anvilFolder).tool((Ingredient)HeatIngredient.of(Ingredient.m_204132_(EmbersItemTags.AUGMENTABLE_TOOLS))).input((ItemLike)RegistryManager.SUPERHEATER.get()).save(consumer);
        AnvilAugmentRecipeBuilder.create(RegistryManager.CINDER_JET_AUGMENT).folder(anvilFolder).tool((Ingredient)HeatIngredient.of(Ingredient.m_204132_(EmbersItemTags.AUGMENTABLE_ARMORS))).input((ItemLike)RegistryManager.CINDER_JET.get()).save(consumer);
        AnvilAugmentRecipeBuilder.create(RegistryManager.BLASTING_CORE_AUGMENT).folder(anvilFolder).tool((Ingredient)HeatIngredient.of(Ingredient.m_204132_(EmbersItemTags.AUGMENTABLE_TOOLS_AND_ARMORS))).input((ItemLike)RegistryManager.BLASTING_CORE.get()).save(consumer);
        AnvilAugmentRecipeBuilder.create(RegistryManager.CASTER_ORB_AUGMENT).folder(anvilFolder).tool((Ingredient)HeatIngredient.of(Ingredient.m_204132_(EmbersItemTags.AUGMENTABLE_TOOLS))).input((ItemLike)RegistryManager.CASTER_ORB.get()).save(consumer);
        AnvilAugmentRecipeBuilder.create(RegistryManager.RESONATING_BELL_AUGMENT).folder(anvilFolder).tool((Ingredient)HeatIngredient.of(Ingredient.m_204132_(EmbersItemTags.AUGMENTABLE_TOOLS))).input((ItemLike)RegistryManager.RESONATING_BELL.get()).save(consumer);
        AnvilAugmentRecipeBuilder.create(RegistryManager.FLAME_BARRIER_AUGMENT).folder(anvilFolder).tool((Ingredient)HeatIngredient.of(Ingredient.m_204132_(EmbersItemTags.AUGMENTABLE_ARMORS))).input((ItemLike)RegistryManager.FLAME_BARRIER.get()).save(consumer);
        AnvilAugmentRecipeBuilder.create(RegistryManager.ELDRITCH_INSIGNIA_AUGMENT).folder(anvilFolder).tool((Ingredient)HeatIngredient.of(Ingredient.m_204132_(EmbersItemTags.AUGMENTABLE_ARMORS))).input((ItemLike)RegistryManager.ELDRITCH_INSIGNIA.get()).save(consumer);
        AnvilAugmentRecipeBuilder.create(RegistryManager.INTELLIGENT_APPARATUS_AUGMENT).folder(anvilFolder).tool((Ingredient)HeatIngredient.of(Ingredient.m_204132_(EmbersItemTags.AUGMENTABLE_ARMORS))).input((ItemLike)RegistryManager.INTELLIGENT_APPARATUS.get()).save(consumer);
        Ingredient projectileWeapons = CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(EmbersItemTags.AUGMENTABLE_PROJECTILE_WEAPONS), AugmentIngredient.of(Ingredient.m_204132_(EmbersItemTags.AUGMENTABLE_TOOLS), RegistryManager.CASTER_ORB_AUGMENT)});
        AnvilAugmentRecipeBuilder.create(RegistryManager.DIFFRACTION_BARREL_AUGMENT).folder(anvilFolder).tool(projectileWeapons).input((ItemLike)RegistryManager.DIFFRACTION_BARREL.get()).save(consumer);
        AnvilAugmentRecipeBuilder.create(RegistryManager.FOCAL_LENS_AUGMENT).folder(anvilFolder).tool(projectileWeapons).input((ItemLike)RegistryManager.FOCAL_LENS.get()).save(consumer);
        AnvilAugmentRecipeBuilder.create(RegistryManager.SHIFTING_SCALES_AUGMENT).folder(anvilFolder).tool((Ingredient)HeatIngredient.of(Ingredient.m_204132_(EmbersItemTags.AUGMENTABLE_ARMORS))).input((ItemLike)RegistryManager.SHIFTING_SCALES.get()).save(consumer);
        AnvilAugmentRecipeBuilder.create(RegistryManager.WINDING_GEARS_AUGMENT).folder(anvilFolder).tool((Ingredient)HeatIngredient.of(CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(EmbersItemTags.AUGMENTABLE_TOOLS), Ingredient.m_204132_(EmbersItemTags.AUGMENTABLE_BOOTS)}))).input((ItemLike)RegistryManager.WINDING_GEARS.get()).save(consumer);
        GemSocketRecipeBuilder.create((TagKey<Item>)Tags.Items.STRING).id(new ResourceLocation("embers", "gem_socketing")).save(consumer);
        GenericRecipeBuilder.create(new GemUnsocketRecipe(new ResourceLocation("embers", "gem_unsocketing"))).save(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.EMBER_CRYSTAL.get())).m_126130_("XXX").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.EMBER_SHARD.get()).m_126132_("has_shard", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.EMBER_SHARD.get()))).m_126140_(consumer, EmbersRecipes.getResource("ember_shard_to_crystal"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.EMBER_SHARD.get()), (int)6).m_126209_((ItemLike)RegistryManager.EMBER_CRYSTAL.get()).m_126132_("has_crystal", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.EMBER_CRYSTAL.get()))).m_126140_(consumer, EmbersRecipes.getResource("ember_crystal_to_shard"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.CAMINITE_BLEND.get()), (int)8).m_126209_((ItemLike)Items.f_42461_).m_126209_((ItemLike)Items.f_42461_).m_126209_((ItemLike)Items.f_42461_).m_126209_((ItemLike)Items.f_42461_).m_206419_(Tags.Items.SAND).m_126132_("has_clay", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)Items.f_42461_)).m_126140_(consumer, EmbersRecipes.getResource("caminite_blend"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.RAW_CAMINITE_PLATE.get())).m_126130_("XX").m_126130_("XX").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.CAMINITE_BLEND.get()).m_126132_("has_caminite", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.CAMINITE_BLEND.get()))).m_126140_(consumer, EmbersRecipes.getResource("raw_caminite_plate"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.RAW_FLAT_STAMP.get())).m_126130_("XXX").m_126130_("X X").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.CAMINITE_BLEND.get()).m_126132_("has_caminite", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.CAMINITE_BLEND.get()))).m_126140_(consumer, EmbersRecipes.getResource("raw_flat_stamp"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.RAW_INGOT_STAMP.get())).m_126130_(" X ").m_126130_("X X").m_126130_(" X ").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.CAMINITE_BLEND.get()).m_126132_("has_caminite", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.CAMINITE_BLEND.get()))).m_126140_(consumer, EmbersRecipes.getResource("raw_ingot_stamp"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.RAW_NUGGET_STAMP.get())).m_126130_("X X").m_126130_("X X").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.CAMINITE_BLEND.get()).m_126132_("has_caminite", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.CAMINITE_BLEND.get()))).m_126140_(consumer, EmbersRecipes.getResource("raw_nugget_stamp"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.RAW_PLATE_STAMP.get())).m_126130_("X X").m_126130_("   ").m_126130_("X X").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.CAMINITE_BLEND.get()).m_126132_("has_caminite", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.CAMINITE_BLEND.get()))).m_126140_(consumer, EmbersRecipes.getResource("raw_plate_stamp"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.RAW_GEAR_STAMP.get())).m_126130_("X X").m_126130_(" X ").m_126130_("X X").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.CAMINITE_BLEND.get()).m_126132_("has_caminite", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.CAMINITE_BLEND.get()))).m_126140_(ConsumerWrapperBuilder.wrap().addCondition(this.tagReal(this.itemTag("forge", "gears"))).build(consumer), EmbersRecipes.getResource("raw_gear_stamp"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RegistryManager.CAMINITE_BRICKS.get())).m_126130_("XX").m_126130_("XX").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.CAMINITE_BRICK.get()).m_126132_("has_brick", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.CAMINITE_BRICK.get()))).m_126140_(consumer, EmbersRecipes.getResource("caminite_bricks"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RegistryManager.CAMINITE_LARGE_BRICKS.get()), (int)4).m_126130_("XX").m_126130_("XX").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.CAMINITE_BRICKS.get()).m_126132_("has_brick", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.CAMINITE_BRICK.get()))).m_126140_(consumer, EmbersRecipes.getResource("caminite_large_bricks"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RegistryManager.CAMINITE_BRICKS.get()), (int)4).m_126130_("XX").m_126130_("XX").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.CAMINITE_LARGE_BRICKS.get()).m_126132_("has_brick", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.CAMINITE_BRICK.get()))).m_126140_(consumer, EmbersRecipes.getResource("caminite_bricks_reverse"));
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.CAMINITE_LARGE_BRICKS.get(), (ItemLike)RegistryManager.CAMINITE_BRICKS.get());
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.CAMINITE_BRICKS.get(), (ItemLike)RegistryManager.CAMINITE_LARGE_BRICKS.get());
        this.decoRecipes(RegistryManager.CAMINITE_BRICKS_DECO, consumer);
        this.decoRecipes(RegistryManager.CAMINITE_LARGE_BRICKS_DECO, consumer);
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RegistryManager.CAMINITE_BLEND.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.CAMINITE_BRICK.get()), (float)0.1f, (int)200).m_126132_("has_caminite", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.CAMINITE_BLEND.get()))).m_126140_(consumer, EmbersRecipes.getResource("caminite_brick"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RegistryManager.RAW_CAMINITE_PLATE.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.CAMINITE_PLATE.get()), (float)0.1f, (int)200).m_126132_("has_raw_plate", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.RAW_CAMINITE_PLATE.get()))).m_126140_(consumer, EmbersRecipes.getResource("caminite_plate"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RegistryManager.RAW_FLAT_STAMP.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.FLAT_STAMP.get()), (float)0.1f, (int)200).m_126132_("has_raw_flat_stamp", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.RAW_FLAT_STAMP.get()))).m_126140_(consumer, EmbersRecipes.getResource("flat_stamp"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RegistryManager.RAW_INGOT_STAMP.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.INGOT_STAMP.get()), (float)0.1f, (int)200).m_126132_("has_raw_ingot_stamp", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.RAW_INGOT_STAMP.get()))).m_126140_(consumer, EmbersRecipes.getResource("ingot_stamp"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RegistryManager.RAW_NUGGET_STAMP.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.NUGGET_STAMP.get()), (float)0.1f, (int)200).m_126132_("has_raw_nugget_stamp", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.RAW_NUGGET_STAMP.get()))).m_126140_(consumer, EmbersRecipes.getResource("nugget_stamp"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RegistryManager.RAW_PLATE_STAMP.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.PLATE_STAMP.get()), (float)0.1f, (int)200).m_126132_("has_raw_plate_stamp", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.RAW_PLATE_STAMP.get()))).m_126140_(consumer, EmbersRecipes.getResource("plate_stamp"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RegistryManager.RAW_GEAR_STAMP.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.GEAR_STAMP.get()), (float)0.1f, (int)200).m_126132_("has_raw_gear_stamp", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.RAW_GEAR_STAMP.get()))).m_126140_(ConsumerWrapperBuilder.wrap().addCondition(this.tagReal(this.itemTag("forge", "gears"))).build(consumer), EmbersRecipes.getResource("gear_stamp"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RegistryManager.RAW_CAMINITE_BLOCK.get()), (int)3).m_126130_("XXX").m_126130_("XXX").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.CAMINITE_BLEND.get()).m_126132_("has_caminite", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.CAMINITE_BLEND.get()))).m_126140_(consumer, EmbersRecipes.getResource("raw_caminite_block"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RegistryManager.RAW_CAMINITE_BLOCK.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.CAMINITE_LARGE_TILE.get()), (float)0.1f, (int)200).m_126132_("has_caminite", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.CAMINITE_BLEND.get()))).m_126140_(consumer, EmbersRecipes.getResource("caminite_large_tile_smelting"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RegistryManager.CAMINITE_TILES.get()), (int)4).m_126130_("XX").m_126130_("XX").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.CAMINITE_LARGE_TILE.get()).m_126132_("has_tile", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.CAMINITE_LARGE_TILE.get()))).m_126140_(consumer, EmbersRecipes.getResource("caminite_tiles"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RegistryManager.CAMINITE_LARGE_TILE.get()), (int)4).m_126130_("XX").m_126130_("XX").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.CAMINITE_TILES.get()).m_126132_("has_tile", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.CAMINITE_LARGE_TILE.get()))).m_126140_(consumer, EmbersRecipes.getResource("caminite_large_tile_reverse"));
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.CAMINITE_TILES.get(), (ItemLike)RegistryManager.CAMINITE_LARGE_TILE.get());
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.CAMINITE_LARGE_TILE.get(), (ItemLike)RegistryManager.CAMINITE_TILES.get());
        this.decoRecipes(RegistryManager.CAMINITE_LARGE_TILE_DECO, consumer);
        this.decoRecipes(RegistryManager.CAMINITE_TILES_DECO, consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RegistryManager.ARCHAIC_BRICKS.get())).m_126130_("XX").m_126130_("XX").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.ARCHAIC_BRICK.get()).m_126132_("has_brick", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.ARCHAIC_BRICK.get()))).m_126140_(consumer, EmbersRecipes.getResource("archaic_bricks"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RegistryManager.ARCHAIC_LIGHT.get())).m_126130_(" X ").m_126130_("XSX").m_126130_(" X ").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.ARCHAIC_BRICK.get()).m_126127_(Character.valueOf('S'), (ItemLike)RegistryManager.EMBER_SHARD.get()).m_126132_("has_shard", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.EMBER_SHARD.get()))).m_126140_(consumer, EmbersRecipes.getResource("archaic_light"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RegistryManager.ARCHAIC_EDGE.get()), (int)2).m_126130_("XXX").m_126130_("XSX").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.ARCHAIC_BRICK.get()).m_126127_(Character.valueOf('S'), (ItemLike)RegistryManager.EMBER_SHARD.get()).m_126132_("has_shard", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.EMBER_SHARD.get()))).m_126140_(consumer, EmbersRecipes.getResource("archaic_edge"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RegistryManager.ARCHAIC_TILE.get()), (int)4).m_126130_("XX").m_126130_("XX").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.ARCHAIC_BRICKS.get()).m_126132_("has_bricks", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.ARCHAIC_BRICKS.get()))).m_126140_(consumer, EmbersRecipes.getResource("archaic_tile"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RegistryManager.ARCHAIC_LARGE_BRICKS.get()), (int)4).m_126130_("XX").m_126130_("XX").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.ARCHAIC_TILE.get()).m_126132_("has_bricks", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.ARCHAIC_BRICKS.get()))).m_126140_(consumer, EmbersRecipes.getResource("archaic_large_bricks"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RegistryManager.ARCHAIC_BRICKS.get()), (int)4).m_126130_("XX").m_126130_("XX").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.ARCHAIC_LARGE_BRICKS.get()).m_126132_("has_bricks", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.ARCHAIC_BRICKS.get()))).m_126140_(consumer, EmbersRecipes.getResource("archaic_bricks_2"));
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.ARCHAIC_TILE.get(), (ItemLike)RegistryManager.ARCHAIC_BRICKS.get());
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.ARCHAIC_LARGE_BRICKS.get(), (ItemLike)RegistryManager.ARCHAIC_BRICKS.get());
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.ARCHAIC_BRICKS.get(), (ItemLike)RegistryManager.ARCHAIC_TILE.get());
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.ARCHAIC_LARGE_BRICKS.get(), (ItemLike)RegistryManager.ARCHAIC_TILE.get());
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.ARCHAIC_BRICKS.get(), (ItemLike)RegistryManager.ARCHAIC_LARGE_BRICKS.get());
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.ARCHAIC_TILE.get(), (ItemLike)RegistryManager.ARCHAIC_LARGE_BRICKS.get());
        this.decoRecipes(RegistryManager.ARCHAIC_BRICKS_DECO, consumer);
        this.decoRecipes(RegistryManager.ARCHAIC_TILE_DECO, consumer);
        this.decoRecipes(RegistryManager.ARCHAIC_LARGE_BRICKS_DECO, consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RegistryManager.ASHEN_STONE.get()), (int)4).m_126130_(" S ").m_126130_("SAS").m_126130_(" S ").m_206416_(Character.valueOf('S'), Tags.Items.STONE).m_206416_(Character.valueOf('A'), EmbersItemTags.ASH_DUST).m_126132_("has_ash", (CriterionTriggerInstance)EmbersRecipes.m_206406_(EmbersItemTags.ASH_DUST)).m_126140_(consumer, EmbersRecipes.getResource("ashen_stone"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RegistryManager.ASHEN_BRICK.get()), (int)4).m_126130_(" S ").m_126130_("SAS").m_126130_(" S ").m_206416_(Character.valueOf('S'), ItemTags.f_13169_).m_206416_(Character.valueOf('A'), EmbersItemTags.ASH_DUST).m_126132_("has_ash", (CriterionTriggerInstance)EmbersRecipes.m_206406_(EmbersItemTags.ASH_DUST)).m_126140_(consumer, EmbersRecipes.getResource("ashen_brick"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RegistryManager.ASHEN_BRICK.get()), (int)4).m_126130_("SS").m_126130_("SS").m_126127_(Character.valueOf('S'), (ItemLike)RegistryManager.ASHEN_STONE.get()).m_126132_("has_ash", (CriterionTriggerInstance)EmbersRecipes.m_206406_(EmbersItemTags.ASH_DUST)).m_126140_(consumer, EmbersRecipes.getResource("ashen_brick_2"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RegistryManager.ASHEN_TILE.get()), (int)4).m_126130_("SS").m_126130_("SS").m_126127_(Character.valueOf('S'), (ItemLike)RegistryManager.ASHEN_BRICK.get()).m_126132_("has_ash", (CriterionTriggerInstance)EmbersRecipes.m_206406_(EmbersItemTags.ASH_DUST)).m_126140_(consumer, EmbersRecipes.getResource("ashen_tile"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RegistryManager.ASHEN_STONE.get()), (int)4).m_126130_("SS").m_126130_("SS").m_126127_(Character.valueOf('S'), (ItemLike)RegistryManager.ASHEN_TILE.get()).m_126132_("has_ash", (CriterionTriggerInstance)EmbersRecipes.m_206406_(EmbersItemTags.ASH_DUST)).m_126140_(consumer, EmbersRecipes.getResource("ashen_stone_2"));
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.ASHEN_BRICK.get(), (ItemLike)RegistryManager.ASHEN_STONE.get());
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.ASHEN_TILE.get(), (ItemLike)RegistryManager.ASHEN_STONE.get());
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.ASHEN_STONE.get(), (ItemLike)RegistryManager.ASHEN_BRICK.get());
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.ASHEN_TILE.get(), (ItemLike)RegistryManager.ASHEN_BRICK.get());
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.ASHEN_STONE.get(), (ItemLike)RegistryManager.ASHEN_TILE.get());
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.ASHEN_BRICK.get(), (ItemLike)RegistryManager.ASHEN_TILE.get());
        this.decoRecipes(RegistryManager.ASHEN_STONE_DECO, consumer);
        this.decoRecipes(RegistryManager.ASHEN_BRICK_DECO, consumer);
        this.decoRecipes(RegistryManager.ASHEN_TILE_DECO, consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RegistryManager.SEALED_PLANKS.get()), (int)8).m_126130_("PPP").m_126130_("PSP").m_126130_("PPP").m_206416_(Character.valueOf('P'), ItemTags.f_13168_).m_206416_(Character.valueOf('S'), Tags.Items.SLIMEBALLS).m_126132_("has_slime", (CriterionTriggerInstance)EmbersRecipes.m_206406_((TagKey)Tags.Items.SLIMEBALLS)).m_126140_(consumer, EmbersRecipes.getResource("sealed_wood"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RegistryManager.SEALED_WOOD_TILE.get()), (int)4).m_126130_("XX").m_126130_("XX").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.SEALED_PLANKS.get()).m_126132_("has_planks", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.SEALED_PLANKS.get()))).m_126140_(consumer, EmbersRecipes.getResource("sealed_wood_tile"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RegistryManager.SEALED_PLANKS.get()), (int)4).m_126130_("XX").m_126130_("XX").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.SEALED_WOOD_TILE.get()).m_126132_("has_planks", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.SEALED_PLANKS.get()))).m_126140_(consumer, EmbersRecipes.getResource("sealed_wood_reverse"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RegistryManager.SEALED_WOOD_PILLAR.get()), (int)2).m_126130_("X").m_126130_("X").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.SEALED_PLANKS.get()).m_126132_("has_planks", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.SEALED_PLANKS.get()))).m_126140_(consumer, EmbersRecipes.getResource("sealed_wood_pillar"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RegistryManager.REINFORCED_SEALED_PLANKS.get())).m_126209_((ItemLike)RegistryManager.SEALED_PLANKS.get()).m_126209_((ItemLike)Items.f_42025_).m_126132_("has_planks", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.SEALED_PLANKS.get()))).m_126140_(consumer, EmbersRecipes.getResource("reinforced_sealed_wood"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RegistryManager.SEALED_WOOD_KEG.get()), (int)2).m_126130_("X").m_126130_("X").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.REINFORCED_SEALED_PLANKS.get()).m_126132_("has_planks", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.SEALED_PLANKS.get()))).m_126140_(consumer, EmbersRecipes.getResource("sealed_wood_keg"));
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.SEALED_WOOD_TILE.get(), (ItemLike)RegistryManager.SEALED_PLANKS.get());
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.SEALED_WOOD_PILLAR.get(), (ItemLike)RegistryManager.SEALED_PLANKS.get());
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.SEALED_PLANKS.get(), (ItemLike)RegistryManager.SEALED_WOOD_TILE.get());
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.SEALED_WOOD_PILLAR.get(), (ItemLike)RegistryManager.SEALED_WOOD_TILE.get());
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.SEALED_WOOD_TILE.get(), (ItemLike)RegistryManager.SEALED_WOOD_PILLAR.get());
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.SEALED_PLANKS.get(), (ItemLike)RegistryManager.SEALED_WOOD_PILLAR.get());
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.SEALED_WOOD_KEG.get(), (ItemLike)RegistryManager.REINFORCED_SEALED_PLANKS.get());
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.REINFORCED_SEALED_PLANKS.get(), (ItemLike)RegistryManager.SEALED_WOOD_KEG.get());
        this.decoRecipes(RegistryManager.SEALED_PLANKS_DECO, consumer);
        this.decoRecipes(RegistryManager.SEALED_WOOD_TILE_DECO, consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RegistryManager.METAL_PLATFORM.get()), (int)4).m_126130_("XX").m_126130_("XX").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.SOLIDIFIED_METAL.get()).m_126132_("has_metal", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.SOLIDIFIED_METAL.get()))).m_126140_(consumer, EmbersRecipes.getResource("metal_platform"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RegistryManager.METAL_PLATFORM.get()), (int)1).m_126130_("X").m_126130_("X").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.METAL_PLATFORM_DECO.slab.get()).m_126132_("has_metal", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.SOLIDIFIED_METAL.get()))).m_126140_(consumer, EmbersRecipes.getResource("metal_platform_reverse"));
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.METAL_PLATFORM.get(), (ItemLike)RegistryManager.SOLIDIFIED_METAL.get());
        EmbersRecipes.m_247600_(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RegistryManager.SOLIDIFIED_METAL.get(), (ItemLike)RegistryManager.METAL_PLATFORM.get());
        this.decoRecipes(RegistryManager.METAL_PLATFORM_DECO, consumer);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RegistryManager.EMBER_LANTERN.get()), (int)4).m_126130_("P").m_126130_("E").m_126130_("I").m_126127_(Character.valueOf('E'), (ItemLike)RegistryManager.EMBER_SHARD.get()).m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/iron")).m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_126132_("has_shard", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.EMBER_SHARD.get()))).m_126140_(consumer, EmbersRecipes.getResource("ember_lantern"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.ANCIENT_CODEX.get())).m_126130_(" X ").m_126130_("XCX").m_126130_(" X ").m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.ARCHAIC_BRICK.get()).m_126127_(Character.valueOf('C'), (ItemLike)RegistryManager.ANCIENT_MOTIVE_CORE.get()).m_126132_("has_core", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.ANCIENT_MOTIVE_CORE.get()))).m_126140_(consumer, EmbersRecipes.getResource("ancient_codex"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)RegistryManager.TINKER_HAMMER.get())).m_126130_("IBI").m_126130_("ISI").m_126130_(" S ").m_206416_(Character.valueOf('B'), this.itemTag("forge", "ingots/lead")).m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_126132_("has_lead", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "ingots/lead"))).m_126140_(consumer, EmbersRecipes.getResource("tinker_hammer"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)RegistryManager.TINKER_LENS.get())).m_126130_("BE ").m_126130_("IPE").m_126130_("BE ").m_206416_(Character.valueOf('E'), this.itemTag("forge", "nuggets/lead")).m_206416_(Character.valueOf('I'), this.itemTag("forge", "plates/lead")).m_206416_(Character.valueOf('B'), this.itemTag("forge", "ingots/iron")).m_206416_(Character.valueOf('P'), Tags.Items.GLASS_SILICA).m_126132_("has_lead_plate", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "plates/lead"))).m_126140_(consumer, EmbersRecipes.getResource("tinker_lens"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)RegistryManager.SMOKY_TINKER_LENS.get())).m_126130_(" A ").m_126130_("APA").m_126130_(" A ").m_206416_(Character.valueOf('A'), EmbersItemTags.ASH_DUST).m_126127_(Character.valueOf('P'), (ItemLike)RegistryManager.TINKER_LENS.get()).m_126132_("has_ash", (CriterionTriggerInstance)EmbersRecipes.m_206406_(EmbersItemTags.ASH_DUST)).m_126140_(consumer, EmbersRecipes.getResource("smoky_tinker_lens"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)RegistryManager.ATMOSPHERIC_GAUGE.get())).m_126130_(" I ").m_126130_("CRC").m_126130_("CIC").m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_206416_(Character.valueOf('C'), this.itemTag("forge", "ingots/copper")).m_206416_(Character.valueOf('R'), this.itemTag("forge", "dusts/redstone")).m_126132_("has_redstone", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "dusts/redstone"))).m_126140_(consumer, EmbersRecipes.getResource("atmospheric_gauge"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)RegistryManager.EMBER_JAR.get())).m_126130_(" C ").m_126130_("ISI").m_126130_(" G ").m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_206416_(Character.valueOf('C'), this.itemTag("forge", "ingots/copper")).m_126127_(Character.valueOf('S'), (ItemLike)RegistryManager.EMBER_SHARD.get()).m_206416_(Character.valueOf('G'), Tags.Items.GLASS_SILICA).m_126132_("has_charger", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.COPPER_CHARGER.get()))).m_126140_(consumer, EmbersRecipes.getResource("ember_jar"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)RegistryManager.EMBER_CARTRIDGE.get())).m_126130_("ICI").m_126130_("GSG").m_126130_(" G ").m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_206416_(Character.valueOf('C'), this.itemTag("forge", "ingots/copper")).m_126127_(Character.valueOf('S'), (ItemLike)RegistryManager.EMBER_CRYSTAL.get()).m_206416_(Character.valueOf('G'), Tags.Items.GLASS_SILICA).m_126132_("has_charger", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.COPPER_CHARGER.get()))).m_126140_(consumer, EmbersRecipes.getResource("ember_cartridge"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)CuriosCompat.EMBER_BULB.get())).m_126130_(" CI").m_126130_("GSG").m_126130_(" G ").m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/lead")).m_206416_(Character.valueOf('C'), this.itemTag("forge", "plates/dawnstone")).m_126127_(Character.valueOf('S'), (ItemLike)RegistryManager.EMBER_CRYSTAL_CLUSTER.get()).m_206416_(Character.valueOf('G'), Tags.Items.GLASS_SILICA).m_126132_("has_cluster", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.EMBER_CRYSTAL_CLUSTER.get()))).m_176498_(ConsumerWrapperBuilder.wrap().addCondition((ICondition)new ModLoadedCondition("curios")).build(consumer));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)RegistryManager.CLOCKWORK_PICKAXE.get())).m_126130_("ISI").m_126130_(" C ").m_126130_(" W ").m_206416_(Character.valueOf('C'), this.itemTag("forge", "ingots/copper")).m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/dawnstone")).m_126127_(Character.valueOf('S'), (ItemLike)RegistryManager.EMBER_SHARD.get()).m_206416_(Character.valueOf('W'), Tags.Items.RODS_WOODEN).m_126132_("has_charger", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.COPPER_CHARGER.get()))).m_126140_(consumer, EmbersRecipes.getResource("clockwork_pickaxe"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)RegistryManager.CLOCKWORK_AXE.get())).m_126130_("PCP").m_126130_("ISI").m_126130_(" W ").m_206416_(Character.valueOf('C'), this.itemTag("forge", "plates/copper")).m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/dawnstone")).m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/dawnstone")).m_126127_(Character.valueOf('S'), (ItemLike)RegistryManager.EMBER_SHARD.get()).m_206416_(Character.valueOf('W'), Tags.Items.RODS_WOODEN).m_126132_("has_charger", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.COPPER_CHARGER.get()))).m_126140_(consumer, EmbersRecipes.getResource("clockwork_axe"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)RegistryManager.GRANDHAMMER.get())).m_126130_("BIB").m_126130_(" C ").m_126130_(" W ").m_206416_(Character.valueOf('C'), this.itemTag("forge", "ingots/copper")).m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/dawnstone")).m_206416_(Character.valueOf('B'), this.itemTag("forge", "storage_blocks/dawnstone")).m_206416_(Character.valueOf('W'), Tags.Items.RODS_WOODEN).m_126132_("has_charger", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.COPPER_CHARGER.get()))).m_126140_(consumer, EmbersRecipes.getResource("grandhammer"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)RegistryManager.BLAZING_RAY.get())).m_126130_(" DP").m_126130_("DPI").m_126130_("SW ").m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_206416_(Character.valueOf('D'), this.itemTag("forge", "ingots/dawnstone")).m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/dawnstone")).m_126127_(Character.valueOf('S'), (ItemLike)RegistryManager.EMBER_SHARD.get()).m_206416_(Character.valueOf('W'), Tags.Items.RODS_WOODEN).m_126132_("has_charger", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.COPPER_CHARGER.get()))).m_126140_(consumer, EmbersRecipes.getResource("blazing_ray"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)RegistryManager.CINDER_STAFF.get())).m_126130_("SES").m_126130_("IWI").m_126130_(" W ").m_206416_(Character.valueOf('S'), this.itemTag("forge", "plates/silver")).m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/dawnstone")).m_126127_(Character.valueOf('E'), (ItemLike)RegistryManager.EMBER_SHARD.get()).m_206416_(Character.valueOf('W'), Tags.Items.RODS_WOODEN).m_126132_("has_charger", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.COPPER_CHARGER.get()))).m_126140_(consumer, EmbersRecipes.getResource("cinder_staff"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)RegistryManager.ASHEN_GOGGLES.get())).m_126130_(" S ").m_126130_("C C").m_126130_("DCD").m_206416_(Character.valueOf('S'), Tags.Items.STRING).m_206416_(Character.valueOf('D'), this.itemTag("forge", "ingots/dawnstone")).m_126127_(Character.valueOf('C'), (ItemLike)RegistryManager.ASHEN_FABRIC.get()).m_126132_("has_ashen_fabric", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.ASHEN_FABRIC.get()))).m_126140_(consumer, EmbersRecipes.getResource("ashen_goggles"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)RegistryManager.ASHEN_CLOAK.get())).m_126130_("P P").m_126130_("CDC").m_126130_("CDC").m_206416_(Character.valueOf('D'), this.itemTag("forge", "ingots/dawnstone")).m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/dawnstone")).m_126127_(Character.valueOf('C'), (ItemLike)RegistryManager.ASHEN_FABRIC.get()).m_126132_("has_ashen_fabric", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.ASHEN_FABRIC.get()))).m_126140_(consumer, EmbersRecipes.getResource("ashen_cloak"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)RegistryManager.ASHEN_LEGGINGS.get())).m_126130_("CCC").m_126130_("D D").m_126130_("D D").m_206416_(Character.valueOf('D'), this.itemTag("forge", "ingots/dawnstone")).m_126127_(Character.valueOf('C'), (ItemLike)RegistryManager.ASHEN_FABRIC.get()).m_126132_("has_ashen_fabric", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.ASHEN_FABRIC.get()))).m_126140_(consumer, EmbersRecipes.getResource("ashen_leggings"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)RegistryManager.ASHEN_BOOTS.get())).m_126130_("C C").m_126130_("C C").m_126130_("C C").m_126127_(Character.valueOf('C'), (ItemLike)RegistryManager.ASHEN_FABRIC.get()).m_126132_("has_ashen_fabric", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.ASHEN_FABRIC.get()))).m_126140_(consumer, EmbersRecipes.getResource("ashen_boots"));
        this.toolRecipes(RegistryManager.LEAD_TOOLS, EmbersItemTags.LEAD_INGOT, (Item)RegistryManager.LEAD_NUGGET.get(), consumer);
        this.toolRecipes(RegistryManager.SILVER_TOOLS, EmbersItemTags.SILVER_INGOT, (Item)RegistryManager.SILVER_NUGGET.get(), consumer);
        this.toolRecipes(RegistryManager.DAWNSTONE_TOOLS, EmbersItemTags.DAWNSTONE_INGOT, (Item)RegistryManager.DAWNSTONE_NUGGET.get(), consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)CuriosCompat.EMBER_RING.get())).m_126130_("CN ").m_126130_("N N").m_126130_(" N ").m_126127_(Character.valueOf('C'), (ItemLike)RegistryManager.EMBER_CRYSTAL_CLUSTER.get()).m_206416_(Character.valueOf('N'), this.itemTag("forge", "ingots/dawnstone")).m_126132_("has_cluster", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.EMBER_CRYSTAL_CLUSTER.get()))).m_176498_(ConsumerWrapperBuilder.wrap().addCondition((ICondition)new ModLoadedCondition("curios")).build(consumer));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)CuriosCompat.EMBER_BELT.get())).m_126130_("LIL").m_126130_("L L").m_126130_("PCP").m_126127_(Character.valueOf('C'), (ItemLike)RegistryManager.EMBER_CRYSTAL_CLUSTER.get()).m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/dawnstone")).m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/dawnstone")).m_206416_(Character.valueOf('L'), Tags.Items.LEATHER).m_126132_("has_cluster", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.EMBER_CRYSTAL_CLUSTER.get()))).m_176498_(ConsumerWrapperBuilder.wrap().addCondition((ICondition)new ModLoadedCondition("curios")).build(consumer));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)CuriosCompat.EMBER_AMULET.get())).m_126130_(" L ").m_126130_("L L").m_126130_("NCN").m_126127_(Character.valueOf('C'), (ItemLike)RegistryManager.EMBER_CRYSTAL_CLUSTER.get()).m_206416_(Character.valueOf('N'), this.itemTag("forge", "ingots/dawnstone")).m_206416_(Character.valueOf('L'), Tags.Items.LEATHER).m_126132_("has_cluster", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.EMBER_CRYSTAL_CLUSTER.get()))).m_176498_(ConsumerWrapperBuilder.wrap().addCondition((ICondition)new ModLoadedCondition("curios")).build(consumer));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)CuriosCompat.DAWNSTONE_MAIL.get())).m_126130_("P P").m_126130_("PPP").m_126130_("PPP").m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/dawnstone")).m_126132_("has_dawnstone_plate", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "plates/dawnstone"))).m_176498_(ConsumerWrapperBuilder.wrap().addCondition((ICondition)new ModLoadedCondition("curios")).build(consumer));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)CuriosCompat.ASHEN_AMULET.get())).m_126130_(" L ").m_126130_("L L").m_126130_("NCN").m_206416_(Character.valueOf('C'), EmbersItemTags.ASH_DUST).m_126127_(Character.valueOf('N'), (ItemLike)RegistryManager.ARCHAIC_BRICK.get()).m_206416_(Character.valueOf('L'), Tags.Items.LEATHER).m_126132_("has_ash", (CriterionTriggerInstance)EmbersRecipes.m_206406_(EmbersItemTags.ASH_DUST)).m_176498_(ConsumerWrapperBuilder.wrap().addCondition((ICondition)new ModLoadedCondition("curios")).build(consumer));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.MECHANICAL_CORE.get())).m_126130_("IBI").m_126130_(" P ").m_126130_("I I").m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/lead")).m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_126127_(Character.valueOf('B'), (ItemLike)RegistryManager.CAMINITE_BRICKS.get()).m_126132_("has_lead_plate", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "plates/lead"))).m_126140_(consumer, EmbersRecipes.getResource("mechanical_core"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.EMBER_BORE.get())).m_126130_("YCY").m_126130_("YBY").m_126130_("III").m_126127_(Character.valueOf('B'), (ItemLike)RegistryManager.MECHANICAL_CORE.get()).m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_206416_(Character.valueOf('C'), this.itemTag("forge", "ingots/copper")).m_126127_(Character.valueOf('Y'), (ItemLike)RegistryManager.CAMINITE_BRICKS.get()).m_126132_("has_mech_core", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.MECHANICAL_CORE.get()))).m_126140_(consumer, EmbersRecipes.getResource("ember_bore"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)RegistryManager.CAMINITE_LEVER.get()), (int)4).m_126130_("S").m_126130_("P").m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_126127_(Character.valueOf('P'), (ItemLike)RegistryManager.CAMINITE_PLATE.get()).m_126132_("has_caminite_plate", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.CAMINITE_PLATE.get()))).m_126140_(consumer, EmbersRecipes.getResource("caminite_lever"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)RegistryManager.CAMINITE_BUTTON.get())).m_126209_((ItemLike)RegistryManager.CAMINITE_BRICK.get()).m_126132_("has_caminite", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.CAMINITE_BRICK.get()))).m_126140_(consumer, EmbersRecipes.getResource("caminite_button"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.EMBER_EMITTER.get()), (int)4).m_126130_(" C ").m_126130_(" C ").m_126130_("IPI").m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_206416_(Character.valueOf('C'), this.itemTag("forge", "ingots/copper")).m_126127_(Character.valueOf('P'), (ItemLike)RegistryManager.CAMINITE_PLATE.get()).m_126132_("has_caminite_plate", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.CAMINITE_PLATE.get()))).m_126140_(consumer, EmbersRecipes.getResource("ember_emitter"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.EMBER_RECEIVER.get()), (int)4).m_126130_("I I").m_126130_("CPC").m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_206416_(Character.valueOf('C'), this.itemTag("forge", "ingots/copper")).m_126127_(Character.valueOf('P'), (ItemLike)RegistryManager.CAMINITE_PLATE.get()).m_126132_("has_caminite_plate", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.CAMINITE_PLATE.get()))).m_126140_(consumer, EmbersRecipes.getResource("ember_receiver"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.EMBER_ACTIVATOR.get())).m_126130_("CCC").m_126130_("CCC").m_126130_("IFI").m_206416_(Character.valueOf('I'), this.itemTag("forge", "plates/iron")).m_206416_(Character.valueOf('C'), this.itemTag("forge", "ingots/copper")).m_126127_(Character.valueOf('F'), (ItemLike)Items.f_41962_).m_126132_("has_iron_plate", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "plates/iron"))).m_126140_(consumer, EmbersRecipes.getResource("ember_activator"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.PRESSURE_REFINERY.get())).m_126130_("CCC").m_126130_("IDI").m_126130_("IBI").m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_206416_(Character.valueOf('C'), this.itemTag("forge", "ingots/copper")).m_206416_(Character.valueOf('B'), this.itemTag("forge", "storage_blocks/copper")).m_206416_(Character.valueOf('D'), this.itemTag("forge", "ingots/dawnstone")).m_126132_("has_dawnstone", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "ingots/dawnstone"))).m_126140_(consumer, EmbersRecipes.getResource("pressure_refinery"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.COPPER_CELL.get())).m_126130_("BIB").m_126130_("ICI").m_126130_("BIB").m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_206416_(Character.valueOf('C'), this.itemTag("forge", "storage_blocks/copper")).m_126127_(Character.valueOf('B'), (ItemLike)RegistryManager.CAMINITE_BRICKS.get()).m_126132_("has_caminite_bricks", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.CAMINITE_BRICKS.get()))).m_126140_(consumer, EmbersRecipes.getResource("copper_cell"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.MELTER.get())).m_126130_("BPB").m_126130_("BCB").m_126130_("IFI").m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_206416_(Character.valueOf('C'), this.itemTag("forge", "ingots/copper")).m_126127_(Character.valueOf('P'), (ItemLike)RegistryManager.CAMINITE_PLATE.get()).m_126127_(Character.valueOf('B'), (ItemLike)RegistryManager.CAMINITE_BRICKS.get()).m_126127_(Character.valueOf('F'), (ItemLike)Items.f_41962_).m_126132_("has_caminite_bricks", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.CAMINITE_BRICKS.get()))).m_126140_(consumer, EmbersRecipes.getResource("melter"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.FLUID_VESSEL.get())).m_126130_("B B").m_126130_("P P").m_126130_("BIB").m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/iron")).m_126127_(Character.valueOf('B'), (ItemLike)RegistryManager.CAMINITE_BRICK.get()).m_126132_("has_caminite_brick", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.CAMINITE_BRICK.get()))).m_126140_(consumer, EmbersRecipes.getResource("fluid_vessel"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.STAMPER.get())).m_126130_("XCX").m_126130_("XBX").m_126130_("X X").m_206416_(Character.valueOf('B'), this.itemTag("forge", "storage_blocks/iron")).m_206416_(Character.valueOf('C'), this.itemTag("forge", "ingots/copper")).m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.CAMINITE_BRICK.get()).m_126132_("has_iron_block", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "storage_blocks/iron"))).m_126140_(consumer, EmbersRecipes.getResource("stamper"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.STAMP_BASE.get())).m_126130_("I I").m_126130_("XBX").m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42446_).m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.CAMINITE_BRICK.get()).m_126132_("has_bucket", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)Items.f_42446_)).m_126140_(consumer, EmbersRecipes.getResource("stamp_base"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.EMBER_DIAL.get())).m_126130_("P").m_126130_("C").m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_206416_(Character.valueOf('C'), this.itemTag("forge", "plates/copper")).m_126132_("has_copper_plate", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "plates/copper"))).m_126140_(consumer, EmbersRecipes.getResource("ember_dial"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.ITEM_DIAL.get())).m_126130_("P").m_126130_("L").m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_206416_(Character.valueOf('L'), this.itemTag("forge", "plates/lead")).m_126132_("has_lead_plate", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "plates/lead"))).m_126140_(consumer, EmbersRecipes.getResource("item_dial"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.FLUID_DIAL.get())).m_126130_("P").m_126130_("I").m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_206416_(Character.valueOf('I'), this.itemTag("forge", "plates/iron")).m_126132_("has_iron_plate", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "plates/iron"))).m_126140_(consumer, EmbersRecipes.getResource("fluid_dial"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.CLOCKWORK_ATTENUATOR.get())).m_126130_("P").m_126130_("I").m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_206416_(Character.valueOf('I'), this.itemTag("forge", "plates/silver")).m_126132_("has_silver_plate", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "plates/silver"))).m_126140_(consumer, EmbersRecipes.getResource("clockwork_attenuator"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.FLUID_PIPE.get()), (int)8).m_126130_("IPI").m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/iron")).m_126132_("has_iron_plate", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "plates/iron"))).m_126140_(consumer, EmbersRecipes.getResource("fluid_pipe"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.ITEM_PIPE.get()), (int)8).m_126130_("IPI").m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/lead")).m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/lead")).m_126132_("has_lead_plate", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "plates/lead"))).m_126140_(consumer, EmbersRecipes.getResource("item_pipe"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.FLUID_EXTRACTOR.get())).m_126130_(" R ").m_126130_("PBP").m_126130_(" R ").m_126127_(Character.valueOf('P'), (ItemLike)RegistryManager.FLUID_PIPE.get()).m_126127_(Character.valueOf('B'), (ItemLike)RegistryManager.CAMINITE_PLATE.get()).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_126132_("has_fluid_pipe", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.FLUID_PIPE.get()))).m_126140_(consumer, EmbersRecipes.getResource("fluid_extractor"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.ITEM_EXTRACTOR.get())).m_126130_(" R ").m_126130_("PBP").m_126130_(" R ").m_126127_(Character.valueOf('P'), (ItemLike)RegistryManager.ITEM_PIPE.get()).m_126127_(Character.valueOf('B'), (ItemLike)RegistryManager.CAMINITE_PLATE.get()).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_126132_("has_item_pipe", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.ITEM_PIPE.get()))).m_126140_(consumer, EmbersRecipes.getResource("item_extractor"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.ITEM_DROPPER.get())).m_126130_(" P ").m_126130_("I I").m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/lead")).m_126127_(Character.valueOf('P'), (ItemLike)RegistryManager.ITEM_PIPE.get()).m_126132_("has_item_pipe", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.ITEM_PIPE.get()))).m_126140_(consumer, EmbersRecipes.getResource("item_dropper"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.BIN.get())).m_126130_("I I").m_126130_("I I").m_126130_("IPI").m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/lead")).m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/lead")).m_126132_("has_lead_plate", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "plates/lead"))).m_126140_(consumer, EmbersRecipes.getResource("bin"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.MIXER_CENTRIFUGE.get())).m_126130_("PPP").m_126130_("PCP").m_126130_("IMI").m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/iron")).m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_206416_(Character.valueOf('C'), this.itemTag("forge", "ingots/copper")).m_126127_(Character.valueOf('M'), (ItemLike)RegistryManager.MECHANICAL_CORE.get()).m_126132_("has_melter", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.MELTER.get()))).m_126140_(consumer, EmbersRecipes.getResource("mixer_centrifuge"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.EMBER_EJECTOR.get())).m_126130_("P").m_126130_("E").m_126130_("I").m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/dawnstone")).m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_126127_(Character.valueOf('E'), (ItemLike)RegistryManager.EMBER_EMITTER.get()).m_126132_("has_dawnstone", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "ingots/dawnstone"))).m_126140_(consumer, EmbersRecipes.getResource("ember_ejector"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.EMBER_FUNNEL.get())).m_126130_("P P").m_126130_("CRC").m_126130_(" P ").m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/dawnstone")).m_206416_(Character.valueOf('C'), this.itemTag("forge", "ingots/copper")).m_126127_(Character.valueOf('R'), (ItemLike)RegistryManager.EMBER_RECEIVER.get()).m_126132_("has_dawnstone", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "ingots/dawnstone"))).m_126140_(consumer, EmbersRecipes.getResource("ember_funnel"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.EMBER_RELAY.get()), (int)4).m_126130_(" C ").m_126130_("C C").m_126130_(" P ").m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/iron")).m_206416_(Character.valueOf('C'), this.itemTag("forge", "ingots/copper")).m_126132_("has_iron_plate", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "plates/iron"))).m_126140_(consumer, EmbersRecipes.getResource("ember_relay"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.MIRROR_RELAY.get()), (int)4).m_126130_(" P ").m_126130_("S S").m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/lead")).m_206416_(Character.valueOf('S'), this.itemTag("forge", "ingots/silver")).m_126132_("has_silver", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "ingots/silver"))).m_126140_(consumer, EmbersRecipes.getResource("mirror_relay"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.BEAM_SPLITTER.get())).m_126130_(" D ").m_126130_("CPC").m_126130_(" I ").m_206416_(Character.valueOf('C'), this.itemTag("forge", "ingots/copper")).m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/iron")).m_206416_(Character.valueOf('D'), this.itemTag("forge", "ingots/dawnstone")).m_126132_("has_dawnstone", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "ingots/dawnstone"))).m_126140_(consumer, EmbersRecipes.getResource("beam_splitter"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.ITEM_VACUUM.get())).m_126130_(" II").m_126130_("P  ").m_126130_(" II").m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/lead")).m_126127_(Character.valueOf('P'), (ItemLike)RegistryManager.ITEM_PIPE.get()).m_126132_("has_item_pipe", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.ITEM_PIPE.get()))).m_126140_(consumer, EmbersRecipes.getResource("item_vacuum"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.HEARTH_COIL.get())).m_126130_("PPP").m_126130_("ICI").m_126130_(" B ").m_126127_(Character.valueOf('B'), (ItemLike)RegistryManager.MECHANICAL_CORE.get()).m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/copper")).m_206416_(Character.valueOf('C'), this.itemTag("forge", "storage_blocks/copper")).m_126132_("has_mech_core", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.MECHANICAL_CORE.get()))).m_126140_(consumer, EmbersRecipes.getResource("hearth_coil"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.RESERVOIR.get())).m_126130_("B B").m_126130_("I I").m_126130_("BTB").m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_126127_(Character.valueOf('B'), (ItemLike)RegistryManager.CAMINITE_BRICKS.get()).m_126127_(Character.valueOf('T'), (ItemLike)RegistryManager.FLUID_VESSEL.get()).m_126132_("has_vessel", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.FLUID_VESSEL.get()))).m_126140_(consumer, EmbersRecipes.getResource("reservoir"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.CAMINITE_RING.get())).m_126130_("BBB").m_126130_("B B").m_126130_("BBB").m_126127_(Character.valueOf('B'), (ItemLike)RegistryManager.CAMINITE_BRICKS.get()).m_126132_("has_reservoir", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.RESERVOIR.get()))).m_126140_(consumer, EmbersRecipes.getResource("caminite_ring"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.CAMINITE_GAUGE.get())).m_126130_("BBB").m_126130_("G G").m_126130_("BBB").m_126127_(Character.valueOf('B'), (ItemLike)RegistryManager.CAMINITE_BRICKS.get()).m_206416_(Character.valueOf('G'), Tags.Items.GLASS_SILICA).m_126132_("has_reservoir", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.RESERVOIR.get()))).m_126140_(consumer, EmbersRecipes.getResource("caminite_gauge"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.CAMINITE_VALVE.get())).m_126130_("BBB").m_126130_("P P").m_126130_("BBB").m_126127_(Character.valueOf('B'), (ItemLike)RegistryManager.CAMINITE_BRICKS.get()).m_126127_(Character.valueOf('P'), (ItemLike)RegistryManager.FLUID_PIPE.get()).m_126132_("has_reservoir", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.RESERVOIR.get()))).m_126140_(consumer, EmbersRecipes.getResource("caminite_valve"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.CRYSTAL_CELL.get())).m_126130_(" E ").m_126130_("DED").m_126130_("CBC").m_206416_(Character.valueOf('C'), this.itemTag("forge", "storage_blocks/copper")).m_206416_(Character.valueOf('B'), this.itemTag("forge", "storage_blocks/dawnstone")).m_206416_(Character.valueOf('D'), this.itemTag("forge", "plates/dawnstone")).m_126127_(Character.valueOf('E'), (ItemLike)RegistryManager.EMBER_CRYSTAL.get()).m_126132_("has_dawnstone", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "ingots/dawnstone"))).m_126140_(consumer, EmbersRecipes.getResource("crystal_cell"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.GEOLOGIC_SEPARATOR.get())).m_126130_("  B").m_126130_("GIG").m_206416_(Character.valueOf('B'), this.itemTag("forge", "storage_blocks/silver")).m_126127_(Character.valueOf('G'), (ItemLike)RegistryManager.CAMINITE_BRICK.get()).m_126127_(Character.valueOf('I'), (ItemLike)RegistryManager.FLUID_VESSEL.get()).m_126132_("has_silver", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "ingots/silver"))).m_126140_(consumer, EmbersRecipes.getResource("geologic_separator"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.COPPER_CHARGER.get())).m_126130_(" X ").m_126130_("DCD").m_126130_("IPI").m_206416_(Character.valueOf('D'), this.itemTag("forge", "ingots/dawnstone")).m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/copper")).m_206416_(Character.valueOf('C'), this.itemTag("forge", "ingots/copper")).m_206416_(Character.valueOf('X'), this.itemTag("forge", "plates/iron")).m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_126132_("has_dawnstone", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "ingots/dawnstone"))).m_126140_(consumer, EmbersRecipes.getResource("copper_charger"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.EMBER_SIPHON.get())).m_126130_("BGB").m_126130_("XGX").m_126130_("BBB").m_206416_(Character.valueOf('G'), this.itemTag("forge", "ingots/copper")).m_206416_(Character.valueOf('X'), this.itemTag("forge", "plates/silver")).m_126127_(Character.valueOf('B'), (ItemLike)RegistryManager.CAMINITE_BRICK.get()).m_126132_("has_charger", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.COPPER_CHARGER.get()))).m_126140_(consumer, EmbersRecipes.getResource("ember_siphon"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.ITEM_TRANSFER.get()), (int)3).m_126130_("PLP").m_126130_("ILI").m_126130_("I I").m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/lead")).m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/lead")).m_126127_(Character.valueOf('L'), (ItemLike)RegistryManager.ITEM_PIPE.get()).m_126132_("has_item_pipe", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.ITEM_PIPE.get()))).m_126140_(consumer, EmbersRecipes.getResource("item_transfer"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.FLUID_TRANSFER.get()), (int)3).m_126130_("PLP").m_126130_("ILI").m_126130_("I I").m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/iron")).m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_126127_(Character.valueOf('L'), (ItemLike)RegistryManager.FLUID_PIPE.get()).m_126132_("has_fluid_pipe", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.FLUID_PIPE.get()))).m_126140_(consumer, EmbersRecipes.getResource("fluid_transfer"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.ALCHEMY_PEDESTAL.get())).m_126130_("D D").m_126130_("ICI").m_126130_("SBS").m_206416_(Character.valueOf('D'), this.itemTag("forge", "plates/dawnstone")).m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/dawnstone")).m_206416_(Character.valueOf('B'), this.itemTag("forge", "storage_blocks/copper")).m_126127_(Character.valueOf('C'), (ItemLike)RegistryManager.EMBER_CRYSTAL.get()).m_126127_(Character.valueOf('S'), (ItemLike)RegistryManager.CAMINITE_BRICKS.get()).m_126132_("has_dawnstone", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "ingots/dawnstone"))).m_126140_(consumer, EmbersRecipes.getResource("alchemy_pedestal"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.ALCHEMY_TABLET.get())).m_126130_(" D ").m_126130_("SXS").m_126130_("SIS").m_206416_(Character.valueOf('D'), this.itemTag("forge", "plates/dawnstone")).m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/dawnstone")).m_206416_(Character.valueOf('X'), this.itemTag("forge", "plates/copper")).m_126127_(Character.valueOf('S'), (ItemLike)RegistryManager.CAMINITE_BRICKS.get()).m_126132_("has_dawnstone", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "ingots/dawnstone"))).m_126140_(consumer, EmbersRecipes.getResource("alchemy_tablet"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.BEAM_CANNON.get())).m_126130_("PSP").m_126130_("PSP").m_126130_("IBI").m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/copper")).m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/dawnstone")).m_126127_(Character.valueOf('B'), (ItemLike)RegistryManager.CAMINITE_BRICKS.get()).m_126127_(Character.valueOf('S'), (ItemLike)RegistryManager.EMBER_CRYSTAL.get()).m_126132_("has_dawnstone", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "ingots/dawnstone"))).m_126140_(consumer, EmbersRecipes.getResource("beam_cannon"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.MECHANICAL_PUMP.get())).m_126130_("EPE").m_126130_("PPP").m_126130_("BIB").m_126127_(Character.valueOf('E'), (ItemLike)RegistryManager.FLUID_PIPE.get()).m_126127_(Character.valueOf('I'), (ItemLike)RegistryManager.FLUID_EXTRACTOR.get()).m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/iron")).m_126127_(Character.valueOf('B'), (ItemLike)RegistryManager.CAMINITE_BRICK.get()).m_126132_("has_extractor", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.FLUID_EXTRACTOR.get()))).m_126140_(consumer, EmbersRecipes.getResource("mechanical_pump"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.MINI_BOILER.get())).m_126130_("PPP").m_126130_("E P").m_126130_("PPP").m_206416_(Character.valueOf('E'), this.itemTag("forge", "ingots/copper")).m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/iron")).m_126132_("has_iron_plate", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "plates/iron"))).m_126140_(consumer, EmbersRecipes.getResource("mini_boiler"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.WILDFIRE_STIRLING.get())).m_126130_("XGX").m_126130_("XGX").m_126130_("BPB").m_206416_(Character.valueOf('G'), this.itemTag("forge", "storage_blocks/copper")).m_206416_(Character.valueOf('X'), this.itemTag("forge", "plates/dawnstone")).m_126127_(Character.valueOf('P'), (ItemLike)RegistryManager.WILDFIRE_CORE.get()).m_126127_(Character.valueOf('B'), (ItemLike)RegistryManager.EMBER_SHARD.get()).m_126132_("has_wildfire_core", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.WILDFIRE_CORE.get()))).m_126140_(consumer, EmbersRecipes.getResource("wildfire_stirling"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.EMBER_INJECTOR.get())).m_126130_("S S").m_126130_("DCD").m_126130_("BPB").m_206416_(Character.valueOf('S'), this.itemTag("forge", "ingots/silver")).m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/silver")).m_206416_(Character.valueOf('D'), this.itemTag("forge", "plates/dawnstone")).m_126127_(Character.valueOf('C'), (ItemLike)RegistryManager.WILDFIRE_CORE.get()).m_126127_(Character.valueOf('B'), (ItemLike)RegistryManager.CAMINITE_BRICKS.get()).m_126132_("has_wildfire_core", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.WILDFIRE_CORE.get()))).m_126140_(consumer, EmbersRecipes.getResource("ember_injector"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.FIELD_CHART.get())).m_126130_("BBB").m_126130_("BCB").m_126130_("BBB").m_126127_(Character.valueOf('C'), (ItemLike)RegistryManager.EMBER_CRYSTAL_CLUSTER.get()).m_126127_(Character.valueOf('B'), (ItemLike)RegistryManager.ARCHAIC_BRICK.get()).m_126132_("has_cluster", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.EMBER_CRYSTAL_CLUSTER.get()))).m_126140_(consumer, EmbersRecipes.getResource("field_chart"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)Items.f_42655_, (int)2).m_126130_("SS ").m_126130_("SB ").m_126130_("  S").m_206416_(Character.valueOf('S'), Tags.Items.STRING).m_206416_(Character.valueOf('B'), Tags.Items.SLIMEBALLS).m_126132_("has_slime", (CriterionTriggerInstance)EmbersRecipes.m_206406_((TagKey)Tags.Items.SLIMEBALLS)).m_126140_(consumer, EmbersRecipes.getResource("lead_adhesive"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Items.f_41862_).m_126130_("B").m_126130_("P").m_126127_(Character.valueOf('P'), (ItemLike)Items.f_41869_).m_206416_(Character.valueOf('B'), Tags.Items.SLIMEBALLS).m_126132_("has_slime", (CriterionTriggerInstance)EmbersRecipes.m_206406_((TagKey)Tags.Items.SLIMEBALLS)).m_126140_(consumer, EmbersRecipes.getResource("sticky_piston_adhesive"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.IGNEM_REACTOR.get())).m_126130_("CCC").m_126130_("CWC").m_126130_("SBS").m_206416_(Character.valueOf('C'), this.itemTag("forge", "ingots/copper")).m_206416_(Character.valueOf('S'), this.itemTag("forge", "plates/silver")).m_126127_(Character.valueOf('W'), (ItemLike)RegistryManager.WILDFIRE_CORE.get()).m_126127_(Character.valueOf('B'), (ItemLike)RegistryManager.CAMINITE_BRICKS.get()).m_126132_("has_wildfire_core", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.WILDFIRE_CORE.get()))).m_126140_(consumer, EmbersRecipes.getResource("ignem_reactor"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.CATALYSIS_CHAMBER.get())).m_126130_(" C ").m_126130_("PEP").m_126130_("CMC").m_206416_(Character.valueOf('C'), this.itemTag("forge", "ingots/silver")).m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/silver")).m_126127_(Character.valueOf('M'), (ItemLike)RegistryManager.MECHANICAL_CORE.get()).m_126127_(Character.valueOf('E'), (ItemLike)RegistryManager.EMBER_CRYSTAL_CLUSTER.get()).m_126132_("has_wildfire_core", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.WILDFIRE_CORE.get()))).m_126140_(consumer, EmbersRecipes.getResource("catalysis_chamber"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.COMBUSTION_CHAMBER.get())).m_126130_(" C ").m_126130_("PEP").m_126130_("CMC").m_206416_(Character.valueOf('C'), this.itemTag("forge", "ingots/copper")).m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/copper")).m_126127_(Character.valueOf('M'), (ItemLike)RegistryManager.MECHANICAL_CORE.get()).m_126127_(Character.valueOf('E'), (ItemLike)RegistryManager.EMBER_CRYSTAL_CLUSTER.get()).m_126132_("has_wildfire_core", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.WILDFIRE_CORE.get()))).m_126140_(consumer, EmbersRecipes.getResource("combustion_chamber"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.GLIMMER_LAMP.get())).m_126130_(" P ").m_126130_("IGI").m_126130_(" P ").m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/iron")).m_126127_(Character.valueOf('G'), (ItemLike)RegistryManager.GLIMMER_CRYSTAL.get()).m_126132_("has_glimmer_crystal", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.GLIMMER_CRYSTAL.get()))).m_126140_(consumer, EmbersRecipes.getResource("glimmer_lamp"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.CINDER_PLINTH.get())).m_126130_(" P ").m_126130_("SFS").m_126130_("PBP").m_206416_(Character.valueOf('S'), this.itemTag("forge", "ingots/silver")).m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/lead")).m_126127_(Character.valueOf('B'), (ItemLike)RegistryManager.CAMINITE_BRICKS.get()).m_126127_(Character.valueOf('F'), (ItemLike)Blocks.f_50094_).m_126132_("has_silver", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "ingots/silver"))).m_126140_(consumer, EmbersRecipes.getResource("cinder_plinth"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.DAWNSTONE_ANVIL.get())).m_126130_("BBB").m_126130_(" I ").m_126130_("CCC").m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/dawnstone")).m_206416_(Character.valueOf('B'), this.itemTag("forge", "storage_blocks/dawnstone")).m_126127_(Character.valueOf('C'), (ItemLike)RegistryManager.CAMINITE_BRICKS.get()).m_126132_("has_dawnstone", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "ingots/dawnstone"))).m_126140_(consumer, EmbersRecipes.getResource("dawnstone_anvil"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.AUTOMATIC_HAMMER.get())).m_126130_("BB ").m_126130_("CIX").m_126130_("BB ").m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_206416_(Character.valueOf('X'), this.itemTag("forge", "storage_blocks/iron")).m_206416_(Character.valueOf('C'), this.itemTag("forge", "storage_blocks/copper")).m_126127_(Character.valueOf('B'), (ItemLike)RegistryManager.CAMINITE_BRICKS.get()).m_126132_("has_anvil", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.DAWNSTONE_ANVIL.get()))).m_126140_(consumer, EmbersRecipes.getResource("automatic_hammer"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.INFERNO_FORGE.get())).m_126130_("BPB").m_126130_("DCD").m_126130_("SWS").m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/iron")).m_206416_(Character.valueOf('C'), this.itemTag("forge", "storage_blocks/copper")).m_206416_(Character.valueOf('D'), this.itemTag("forge", "ingots/dawnstone")).m_206416_(Character.valueOf('B'), this.itemTag("forge", "storage_blocks/dawnstone")).m_126127_(Character.valueOf('W'), (ItemLike)RegistryManager.WILDFIRE_CORE.get()).m_126127_(Character.valueOf('S'), (ItemLike)RegistryManager.CAMINITE_BRICKS.get()).m_126132_("has_wildfire_core", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.WILDFIRE_CORE.get()))).m_126140_(consumer, EmbersRecipes.getResource("inferno_forge"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.ARCHAIC_CIRCUIT.get())).m_126130_(" B ").m_126130_("BCB").m_126130_(" B ").m_206416_(Character.valueOf('C'), this.itemTag("forge", "ingots/copper")).m_126127_(Character.valueOf('B'), (ItemLike)RegistryManager.ARCHAIC_BRICK.get()).m_126132_("has_archaic_brick", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.ARCHAIC_BRICK.get()))).m_126140_(consumer, EmbersRecipes.getResource("archaic_circuit"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.SUPERHEATER.get())).m_126130_(" ID").m_126130_("CCI").m_126130_("CC ").m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/dawnstone")).m_206416_(Character.valueOf('D'), this.itemTag("forge", "plates/dawnstone")).m_206416_(Character.valueOf('C'), this.itemTag("forge", "ingots/copper")).m_126132_("has_inferno_forge", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.INFERNO_FORGE.get()))).m_126140_(consumer, EmbersRecipes.getResource("superheater"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.CINDER_JET.get())).m_126130_("PP ").m_126130_("ISD").m_126130_("PP ").m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_206416_(Character.valueOf('D'), this.itemTag("forge", "ingots/dawnstone")).m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/dawnstone")).m_126127_(Character.valueOf('S'), (ItemLike)RegistryManager.EMBER_SHARD.get()).m_126132_("has_inferno_forge", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.INFERNO_FORGE.get()))).m_126140_(consumer, EmbersRecipes.getResource("cinder_jet"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.CASTER_ORB.get())).m_126130_("DCD").m_126130_("D D").m_126130_(" P ").m_206416_(Character.valueOf('D'), this.itemTag("forge", "ingots/dawnstone")).m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/dawnstone")).m_126127_(Character.valueOf('C'), (ItemLike)RegistryManager.EMBER_CRYSTAL.get()).m_126132_("has_inferno_forge", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.INFERNO_FORGE.get()))).m_126140_(consumer, EmbersRecipes.getResource("caster_orb"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.RESONATING_BELL.get())).m_126130_("IIP").m_126130_(" SI").m_126130_("V I").m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/iron")).m_206416_(Character.valueOf('S'), this.itemTag("forge", "ingots/silver")).m_206416_(Character.valueOf('V'), this.itemTag("forge", "plates/silver")).m_126132_("has_inferno_forge", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.INFERNO_FORGE.get()))).m_126140_(consumer, EmbersRecipes.getResource("resonating_bell"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.DIFFRACTION_BARREL.get())).m_126130_("IPX").m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/iron")).m_126127_(Character.valueOf('X'), (ItemLike)RegistryManager.SUPERHEATER.get()).m_126132_("has_superheater", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.SUPERHEATER.get()))).m_126140_(consumer, EmbersRecipes.getResource("diffraction_barrel"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.MNEMONIC_INSCRIBER.get())).m_126130_("C").m_126130_("A").m_126127_(Character.valueOf('C'), (ItemLike)RegistryManager.EMBER_CRYSTAL.get()).m_126127_(Character.valueOf('A'), (ItemLike)RegistryManager.INTELLIGENT_APPARATUS.get()).m_126132_("has_apparatus", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.INTELLIGENT_APPARATUS.get()))).m_126140_(consumer, EmbersRecipes.getResource("mnemonic_inscriber"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.CHAR_INSTILLER.get())).m_126130_("PPP").m_126130_("I I").m_126130_("PPP").m_206416_(Character.valueOf('I'), this.itemTag("forge", "plates/iron")).m_126127_(Character.valueOf('P'), (ItemLike)RegistryManager.SEALED_PLANKS.get()).m_126132_("has_hearth_coil", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.HEARTH_COIL.get()))).m_126140_(consumer, EmbersRecipes.getResource("char_instiller"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.ATMOSPHERIC_BELLOWS.get())).m_126130_("CPC").m_126130_("LLL").m_126130_("CPC").m_206416_(Character.valueOf('C'), this.itemTag("forge", "plates/copper")).m_206416_(Character.valueOf('L'), Tags.Items.LEATHER).m_126127_(Character.valueOf('P'), (ItemLike)RegistryManager.SEALED_PLANKS.get()).m_126132_("has_hearth_coil", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.HEARTH_COIL.get()))).m_126140_(consumer, EmbersRecipes.getResource("atmospheric_bellows"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.HEAT_EXCHANGER.get())).m_126130_("C C").m_126130_("IPI").m_126130_("IPI").m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/copper")).m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_206416_(Character.valueOf('C'), this.itemTag("forge", "ingots/copper")).m_126132_("has_activator", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.EMBER_ACTIVATOR.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.HEAT_INSULATION.get())).m_126130_("P").m_126130_("C").m_126130_("A").m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/silver")).m_206416_(Character.valueOf('C'), this.itemTag("forge", "storage_blocks/copper")).m_206416_(Character.valueOf('A'), EmbersItemTags.ASHEN_STONE).m_126132_("has_activator", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.HEARTH_COIL.get()))).m_176498_(consumer);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RegistryManager.EXCAVATION_BUCKETS.get())).m_126130_("PPP").m_126130_("BIP").m_126130_("PPP").m_206416_(Character.valueOf('P'), this.itemTag("forge", "plates/lead")).m_206416_(Character.valueOf('I'), this.itemTag("forge", "ingots/iron")).m_206416_(Character.valueOf('B'), this.itemTag("forge", "storage_blocks/lead")).m_126132_("has_bore", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)RegistryManager.EMBER_BORE.get()))).m_176498_(consumer);
    }

    public void fullOreRecipes(String name, ImmutableList<ItemLike> ores, Fluid fluid, Item raw, Item rawBlock, Item block, Item ingot, Item nugget, Item plate, Consumer<FinishedRecipe> consumer, MeltingBonus ... bonusses) {
        this.fullMetalRecipes(name, fluid, block, ingot, nugget, plate, consumer);
        this.oreMeltingRecipes(name, fluid, consumer, bonusses);
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)rawBlock).m_126130_("XXX").m_126130_("XYX").m_126130_("XXX").m_206416_(Character.valueOf('X'), this.itemTag("forge", "raw_materials/" + name)).m_126127_(Character.valueOf('Y'), (ItemLike)raw).m_126132_("has_raw", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)raw)).m_126140_(consumer, EmbersRecipes.getResource(name + "_raw_to_raw_block"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)raw, (int)9).m_126209_((ItemLike)rawBlock).m_126132_("has_block", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)rawBlock)).m_126140_(consumer, EmbersRecipes.getResource(name + "_raw_block_to_raw"));
        EmbersRecipes.m_246272_(consumer, ores, RecipeCategory.MISC, (ItemLike)ingot, 0.7f, 200, name + "_ingot");
        EmbersRecipes.m_245412_(consumer, ores, RecipeCategory.MISC, (ItemLike)ingot, 0.7f, 100, name + "_ingot");
    }

    public void fullMetalRecipes(String name, Fluid fluid, Item block, Item ingot, Item nugget, Item plate, Consumer<FinishedRecipe> consumer) {
        this.fullMeltingStampingRecipes(name, fluid, consumer);
        this.blockIngotNuggetCompression(name, block, ingot, nugget, consumer);
        this.plateHammerRecipe(name, plate, consumer);
    }

    public void plateHammerRecipe(String name, Item plate, Consumer<FinishedRecipe> consumer) {
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)plate).m_206419_(this.itemTag("forge", "ingots/" + name)).m_206419_(this.itemTag("forge", "ingots/" + name)).m_206419_(EmbersItemTags.TINKER_HAMMER).m_126132_("has_ingot", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "ingots/" + name))).m_126140_(consumer, EmbersRecipes.getResource(name + "_plate_hammering"));
    }

    public void fullOreMeltingStampingRecipes(String name, Fluid fluid, Consumer<FinishedRecipe> consumer, MeltingBonus ... bonusses) {
        this.oreMeltingRecipes(name, fluid, consumer, bonusses);
        this.fullMeltingStampingRecipes(name, fluid, consumer);
    }

    public void oreMeltingRecipes(String name, Fluid fluid, Consumer<FinishedRecipe> consumer, MeltingBonus ... bonusses) {
        TagKey<Item> raw = this.itemTag("forge", "raw_materials/" + name);
        TagKey<Item> ore = this.itemTag("forge", "ores/" + name);
        TagKey<Item> rawBlock = this.itemTag("forge", "storage_blocks/raw_" + name);
        this.bonusRecipe((condition, bonus) -> MeltingRecipeBuilder.create(raw).domain("embers").folder(meltingFolder).bonusName(bonus.name).output(fluid, 120).bonus(bonus.fluid, bonus.amount).save(ConsumerWrapperBuilder.wrap().addCondition((ICondition)condition).build(consumer)), this.tagReal(raw), bonusses);
        this.bonusRecipe((condition, bonus) -> MeltingRecipeBuilder.create(ore).domain("embers").folder(meltingFolder).bonusName(bonus.name).output(fluid, 240).bonus(bonus.fluid, bonus.amount * 2).save(ConsumerWrapperBuilder.wrap().addCondition((ICondition)condition).build(consumer)), this.tagReal(ore), bonusses);
        this.bonusRecipe((condition, bonus) -> MeltingRecipeBuilder.create(rawBlock).domain("embers").folder(meltingFolder).bonusName(bonus.name).output(fluid, 1080).bonus(bonus.fluid, bonus.amount * 9).save(ConsumerWrapperBuilder.wrap().addCondition((ICondition)condition).build(consumer)), this.tagReal(rawBlock), bonusses);
    }

    public void bonusRecipe(BiConsumer<ICondition, MeltingBonus> recipe, ICondition baseCondition, MeltingBonus ... bonusses) {
        ArrayList<TagEmptyCondition> conditions = new ArrayList<TagEmptyCondition>();
        for (MeltingBonus bonus : bonusses) {
            TagEmptyCondition condition = new TagEmptyCondition(this.itemTag("forge", "ingots/" + bonus.name).f_203868_());
            ArrayList<Object> recipeConditions = new ArrayList<Object>();
            recipeConditions.addAll(conditions);
            recipeConditions.add(baseCondition);
            if (bonus.optional) {
                recipeConditions.add(new NotCondition((ICondition)condition));
            }
            recipe.accept((ICondition)new AndCondition(recipeConditions.toArray(new ICondition[recipeConditions.size()])), bonus);
            conditions.add(condition);
        }
    }

    public void fullMeltingStampingRecipes(String name, Fluid fluid, Consumer<FinishedRecipe> consumer) {
        TagKey<Item> ingot = this.itemTag("forge", "ingots/" + name);
        TagKey<Item> nugget = this.itemTag("forge", "nuggets/" + name);
        TagKey<Item> block = this.itemTag("forge", "storage_blocks/" + name);
        TagKey<Item> plate = this.itemTag("forge", "plates/" + name);
        TagKey<Item> gear = this.itemTag("forge", "gears/" + name);
        MeltingRecipeBuilder.create(ingot).domain("embers").folder(meltingFolder).output(fluid, 90).save(ConsumerWrapperBuilder.wrap().addCondition(this.tagReal(ingot)).build(consumer));
        MeltingRecipeBuilder.create(nugget).domain("embers").folder(meltingFolder).output(fluid, 10).save(ConsumerWrapperBuilder.wrap().addCondition(this.tagReal(nugget)).build(consumer));
        MeltingRecipeBuilder.create(block).domain("embers").folder(meltingFolder).output(fluid, 810).save(ConsumerWrapperBuilder.wrap().addCondition(this.tagReal(block)).build(consumer));
        MeltingRecipeBuilder.create(plate).domain("embers").folder(meltingFolder).output(fluid, 90).save(ConsumerWrapperBuilder.wrap().addCondition(this.tagReal(plate)).build(consumer));
        MeltingRecipeBuilder.create(gear).domain("embers").folder(meltingFolder).output(fluid, 180).save(ConsumerWrapperBuilder.wrap().addCondition(this.tagReal(gear)).build(consumer));
        StampingRecipeBuilder.create(ingot).domain("embers").folder(stampingFolder).stamp((ItemLike)RegistryManager.INGOT_STAMP.get()).fluid(this.fluidTag("forge", "molten_" + name), 90).save(ConsumerWrapperBuilder.wrap().addCondition(this.tagReal(ingot)).build(consumer));
        StampingRecipeBuilder.create(nugget).domain("embers").folder(stampingFolder).stamp((ItemLike)RegistryManager.NUGGET_STAMP.get()).fluid(this.fluidTag("forge", "molten_" + name), 10).save(ConsumerWrapperBuilder.wrap().addCondition(this.tagReal(nugget)).build(consumer));
        StampingRecipeBuilder.create(plate).domain("embers").folder(stampingFolder).stamp((ItemLike)RegistryManager.PLATE_STAMP.get()).fluid(this.fluidTag("forge", "molten_" + name), 90).save(ConsumerWrapperBuilder.wrap().addCondition(this.tagReal(plate)).build(consumer));
        StampingRecipeBuilder.create(gear).domain("embers").folder(stampingFolder).stamp((ItemLike)RegistryManager.GEAR_STAMP.get()).fluid(this.fluidTag("forge", "molten_" + name), 180).save(ConsumerWrapperBuilder.wrap().addCondition(this.tagReal(gear)).build(consumer));
    }

    public void blockIngotNuggetCompression(String name, Item block, Item ingot, Item nugget, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)block).m_126130_("XXX").m_126130_("XYX").m_126130_("XXX").m_206416_(Character.valueOf('X'), this.itemTag("forge", "ingots/" + name)).m_126127_(Character.valueOf('Y'), (ItemLike)ingot).m_126132_("has_ingot", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "ingots/" + name))).m_126140_(consumer, EmbersRecipes.getResource(name + "_ingot_to_block"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ingot, (int)9).m_126209_((ItemLike)block).m_126132_("has_block", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)block)).m_126140_(consumer, EmbersRecipes.getResource(name + "_block_to_ingot"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ingot).m_126130_("XXX").m_126130_("XYX").m_126130_("XXX").m_206416_(Character.valueOf('X'), this.itemTag("forge", "nuggets/" + name)).m_126127_(Character.valueOf('Y'), (ItemLike)nugget).m_126132_("has_nugget", (CriterionTriggerInstance)EmbersRecipes.m_206406_(this.itemTag("forge", "nuggets/" + name))).m_126140_(consumer, EmbersRecipes.getResource(name + "_nugget_to_ingot"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)nugget, (int)9).m_126209_((ItemLike)ingot).m_126132_("has_ingot", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)ingot)).m_126140_(consumer, EmbersRecipes.getResource(name + "_ingot_to_nugget"));
    }

    public void decoRecipes(RegistryManager.StoneDecoBlocks deco, Consumer<FinishedRecipe> consumer) {
        Item item = ((Block)deco.block.get()).m_5456_();
        if (deco.stairs != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)deco.stairs.get()), (int)4).m_126130_("X  ").m_126130_("XX ").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)item).m_126132_("has_" + deco.name, (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)item)).m_126140_(consumer, deco.stairs.getId());
            EmbersRecipes.m_247600_(consumer, RecipeCategory.DECORATIONS, (ItemLike)deco.stairs.get(), (ItemLike)item);
        }
        if (deco.slab != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)deco.slab.get()), (int)6).m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)item).m_126132_("has_" + deco.name, (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)item)).m_126140_(consumer, deco.slab.getId());
            EmbersRecipes.m_247298_(consumer, RecipeCategory.DECORATIONS, (ItemLike)deco.slab.get(), (ItemLike)item, 2);
        }
        if (deco.wall != null) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)deco.wall.get()), (int)6).m_126130_("XXX").m_126130_("XXX").m_126127_(Character.valueOf('X'), (ItemLike)item).m_126132_("has_" + deco.name, (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)item)).m_126140_(consumer, deco.wall.getId());
            EmbersRecipes.m_247600_(consumer, RecipeCategory.DECORATIONS, (ItemLike)deco.wall.get(), (ItemLike)item);
        }
    }

    protected static void m_247600_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, RecipeCategory pCategory, ItemLike pResult, ItemLike pMaterial) {
        EmbersRecipes.m_247298_(pFinishedRecipeConsumer, pCategory, pResult, pMaterial, 1);
    }

    protected static void m_247298_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, RecipeCategory pCategory, ItemLike pResult, ItemLike pMaterial, int pResultCount) {
        SingleItemRecipeBuilder.m_246944_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{pMaterial}), (RecipeCategory)pCategory, (ItemLike)pResult, (int)pResultCount).m_126132_(EmbersRecipes.m_176602_((ItemLike)pMaterial), (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)pMaterial)).m_126140_(pFinishedRecipeConsumer, EmbersRecipes.getResource(EmbersRecipes.m_176517_((ItemLike)pResult, (ItemLike)pMaterial) + "_stonecutting"));
    }

    protected static void m_246272_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTIme, String pGroup) {
        EmbersRecipes.m_245809_(pFinishedRecipeConsumer, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44091_, pIngredients, pCategory, pResult, pExperience, pCookingTIme, pGroup, "_from_smelting");
    }

    protected static void m_245412_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup) {
        EmbersRecipes.m_245809_(pFinishedRecipeConsumer, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44092_, pIngredients, pCategory, pResult, pExperience, pCookingTime, pGroup, "_from_blasting");
    }

    protected static void m_245809_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, RecipeSerializer<? extends AbstractCookingRecipe> pCookingSerializer, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup, String pRecipeName) {
        for (ItemLike itemlike : pIngredients) {
            SimpleCookingRecipeBuilder.m_247607_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemlike}), (RecipeCategory)pCategory, (ItemLike)pResult, (float)pExperience, (int)pCookingTime, pCookingSerializer).m_126145_(pGroup).m_126132_(EmbersRecipes.m_176602_((ItemLike)itemlike), (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)itemlike)).m_126140_(pFinishedRecipeConsumer, EmbersRecipes.getResource(EmbersRecipes.m_176632_((ItemLike)pResult) + pRecipeName + "_" + EmbersRecipes.m_176632_((ItemLike)itemlike)));
        }
    }

    public void toolRecipes(RegistryManager.ToolSet set, TagKey<Item> material, Item nugget, Consumer<FinishedRecipe> consumer) {
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)set.SWORD.get()}), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)nugget, (float)0.1f, (int)200).m_126132_("has_" + set.name + "_sword", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)set.SWORD.get()))).m_126140_(consumer, EmbersRecipes.getResource(set.name + "_sword_smelting"));
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)set.SWORD.get()}), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)nugget, (float)0.1f, (int)100).m_126132_("has_" + set.name + "_sword", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)set.SWORD.get()))).m_126140_(consumer, EmbersRecipes.getResource(set.name + "_sword_blasting"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)set.SHOVEL.get()}), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)nugget, (float)0.1f, (int)200).m_126132_("has_" + set.name + "_shovel", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)set.SHOVEL.get()))).m_126140_(consumer, EmbersRecipes.getResource(set.name + "_shovel_smelting"));
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)set.SHOVEL.get()}), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)nugget, (float)0.1f, (int)100).m_126132_("has_" + set.name + "_shovel", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)set.SHOVEL.get()))).m_126140_(consumer, EmbersRecipes.getResource(set.name + "_shovel_blasting"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)set.PICKAXE.get()}), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)nugget, (float)0.1f, (int)200).m_126132_("has_" + set.name + "_pickaxe", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)set.PICKAXE.get()))).m_126140_(consumer, EmbersRecipes.getResource(set.name + "_pickaxe_smelting"));
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)set.PICKAXE.get()}), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)nugget, (float)0.1f, (int)100).m_126132_("has_" + set.name + "_pickaxe", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)set.PICKAXE.get()))).m_126140_(consumer, EmbersRecipes.getResource(set.name + "_pickaxe_blasting"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)set.AXE.get()}), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)nugget, (float)0.1f, (int)200).m_126132_("has_" + set.name + "_axe", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)set.AXE.get()))).m_126140_(consumer, EmbersRecipes.getResource(set.name + "_axe_smelting"));
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)set.AXE.get()}), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)nugget, (float)0.1f, (int)100).m_126132_("has_" + set.name + "_axe", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)set.AXE.get()))).m_126140_(consumer, EmbersRecipes.getResource(set.name + "_axe_blasting"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)set.HOE.get()}), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)nugget, (float)0.1f, (int)200).m_126132_("has_" + set.name + "_hoe", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)set.HOE.get()))).m_126140_(consumer, EmbersRecipes.getResource(set.name + "_hoe_smelting"));
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)set.HOE.get()}), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)nugget, (float)0.1f, (int)100).m_126132_("has_" + set.name + "_hoe", (CriterionTriggerInstance)EmbersRecipes.m_125977_((ItemLike)((ItemLike)set.HOE.get()))).m_126140_(consumer, EmbersRecipes.getResource(set.name + "_hoe_blasting"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)set.SWORD.get())).m_126130_("M").m_126130_("M").m_126130_("S").m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_206416_(Character.valueOf('M'), material).m_126132_("has_" + set.name, (CriterionTriggerInstance)EmbersRecipes.m_206406_(material)).m_126140_(consumer, EmbersRecipes.getResource(set.name + "_sword"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)set.SHOVEL.get())).m_126130_("M").m_126130_("S").m_126130_("S").m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_206416_(Character.valueOf('M'), material).m_126132_("has_" + set.name, (CriterionTriggerInstance)EmbersRecipes.m_206406_(material)).m_126140_(consumer, EmbersRecipes.getResource(set.name + "_shovel"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)set.PICKAXE.get())).m_126130_("MMM").m_126130_(" S ").m_126130_(" S ").m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_206416_(Character.valueOf('M'), material).m_126132_("has_" + set.name, (CriterionTriggerInstance)EmbersRecipes.m_206406_(material)).m_126140_(consumer, EmbersRecipes.getResource(set.name + "_pickaxe"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)set.AXE.get())).m_126130_("MM").m_126130_("MS").m_126130_(" S").m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_206416_(Character.valueOf('M'), material).m_126132_("has_" + set.name, (CriterionTriggerInstance)EmbersRecipes.m_206406_(material)).m_126140_(consumer, EmbersRecipes.getResource(set.name + "_axe"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)set.HOE.get())).m_126130_("MM").m_126130_(" S").m_126130_(" S").m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_206416_(Character.valueOf('M'), material).m_126132_("has_" + set.name, (CriterionTriggerInstance)EmbersRecipes.m_206406_(material)).m_126140_(consumer, EmbersRecipes.getResource(set.name + "_hoe"));
    }

    public TagKey<Item> itemTag(String modId, String name) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(modId, name));
    }

    public TagKey<Fluid> fluidTag(String modId, String name) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)new ResourceLocation(modId, name));
    }

    public ICondition tagReal(TagKey<?> tag) {
        return new NotCondition((ICondition)new TagEmptyCondition(tag.f_203868_()));
    }

    public static ResourceLocation getResource(String name) {
        return new ResourceLocation("embers", name);
    }
}

