/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.compat.jei;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.compat.jei.IngotTooltipCallback;
import com.rekindled.embers.compat.jei.JEIPlugin;
import com.rekindled.embers.recipe.IMeltingRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class MeltingCategory
implements IRecipeCategory<IMeltingRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    public static Component title = Component.m_237115_((String)"embers.jei.recipe.melting");
    public static ResourceLocation texture = new ResourceLocation("embers", "textures/gui/jei_melter.png");
    double scale = 0.03125;

    public MeltingCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(texture, 0, 14, 108, 42);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)RegistryManager.MELTER_ITEM.get()));
    }

    public RecipeType<IMeltingRecipe> getRecipeType() {
        return JEIPlugin.MELTING;
    }

    public Component getTitle() {
        return title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IMeltingRecipe recipe, IFocusGroup focuses) {
        int capacity = 4000;
        builder.addSlot(RecipeIngredientRole.INPUT, 8, 14).addIngredients(recipe.getDisplayInput());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 84, 6).addTooltipCallback((IRecipeSlotTooltipCallback)IngotTooltipCallback.INSTANCE).setFluidRenderer((long)((int)((double)capacity * this.scale + (double)recipe.getDisplayOutput().getAmount() * (1.0 - this.scale))), false, 16, 32).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.getDisplayOutput());
    }
}

