/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.compat.jei;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.compat.jei.JEIPlugin;
import com.rekindled.embers.recipe.IBoringRecipe;
import com.rekindled.embers.util.Misc;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.text.WordUtils;

public class BoringCategory
implements IRecipeCategory<IBoringRecipe> {
    private final IDrawable background;
    public IDrawable icon;
    public static Component title = Component.m_237115_((String)"embers.jei.recipe.boring");
    public static ResourceLocation texture = new ResourceLocation("embers", "textures/gui/jei_boring.png");

    public BoringCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(texture, 0, 0, 126, 98);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)RegistryManager.EMBER_BORE_ITEM.get()));
    }

    public RecipeType<IBoringRecipe> getRecipeType() {
        return JEIPlugin.BORING;
    }

    public Component getTitle() {
        return title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IBoringRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 6, 6).addItemStack(recipe.getDisplayOutput().getStack());
        builder.addSlot(RecipeIngredientRole.CATALYST, 6, 26).addItemStacks(recipe.getDisplayInput());
    }

    public List<Component> getTooltipStrings(IBoringRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        int height = 48;
        ArrayList<Component> text = new ArrayList<Component>();
        if (recipe.getMinHeight() != Integer.MIN_VALUE) {
            height += 11;
        }
        if (recipe.getMaxHeight() != Integer.MAX_VALUE) {
            height += 11;
        }
        if (!recipe.getDimensions().isEmpty()) {
            if (mouseY > (double)height && mouseY < (double)(height + 11) && mouseX > 7.0 && mouseX < 119.0) {
                for (ResourceLocation dimension : recipe.getDimensions()) {
                    text.add((Component)Component.m_264568_((String)("dimension." + dimension.m_214298_()), (String)WordUtils.capitalize((String)dimension.m_135815_().replace("_", " "))));
                }
            }
            height += 11;
        }
        if (!recipe.getBiomes().isEmpty()) {
            if (mouseY > (double)height && mouseY < (double)(height + 11) && mouseX > 7.0 && mouseX < 119.0) {
                for (ResourceLocation biome : recipe.getBiomes()) {
                    text.add((Component)Component.m_237113_((String)biome.toString()));
                }
            }
            height += 11;
        }
        return text;
    }

    public void draw(IBoringRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        Misc.drawComponents(fontRenderer, guiGraphics, 28, 10, new Component[]{Component.m_237110_((String)"embers.jei.recipe.boring.weight", (Object[])new Object[]{recipe.getDisplayOutput().m_142631_()})});
        Misc.drawComponents(fontRenderer, guiGraphics, 28, 30, new Component[]{Component.m_237115_((String)"embers.jei.recipe.boring.required_blocks")});
        ArrayList<MutableComponent> text = new ArrayList<MutableComponent>();
        if (recipe.getMinHeight() != Integer.MIN_VALUE) {
            text.add(Component.m_237110_((String)"embers.jei.recipe.boring.min_height", (Object[])new Object[]{recipe.getMinHeight()}));
        }
        if (recipe.getMaxHeight() != Integer.MAX_VALUE) {
            text.add(Component.m_237110_((String)"embers.jei.recipe.boring.max_height", (Object[])new Object[]{recipe.getMaxHeight()}));
        }
        if (!recipe.getDimensions().isEmpty()) {
            text.add(Component.m_237115_((String)"embers.jei.recipe.boring.dimensions").m_130938_(style -> style.m_178520_(16758093)));
        }
        if (!recipe.getBiomes().isEmpty()) {
            text.add(Component.m_237115_((String)"embers.jei.recipe.boring.biomes").m_130938_(style -> style.m_178520_(16758093)));
        }
        Component[] components = new Component[text.size()];
        for (int i = 0; i < text.size(); ++i) {
            components[i] = (Component)text.get(i);
        }
        Misc.drawComponents(fontRenderer, guiGraphics, 10, 48, components);
    }
}

