/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.rekindled.embers.ConfigManager;
import com.rekindled.embers.EmbersClientEvents;
import com.rekindled.embers.block.FieldChartBlock;
import com.rekindled.embers.blockentity.FieldChartBlockEntity;
import com.rekindled.embers.render.EmbersRenderTypes;
import com.rekindled.embers.util.EmberGenUtil;
import com.rekindled.embers.util.Misc;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class FieldChartBlockEntityRenderer
implements BlockEntityRenderer<FieldChartBlockEntity> {
    public static float baseHeight = 0.375f;
    public static float height = 0.55f;

    public FieldChartBlockEntityRenderer(BlockEntityRendererProvider.Context pContext) {
    }

    public void render(FieldChartBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (blockEntity != null) {
            VertexConsumer buffer = bufferSource.m_6299_((Boolean)ConfigManager.RENDER_FALLBACK.get() != false ? EmbersRenderTypes.FIELD_CHART_FALLBACK : EmbersRenderTypes.FIELD_CHART);
            RenderSystem.enableDepthTest();
            RenderSystem.disableCull();
            BlockState state = blockEntity.m_58904_().m_8055_(blockEntity.m_58899_());
            if (state.m_61138_((Property)FieldChartBlock.INVERTED) && ((Boolean)state.m_61143_((Property)FieldChartBlock.INVERTED)).booleanValue()) {
                this.renderChart(blockEntity.m_58904_(), blockEntity.m_58899_(), 0.0f, 0.0f, 0.0f, buffer, poseStack.m_85850_().m_252922_(), (cx, cz) -> EmberGenUtil.getEmberStability(EmbersClientEvents.seed, cx, cz), new Color(16, 64, 255), new Color(16, 192, 255), new Color(8, 255, 255));
            } else {
                this.renderChart(blockEntity.m_58904_(), blockEntity.m_58899_(), 0.0f, 0.0f, 0.0f, buffer, poseStack.m_85850_().m_252922_(), (cx, cz) -> EmberGenUtil.getEmberDensity(EmbersClientEvents.seed, cx, cz), new Color(255, 64, 16), new Color(255, 192, 16), new Color(255, 255, 8));
            }
            RenderSystem.enableCull();
        }
    }

    public void renderChart(Level level, BlockPos pos, float x, float y, float z, VertexConsumer buffer, Matrix4f matrix4f, IChartSource source, Color color1, Color color2, Color color3) {
        int signal = level.m_277086_(pos);
        float brightness = 1.0f;
        if (signal > 2) {
            brightness = Misc.getLightBrightness(15 - signal, EmbersClientEvents.ticks);
        }
        float red1 = brightness * (float)color1.getRed() / 255.0f;
        float green1 = brightness * (float)color1.getGreen() / 255.0f;
        float blue1 = brightness * (float)color1.getBlue() / 255.0f;
        float[][][] valueCache = new float[10][10][4];
        for (float i = -160.0f; i < 160.0f; i += 32.0f) {
            for (float j = -160.0f; j < 160.0f; j += 32.0f) {
                float[] values = new float[]{source.get(pos.m_123341_() + (int)i / 2, pos.m_123343_() + (int)j / 2), source.get(pos.m_123341_() + (int)i / 2 + 16, pos.m_123343_() + (int)j / 2), source.get(pos.m_123341_() + (int)i / 2 + 16, pos.m_123343_() + (int)j / 2 + 16), source.get(pos.m_123341_() + (int)i / 2, pos.m_123343_() + (int)j / 2 + 16)};
                valueCache[(int)(i / 32.0f) + 5][(int)(j / 32.0f) + 5] = values;
                float alphaul = Math.min(1.0f, Math.max(0.0f, 1.0f - Math.max(Math.abs(i), Math.abs(j)) / 160.0f));
                float alphaur = Math.min(1.0f, Math.max(0.0f, 1.0f - Math.max(Math.abs(i + 32.0f), Math.abs(j)) / 160.0f));
                float alphadr = Math.min(1.0f, Math.max(0.0f, 1.0f - Math.max(Math.abs(i + 32.0f), Math.abs(j + 32.0f)) / 160.0f));
                float alphadl = Math.min(1.0f, Math.max(0.0f, 1.0f - Math.max(Math.abs(i), Math.abs(j + 32.0f)) / 160.0f));
                buffer.m_252986_(matrix4f, x + 0.5f + 1.25f * (i / 160.0f), y + baseHeight + values[0] * height, z + 0.5f + 1.25f * (j / 160.0f)).m_7421_(0.0f, 0.0f).m_85950_(red1 * alphaul, green1 * alphaul, blue1 * alphaul, 1.0f).m_5752_();
                buffer.m_252986_(matrix4f, x + 0.5f + 1.25f * (i / 160.0f) + 0.25f, y + baseHeight + values[1] * height, z + 0.5f + 1.25f * (j / 160.0f)).m_7421_(1.0f, 0.0f).m_85950_(red1 * alphaur, green1 * alphaur, blue1 * alphaur, 1.0f).m_5752_();
                buffer.m_252986_(matrix4f, x + 0.5f + 1.25f * (i / 160.0f) + 0.25f, y + baseHeight + values[2] * height, z + 0.5f + 1.25f * (j / 160.0f) + 0.25f).m_7421_(1.0f, 1.0f).m_85950_(red1 * alphadr, green1 * alphadr, blue1 * alphadr, 1.0f).m_5752_();
                buffer.m_252986_(matrix4f, x + 0.5f + 1.25f * (i / 160.0f), y + baseHeight + values[3] * height, z + 0.5f + 1.25f * (j / 160.0f) + 0.25f).m_7421_(0.0f, 1.0f).m_85950_(red1 * alphadl, green1 * alphadl, blue1 * alphadl, 1.0f).m_5752_();
            }
        }
        float red2 = brightness * (float)color2.getRed() / 255.0f;
        float green2 = brightness * (float)color2.getGreen() / 255.0f;
        float blue2 = brightness * (float)color2.getBlue() / 255.0f;
        for (float i = -160.0f; i < 160.0f; i += 32.0f) {
            for (float j = -160.0f; j < 160.0f; j += 32.0f) {
                float[] values = valueCache[(int)(i / 32.0f) + 5][(int)(j / 32.0f) + 5];
                float amountul = values[0];
                float amountur = values[1];
                float amountdr = values[2];
                float amountdl = values[3];
                float alphaul = Math.min(1.0f, Math.max(0.0f, 1.0f - Math.max(Math.abs(i), Math.abs(j)) / 160.0f) * amountul * amountul) * 0.875f;
                float alphaur = Math.min(1.0f, Math.max(0.0f, 1.0f - Math.max(Math.abs(i + 32.0f), Math.abs(j)) / 160.0f) * amountur * amountur) * 0.875f;
                float alphadr = Math.min(1.0f, Math.max(0.0f, 1.0f - Math.max(Math.abs(i + 32.0f), Math.abs(j + 32.0f)) / 160.0f) * amountdr * amountdr) * 0.875f;
                float alphadl = Math.min(1.0f, Math.max(0.0f, 1.0f - Math.max(Math.abs(i), Math.abs(j + 32.0f)) / 160.0f) * amountdl * amountdl) * 0.875f;
                buffer.m_252986_(matrix4f, x + 0.5f + 1.25f * (i / 160.0f), y + baseHeight + amountul * height, z + 0.5f + 1.25f * (j / 160.0f)).m_7421_(0.0f, 0.0f).m_85950_(red2 * alphaul, green2 * alphaul, blue2 * alphaul, 1.0f).m_5752_();
                buffer.m_252986_(matrix4f, x + 0.5f + 1.25f * (i / 160.0f) + 0.25f, y + baseHeight + amountur * height, z + 0.5f + 1.25f * (j / 160.0f)).m_7421_(1.0f, 0.0f).m_85950_(red2 * alphaur, green2 * alphaur, blue2 * alphaur, 1.0f).m_5752_();
                buffer.m_252986_(matrix4f, x + 0.5f + 1.25f * (i / 160.0f) + 0.25f, y + baseHeight + amountdr * height, z + 0.5f + 1.25f * (j / 160.0f) + 0.25f).m_7421_(1.0f, 1.0f).m_85950_(red2 * alphadr, green2 * alphadr, blue2 * alphadr, 1.0f).m_5752_();
                buffer.m_252986_(matrix4f, x + 0.5f + 1.25f * (i / 160.0f), y + baseHeight + amountdl * height, z + 0.5f + 1.25f * (j / 160.0f) + 0.25f).m_7421_(0.0f, 1.0f).m_85950_(red2 * alphadl, green2 * alphadl, blue2 * alphadl, 1.0f).m_5752_();
            }
        }
        float red3 = brightness * (float)color3.getRed() / 255.0f;
        float green3 = brightness * (float)color3.getGreen() / 255.0f;
        float blue3 = brightness * (float)color3.getBlue() / 255.0f;
        for (float i = -160.0f; i < 160.0f; i += 32.0f) {
            for (float j = -160.0f; j < 160.0f; j += 32.0f) {
                float[] values = valueCache[(int)(i / 32.0f) + 5][(int)(j / 32.0f) + 5];
                float amountul = values[0];
                float amountur = values[1];
                float amountdr = values[2];
                float amountdl = values[3];
                float alphaul = Math.min(1.0f, Math.max(0.0f, 1.0f - Math.max(Math.abs(i), Math.abs(j)) / 160.0f) * amountul * amountul * amountul);
                float alphaur = Math.min(1.0f, Math.max(0.0f, 1.0f - Math.max(Math.abs(i + 32.0f), Math.abs(j)) / 160.0f) * amountur * amountur * amountur);
                float alphadr = Math.min(1.0f, Math.max(0.0f, 1.0f - Math.max(Math.abs(i + 32.0f), Math.abs(j + 32.0f)) / 160.0f) * amountdr * amountdr * amountdr);
                float alphadl = Math.min(1.0f, Math.max(0.0f, 1.0f - Math.max(Math.abs(i), Math.abs(j + 32.0f)) / 160.0f) * amountdl * amountdl * amountdl);
                buffer.m_252986_(matrix4f, x + 0.5f + 1.25f * (i / 160.0f), y + baseHeight + amountul * height, z + 0.5f + 1.25f * (j / 160.0f)).m_7421_(0.0f, 0.0f).m_85950_(red3 * alphaul, green3 * alphaul, blue3 * alphaul, 1.0f).m_5752_();
                buffer.m_252986_(matrix4f, x + 0.5f + 1.25f * (i / 160.0f) + 0.25f, y + baseHeight + amountur * height, z + 0.5f + 1.25f * (j / 160.0f)).m_7421_(1.0f, 0.0f).m_85950_(red3 * alphaur, green3 * alphaur, blue3 * alphaur, 1.0f).m_5752_();
                buffer.m_252986_(matrix4f, x + 0.5f + 1.25f * (i / 160.0f) + 0.25f, y + baseHeight + amountdr * height, z + 0.5f + 1.25f * (j / 160.0f) + 0.25f).m_7421_(1.0f, 1.0f).m_85950_(red3 * alphadr, green3 * alphadr, blue3 * alphadr, 1.0f).m_5752_();
                buffer.m_252986_(matrix4f, x + 0.5f + 1.25f * (i / 160.0f), y + baseHeight + amountdl * height, z + 0.5f + 1.25f * (j / 160.0f) + 0.25f).m_7421_(0.0f, 1.0f).m_85950_(red3 * alphadl, green3 * alphadl, blue3 * alphadl, 1.0f).m_5752_();
            }
        }
    }

    static interface IChartSource {
        public float get(int var1, int var2);
    }
}

