/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.api.block.IPipeConnection;
import com.rekindled.embers.block.PipeBlockBase;
import com.rekindled.embers.particle.GlowParticleOptions;
import com.rekindled.embers.util.Misc;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.joml.Vector3f;

public class PipeBlockEntityBase
extends BlockEntity {
    public static final int PRIORITY_BLOCK = 0;
    public static final int PRIORITY_PIPE = 0;
    static Random random = new Random();
    public PipeConnection[] connections = new PipeConnection[]{PipeConnection.NONE, PipeConnection.NONE, PipeConnection.NONE, PipeConnection.NONE, PipeConnection.NONE, PipeConnection.NONE};
    public boolean[] from = new boolean[Direction.values().length];
    public boolean clogged = false;
    public Direction lastTransfer;
    public int ticksExisted;
    public int lastRobin;
    public boolean loaded = false;
    public boolean saveConnections = true;
    public boolean syncConnections = true;
    public boolean syncCloggedFlag = true;
    public boolean syncTransfer = true;
    public static final ModelProperty<int[]> DATA_TYPE = new ModelProperty();

    public PipeBlockEntityBase(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public void setFrom(Direction facing, boolean flag) {
        this.from[facing.m_122411_()] = flag;
    }

    public void resetFrom() {
        for (Direction facing : Direction.values()) {
            this.setFrom(facing, false);
        }
    }

    protected boolean isFrom(Direction facing) {
        return this.from[facing.m_122411_()];
    }

    protected boolean isAnySideUnclogged() {
        for (Direction facing : Direction.values()) {
            BlockEntity tile;
            if (!this.getConnection((Direction)facing).transfer || !((tile = this.f_58857_.m_7702_(this.f_58858_.m_121945_(facing))) instanceof PipeBlockEntityBase) || ((PipeBlockEntityBase)tile).clogged) continue;
            return true;
        }
        return false;
    }

    public void initConnections() {
        Block block = this.f_58857_.m_8055_(this.f_58858_).m_60734_();
        for (Direction direction : Direction.values()) {
            if (!(block instanceof PipeBlockBase)) continue;
            PipeBlockBase pipeBlock = (PipeBlockBase)block;
            BlockState facingState = this.f_58857_.m_8055_(this.f_58858_.m_121945_(direction));
            BlockEntity facingBE = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
            if (facingBE instanceof PipeBlockEntityBase && ((PipeBlockEntityBase)facingBE).getConnection(direction.m_122424_()) == PipeConnection.DISABLED) continue;
            if (facingState.m_204336_(pipeBlock.getConnectionTag())) {
                if (facingBE instanceof PipeBlockEntityBase && ((PipeBlockEntityBase)facingBE).getConnection(direction.m_122424_()) == PipeConnection.DISABLED) {
                    this.connections[direction.m_122411_()] = PipeConnection.DISABLED;
                    continue;
                }
                this.connections[direction.m_122411_()] = PipeConnection.PIPE;
                continue;
            }
            if (pipeBlock.connected(direction, facingState)) {
                this.connections[direction.m_122411_()] = PipeConnection.LEVER;
                continue;
            }
            if (pipeBlock.connectToTile(facingBE, direction)) {
                if (facingState.m_60734_() instanceof IPipeConnection) {
                    this.connections[direction.m_122411_()] = ((IPipeConnection)facingState.m_60734_()).getPipeConnection(facingState, direction.m_122424_());
                    continue;
                }
                this.connections[direction.m_122411_()] = PipeConnection.END;
                continue;
            }
            this.connections[direction.m_122411_()] = PipeConnection.NONE;
        }
        this.syncConnections = true;
        Misc.sendToTrackingPlayers(this.f_58857_, this.f_58858_, this.m_58483_());
        this.loaded = true;
        this.m_6596_();
        this.f_58857_.m_46745_(this.f_58858_).m_8092_(true);
        this.f_58857_.m_46717_(this.f_58858_, block);
    }

    public ModelData getModelData() {
        int[] data = new int[]{this.connections[0].visualIndex, this.connections[1].visualIndex, this.connections[2].visualIndex, this.connections[3].visualIndex, this.connections[4].visualIndex, this.connections[5].visualIndex};
        return ModelData.builder().with(DATA_TYPE, (Object)data).build();
    }

    public void setConnection(Direction direction, PipeConnection connection) {
        this.connections[direction.m_122411_()] = connection;
        this.syncConnections = true;
        this.requestModelDataUpdate();
        this.m_6596_();
    }

    public PipeConnection getConnection(Direction direction) {
        return this.connections[direction.m_122411_()];
    }

    public void setConnections(PipeConnection[] connections) {
        this.connections = connections;
        this.syncConnections = true;
        this.requestModelDataUpdate();
        this.m_6596_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientTick(Level level, BlockPos pos, BlockState state, PipeBlockEntityBase blockEntity) {
        if (blockEntity.lastTransfer != null && Misc.isWearingLens((Player)Minecraft.m_91087_().f_91074_)) {
            float vx = blockEntity.lastTransfer.m_122429_() / 1;
            float vy = blockEntity.lastTransfer.m_122430_() / 1;
            float vz = blockEntity.lastTransfer.m_122431_() / 1;
            double x = (float)pos.m_123341_() + 0.4f + random.nextFloat() * 0.2f;
            double y = (float)pos.m_123342_() + 0.4f + random.nextFloat() * 0.2f;
            double z = (float)pos.m_123343_() + 0.4f + random.nextFloat() * 0.2f;
            float r = blockEntity.clogged ? 255.0f : 16.0f;
            float g = blockEntity.clogged ? 16.0f : 255.0f;
            float b = 16.0f;
            for (int i = 0; i < 3; ++i) {
                level.m_7106_((ParticleOptions)new GlowParticleOptions(new Vector3f(r / 255.0f, g / 255.0f, b / 255.0f), new Vec3((double)vx, (double)vy, (double)vz), 2.0f), x, y, z, (double)vx, (double)vy, (double)vz);
            }
        }
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        if (this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    protected void resetSync() {
        this.syncCloggedFlag = false;
        this.syncTransfer = false;
        this.syncConnections = false;
    }

    protected boolean requiresSync() {
        return this.syncCloggedFlag || this.syncTransfer || this.syncConnections || !this.loaded;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("clogged")) {
            this.clogged = nbt.m_128471_("clogged");
        }
        if (nbt.m_128441_("lastTransfer")) {
            this.lastTransfer = Misc.readNullableFacing(nbt.m_128451_("lastTransfer"));
        }
        for (Direction facing : Direction.values()) {
            if (!nbt.m_128441_("from" + facing.m_122411_())) continue;
            this.from[facing.m_122411_()] = nbt.m_128471_("from" + facing.m_122411_());
        }
        if (nbt.m_128441_("lastRobin")) {
            this.lastRobin = nbt.m_128451_("lastRobin");
        }
        this.loadConnections(nbt);
        this.loaded = true;
    }

    public void loadConnections(CompoundTag nbt) {
        for (Direction direction : Direction.values()) {
            if (!nbt.m_128441_("connection" + direction.m_122411_())) continue;
            this.connections[direction.m_122411_()] = PipeConnection.values()[nbt.m_128451_("connection" + direction.m_122411_())];
        }
        this.requestModelDataUpdate();
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.saveConnections) {
            this.writeConnections(nbt);
        }
        this.writeCloggedFlag(nbt);
        this.writeLastTransfer(nbt);
        for (Direction facing : Direction.values()) {
            nbt.m_128379_("from" + facing.m_122411_(), this.from[facing.m_122411_()]);
        }
        nbt.m_128405_("lastRobin", this.lastRobin);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        if (this.saveConnections) {
            this.writeConnections(nbt);
        }
        if (this.syncCloggedFlag) {
            this.writeCloggedFlag(nbt);
        }
        if (this.syncTransfer) {
            this.writeLastTransfer(nbt);
        }
        return nbt;
    }

    public void writeConnections(CompoundTag nbt) {
        for (Direction direction : Direction.values()) {
            nbt.m_128405_("connection" + direction.m_122411_(), this.getConnection((Direction)direction).index);
        }
    }

    public void writeCloggedFlag(CompoundTag nbt) {
        nbt.m_128379_("clogged", this.clogged);
    }

    public void writeLastTransfer(CompoundTag nbt) {
        nbt.m_128405_("lastTransfer", Misc.writeNullableFacing(this.lastTransfer));
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        if (this.requiresSync()) {
            ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
            this.resetSync();
            return packet;
        }
        return null;
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
        }
    }

    public static enum PipeConnection implements StringRepresentable
    {
        NONE("none", 0, 0, false),
        DISABLED("disabled", 1, 0, false),
        PIPE("pipe", 2, 1, true),
        END("end", 3, 2, true),
        LEVER("lever", 4, 2, false);

        private final String name;
        public final int index;
        public final int visualIndex;
        public final boolean transfer;
        public static final PipeConnection[] visualValues;

        private PipeConnection(String name, int index, int visualIndex, boolean transfer) {
            this.name = name;
            this.index = index;
            this.visualIndex = visualIndex;
            this.transfer = transfer;
        }

        public static PipeConnection[] visual() {
            return visualValues;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            visualValues = new PipeConnection[]{NONE, PIPE, END};
        }
    }
}

