/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.upgrade.ClockworkAttenuatorUpgrade;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class ClockworkAttenuatorBlockEntity
extends BlockEntity {
    public ClockworkAttenuatorUpgrade upgrade;
    public double activeSpeed = 0.0;
    public double inactiveSpeed = 1.0;
    public double[] validSpeeds = new double[]{0.0, 0.0625, 0.125, 0.25, 0.5, 1.0};

    public ClockworkAttenuatorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.CLOCKWORK_ATTENUATOR_ENTITY.get(), pPos, pBlockState);
        this.upgrade = new ClockworkAttenuatorUpgrade(this);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.activeSpeed = nbt.m_128459_("active_speed");
        this.inactiveSpeed = nbt.m_128459_("inactive_speed");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128347_("active_speed", this.activeSpeed);
        nbt.m_128347_("inactive_speed", this.inactiveSpeed);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128347_("active_speed", this.activeSpeed);
        nbt.m_128347_("inactive_speed", this.inactiveSpeed);
        return nbt;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!(this.f_58859_ || cap != EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY || side != null && ((Direction)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_() != side)) {
            return this.upgrade.getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    public double getSpeed() {
        return this.f_58857_.m_276867_(this.f_58858_) ? this.activeSpeed : this.inactiveSpeed;
    }

    public double getNext(double current) {
        for (int i = 0; i < this.validSpeeds.length - 1; ++i) {
            double a = this.validSpeeds[i];
            double b = this.validSpeeds[i + 1];
            if (!(b > current) || !(a <= current)) continue;
            return b;
        }
        return current;
    }

    public double getPrevious(double current) {
        for (int i = 0; i < this.validSpeeds.length - 1; ++i) {
            double a = this.validSpeeds[i];
            double b = this.validSpeeds[i + 1];
            if (!(b >= current) || !(a < current)) continue;
            return a;
        }
        return current;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.upgrade.invalidate();
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
        }
    }
}

