/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.block;

import com.rekindled.embers.block.EmberEmitterBlock;
import com.rekindled.embers.block.PipeBlockBase;
import com.rekindled.embers.blockentity.PipeBlockEntityBase;
import com.rekindled.embers.datagen.EmbersBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class ExtractorBlockBase
extends PipeBlockBase {
    public static final VoxelShape EXTRACTOR_AABB = Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    public static final VoxelShape[] EXTRACTOR_SHAPES = new VoxelShape[729];

    public ExtractorBlockBase(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public VoxelShape getCenterShape() {
        return EXTRACTOR_AABB;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        BlockEntity BE = level.m_7702_(pos);
        if (BE instanceof PipeBlockEntityBase) {
            PipeBlockEntityBase pipe = (PipeBlockEntityBase)BE;
            return EXTRACTOR_SHAPES[ExtractorBlockBase.getShapeIndex(pipe.connections[0], pipe.connections[1], pipe.connections[2], pipe.connections[3], pipe.connections[4], pipe.connections[5])];
        }
        return CENTER_AABB;
    }

    @Override
    public boolean connected(Direction direction, BlockState state) {
        if (!state.m_204336_(EmbersBlockTags.EMITTER_CONNECTION)) {
            return false;
        }
        if (state.m_204336_(EmbersBlockTags.EMITTER_CONNECTION_FLOOR)) {
            if (direction == Direction.DOWN && state.m_204336_(EmbersBlockTags.EMITTER_CONNECTION_CEILING)) {
                return true;
            }
            return direction == Direction.UP;
        }
        BooleanProperty sideProp = EmberEmitterBlock.ALL_DIRECTIONS[direction.m_122424_().m_122411_()];
        if (state.m_61138_((Property)sideProp) && ((Boolean)state.m_61143_((Property)sideProp)).booleanValue()) {
            return true;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61377_) && state.m_61143_((Property)BlockStateProperties.f_61377_) == BellAttachType.CEILING && direction == Direction.DOWN) {
            return true;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61435_)) {
            if (direction == Direction.DOWN && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61435_)).booleanValue()) {
                return true;
            }
            return direction == Direction.UP && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61435_) == false;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61365_)) {
            return state.m_61143_((Property)BlockStateProperties.f_61365_) == direction.m_122434_();
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61376_) && state.m_61143_((Property)BlockStateProperties.f_61376_) != AttachFace.WALL) {
            if (direction == Direction.DOWN && state.m_61143_((Property)BlockStateProperties.f_61376_) == AttachFace.CEILING) {
                return true;
            }
            return direction == Direction.UP && state.m_61143_((Property)BlockStateProperties.f_61376_) == AttachFace.FLOOR;
        }
        return ExtractorBlockBase.facingConnected(direction, state, BlockStateProperties.f_61374_) && ExtractorBlockBase.facingConnected(direction, state, BlockStateProperties.f_61372_) && ExtractorBlockBase.facingConnected(direction, state, BlockStateProperties.f_61373_);
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return Shapes.m_83144_();
    }

    static {
        ExtractorBlockBase.makeShapes(EXTRACTOR_AABB, EXTRACTOR_SHAPES);
    }
}

