/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.augment;

import com.rekindled.embers.ConfigManager;
import com.rekindled.embers.api.augment.AugmentUtil;
import com.rekindled.embers.api.event.EmberProjectileEvent;
import com.rekindled.embers.api.projectile.IProjectilePreset;
import com.rekindled.embers.api.projectile.ProjectileFireball;
import com.rekindled.embers.api.projectile.ProjectileRay;
import com.rekindled.embers.augment.AugmentBase;
import java.util.ListIterator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FocalLensAugment
extends AugmentBase {
    public FocalLensAugment(ResourceLocation id) {
        super(id, 10.0);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onProjectileFire(EmberProjectileEvent event) {
        ListIterator<IProjectilePreset> projectiles = event.getProjectiles().listIterator();
        ItemStack weapon = event.getStack();
        if (!weapon.m_41619_() && AugmentUtil.hasHeat(weapon)) {
            int level = AugmentUtil.getAugmentLevel(weapon, this);
            int index = 0;
            int modulo = 1 + (level - 1) * 2;
            if (level > 0) {
                while (projectiles.hasNext()) {
                    IProjectilePreset projectile = projectiles.next();
                    if (projectile instanceof ProjectileRay) {
                        ((ProjectileRay)projectile).setPierceEntities(true);
                    } else if (projectile instanceof ProjectileFireball) {
                        ((ProjectileFireball)projectile).setHoming(level * 10, 4.0 + (double)level * 1.0, index, modulo, EntitySelector.f_20408_.and(EntitySelector.f_20403_).and(entity -> {
                            Entity shooter = projectile.getShooter();
                            if (shooter != null && entity.m_7307_(shooter)) {
                                return false;
                            }
                            if (entity instanceof Player && shooter instanceof Player && !FocalLensAugment.isPVPEnabled(entity.m_9236_())) {
                                return false;
                            }
                            return shooter != entity;
                        }));
                    }
                    ++index;
                }
            }
        }
    }

    public static boolean isPVPEnabled(Level world) {
        MinecraftServer server = world.m_7654_();
        return server != null && server.m_129799_() && (Boolean)ConfigManager.PVP_EVERYBODY_IS_ENEMY.get() != false;
    }
}

