/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.apiimpl;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.EmbersAPI;
import com.rekindled.embers.api.IEmbersAPI;
import com.rekindled.embers.api.augment.AugmentUtil;
import com.rekindled.embers.api.upgrades.UpgradeUtil;
import com.rekindled.embers.apiimpl.AugmentUtilImpl;
import com.rekindled.embers.apiimpl.UpgradeUtilImpl;
import com.rekindled.embers.augment.ShiftingScalesAugment;
import com.rekindled.embers.network.PacketHandler;
import com.rekindled.embers.network.message.MessageScalesData;
import com.rekindled.embers.util.EmberGenUtil;
import com.rekindled.embers.util.EmberInventoryUtil;
import com.rekindled.embers.util.Misc;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;

public class EmbersAPIImpl
implements IEmbersAPI {
    public static void init() {
        EmbersAPI.IMPL = new EmbersAPIImpl();
        AugmentUtil.IMPL = new AugmentUtilImpl();
        UpgradeUtil.IMPL = new UpgradeUtilImpl();
    }

    @Override
    public float getEmberDensity(long seed, int x, int z) {
        return EmberGenUtil.getEmberDensity(seed, x, z);
    }

    @Override
    public float getEmberStability(long seed, int x, int z) {
        return EmberGenUtil.getEmberStability(seed, x, z);
    }

    @Override
    public void registerLinkingHammer(Item item) {
        Misc.IS_HOLDING_HAMMER.add((player, hand) -> player.m_21120_(hand).m_41720_() == item);
    }

    @Override
    public void registerLinkingHammer(BiPredicate<Player, InteractionHand> predicate) {
        Misc.IS_HOLDING_HAMMER.add(predicate);
    }

    @Override
    public void registerHammerTargetGetter(Item item) {
        Misc.GET_HAMMER_TARGET.add(player -> {
            ItemStack stack = player.m_21205_();
            if (stack.m_41720_() != item) {
                stack = player.m_21206_();
            }
            if (stack.m_41720_() == item && stack.m_41782_()) {
                CompoundTag nbt = stack.m_41783_();
                if (stack.m_41782_() && nbt.m_128441_("targetWorld") && player.m_9236_().m_46472_().m_135782_().toString().equals(nbt.m_128461_("targetWorld"))) {
                    return Pair.of((Object)new BlockPos(nbt.m_128451_("targetX"), nbt.m_128451_("targetY"), nbt.m_128451_("targetZ")), (Object)Direction.m_122402_((String)nbt.m_128461_("targetFace")));
                }
            }
            return null;
        });
    }

    @Override
    public void registerHammerTargetGetter(Function<Player, Pair<BlockPos, Direction>> predicate) {
        Misc.GET_HAMMER_TARGET.add(predicate);
    }

    @Override
    public boolean isHoldingHammer(Player player, InteractionHand hand) {
        return Misc.isHoldingHammer(player, hand);
    }

    @Override
    public Pair<BlockPos, Direction> getHammerTarget(Player player) {
        return Misc.getHammerTarget(player);
    }

    @Override
    public void registerLens(Ingredient ingredient) {
        Misc.IS_WEARING_LENS.add(player -> ingredient.test(player.m_21205_()) || ingredient.test(player.m_21206_()));
    }

    @Override
    public void registerWearableLens(Ingredient ingredient) {
        Misc.IS_WEARING_LENS.add(player -> {
            if (ingredient.test((ItemStack)player.m_150109_().f_35975_.get(EquipmentSlot.HEAD.m_20749_()))) {
                return AugmentUtil.getAugmentLevel((ItemStack)player.m_150109_().f_35975_.get(EquipmentSlot.HEAD.m_20749_()), RegistryManager.SMOKY_LENS_AUGMENT) < 1;
            }
            return false;
        });
    }

    @Override
    public void registerLens(Predicate<Player> predicate) {
        Misc.IS_WEARING_LENS.add(predicate);
    }

    @Override
    public boolean isWearingLens(Player player) {
        return Misc.isWearingLens(player);
    }

    @Override
    public void registerEmberResonance(Ingredient ingredient, double resonance) {
        Misc.GET_EMBER_RESONANCE.add(stack -> ingredient.test(stack) ? resonance : -1.0);
    }

    @Override
    public double getEmberResonance(ItemStack stack) {
        return Misc.getEmberResonance(stack);
    }

    @Override
    public double getEmberTotal(Player player) {
        return EmberInventoryUtil.getEmberTotal(player);
    }

    @Override
    public double getEmberCapacityTotal(Player player) {
        return EmberInventoryUtil.getEmberCapacityTotal(player);
    }

    @Override
    public void removeEmber(Player player, double amount) {
        EmberInventoryUtil.removeEmber(player, amount);
    }

    @Override
    public Item getTaggedItem(TagKey<Item> tag) {
        return Misc.getTaggedItem(tag);
    }

    @Override
    public double getScales(LivingEntity entity) {
        ShiftingScalesAugment.IScalesCapability cap = (ShiftingScalesAugment.IScalesCapability)entity.getCapability(ShiftingScalesAugment.ScalesCapabilityProvider.scalesCapability).orElse(null);
        if (cap != null) {
            return cap.getScales();
        }
        return 0.0;
    }

    @Override
    public void setScales(LivingEntity entity, double scales) {
        ShiftingScalesAugment.IScalesCapability cap = (ShiftingScalesAugment.IScalesCapability)entity.getCapability(ShiftingScalesAugment.ScalesCapabilityProvider.scalesCapability).orElse(null);
        if (cap != null) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                if (cap.getScales() != scales) {
                    PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageScalesData(scales));
                }
            }
            cap.setScales(scales);
        }
    }
}

