/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.api.upgrades;

import com.rekindled.embers.api.event.UpgradeEvent;
import com.rekindled.embers.api.upgrades.UpgradeContext;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;

public interface IUpgradeProvider {
    public ResourceLocation getUpgradeId();

    default public int getPriority() {
        return 0;
    }

    default public int getLimit(BlockEntity tile) {
        return Integer.MAX_VALUE;
    }

    default public double getSpeed(BlockEntity tile, double speed, int distance, int count) {
        return speed;
    }

    default public boolean doTick(BlockEntity tile, List<UpgradeContext> upgrades, int distance, int count) {
        return false;
    }

    default public boolean doWork(BlockEntity tile, List<UpgradeContext> upgrades, int distance, int count) {
        return false;
    }

    default public double transformEmberConsumption(BlockEntity tile, double ember, int distance, int count) {
        return ember;
    }

    default public double transformEmberProduction(BlockEntity tile, double ember, int distance, int count) {
        return ember;
    }

    default public void transformOutput(BlockEntity tile, List<ItemStack> outputs, int distance, int count) {
    }

    default public FluidStack transformOutput(BlockEntity tile, FluidStack output, int distance, int count) {
        return output;
    }

    default public boolean getOtherParameter(BlockEntity tile, String type, boolean value, int distance, int count) {
        return value;
    }

    default public double getOtherParameter(BlockEntity tile, String type, double value, int distance, int count) {
        return value;
    }

    default public int getOtherParameter(BlockEntity tile, String type, int value, int distance, int count) {
        return value;
    }

    default public String getOtherParameter(BlockEntity tile, String type, String value, int distance, int count) {
        return value;
    }

    default public <T> T getOtherParameter(BlockEntity tile, String type, T value, int distance, int count) {
        return value;
    }

    default public void throwEvent(BlockEntity tile, List<UpgradeContext> upgrades, UpgradeEvent event, int distance, int count) {
    }
}

