/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.api.filter;

import com.rekindled.embers.api.filter.EnumFilterSetting;
import com.rekindled.embers.api.filter.IFilter;
import com.rekindled.embers.api.filter.IFilterComparator;
import com.rekindled.embers.util.FilterUtil;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class FilterSieve
implements IFilter {
    public static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("embers", "sieve");
    private ItemStack stack1;
    private ItemStack stack2;
    private int offset;
    private EnumFilterSetting setting;
    private boolean inverted;
    private IFilterComparator comparator;

    public FilterSieve(CompoundTag tag) {
        this.readFromNBT(tag);
    }

    public FilterSieve(ItemStack stack1, ItemStack stack2, int offset, EnumFilterSetting setting, boolean inverted) {
        this.stack1 = stack1;
        this.stack2 = stack2;
        this.offset = offset;
        this.setting = setting;
        this.inverted = inverted;
        this.findComparator();
    }

    private void findComparator() {
        if (this.stack1.m_41619_() && this.stack2.m_41619_()) {
            this.comparator = FilterUtil.ANY;
        } else {
            List<IFilterComparator> comparators = FilterUtil.getComparators(this.stack1, this.stack2);
            this.comparator = comparators.get(this.offset % comparators.size());
        }
    }

    @Override
    public ResourceLocation getType() {
        return RESOURCE_LOCATION;
    }

    @Override
    public boolean acceptsItem(ItemStack stack) {
        return this.comparator.isBetween(this.stack1, this.stack2, stack, this.setting) != this.inverted;
    }

    @Override
    public String formatFilter() {
        if (this.comparator == null) {
            return "INVALID COMPARATOR";
        }
        return this.comparator.format(this.stack1, this.stack2, this.setting, this.inverted);
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag tag) {
        tag.m_128359_("type", this.getType().toString());
        tag.m_128365_("stack1", (Tag)this.stack1.serializeNBT());
        tag.m_128365_("stack2", (Tag)this.stack2.serializeNBT());
        tag.m_128405_("offset", this.offset);
        tag.m_128405_("setting", this.setting.ordinal());
        tag.m_128379_("inverted", this.inverted);
        tag.m_128359_("comparator", this.comparator.getName());
        return tag;
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        this.stack1 = ItemStack.m_41712_((CompoundTag)tag.m_128469_("stack1"));
        this.stack2 = ItemStack.m_41712_((CompoundTag)tag.m_128469_("stack2"));
        this.offset = tag.m_128451_("offset");
        this.setting = EnumFilterSetting.values()[tag.m_128451_("setting")];
        this.inverted = tag.m_128471_("invert");
        if (tag.m_128441_("comparator")) {
            this.comparator = FilterUtil.getComparator(tag.m_128461_("comparator"));
        } else {
            this.findComparator();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterSieve) {
            return this.equals((FilterSieve)obj);
        }
        return super.equals(obj);
    }

    private boolean equals(FilterSieve other) {
        return Objects.equals(this.comparator, other.comparator) && Objects.equals(this.inverted, other.inverted) && Objects.equals((Object)this.setting, (Object)other.setting) && ItemStack.m_150942_((ItemStack)this.stack1, (ItemStack)other.stack1) && ItemStack.m_150942_((ItemStack)this.stack2, (ItemStack)other.stack2);
    }
}

