/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.augment.AugmentUtil;
import com.rekindled.embers.api.event.EmberProjectileEvent;
import com.rekindled.embers.api.item.IInflictorGem;
import com.rekindled.embers.api.item.IInflictorGemHolder;
import com.rekindled.embers.api.item.ITyrfingWeapon;
import com.rekindled.embers.augment.ShiftingScalesAugment;
import com.rekindled.embers.blockentity.ExplosionPedestalBlockEntity;
import com.rekindled.embers.datagen.EmbersDamageTypes;
import com.rekindled.embers.datagen.EmbersItemTags;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.network.PacketHandler;
import com.rekindled.embers.network.message.MessageEmberGenOffset;
import com.rekindled.embers.network.message.MessageWorldSeed;
import com.rekindled.embers.research.ResearchManager;
import com.rekindled.embers.util.EmberGenUtil;
import com.rekindled.embers.util.EmberWorldData;
import com.rekindled.embers.util.ExplosionCharmWorldInfo;
import com.rekindled.embers.util.Misc;
import java.util.HashMap;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.MissingMappingsEvent;

public class EmbersEvents {
    public static HashMap<ResourceLocation, ExplosionCharmWorldInfo> explosionCharmData = new HashMap();

    public static void fixMappings(MissingMappingsEvent event) {
        for (MissingMappingsEvent.Mapping mapping : event.getMappings(ForgeRegistries.Keys.BLOCKS, "embersrekindled")) {
            mapping.remap((Object)((Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation("embers", mapping.getKey().m_135815_()))));
        }
        for (MissingMappingsEvent.Mapping mapping : event.getMappings(ForgeRegistries.Keys.ITEMS, "embersrekindled")) {
            mapping.remap((Object)((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("embers", mapping.getKey().m_135815_()))));
        }
        for (MissingMappingsEvent.Mapping mapping : event.getMappings(ForgeRegistries.Keys.FLUIDS, "embersrekindled")) {
            mapping.remap((Object)((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation("embers", mapping.getKey().m_135815_()))));
        }
        for (MissingMappingsEvent.Mapping mapping : event.getMappings(ForgeRegistries.Keys.ENTITY_TYPES, "embersrekindled")) {
            mapping.remap((Object)((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation("embers", mapping.getKey().m_135815_()))));
        }
    }

    public static void onJoin(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof ServerPlayer && !event.getLevel().m_5776_()) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            ResearchManager.sendResearchData(player);
            ShiftingScalesAugment.sendScalesData(player);
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageWorldSeed(((ServerLevel)event.getLevel()).m_7328_()));
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageEmberGenOffset(EmberGenUtil.offX, EmberGenUtil.offZ));
        }
    }

    public static void onEntityDamaged(LivingHurtEvent event) {
        if (event.getSource().m_269415_().equals(((Registry)event.getEntity().m_9236_().m_9598_().m_6632_(Registries.f_268580_).get()).m_246971_(EmbersDamageTypes.EMBER_KEY).get()) && (event.getEntity().m_5825_() || event.getEntity().m_21023_(MobEffects.f_19607_))) {
            event.setAmount(event.getAmount() * 0.5f);
        }
        EmbersEvents.attuneInflictorGem(event.getEntity(), event.getSource(), event.getEntity().m_21205_());
        EmbersEvents.attuneInflictorGem(event.getEntity(), event.getSource(), event.getEntity().m_21206_());
        float mult = 1.0f;
        for (ItemStack armor : event.getEntity().m_6168_()) {
            mult -= EmbersEvents.getInflictorGemResistance(event, armor);
            EmbersEvents.addHeat((Entity)event.getEntity(), armor, 5.0f);
        }
        if (mult <= 0.0f) {
            event.setCanceled(true);
        }
        event.setAmount(event.getAmount() * mult);
        Entity source = event.getSource().m_7640_();
        if (source instanceof LivingEntity) {
            LivingEntity livingSource = (LivingEntity)source;
            ItemStack heldStack = livingSource.m_21205_();
            Item item = heldStack.m_41720_();
            if (item instanceof ITyrfingWeapon) {
                ITyrfingWeapon tyrfing = (ITyrfingWeapon)item;
                tyrfing.attack(event, event.getEntity().m_21051_(Attributes.f_22284_).m_22135_());
            }
            EmbersEvents.addHeat(source, heldStack, Math.max(1.0f, 0.5f * event.getAmount()));
        }
    }

    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player != null && event.getState().m_60800_((BlockGetter)event.getLevel(), event.getPos()) > 0.0f) {
            EmbersEvents.addHeat((Entity)player, player.m_21205_(), 1.0f);
        }
    }

    public static void onProjectileFired(EmberProjectileEvent event) {
        EmbersEvents.addHeat((Entity)event.getShooter(), event.getStack(), (float)event.getProjectiles().size() * (float)Mth.m_14085_((double)0.5, (double)3.0, (double)event.getCharge()));
    }

    public static void onArrowLoose(ArrowLooseEvent event) {
        EmbersEvents.addHeat((Entity)event.getEntity(), event.getBow(), 1.0f);
    }

    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        if (event.getLeft().isRepairable() && !event.getLeft().m_204117_(EmbersItemTags.MATERIA_BLACKLIST) && event.getRight().m_41720_() == RegistryManager.ISOLATED_MATERIA.get()) {
            int i3;
            int i = 0;
            int j = 0;
            int k = 0;
            int l2 = Math.min(event.getLeft().m_41773_(), event.getLeft().m_41776_() / 4);
            if (l2 <= 0) {
                event.setOutput(ItemStack.f_41583_);
                event.setCost(0);
                return;
            }
            ItemStack copy = event.getLeft().m_41777_();
            for (i3 = 0; l2 > 0 && i3 < event.getRight().m_41613_(); ++i3) {
                int j3 = copy.m_41773_() - l2;
                copy.m_41721_(j3);
                ++i;
                l2 = Math.min(event.getLeft().m_41773_(), event.getLeft().m_41776_() / 4);
            }
            event.setMaterialCost(i3);
            if (event.getName() != null && !Util.m_288217_((String)event.getName())) {
                if (!event.getName().equals(event.getLeft().m_41786_().getString())) {
                    k = 1;
                    i += k;
                    copy.m_41714_((Component)Component.m_237113_((String)event.getName()));
                }
            } else if (event.getLeft().m_41788_()) {
                k = 1;
                i += k;
                copy.m_41787_();
            }
            event.setCost(j + i);
            if (i <= 0) {
                copy = ItemStack.f_41583_;
            }
            if (k == i && k > 0 && event.getCost() >= 40) {
                event.setCost(39);
            }
            if (event.getCost() >= 40 && !event.getPlayer().m_150110_().f_35937_) {
                copy = ItemStack.f_41583_;
            }
            if (!copy.m_41619_()) {
                int k2 = copy.m_41610_();
                if (k != i || k == 0) {
                    k2 = k2 * 2 + 1;
                }
                copy.m_41742_(k2);
            }
            event.setOutput(copy);
        }
    }

    public static void onLevelLoad(LevelEvent.Load event) {
        ServerLevel server;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (server = (ServerLevel)levelAccessor).m_46472_() == Level.f_46428_) {
            EmberWorldData.get(server);
        }
    }

    public static void onServerTick(TickEvent.LevelTickEvent event) {
        if (event.side.isServer() && event.level.m_46472_() == Level.f_46428_) {
            boolean changed = false;
            if (Misc.random.nextInt(400) == 0) {
                ++EmberGenUtil.offX;
                changed = true;
            }
            if (Misc.random.nextInt(400) == 0) {
                ++EmberGenUtil.offZ;
                changed = true;
            }
            if (changed) {
                PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new MessageEmberGenOffset(EmberGenUtil.offX, EmberGenUtil.offZ));
                EmberWorldData.get((ServerLevel)event.level).m_77762_();
            }
        }
    }

    public static void putExplosionCharm(Level world, BlockPos pos) {
        if (!explosionCharmData.containsKey(world.m_46472_().m_135782_())) {
            explosionCharmData.put(world.m_46472_().m_135782_(), new ExplosionCharmWorldInfo());
        }
        ExplosionCharmWorldInfo data = explosionCharmData.get(world.m_46472_().m_135782_());
        data.put(pos);
    }

    public static void onExplosion(ExplosionEvent.Start event) {
        BlockEntity tile;
        Level world = event.getLevel();
        Explosion explosion = event.getExplosion();
        ExplosionCharmWorldInfo data = explosionCharmData.get(world.m_46472_().m_135782_());
        if (data == null) {
            return;
        }
        BlockPos charmPos = data.getClosestExplosionCharm(world, BlockPos.m_274446_((Position)explosion.getPosition()), 8);
        if (charmPos != null && (tile = world.m_7702_(charmPos)) instanceof ExplosionPedestalBlockEntity) {
            ((ExplosionPedestalBlockEntity)tile).absorb(explosion);
            event.setCanceled(true);
        }
    }

    public static void addHeat(Entity entity, ItemStack stack, float added) {
        if (AugmentUtil.hasHeat(stack)) {
            double maxHeat = AugmentUtil.getMaxHeat(stack);
            double heat = AugmentUtil.getHeat(stack);
            if (heat < maxHeat) {
                AugmentUtil.addHeat(stack, added);
                if (heat + (double)added >= maxHeat) {
                    entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)EmbersSounds.HEATED_ITEM_LEVELUP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    public static void attuneInflictorGem(LivingEntity entityLiving, DamageSource source, ItemStack stack) {
        if (stack.m_41720_() instanceof IInflictorGem) {
            ((IInflictorGem)stack.m_41720_()).attuneSource(stack, entityLiving, source);
        }
    }

    public static float getInflictorGemResistance(LivingHurtEvent event, ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IInflictorGemHolder) {
            IInflictorGemHolder inflictorGemHolder = (IInflictorGemHolder)item;
            return inflictorGemHolder.getTotalDamageResistance(event.getEntity(), event.getSource(), stack);
        }
        return 0.0f;
    }
}

