/*
 * Decompiled with CFR 0.152.
 */
package com.dugkse.moderntrainparts.content.wire;

import com.dugkse.moderntrainparts.config.MTPConfigs;
import com.dugkse.moderntrainparts.content.wire.WireBetweenBlockEntity;
import com.dugkse.moderntrainparts.content.wire.WireBlock;
import com.dugkse.moderntrainparts.content.wire.WireBlockEntity;
import com.dugkse.moderntrainparts.init.MTPBlockinit;
import com.simibubi.create.content.trains.track.FakeTrackBlock;
import com.simibubi.create.content.trains.track.FakeTrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class WireConnectorItem
extends Item {
    public WireConnectorItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        return this.useItem(context.m_43723_(), context.m_43725_(), context.m_8083_(), context.m_43719_()) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public static Boolean onTrack(Level lvl, BlockPos pos) {
        Block block = lvl.m_8055_(pos).m_60734_();
        return block instanceof TrackBlock || block instanceof FakeTrackBlock || lvl.m_7702_(pos) instanceof FakeTrackBlockEntity;
    }

    public static Tuple<BlockPos, BlockPos> getCorrectPos(Level lvl, BlockPos start, BlockPos end, Direction face1, Direction face2, Boolean onTrack1, Boolean onTrack2) {
        Tuple result = new Tuple((Object)BlockPos.f_121853_, (Object)BlockPos.f_121853_);
        result.m_145023_((Object)start.m_121945_(face1));
        result.m_145025_((Object)end.m_121945_(face2));
        if (WireBlock.isWireBlock(lvl.m_8055_(start))) {
            result.m_145023_((Object)end.m_121945_(face2));
            result.m_145025_((Object)start);
        } else if (WireBlock.isWireBlock(lvl.m_8055_(end))) {
            result.m_145025_((Object)end);
        }
        if (onTrack1.booleanValue()) {
            result.m_145023_((Object)start.m_6630_(WireConnectorItem.trackHeight().intValue()));
        }
        if (onTrack2.booleanValue()) {
            result.m_145025_((Object)end.m_6630_(WireConnectorItem.trackHeight().intValue()));
        }
        return result;
    }

    public boolean useItem(Player playerEntity, Level world, BlockPos pos, Direction face) {
        return this.useItem(playerEntity, world, pos, face, false);
    }

    public boolean useItem(Player playerEntity, Level world, BlockPos pos, Direction face, Boolean onTrack) {
        ItemStack heldItem = playerEntity.m_21205_();
        if (playerEntity.m_6144_()) {
            heldItem.m_41751_(null);
            return false;
        }
        boolean validAxis = WireConnectorItem.validateAxis(world, pos);
        CompoundTag tag = heldItem.m_41784_();
        BlockPos firstPulley = null;
        if (!(!tag.m_128441_("FirstPulley") || WireConnectorItem.validateAxis(world, firstPulley = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("FirstPulley"))) && firstPulley.m_123314_((Vec3i)pos, (double)(WireConnectorItem.maxLength() * 2)))) {
            tag.m_128473_("FirstPulley");
            heldItem.m_41751_(tag);
        }
        if (!validAxis) {
            return false;
        }
        if (tag.m_128441_("FirstPulley") && firstPulley != null) {
            Tuple<BlockPos, BlockPos> positions = WireConnectorItem.getCorrectPos(world, firstPulley, pos, Direction.m_122402_((String)tag.m_128469_("FirstPulley").m_128461_("ClickedFace")), face, tag.m_128469_("FirstPulley").m_128471_("OnTrack"), onTrack != false || WireConnectorItem.onTrack(world, pos) != false);
            if (!WireConnectorItem.canConnect(world, (BlockPos)positions.m_14418_(), (BlockPos)positions.m_14419_())) {
                return false;
            }
            if (!((BlockPos)positions.m_14418_()).equals(positions.m_14419_())) {
                WireConnectorItem.createWire(world, (BlockPos)positions.m_14418_(), (BlockPos)positions.m_14419_(), playerEntity);
                if (!playerEntity.m_7500_()) {
                    heldItem.m_41774_(1);
                }
            }
            if (!heldItem.m_41619_()) {
                heldItem.m_41751_(null);
                playerEntity.m_36335_().m_41524_((Item)this, 5);
            }
            return true;
        }
        CompoundTag compoundTag = NbtUtils.m_129224_((BlockPos)pos);
        compoundTag.m_128359_("ClickedFace", face.m_122433_());
        compoundTag.m_128379_("OnTrack", onTrack != false || WireConnectorItem.onTrack(world, pos) != false);
        tag.m_128365_("FirstPulley", (Tag)compoundTag);
        heldItem.m_41751_(tag);
        playerEntity.m_36335_().m_41524_((Item)this, 5);
        return true;
    }

    public static boolean canConnect(Level world, BlockPos first, BlockPos second) {
        if (!WireConnectorItem.validateAxis(world, first)) {
            return false;
        }
        if (!WireConnectorItem.validateAxis(world, second)) {
            return false;
        }
        if (!second.m_123314_((Vec3i)first, (double)WireConnectorItem.maxLength().intValue())) {
            return false;
        }
        BlockState firstState = world.m_8055_(first);
        BlockState secondState = world.m_8055_(second);
        double distance = first.m_123331_((Vec3i)second);
        if (WireBlock.isWireBlock(firstState) && WireBlock.isWireBlock(secondState)) {
            return false;
        }
        int limit = 1000;
        for (double t = 0.0; t < 1.0 && limit-- > 0; t += 0.25 / distance) {
            BlockPos pos = new BlockPos((int)Mth.m_14139_((double)t, (double)((double)first.m_123341_() + 0.5), (double)((double)second.m_123341_() + 0.5)), (int)Mth.m_14139_((double)t, (double)((double)first.m_123342_() + 0.5), (double)((double)second.m_123342_() + 0.5)), (int)Mth.m_14139_((double)t, (double)((double)first.m_123343_() + 0.5), (double)((double)second.m_123343_() + 0.5)));
            BlockState blockState = world.m_8055_(pos);
            if (WireBlock.isWireBlock(blockState) || blockState.m_247087_()) continue;
            return false;
        }
        return true;
    }

    public static Integer maxLength() {
        return (Integer)MTPConfigs.server().WIRE_LENGTH.get();
    }

    public static Integer trackHeight() {
        return (Integer)MTPConfigs.server().WIRE_TRACK_PL_HEIGHT.get();
    }

    public static boolean validateAxis(Level world, BlockPos pos) {
        return world.m_46749_(pos);
    }

    public static double enlarge(int val) {
        if (val >= 0) {
            return (double)val + 0.5;
        }
        return (double)val - 0.5;
    }

    public static void createWire(Level world, BlockPos start, BlockPos end, Player plr) {
        Vec3 startVector = new Vec3((double)start.m_123341_(), (double)start.m_123342_(), (double)start.m_123343_());
        Vec3 endVector = new Vec3((double)end.m_123341_(), (double)end.m_123342_(), (double)end.m_123343_());
        double run = Math.sqrt((endVector.f_82479_ - startVector.f_82479_) * (endVector.f_82479_ - startVector.f_82479_) + (endVector.f_82481_ - startVector.f_82481_) * (endVector.f_82481_ - startVector.f_82481_));
        double rise = endVector.f_82480_ - startVector.f_82480_;
        float horizontal_angle = WireConnectorItem.angleFromVectors(startVector.f_82479_, endVector.f_82479_, startVector.f_82481_, endVector.f_82481_);
        float vertical_angle = WireConnectorItem.angleFromSlope(rise / run);
        double distance = startVector.m_82554_(endVector);
        world.m_46597_(start, (BlockState)MTPBlockinit.WIRE_BLOCK.getDefaultState().m_61124_((Property)WireBlock.FACING, (Comparable)WireConnectorItem.getDirFromAngle(horizontal_angle)));
        BlockEntity entity = world.m_7702_(start);
        world.m_142346_((Entity)plr, GameEvent.f_157797_, start);
        world.m_5594_(null, start, SoundEvents.f_144119_, SoundSource.BLOCKS, 0.75f, 1.0f);
        if (entity instanceof WireBlockEntity) {
            WireBlockEntity wBE = (WireBlockEntity)entity;
            wBE.setLength((float)distance);
            wBE.setHorizontalOrientation(horizontal_angle);
            wBE.setVerticalOrientation(vertical_angle);
            wBE.end_position = end.m_121996_((Vec3i)start);
        }
        int limit = 1000;
        for (double t = 0.0; t < 1.0 && limit-- > 0; t += 0.25 / distance) {
            WireBetweenBlockEntity be;
            BlockPos pos = new BlockPos((int)Mth.m_14139_((double)t, (double)WireConnectorItem.enlarge(start.m_123341_()), (double)WireConnectorItem.enlarge(end.m_123341_())), (int)Mth.m_14139_((double)t, (double)WireConnectorItem.enlarge(start.m_123342_()), (double)WireConnectorItem.enlarge(end.m_123342_())), (int)Mth.m_14139_((double)t, (double)WireConnectorItem.enlarge(start.m_123343_()), (double)WireConnectorItem.enlarge(end.m_123343_())));
            BlockState blockState = world.m_8055_(pos);
            if (!blockState.m_247087_() || WireBlock.isWireBlock(blockState)) continue;
            if (pos.equals((Object)end)) break;
            world.m_46597_(pos, MTPBlockinit.WIRE_BETWEEN_BLOCK.getDefaultState());
            BlockEntity blockEntity = world.m_7702_(pos);
            if (!(blockEntity instanceof WireBetweenBlockEntity) || (be = (WireBetweenBlockEntity)blockEntity).isInitialized()) continue;
            be.addBlockPos(start);
        }
    }

    private static Direction getDirFromAngle(float orientation_horizontal) {
        if ((double)orientation_horizontal <= WireBlock.PI4 && (double)orientation_horizontal >= -WireBlock.PI4) {
            return Direction.EAST;
        }
        if ((double)orientation_horizontal > WireBlock.PI4 && (double)orientation_horizontal < 3.0 * WireBlock.PI4) {
            return Direction.SOUTH;
        }
        if ((double)orientation_horizontal > -3.0 * WireBlock.PI4 && (double)orientation_horizontal < -WireBlock.PI4) {
            return Direction.NORTH;
        }
        if ((double)orientation_horizontal >= 3.0 * WireBlock.PI4 || (double)orientation_horizontal <= -3.0 * WireBlock.PI4) {
            return Direction.WEST;
        }
        return Direction.UP;
    }

    private static float angleFromVectors(double x1, double x2, double z1, double z2) {
        double angle = Math.atan2(z2 - z1, x2 - x1);
        return (float)angle;
    }

    private static float angleFromSlope(double slope) {
        double angle = Math.atan(slope);
        return (float)angle;
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("FirstPulley");
    }
}

