/*
 * Decompiled with CFR 0.152.
 */
package com.dugkse.moderntrainparts.content.pantograph;

import com.dugkse.moderntrainparts.content.pantograph.PantographBlock;
import com.dugkse.moderntrainparts.content.pantograph.PantographTileEntity;
import com.dugkse.moderntrainparts.init.MTPPartialModels;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.render.ContraptionRenderDispatcher;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.function.Consumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class PantographRenderer
extends SafeBlockEntityRenderer<PantographTileEntity> {
    public PantographRenderer(BlockEntityRendererProvider.Context context) {
    }

    public static void renderInContraption(LerpedFloat animationProgress, MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        Matrix4f mw = matrices.getWorld();
        int conWL = ContraptionRenderDispatcher.getContraptionWorldLight((MovementContext)context, (VirtualRenderWorld)renderWorld);
        PoseStack ms = matrices.getViewProjection();
        VertexConsumer buf = buffer.m_6299_(RenderType.m_110451_());
        PantographRenderer.renderStatic(context.state, matrices.getModel(), animationProgress.getValue(AnimationTickHolder.getPartialTicks((LevelAccessor)renderWorld)), buff -> buff.light(mw, conWL).renderInto(ms, buf));
    }

    private static void renderStatic(BlockState blockState, PoseStack ps, float t, Consumer<SuperByteBuffer> renderBuffer) {
        float animationProgress = (float)(Math.cos((double)t * Math.PI) - 1.0) / -2.0f;
        float rotation = AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)((Direction)blockState.m_61143_((Property)PantographBlock.FACING))));
        if (((Boolean)blockState.m_61143_((Property)PantographBlock.SINGLE)).booleanValue()) {
            SuperByteBuffer pantoBtm = CachedBufferer.partial((PartialModel)MTPPartialModels.PANTOGRAPH_S_BTM, (BlockState)blockState);
            SuperByteBuffer pantoTop = CachedBufferer.partial((PartialModel)MTPPartialModels.PANTOGRAPH_S_TOP, (BlockState)blockState);
            SuperByteBuffer pantoPullrod = CachedBufferer.partial((PartialModel)MTPPartialModels.PANTOGRAPH_S_PULL_ROD, (BlockState)blockState);
            SuperByteBuffer pantoHinge = CachedBufferer.partial((PartialModel)MTPPartialModels.PANTOGRAPH_S_HINGE, (BlockState)blockState);
            SuperByteBuffer pantoUpper = CachedBufferer.partial((PartialModel)MTPPartialModels.PANTOGRAPH_S_UPPER, (BlockState)blockState);
            SuperByteBuffer pantoLower = CachedBufferer.partial((PartialModel)MTPPartialModels.PANTOGRAPH_S_LOWER, (BlockState)blockState);
            pantoBtm.transform(ps);
            pantoTop.transform(ps);
            pantoPullrod.transform(ps);
            pantoHinge.transform(ps);
            pantoUpper.transform(ps);
            pantoLower.transform(ps);
            renderBuffer.accept(pantoBtm.rotateCentered(Direction.UP, rotation).translate(0.5, 0.0, 0.5));
            renderBuffer.accept(pantoTop.rotateCentered(Direction.UP, rotation).translate(0.5, (double)(animationProgress * 1.25f), 0.5));
            renderBuffer.accept(((SuperByteBuffer)pantoPullrod.rotateCentered(Direction.UP, rotation).translate(0.5, 0.0, 0.5).translate(-0.03125, 0.28125, -0.34375).rotateX(31.59 * (double)animationProgress)).translate(0.03125, -0.28125, 0.34375));
            renderBuffer.accept(PantographRenderer.rotateAndMovePanto(pantoUpper.rotateCentered(Direction.UP, rotation).translate(0.5, 0.0, 0.5), 16.5, 3.6, -19.0, animationProgress));
            renderBuffer.accept(PantographRenderer.rotateAndMovePanto(pantoLower.rotateCentered(Direction.UP, rotation).translate(0.5, 0.0, 0.5), 3.0, -2.7, 23.5, animationProgress));
            double r = PantographRenderer.calculateAngleBetweenTwoPoints(-5.0f, 5.0f, -22.0f, 5.0f, -22.0f, 9.0f, -20.15f, 17.9f, -31.59f * animationProgress, animationProgress);
            renderBuffer.accept(((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)pantoHinge.rotateCentered(Direction.UP, rotation).translate(0.5, 0.0, 0.5).translate(0.0, (double)(animationProgress * 0.55625f), (double)(animationProgress * 0.115625f)).translate(0.0, 0.5625, -1.375).rotateY(-180.0)).rotateX(r)).rotateZ(180.0)).translate(0.0, -0.5625, 1.375));
        } else {
            SuperByteBuffer pantoBtm = CachedBufferer.partial((PartialModel)MTPPartialModels.PANTOGRAPH_D_BTM, (BlockState)blockState);
            SuperByteBuffer pantoTop = CachedBufferer.partial((PartialModel)MTPPartialModels.PANTOGRAPH_D_TOP, (BlockState)blockState);
            SuperByteBuffer pantoLowerA = CachedBufferer.partial((PartialModel)MTPPartialModels.PANTOGRAPH_D_LA, (BlockState)blockState);
            SuperByteBuffer pantoLowerB = CachedBufferer.partial((PartialModel)MTPPartialModels.PANTOGRAPH_D_LB, (BlockState)blockState);
            SuperByteBuffer pantoUA = CachedBufferer.partial((PartialModel)MTPPartialModels.PANTOGRAPH_D_UA, (BlockState)blockState);
            SuperByteBuffer pantoUB = CachedBufferer.partial((PartialModel)MTPPartialModels.PANTOGRAPH_D_UB, (BlockState)blockState);
            SuperByteBuffer pantoSpring = CachedBufferer.partial((PartialModel)MTPPartialModels.PANTOGRAPH_D_SPRING, (BlockState)blockState);
            pantoBtm.transform(ps);
            pantoTop.transform(ps);
            pantoLowerA.transform(ps);
            pantoLowerB.transform(ps);
            pantoUA.transform(ps);
            pantoUB.transform(ps);
            pantoSpring.transform(ps);
            renderBuffer.accept(pantoBtm.rotateCentered(Direction.UP, rotation).translate(0.5, 0.0, 0.5));
            renderBuffer.accept(pantoTop.rotateCentered(Direction.UP, rotation).translate(0.5, 0.0, 0.5).translate(0.0, 0.125 + (double)animationProgress * 1.2375, 0.0));
            renderBuffer.accept(PantographRenderer.rotateAroundPoint(pantoLowerA, rotation, 6.0f, -8.0f, 2.37 + 41.980000000000004 * (double)animationProgress));
            renderBuffer.accept(PantographRenderer.rotateAroundPoint(pantoLowerB, rotation, 6.0f, 8.0f, -2.37 - 41.980000000000004 * (double)animationProgress));
            double r = PantographRenderer.calculateAngleBetweenTwoPoints(-8.0f, 6.0f, -22.5f, 7.5f, -3.0f, 9.0f, -3.0f, 29.0f, -44.35f * animationProgress, animationProgress) - 90.0;
            renderBuffer.accept(((SuperByteBuffer)pantoUA.rotateCentered(Direction.UP, rotation).translate(0.5, 0.0, 0.5).translate(0.0, 0.125 + (double)animationProgress * 1.2375, 0.0).translate(0.0, 0.40625, -0.1875).scale(1.0f, 1.0f, (10.0f - 0.5f * animationProgress) / 10.0f).rotateX(-r)).translate(0.0, -0.40625, 0.1875));
            renderBuffer.accept(((SuperByteBuffer)pantoUB.rotateCentered(Direction.UP, rotation).translate(0.5, 0.0, 0.5).translate(0.0, 0.125 + (double)animationProgress * 1.2375, 0.0).translate(0.0, 0.40625, 0.1875).scale(1.0f, 1.0f, (10.0f - 0.5f * animationProgress) / 10.0f).rotateX(r)).translate(0.0, -0.40625, -0.1875));
            Pair<Double, Double> val = PantographRenderer.calcZY(-8.0f, 6.0f, -8.0f, 8.0f, 44.35f * animationProgress);
            float z = (float)((Double)val.getFirst()).doubleValue();
            double y = (Double)val.getSecond();
            renderBuffer.accept(pantoSpring.rotateCentered(Direction.UP, rotation).translate(0.5, (y - 8.0) / 16.0, 0.5).scale(1.0f, 1.0f, 1.0f + (z + 8.0f) * 2.0f / 17.0f));
        }
    }

    protected void renderSafe(PantographTileEntity be, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110457_());
        PantographRenderer.renderStatic(be.m_58900_(), new PoseStack(), be.animationProgress.getValue(partialTicks), buff -> buff.light(light).renderInto(ms, buffer));
    }

    private static SuperByteBuffer rotateAroundPoint(SuperByteBuffer buff, float r, float y, float z, double angle) {
        return ((SuperByteBuffer)buff.rotateCentered(Direction.UP, r).translate(0.5, 0.0, 0.5).translate(0.0, (double)(y / 16.0f), (double)(z / 16.0f)).rotateX(angle)).translate(0.0, (double)(-y / 16.0f), (double)(-z / 16.0f));
    }

    private static SuperByteBuffer rotateAndMovePanto(SuperByteBuffer buff, double offsetY, double offsetZ, double angle, float animationProgress) {
        return (SuperByteBuffer)buff.translate(0.0, (double)animationProgress * (offsetY / 16.0), (double)animationProgress * (offsetZ / 16.0)).rotateX(angle * (double)animationProgress);
    }

    private static Pair<Double, Double> calcZY(float cz, float cy, float pz, float py, float angleD) {
        double angle = Math.toRadians(angleD);
        return Pair.of((Object)(Math.cos(angle) * (double)(pz - cz) - Math.sin(angle) * (double)(py - cy) + (double)cz), (Object)(Math.sin(angle) * (double)(pz - cz) + Math.cos(angle) * (double)(py - cy) + (double)cy));
    }

    private static double calculateAngleBetweenTwoPoints(float cz, float cy, float pz, float py, float psz, float psy, float pez, float pey, float angleD, float animationProgress) {
        double angle = Math.toRadians(angleD);
        double z = Math.cos(angle) * (double)(pz - cz) - Math.sin(angle) * (double)(py - cy) + (double)cz;
        double y = Math.sin(angle) * (double)(pz - cz) + Math.cos(angle) * (double)(py - cy) + (double)cy;
        return Math.toDegrees(Math.atan2(PantographRenderer.lerp(psy, pey, animationProgress) - y, PantographRenderer.lerp(psz, pez, animationProgress) - z)) + 90.0;
    }

    private static double lerp(float a, float b, float f) {
        return (double)a * (1.0 - (double)f) + (double)(b * f);
    }
}

