/*
 * Decompiled with CFR 0.152.
 */
package com.dugkse.moderntrainparts.content.pantograph;

import com.dugkse.moderntrainparts.content.pantograph.PantographBlock;
import com.dugkse.moderntrainparts.content.pantograph.PantographRenderer;
import com.dugkse.moderntrainparts.content.pantograph.PantographTileEntity;
import com.dugkse.moderntrainparts.init.MTPTagsInit;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;

public class PantographMovementBehaviour
implements MovementBehaviour {
    private double lastParticle = 0.0;
    private float speed = 0.02f;

    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        context.data.m_128457_("animationProgress");
        PantographRenderer.renderInContraption(PantographMovementBehaviour.getAnimation(context), context, renderWorld, matrices, buffer);
    }

    private void spawnParticles(Level level, Vec3 spawnPos, Vec3 speed) {
        if (this.lastParticle > 4.0 || speed.m_82553_() != 0.0) {
            this.lastParticle = 0.0;
            level.m_7106_((ParticleOptions)ParticleTypes.f_175830_, spawnPos.m_7096_(), spawnPos.m_7098_(), spawnPos.m_7094_(), speed.f_82479_, speed.f_82480_, speed.f_82481_);
        }
    }

    public void tick(MovementContext context) {
        this.lastParticle += 1.0;
        PantographMovementBehaviour.getAnimation(context).tickChaser();
        this.animatePantograph(context);
        super.tick(context);
    }

    public boolean mustTickWhileDisabled() {
        return true;
    }

    public void onDisabledByControls(MovementContext context) {
        context.data.m_128379_("isControlled", true);
        context.data.m_128379_("interacted", true);
        this.animatePantograph(context);
        super.onDisabledByControls(context);
    }

    public void visitNewPosition(MovementContext context, BlockPos pos) {
        super.visitNewPosition(context, pos);
        if (this.findPowerTransfer(context, pos)) {
            context.data.m_128365_("touches_power", (Tag)NbtUtils.m_129224_((BlockPos)pos.m_6630_(1)));
        } else {
            context.data.m_128473_("touches_power");
        }
    }

    protected boolean findPowerTransfer(MovementContext context, BlockPos pos) {
        CarriageContraption cc;
        Contraption contraption = context.contraption;
        if (contraption instanceof CarriageContraption && !(cc = (CarriageContraption)contraption).notInPortal()) {
            return false;
        }
        if (PantographMovementBehaviour.getAnimation(context).getValue() < 1.0f) {
            return false;
        }
        Optional<Direction> currentFacingIfValid = this.getCurrentFacingIfValid(context);
        if (currentFacingIfValid.isEmpty()) {
            return false;
        }
        Block blockAbove = context.world.m_8055_(pos.m_6630_(2).m_121945_(currentFacingIfValid.get())).m_60734_();
        return blockAbove instanceof IronBarsBlock || MTPTagsInit.AllBlockTags.TRANSFERS_ELECTRICITY_TRAINS.matches(blockAbove);
    }

    private Optional<Direction> getCurrentFacingIfValid(MovementContext context) {
        Direction facingFromVector;
        Vec3 directionVec = Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_((Property)PantographBlock.FACING)).m_122436_());
        if ((directionVec = (Vec3)context.rotation.apply(directionVec)).m_82554_(Vec3.m_82528_((Vec3i)(facingFromVector = Direction.m_122366_((double)directionVec.f_82479_, (double)directionVec.f_82480_, (double)directionVec.f_82481_)).m_122436_())) > 0.5) {
            return Optional.empty();
        }
        return Optional.of(facingFromVector);
    }

    private void animatePantograph(MovementContext context) {
        if (context.contraption.entity == null) {
            return;
        }
        BlockState info = ((StructureTemplate.StructureBlockInfo)context.contraption.getBlocks().get(context.localPos)).f_74676_();
        LerpedFloat animationProgress = PantographMovementBehaviour.getAnimation(context);
        if (context.data.m_128471_("isControlled")) {
            if (!context.disabled) {
                this.setGoUp(context, animationProgress);
            } else {
                this.setGoDown(context, animationProgress);
            }
            info.m_61124_((Property)PantographBlock.UP, (Comparable)Boolean.valueOf(!context.disabled));
            if (!context.world.f_46443_) {
                context.contraption.entity.setBlock(context.localPos, new StructureTemplate.StructureBlockInfo(context.localPos, (BlockState)context.state.m_61124_((Property)PantographBlock.UP, (Comparable)Boolean.valueOf(!context.disabled)), context.data));
            }
        } else if (context.data.m_128471_("interacted")) {
            if (((Boolean)info.m_61143_((Property)PantographBlock.UP)).booleanValue()) {
                this.setGoUp(context, animationProgress);
            } else {
                this.setGoDown(context, animationProgress);
            }
        } else if (((Boolean)info.m_61143_((Property)PantographBlock.UP)).booleanValue()) {
            animationProgress.setValue(1.0);
            animationProgress.setValue(1.0);
            this.setGoUp(context, animationProgress);
        } else {
            animationProgress.setValue(0.0);
            animationProgress.setValue(0.0);
            this.setGoDown(context, animationProgress);
        }
    }

    private void setGoDown(MovementContext context, LerpedFloat animationProgress) {
        PantographTileEntity.animationChase(0.0f, animationProgress);
        context.data.m_128473_("touches_power");
    }

    private void setGoUp(MovementContext context, LerpedFloat animationProgress) {
        PantographTileEntity.animationChase(1.0f, animationProgress);
        Vec3 positions = context.position;
        BlockPos pos = new BlockPos((int)positions.m_7096_(), (int)positions.m_7098_(), (int)positions.m_7094_());
        if (!context.data.m_128441_("touches_power") && this.findPowerTransfer(context, pos)) {
            context.data.m_128365_("touches_power", (Tag)NbtUtils.m_129224_((BlockPos)pos.m_6630_(1)));
        }
    }

    public static LerpedFloat getAnimation(MovementContext context) {
        Object object = context.temporaryData;
        if (!(object instanceof LerpedFloat)) {
            LerpedFloat nlf = LerpedFloat.linear();
            context.temporaryData = nlf;
            return nlf;
        }
        LerpedFloat lf = (LerpedFloat)object;
        return lf;
    }
}

