/*
 * Decompiled with CFR 0.152.
 */
package com.dugkse.moderntrainparts.content.containers.forge;

import com.dugkse.moderntrainparts.config.MTPConfigs;
import com.dugkse.moderntrainparts.content.containers.ContainerWall;
import com.dugkse.moderntrainparts.content.containers.ItemContainerTileEntity;
import com.dugkse.moderntrainparts.init.MTPBlockEntitiesinit;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryWrapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class ItemContainerTileEntityImpl
extends ItemContainerTileEntity {
    public ItemStackHandler inventory;
    private LazyOptional<IItemHandler> itemCapability;

    @Override
    protected void ClearItemCapabalitiy() {
        this.itemCapability.invalidate();
    }

    protected ItemContainerTileEntityImpl(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.inventory = new ItemStackHandler((Integer)MTPConfigs.server().CONTAINER_CAPACITY.get()){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                ItemContainerTileEntityImpl.this.recalculateComparatorsNextTick = true;
            }
        };
        this.itemCapability = LazyOptional.empty();
    }

    public static ItemContainerTileEntity create(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        return new ItemContainerTileEntityImpl(tileEntityTypeIn, pos, state);
    }

    @Override
    protected void initCapability() {
        if (this.itemCapability.isPresent()) {
            return;
        }
        if (!this.isController()) {
            ItemContainerTileEntityImpl controllerTE = (ItemContainerTileEntityImpl)this.getControllerBE();
            if (controllerTE == null) {
                return;
            }
            controllerTE.initCapability();
            this.itemCapability = controllerTE.itemCapability;
            return;
        }
        boolean alongZ = ContainerWall.getContainerBlockAxis(this.m_58900_()) == Direction.Axis.Z;
        IItemHandlerModifiable[] invs = new IItemHandlerModifiable[this.length * this.radius * this.radius];
        for (int yOffset = 0; yOffset < this.length; ++yOffset) {
            for (int xOffset = 0; xOffset < this.radius; ++xOffset) {
                for (int zOffset = 0; zOffset < this.radius; ++zOffset) {
                    BlockPos vaultPos = alongZ ? this.f_58858_.m_7918_(xOffset, zOffset, yOffset) : this.f_58858_.m_7918_(yOffset, xOffset, zOffset);
                    ItemContainerTileEntityImpl vaultAt = (ItemContainerTileEntityImpl)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)MTPBlockEntitiesinit.CONTAINER_ENTITY.get()), (BlockGetter)this.f_58857_, (BlockPos)vaultPos);
                    invs[yOffset * this.radius * this.radius + xOffset * this.radius + zOffset] = vaultAt != null ? vaultAt.inventory : new ItemStackHandler();
                }
            }
        }
        VersionedInventoryWrapper itemHandler = new VersionedInventoryWrapper((IItemHandlerModifiable)new CombinedInvWrapper(invs));
        this.itemCapability = LazyOptional.of(() -> ItemContainerTileEntityImpl.lambda$initCapability$0((IItemHandler)itemHandler));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isItemHandlerCap(cap)) {
            this.initCapability();
            return this.itemCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStackHandler getInventoryOfBlock() {
        return this.inventory;
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        if (!clientPacket) {
            this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        }
        super.read(compound, clientPacket);
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        if (!clientPacket) {
            compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        }
    }

    public void applyInventoryToBlock(ItemStackHandler handler) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, i < handler.getSlots() ? handler.getStackInSlot(i) : ItemStack.f_41583_);
        }
    }

    private static /* synthetic */ IItemHandler lambda$initCapability$0(IItemHandler itemHandler) {
        return itemHandler;
    }
}

