/*
 * Decompiled with CFR 0.152.
 */
package com.dugkse.moderntrainparts.content.bulkStorage.forge;

import com.dugkse.moderntrainparts.content.bulkStorage.BulkStorageMovement;
import com.dugkse.moderntrainparts.content.bulkStorage.BulkStorageRenderer;
import com.dugkse.moderntrainparts.content.bulkStorage.packets.BulkStorageContraptionFilledPacket;
import com.dugkse.moderntrainparts.init.MTPPacketsInit;
import com.dugkse.moderntrainparts.multiloader.PlayerSelection;
import com.dugkse.moderntrainparts.multiloader.S2CPacket;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;

public class BulkStorageMovementImpl
extends BulkStorageMovement {
    private double lastFilledValue;

    public static BulkStorageMovement create() {
        return new BulkStorageMovementImpl();
    }

    public void tick(MovementContext context) {
        if (context.blockEntityData.m_128441_("Controller")) {
            super.tick(context);
            return;
        }
        Level lvl = context.world;
        if (!lvl.f_46443_) {
            int filled = 0;
            int space = 0;
            BlockState materialState = NbtUtils.m_247651_(BulkStorageRenderer.blockHolderGetter(context.world), (CompoundTag)context.blockEntityData.m_128469_("Material"));
            if (materialState.m_60734_() == Blocks.f_50016_) {
                materialState = NbtUtils.m_247651_(BulkStorageRenderer.blockHolderGetter(context.world), (CompoundTag)context.blockEntityData.m_128469_("LastMaterial"));
            }
            Block materialBlock = materialState.m_60734_();
            IItemHandlerModifiable inv = context.contraption.getSharedInventory();
            for (int i = 0; i < inv.getSlots(); ++i) {
                BlockItem bi;
                Item item;
                ItemStack stack = inv.getStackInSlot(i);
                if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof BlockItem && (bi = (BlockItem)item).m_40614_() == materialBlock) {
                    filled += stack.m_41613_();
                    space += inv.getSlotLimit(i);
                    continue;
                }
                if (!stack.m_41619_()) continue;
                space += inv.getSlotLimit(i);
            }
            double filledVal = (double)filled / (double)space;
            if (this.lastFilledValue != filledVal) {
                this.lastFilledValue = filledVal;
                MTPPacketsInit.PACKETS.sendTo(PlayerSelection.tracking((Entity)context.contraption.entity), (S2CPacket)new BulkStorageContraptionFilledPacket(context.contraption.entity, filledVal));
            }
        }
        super.tick(context);
    }
}

