/*
 * Decompiled with CFR 0.152.
 */
package com.dugkse.moderntrainparts.content.bulkStorage;

import com.dugkse.moderntrainparts.content.bulkStorage.BulkStorageBlockEntity;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.render.BlockEntityRenderHelper;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class BulkStorageRenderer
extends SafeBlockEntityRenderer<BulkStorageBlockEntity> {
    private final BlockEntityRendererProvider.Context context;

    public BulkStorageRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    protected void renderSafe(BulkStorageBlockEntity te, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        float height = (float)te.getFilledpercent();
        if (height == 0.0f) {
            return;
        }
        BulkStorageRenderer.renderFluidStream(te.getFacing(), te.getMaterial(), te.m_58904_(), te.lastKnownPos, height, bufferSource, ms, light);
    }

    private static BlockPos getLightPos(@Nullable Matrix4f lightTransform, BlockPos contraptionPos) {
        if (lightTransform != null) {
            Vector4f lightVec = new Vector4f((float)contraptionPos.m_123341_() + 0.5f, (float)contraptionPos.m_123342_() + 0.5f, (float)contraptionPos.m_123343_() + 0.5f, 1.0f);
            lightVec.mul((Matrix4fc)lightTransform);
            return BlockPos.m_274561_((double)lightVec.x(), (double)lightVec.y(), (double)lightVec.z());
        }
        return contraptionPos;
    }

    public static HolderGetter<Block> blockHolderGetter(Level level) {
        return level != null ? level.m_246945_(Registries.f_256747_) : BuiltInRegistries.f_256975_.m_255303_();
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        Direction facing;
        CompoundTag lastMaterial;
        CompoundTag material;
        AtomicReference<Float> height = new AtomicReference<Float>(Float.valueOf(0.5f));
        context.contraption.maybeInstancedBlockEntities.forEach(blockEntity -> {
            if (blockEntity instanceof BulkStorageBlockEntity && blockEntity.m_58899_() == context.localPos) {
                blockEntity.m_142339_((Level)renderWorld);
                height.set(Float.valueOf((float)((BulkStorageBlockEntity)((Object)blockEntity)).getFilledpercent()));
            }
        });
        if (height.get().floatValue() == 0.0f) {
            return;
        }
        int light = BlockEntityRenderHelper.getCombinedLight((Level)context.world, (BlockPos)BulkStorageRenderer.getLightPos(matrices.getLight(), context.localPos), (VirtualRenderWorld)renderWorld, (BlockPos)context.localPos);
        PoseStack ms = matrices.getViewProjection();
        PoseStack model = matrices.getModel();
        ms.m_85836_();
        ms.m_85850_().m_252922_().mul((Matrix4fc)model.m_85850_().m_252922_());
        ms.m_85850_().m_252943_().mul((Matrix3fc)model.m_85850_().m_252943_());
        if (context.blockEntityData.m_128441_("Controller")) {
            CompoundTag nbt = ((StructureTemplate.StructureBlockInfo)context.contraption.getActorAt((BlockPos)NbtUtils.m_129239_((CompoundTag)context.blockEntityData.m_128469_((String)"Controller"))).left).f_74677_();
            material = nbt.m_128469_("Material");
            lastMaterial = nbt.m_128469_("LastMaterial");
            facing = BulkStorageBlockEntity.getFacing((char)nbt.m_128445_("Direction"));
        } else {
            material = context.blockEntityData.m_128469_("Material");
            lastMaterial = context.blockEntityData.m_128469_("LastMaterial");
            facing = BulkStorageBlockEntity.getFacing((char)context.blockEntityData.m_128445_("Direction"));
        }
        BlockState materialState = NbtUtils.m_247651_(BulkStorageRenderer.blockHolderGetter(context.world), (CompoundTag)material);
        if (materialState.m_60734_() == Blocks.f_50016_) {
            materialState = NbtUtils.m_247651_(BulkStorageRenderer.blockHolderGetter(context.world), (CompoundTag)lastMaterial);
        }
        BulkStorageRenderer.renderFluidStream(facing, materialState, context.world, new BlockPos((int)context.position.m_7096_(), (int)context.position.m_7098_(), (int)context.position.m_7094_()), height.get().floatValue(), buffer, ms, light);
        ms.m_85849_();
    }

    private static ListIterator<BakedQuad> getQuads(BlockRenderDispatcher renderer, BlockState state, Direction dir) {
        return renderer.m_110910_(state).m_213637_(state, dir, RandomSource.m_216327_()).listIterator();
    }

    private static TextureAtlasSprite getSprite(BlockRenderDispatcher renderer, BlockState state, Direction dir) {
        BakedModel model = renderer.m_110910_(state);
        List quads = model.m_213637_(state, dir, RandomSource.m_216327_());
        if (!quads.isEmpty()) {
            return ((BakedQuad)quads.get(0)).m_173410_();
        }
        return model.m_6160_();
    }

    private static void renderDir(Direction dir, double offset_x, double offset_y, double offset_z, float left, float down, float right, float height, float depth, VertexConsumer builder, PoseStack ms, int light, ListIterator<BakedQuad> quads, BlockRenderDispatcher renderer, BlockState state, Level lvl, BlockPos pos) {
        BulkStorageRenderer.renderDir(dir, offset_x, offset_y, offset_z, left, down, right, height, depth, builder, ms, light, quads, renderer, state, lvl, pos, null);
    }

    private static void renderDir(Direction dir, double offset_x, double offset_y, double offset_z, float left, float down, float right, float height, float depth, VertexConsumer builder, PoseStack ms, int light, ListIterator<BakedQuad> quads, BlockRenderDispatcher renderer, BlockState state, Level lvl, BlockPos pos, @Nullable Consumer<PoseStack> consumer) {
        TextureAtlasSprite texture;
        int color = -1;
        if (quads.hasNext()) {
            BakedQuad quad = quads.next();
            texture = quad.m_173410_();
            int tintIndex = -1;
            if (quad.m_111304_()) {
                tintIndex = quad.m_111305_();
            }
            if (!quads.hasNext()) {
                color = Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)lvl, pos, tintIndex);
            }
        } else {
            texture = renderer.m_110910_(state).m_6160_();
        }
        ms.m_85836_();
        if (consumer != null) {
            consumer.accept(ms);
        }
        ms.m_85837_(offset_x, offset_y, offset_z);
        BulkStorageRenderer.renderStillTiledFace(dir, left, down, right, height, depth, builder, ms, light, color, texture);
        ms.m_85849_();
        if (quads.hasNext()) {
            BulkStorageRenderer.renderDir(dir, offset_x, offset_y, offset_z, left, down, right, height, depth, builder, ms, light, quads, renderer, state, lvl, pos, consumer);
        }
    }

    public static void renderFluidStream(Direction facing, BlockState material, Level lvl, BlockPos pos, float height, MultiBufferSource buffer, PoseStack ms, int light) {
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110463_());
        Direction north = Direction.NORTH;
        Direction east = Direction.EAST;
        Direction south = Direction.SOUTH;
        Direction west = Direction.WEST;
        Direction up = Direction.UP;
        Direction down = Direction.DOWN;
        BlockRenderDispatcher renderer = Minecraft.m_91087_().m_91289_();
        ListIterator<BakedQuad> northQuads = BulkStorageRenderer.getQuads(renderer, material, north);
        ListIterator<BakedQuad> eastQuads = BulkStorageRenderer.getQuads(renderer, material, east);
        ListIterator<BakedQuad> southQuads = BulkStorageRenderer.getQuads(renderer, material, south);
        ListIterator<BakedQuad> westQuads = BulkStorageRenderer.getQuads(renderer, material, west);
        ListIterator<BakedQuad> upQuads = BulkStorageRenderer.getQuads(renderer, material, up);
        ListIterator<BakedQuad> downQuads = BulkStorageRenderer.getQuads(renderer, material, down);
        if (facing == Direction.UP) {
            BulkStorageRenderer.renderDir(east, 0.5, 0.0, 1.0, -1.0f, 0.0f, 0.0f, height, 0.5f, builder, ms, light, eastQuads, renderer, material, lvl, pos);
            BulkStorageRenderer.renderDir(west, -0.5, 0.0, 1.0, -1.0f, 0.0f, 0.0f, height, 0.5f, builder, ms, light, westQuads, renderer, material, lvl, pos);
            BulkStorageRenderer.renderDir(south, 1.0, 0.0, 0.5, -1.0f, 0.0f, 0.0f, height, 0.5f, builder, ms, light, southQuads, renderer, material, lvl, pos);
            BulkStorageRenderer.renderDir(north, 1.0, 0.0, -0.5, -1.0f, 0.0f, 0.0f, height, 0.5f, builder, ms, light, northQuads, renderer, material, lvl, pos);
            BulkStorageRenderer.renderDir(up, 1.0, (double)height + 0.5, 1.0, -1.0f, -1.0f, 0.0f, 0.0f, -0.5f, builder, ms, light, upQuads, renderer, material, lvl, pos);
            BulkStorageRenderer.renderDir(down, 1.0, 0.5, 1.0, -1.0f, -1.0f, 0.0f, 0.0f, -0.5f, builder, ms, light, downQuads, renderer, material, lvl, pos);
        } else if (facing == Direction.EAST) {
            BulkStorageRenderer.renderDir(east, 0.5, 0.0, 1.0, -1.0f, 0.0f, 0.0f, height, 0.5f, builder, ms, light, upQuads, renderer, material, lvl, pos);
            BulkStorageRenderer.renderDir(west, -0.5, 0.0, 1.0, -1.0f, 0.0f, 0.0f, height, 0.5f, builder, ms, light, downQuads, renderer, material, lvl, pos);
            BulkStorageRenderer.renderDir(south, 1.0, 0.0, 0.5, -height, 0.0f, 0.0f, 1.0f, 0.5f, builder, ms, light, southQuads, renderer, material, lvl, pos, ps -> {
                ps.m_85837_(0.5, 0.5, 0.5);
                ps.m_252781_(Axis.f_252393_.m_252977_(90.0f));
                ps.m_85837_(-0.5, -0.5, -0.5);
            });
            BulkStorageRenderer.renderDir(north, 1.0, 0.0, -0.5, -height, 0.0f, 0.0f, 1.0f, 0.5f, builder, ms, light, northQuads, renderer, material, lvl, pos, ps -> {
                ps.m_85837_(0.5, 0.5, 0.5);
                ps.m_252781_(Axis.f_252393_.m_252977_(90.0f));
                ps.m_85837_(-0.5, -0.5, -0.5);
            });
            BulkStorageRenderer.renderDir(up, 1.0, (double)height + 0.5, 1.0, -1.0f, -1.0f, 0.0f, 0.0f, -0.5f, builder, ms, light, eastQuads, renderer, material, lvl, pos, ps -> {
                ps.m_85837_(0.5, 0.5, 0.5);
                ps.m_252781_(Axis.f_252392_.m_252977_(90.0f));
                ps.m_85837_(-0.5, -0.5, -0.5);
            });
            BulkStorageRenderer.renderDir(down, 1.0, 0.5, 1.0, -1.0f, -1.0f, 0.0f, 0.0f, -0.5f, builder, ms, light, westQuads, renderer, material, lvl, pos, ps -> {
                ps.m_85837_(0.5, 0.5, 0.5);
                ps.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                ps.m_85837_(-0.5, -0.5, -0.5);
            });
        } else if (facing == Direction.SOUTH) {
            BulkStorageRenderer.renderDir(east, 0.5, 0.0, 1.0, -height, 0.0f, 0.0f, 1.0f, 0.5f, builder, ms, light, eastQuads, renderer, material, lvl, pos, ps -> {
                ps.m_85837_(0.5, 0.5, 0.5);
                ps.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                ps.m_85837_(-0.5, -0.5, -0.5);
            });
            BulkStorageRenderer.renderDir(west, -0.5, 0.0, 1.0, -height, 0.0f, 0.0f, 1.0f, 0.5f, builder, ms, light, westQuads, renderer, material, lvl, pos, ps -> {
                ps.m_85837_(0.5, 0.5, 0.5);
                ps.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                ps.m_85837_(-0.5, -0.5, -0.5);
            });
            BulkStorageRenderer.renderDir(south, 1.0, 0.0, 0.5, -1.0f, 0.0f, 0.0f, height, 0.5f, builder, ms, light, upQuads, renderer, material, lvl, pos);
            BulkStorageRenderer.renderDir(north, 1.0, 0.0, -0.5, -1.0f, 0.0f, 0.0f, height, 0.5f, builder, ms, light, downQuads, renderer, material, lvl, pos);
            BulkStorageRenderer.renderDir(up, 1.0, (double)height + 0.5, 1.0, -1.0f, -1.0f, 0.0f, 0.0f, -0.5f, builder, ms, light, southQuads, renderer, material, lvl, pos, ps -> {
                ps.m_85837_(0.5, 0.5, 0.5);
                ps.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                ps.m_85837_(-0.5, -0.5, -0.5);
            });
            BulkStorageRenderer.renderDir(down, 1.0, 0.5, 1.0, -1.0f, -1.0f, 0.0f, 0.0f, -0.5f, builder, ms, light, northQuads, renderer, material, lvl, pos);
        }
    }

    public static void renderStillTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack ms, int light, int color, TextureAtlasSprite texture) {
        BulkStorageRenderer.renderTiledFace(dir, left, down, right, up, depth, builder, ms, light, color, texture, 1.0f);
    }

    public static void renderFlowingTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack ms, int light, int color, TextureAtlasSprite texture) {
        BulkStorageRenderer.renderTiledFace(dir, left, down, right, up, depth, builder, ms, light, color, texture, 1.0f);
    }

    public static void renderTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack ms, int light, int color, TextureAtlasSprite texture, float textureScale) {
        boolean positive = dir.m_122421_() == Direction.AxisDirection.POSITIVE;
        boolean horizontal = dir.m_122434_().m_122479_();
        boolean x = dir.m_122434_() == Direction.Axis.X;
        float shrink = texture.m_118417_() * 0.25f * textureScale;
        float centerU = texture.m_118409_() + (texture.m_118410_() - texture.m_118409_()) * 0.5f * textureScale;
        float centerV = texture.m_118411_() + (texture.m_118412_() - texture.m_118411_()) * 0.5f * textureScale;
        float x2 = 0.0f;
        float y2 = 0.0f;
        float x1 = left;
        while (x1 < right) {
            float u2;
            float u1;
            float f = Mth.m_14143_((float)x1);
            x2 = Math.min(f + 1.0f, right);
            if (dir == Direction.NORTH || dir == Direction.EAST) {
                f = Mth.m_14167_((float)x2);
                u1 = texture.m_118367_((double)((f - x2) * 16.0f * textureScale));
                u2 = texture.m_118367_((double)((f - x1) * 16.0f * textureScale));
            } else {
                u1 = texture.m_118367_((double)((x1 - f) * 16.0f * textureScale));
                u2 = texture.m_118367_((double)((x2 - f) * 16.0f * textureScale));
            }
            u1 = Mth.m_14179_((float)shrink, (float)u1, (float)centerU);
            u2 = Mth.m_14179_((float)shrink, (float)u2, (float)centerU);
            float y1 = down;
            while (y1 < up) {
                float v2;
                float v1;
                f = Mth.m_14143_((float)y1);
                y2 = Math.min(f + 1.0f, up);
                if (dir == Direction.UP) {
                    v1 = texture.m_118393_((double)((y1 - f) * 16.0f * textureScale));
                    v2 = texture.m_118393_((double)((y2 - f) * 16.0f * textureScale));
                } else {
                    f = Mth.m_14167_((float)y2);
                    v1 = texture.m_118393_((double)((f - y2) * 16.0f * textureScale));
                    v2 = texture.m_118393_((double)((f - y1) * 16.0f * textureScale));
                }
                v1 = Mth.m_14179_((float)shrink, (float)v1, (float)centerV);
                v2 = Mth.m_14179_((float)shrink, (float)v2, (float)centerV);
                if (horizontal) {
                    if (x) {
                        BulkStorageRenderer.putVertex(builder, ms, depth, y2, positive ? x2 : x1, color, u1, v1, dir, light);
                        BulkStorageRenderer.putVertex(builder, ms, depth, y1, positive ? x2 : x1, color, u1, v2, dir, light);
                        BulkStorageRenderer.putVertex(builder, ms, depth, y1, positive ? x1 : x2, color, u2, v2, dir, light);
                        BulkStorageRenderer.putVertex(builder, ms, depth, y2, positive ? x1 : x2, color, u2, v1, dir, light);
                    } else {
                        BulkStorageRenderer.putVertex(builder, ms, positive ? x1 : x2, y2, depth, color, u1, v1, dir, light);
                        BulkStorageRenderer.putVertex(builder, ms, positive ? x1 : x2, y1, depth, color, u1, v2, dir, light);
                        BulkStorageRenderer.putVertex(builder, ms, positive ? x2 : x1, y1, depth, color, u2, v2, dir, light);
                        BulkStorageRenderer.putVertex(builder, ms, positive ? x2 : x1, y2, depth, color, u2, v1, dir, light);
                    }
                } else {
                    BulkStorageRenderer.putVertex(builder, ms, x1, depth, positive ? y1 : y2, color, u1, v1, dir, light);
                    BulkStorageRenderer.putVertex(builder, ms, x1, depth, positive ? y2 : y1, color, u1, v2, dir, light);
                    BulkStorageRenderer.putVertex(builder, ms, x2, depth, positive ? y2 : y1, color, u2, v2, dir, light);
                    BulkStorageRenderer.putVertex(builder, ms, x2, depth, positive ? y1 : y2, color, u2, v1, dir, light);
                }
                y1 = y2;
            }
            x1 = x2;
        }
    }

    private static void putVertex(VertexConsumer builder, PoseStack ms, float x, float y, float z, int color, float u, float v, Direction face, int light) {
        Vec3i normal = face.m_122436_();
        PoseStack.Pose peek = ms.m_85850_();
        int a = -1;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        builder.m_252986_(peek.m_252922_(), x, y, z).m_6122_(r, g, b, a).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(peek.m_252943_(), (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
    }
}

