/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.blockentity.CrystalSeedBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class CrystalSeedStructureProcessor
extends StructureProcessor {
    public static final Codec<CrystalSeedStructureProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("min_xp").forGetter(processor -> processor.minXp), (App)Codec.INT.fieldOf("max_xp").forGetter(processor -> processor.maxXp), (App)Codec.INT.fieldOf("size").forGetter(processor -> processor.size)).apply((Applicative)instance, CrystalSeedStructureProcessor::new));
    public final int minXp;
    public final int maxXp;
    public final int size;

    public CrystalSeedStructureProcessor(int minXp, int maxXp, int size) {
        this.minXp = minXp;
        this.maxXp = maxXp;
        this.size = size;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader level, BlockPos offset, BlockPos pos, StructureTemplate.StructureBlockInfo blockInfo, StructureTemplate.StructureBlockInfo relativeBlockInfo, StructurePlaceSettings settings) {
        ResourceLocation id;
        CompoundTag nbt = relativeBlockInfo.f_74677_();
        if (nbt != null && nbt.m_128441_("id") && (id = new ResourceLocation(nbt.m_128461_("id"))).m_135827_().equals("embers") && id.m_135815_().contains("crystal_seed")) {
            nbt = nbt.m_6426_();
            int xp = this.getXp(settings.m_230326_(relativeBlockInfo.f_74675_()));
            nbt.m_128405_("xp", xp);
            nbt.m_128405_("size", this.size);
            nbt.m_128359_("spawns", CrystalSeedBlockEntity.getSpawnString(CrystalSeedBlockEntity.getSpawns(xp)));
            return new StructureTemplate.StructureBlockInfo(relativeBlockInfo.f_74675_(), relativeBlockInfo.f_74676_(), nbt);
        }
        return relativeBlockInfo;
    }

    public int getXp(RandomSource rand) {
        int xp = rand.m_216339_(this.minXp, this.maxXp);
        xp -= xp % 1000;
        return xp += this.size;
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)RegistryManager.CRYSTAL_SEED_PROCESSOR.get();
    }
}

