/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.upgrade;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.event.EmberBoreBladeRenderEvent;
import com.rekindled.embers.api.event.MachineRecipeEvent;
import com.rekindled.embers.api.event.UpgradeEvent;
import com.rekindled.embers.api.upgrades.UpgradeContext;
import com.rekindled.embers.blockentity.EmberBoreBlockEntity;
import com.rekindled.embers.blockentity.ExcavationBucketsBlockEntity;
import com.rekindled.embers.recipe.BoringContext;
import com.rekindled.embers.upgrade.DefaultUpgradeProvider;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;

public class ExcavationBucketsUpgrade
extends DefaultUpgradeProvider {
    @OnlyIn(value=Dist.CLIENT)
    public static BakedModel buckets;

    public ExcavationBucketsUpgrade(BlockEntity tile) {
        super(new ResourceLocation("embers", "excavation_buckets"), tile);
    }

    @Override
    public int getPriority() {
        return -90;
    }

    @Override
    public int getLimit(BlockEntity tile) {
        if (tile instanceof EmberBoreBlockEntity) {
            return Integer.MAX_VALUE;
        }
        return 0;
    }

    @Override
    public boolean doTick(BlockEntity tile, List<UpgradeContext> upgrades, int distance, int count) {
        ((ExcavationBucketsBlockEntity)this.tile).lastAngle = ((ExcavationBucketsBlockEntity)this.tile).angle;
        if (tile instanceof EmberBoreBlockEntity) {
            EmberBoreBlockEntity bore = (EmberBoreBlockEntity)tile;
            if (bore.isRunning) {
                ((ExcavationBucketsBlockEntity)this.tile).angle = (float)((double)((ExcavationBucketsBlockEntity)this.tile).angle + 14.0 * bore.speedMod);
            }
        }
        return false;
    }

    @Override
    public void throwEvent(BlockEntity tile, List<UpgradeContext> upgrades, UpgradeEvent event, int distance, int count) {
        if (tile instanceof EmberBoreBlockEntity) {
            MachineRecipeEvent recipeEvent;
            EmberBoreBlockEntity bore = (EmberBoreBlockEntity)tile;
            if (event instanceof MachineRecipeEvent && (recipeEvent = (MachineRecipeEvent)event).getRecipe() instanceof List) {
                List recipes = (List)recipeEvent.getRecipe();
                ResourceKey biome = (ResourceKey)tile.m_58904_().m_204166_(tile.m_58899_()).m_203543_().get();
                BoringContext context = new BoringContext(tile.m_58904_().m_46472_().m_135782_(), biome.m_135782_(), tile.m_58899_().m_123342_(), (BlockState[])tile.m_58904_().m_46847_(bore.getBladeBoundingBox()).toArray(BlockState[]::new));
                List newRecipes = tile.m_58904_().m_7465_().m_44056_((RecipeType)RegistryManager.EXCAVATION.get(), (Container)context, tile.m_58904_());
                recipes.addAll(newRecipes);
            }
        }
        if (tile.m_58904_().m_5776_()) {
            CLientStuff.throwEvent(tile, upgrades, event, distance, count);
        }
    }

    public static class CLientStuff {
        public static void throwEvent(BlockEntity tile, List<UpgradeContext> upgrades, UpgradeEvent event, int distance, int count) {
            if (buckets != null && event instanceof EmberBoreBladeRenderEvent) {
                EmberBoreBladeRenderEvent renderEvent = (EmberBoreBladeRenderEvent)event;
                Minecraft.m_91087_().m_91289_().m_110937_().renderModel(renderEvent.getPose().m_85850_(), renderEvent.getBuffer().m_6299_(Sheets.m_110789_()), renderEvent.getBlockState(), buckets, 0.0f, 0.0f, 0.0f, renderEvent.getLight(), renderEvent.getOverlay(), ModelData.EMPTY, Sheets.m_110789_());
            }
        }
    }
}

