/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.upgrade;

import com.rekindled.embers.api.event.AlchemyResultEvent;
import com.rekindled.embers.api.event.AlchemyStartEvent;
import com.rekindled.embers.api.event.UpgradeEvent;
import com.rekindled.embers.api.upgrades.UpgradeContext;
import com.rekindled.embers.blockentity.EntropicEnumeratorBlockEntity;
import com.rekindled.embers.recipe.AlchemyContext;
import com.rekindled.embers.upgrade.DefaultUpgradeProvider;
import com.rekindled.embers.util.Misc;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EntropicEnumeratorUpgrade
extends DefaultUpgradeProvider {
    public EntropicEnumeratorUpgrade(BlockEntity tile) {
        super(new ResourceLocation("embers", "entropic_enumerator"), tile);
    }

    @Override
    public int getPriority() {
        return -90;
    }

    @Override
    public void throwEvent(BlockEntity tile, List<UpgradeContext> upgrades, UpgradeEvent event, int distance, int count) {
        EntropicEnumeratorBlockEntity enumerator;
        BlockEntity blockEntity;
        UpgradeEvent alchemyEvent;
        if (event instanceof AlchemyStartEvent && ((AlchemyStartEvent)(alchemyEvent = (AlchemyStartEvent)event)).getRecipe() != null && (blockEntity = this.tile) instanceof EntropicEnumeratorBlockEntity) {
            enumerator = (EntropicEnumeratorBlockEntity)blockEntity;
            if (((AlchemyStartEvent)alchemyEvent).getRecipe().getResult((AlchemyContext)((AlchemyStartEvent)alchemyEvent).context).blackPins != ((AlchemyStartEvent)alchemyEvent).getRecipe().getInputs().size()) {
                enumerator.solve(false, 390);
            }
        }
        if (event instanceof AlchemyResultEvent) {
            alchemyEvent = (AlchemyResultEvent)event;
            blockEntity = this.tile;
            if (blockEntity instanceof EntropicEnumeratorBlockEntity) {
                enumerator = (EntropicEnumeratorBlockEntity)blockEntity;
                int blackPins = ((AlchemyResultEvent)alchemyEvent).getResult().blackPins;
                int requirement = ((AlchemyResultEvent)alchemyEvent).getRecipe().getInputs().size();
                if (blackPins != requirement) {
                    if (upgrades.get(0).upgrade() == this) {
                        if (Misc.random.nextFloat(count + 3) > 3.0f) {
                            ((AlchemyResultEvent)alchemyEvent).setFailure(true);
                        } else {
                            int bonusWhite = Math.min(((AlchemyResultEvent)alchemyEvent).getResult().whitePins, count + 1);
                            int bonusNothing = count / 2;
                            if (((AlchemyResultEvent)alchemyEvent).isFailure() && requirement <= blackPins + bonusWhite + bonusNothing) {
                                ((AlchemyResultEvent)alchemyEvent).setFailure(false);
                            }
                        }
                    }
                    enumerator.restartScramble(Misc.random.nextInt(EntropicEnumeratorBlockEntity.queueTime));
                }
            }
        }
    }
}

