/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.google.gson.JsonObject;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.recipe.MetalCoefficientRecipe;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;

public class MetalCoefficientRecipeBuilder {
    public ResourceLocation id;
    public ResourceLocation blockTag;
    public double coefficient;

    public static MetalCoefficientRecipeBuilder create(ResourceLocation tag) {
        MetalCoefficientRecipeBuilder builder = new MetalCoefficientRecipeBuilder();
        builder.blockTag = tag;
        return builder;
    }

    public static MetalCoefficientRecipeBuilder create(TagKey<Block> tag) {
        MetalCoefficientRecipeBuilder builder = MetalCoefficientRecipeBuilder.create(tag.f_203868_());
        builder.id = tag.f_203868_();
        return builder;
    }

    public MetalCoefficientRecipeBuilder id(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public MetalCoefficientRecipeBuilder domain(String domain) {
        this.id = new ResourceLocation(domain, this.id.m_135815_());
        return this;
    }

    public MetalCoefficientRecipeBuilder folder(String folder) {
        this.id = new ResourceLocation(this.id.m_135827_(), folder + "/" + this.id.m_135815_());
        return this;
    }

    public MetalCoefficientRecipeBuilder coefficient(double coefficient) {
        this.coefficient = coefficient;
        return this;
    }

    public MetalCoefficientRecipe build() {
        return new MetalCoefficientRecipe(this.id, (TagKey<Block>)BlockTags.create((ResourceLocation)this.blockTag), this.coefficient);
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new Finished(this.build()));
    }

    public static class Finished
    implements FinishedRecipe {
        public final MetalCoefficientRecipe recipe;

        public Finished(MetalCoefficientRecipe recipe) {
            this.recipe = recipe;
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("block_tag", this.recipe.blockTag.f_203868_().toString());
            json.addProperty("coefficient", (Number)this.recipe.coefficient);
        }

        public ResourceLocation m_6445_() {
            return this.recipe.m_6423_();
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RegistryManager.METAL_COEFFICIENT_SERIALIZER.get();
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

