/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.google.gson.JsonObject;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.recipe.GemSocketRecipe;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class GemSocketRecipeBuilder {
    public ResourceLocation id;
    public Ingredient ingredient;

    public static GemSocketRecipeBuilder create(Ingredient ingredient) {
        GemSocketRecipeBuilder builder = new GemSocketRecipeBuilder();
        builder.ingredient = ingredient;
        return builder;
    }

    public static GemSocketRecipeBuilder create(TagKey<Item> tag) {
        GemSocketRecipeBuilder builder = GemSocketRecipeBuilder.create(Ingredient.m_204132_(tag));
        builder.id = tag.f_203868_();
        return builder;
    }

    public static GemSocketRecipeBuilder create(ItemStack itemStack) {
        GemSocketRecipeBuilder builder = GemSocketRecipeBuilder.create(Ingredient.m_43927_((ItemStack[])new ItemStack[]{itemStack}));
        builder.id = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
        return builder;
    }

    public static GemSocketRecipeBuilder create(Item item) {
        return GemSocketRecipeBuilder.create(new ItemStack((ItemLike)item));
    }

    public GemSocketRecipeBuilder id(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public GemSocketRecipeBuilder domain(String domain) {
        this.id = new ResourceLocation(domain, this.id.m_135815_());
        return this;
    }

    public GemSocketRecipeBuilder folder(String folder) {
        this.id = new ResourceLocation(this.id.m_135827_(), folder + "/" + this.id.m_135815_());
        return this;
    }

    public GemSocketRecipe build() {
        return new GemSocketRecipe(this.id, this.ingredient);
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new Finished(this.build()));
    }

    public static class Finished
    implements FinishedRecipe {
        public final GemSocketRecipe recipe;

        public Finished(GemSocketRecipe recipe) {
            this.recipe = recipe;
        }

        public void m_7917_(JsonObject json) {
            json.add("ingredient", this.recipe.ingredient.m_43942_());
        }

        public ResourceLocation m_6445_() {
            return this.recipe.m_6423_();
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RegistryManager.GEM_SOCKET_SERIALIZER.get();
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

