/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.google.gson.JsonObject;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.recipe.EmberActivationRecipe;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class EmberActivationRecipeBuilder {
    public ResourceLocation id;
    public Ingredient ingredient;
    public int ember;

    public static EmberActivationRecipeBuilder create(Ingredient ingredient) {
        EmberActivationRecipeBuilder builder = new EmberActivationRecipeBuilder();
        builder.ingredient = ingredient;
        return builder;
    }

    public static EmberActivationRecipeBuilder create(TagKey<Item> tag) {
        EmberActivationRecipeBuilder builder = EmberActivationRecipeBuilder.create(Ingredient.m_204132_(tag));
        builder.id = tag.f_203868_();
        return builder;
    }

    public static EmberActivationRecipeBuilder create(ItemStack itemStack) {
        EmberActivationRecipeBuilder builder = EmberActivationRecipeBuilder.create(Ingredient.m_43927_((ItemStack[])new ItemStack[]{itemStack}));
        builder.id = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
        return builder;
    }

    public static EmberActivationRecipeBuilder create(Item item) {
        return EmberActivationRecipeBuilder.create(new ItemStack((ItemLike)item));
    }

    public EmberActivationRecipeBuilder id(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public EmberActivationRecipeBuilder domain(String domain) {
        this.id = new ResourceLocation(domain, this.id.m_135815_());
        return this;
    }

    public EmberActivationRecipeBuilder folder(String folder) {
        this.id = new ResourceLocation(this.id.m_135827_(), folder + "/" + this.id.m_135815_());
        return this;
    }

    public EmberActivationRecipeBuilder ember(int ember) {
        this.ember = ember;
        return this;
    }

    public EmberActivationRecipe build() {
        return new EmberActivationRecipe(this.id, this.ingredient, this.ember);
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new Finished(this.build()));
    }

    public static class Finished
    implements FinishedRecipe {
        public final EmberActivationRecipe recipe;

        public Finished(EmberActivationRecipe recipe) {
            this.recipe = recipe;
        }

        public void m_7917_(JsonObject json) {
            json.add("input", this.recipe.ingredient.m_43942_());
            json.addProperty("ember", (Number)this.recipe.ember);
        }

        public ResourceLocation m_6445_() {
            return this.recipe.m_6423_();
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RegistryManager.EMBER_ACTIVATION_SERIALIZER.get();
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

