/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.recipe.AlchemyRecipe;
import com.rekindled.embers.recipe.AlchemyRecipeBase;
import com.rekindled.embers.recipe.AlchemyRecipeForBabies;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class AlchemyRecipeBuilder {
    public ResourceLocation id;
    public ItemStack output;
    public ItemStack failure = ItemStack.f_41583_;
    public Ingredient tablet;
    public ArrayList<Ingredient> aspects = new ArrayList();
    public ArrayList<Ingredient> inputs = new ArrayList();
    public boolean babbyGames = false;

    public static AlchemyRecipeBuilder create(ItemStack itemStack) {
        AlchemyRecipeBuilder builder = new AlchemyRecipeBuilder();
        builder.output = itemStack;
        builder.id = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
        return builder;
    }

    public static AlchemyRecipeBuilder create(ItemLike item) {
        return AlchemyRecipeBuilder.create(new ItemStack(item));
    }

    public AlchemyRecipeBuilder id(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public AlchemyRecipeBuilder domain(String domain) {
        this.id = new ResourceLocation(domain, this.id.m_135815_());
        return this;
    }

    public AlchemyRecipeBuilder folder(String folder) {
        this.id = new ResourceLocation(this.id.m_135827_(), folder + "/" + this.id.m_135815_());
        return this;
    }

    public AlchemyRecipeBuilder tablet(Ingredient tablet) {
        this.tablet = tablet;
        return this;
    }

    public AlchemyRecipeBuilder tablet(ItemLike ... tablet) {
        this.tablet(Ingredient.m_43929_((ItemLike[])tablet));
        return this;
    }

    public AlchemyRecipeBuilder tablet(TagKey<Item> tag) {
        this.tablet(Ingredient.m_204132_(tag));
        return this;
    }

    public AlchemyRecipeBuilder output(ItemStack output) {
        this.output = output;
        return this;
    }

    public AlchemyRecipeBuilder output(Item item) {
        this.output(new ItemStack((ItemLike)item));
        return this;
    }

    public AlchemyRecipeBuilder failure(ItemStack failure) {
        this.failure = failure;
        return this;
    }

    public AlchemyRecipeBuilder failure(Item item) {
        this.failure(new ItemStack((ItemLike)item));
        return this;
    }

    public AlchemyRecipeBuilder aspects(ArrayList<Ingredient> aspects) {
        this.aspects = aspects;
        return this;
    }

    public AlchemyRecipeBuilder inputs(ArrayList<Ingredient> inputs) {
        this.inputs = inputs;
        return this;
    }

    public AlchemyRecipeBuilder aspects(Ingredient ... aspects) {
        for (Ingredient aspect : aspects) {
            this.aspects.add(aspect);
        }
        return this;
    }

    public AlchemyRecipeBuilder inputs(Ingredient ... inputs) {
        for (Ingredient input : inputs) {
            this.inputs.add(input);
        }
        return this;
    }

    public AlchemyRecipeBuilder aspects(ItemLike ... aspects) {
        for (ItemLike aspect : aspects) {
            this.aspects.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{aspect}));
        }
        return this;
    }

    public AlchemyRecipeBuilder inputs(ItemLike ... inputs) {
        for (ItemLike input : inputs) {
            this.inputs.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}));
        }
        return this;
    }

    @SafeVarargs
    public final AlchemyRecipeBuilder aspects(TagKey<Item> ... aspects) {
        for (TagKey<Item> aspect : aspects) {
            this.aspects.add(Ingredient.m_204132_(aspect));
        }
        return this;
    }

    @SafeVarargs
    public final AlchemyRecipeBuilder inputs(TagKey<Item> ... inputs) {
        for (TagKey<Item> input : inputs) {
            this.inputs.add(Ingredient.m_204132_(input));
        }
        return this;
    }

    public AlchemyRecipeBuilder setBabbyGames(boolean babbyGames) {
        this.babbyGames = babbyGames;
        return this;
    }

    public AlchemyRecipeBase build() {
        if (this.babbyGames) {
            return new AlchemyRecipeForBabies(this.id, this.tablet, this.aspects, this.inputs, this.output, this.failure);
        }
        return new AlchemyRecipe(this.id, this.tablet, this.aspects, this.inputs, this.output, this.failure);
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new Finished(this.build()));
    }

    public static class Finished
    implements FinishedRecipe {
        public final AlchemyRecipeBase recipe;

        public Finished(AlchemyRecipeBase recipe) {
            this.recipe = recipe;
        }

        public void m_7917_(JsonObject json) {
            JsonObject outputJson = new JsonObject();
            outputJson.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.recipe.output.m_41720_()).toString());
            int count = this.recipe.output.m_41613_();
            if (count > 1) {
                outputJson.addProperty("count", (Number)count);
            }
            json.add("output", (JsonElement)outputJson);
            if (!this.recipe.failure.m_41619_()) {
                JsonObject failureJson = new JsonObject();
                failureJson.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.recipe.failure.m_41720_()).toString());
                int failureCount = this.recipe.failure.m_41613_();
                if (failureCount > 1) {
                    failureJson.addProperty("count", (Number)failureCount);
                }
                json.add("failure", (JsonElement)failureJson);
            }
            json.add("tablet", this.recipe.tablet.m_43942_());
            JsonArray aspectJson = new JsonArray();
            for (Ingredient aspect : this.recipe.aspects) {
                aspectJson.add(aspect.m_43942_());
            }
            json.add("aspects", (JsonElement)aspectJson);
            JsonArray inputJson = new JsonArray();
            for (Ingredient input : this.recipe.inputs) {
                inputJson.add(input.m_43942_());
            }
            json.add("inputs", (JsonElement)inputJson);
        }

        public ResourceLocation m_6445_() {
            return this.recipe.m_6423_();
        }

        public RecipeSerializer<?> m_6637_() {
            if (this.recipe instanceof AlchemyRecipeForBabies) {
                return (RecipeSerializer)RegistryManager.ALCHEMY_FOR_BABIES_SERIALIZER.get();
            }
            return (RecipeSerializer)RegistryManager.ALCHEMY_SERIALIZER.get();
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

