/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.rekindled.embers.RegistryManager;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class VaporParticleOptions
implements ParticleOptions {
    public static final float MIN_SCALE = 0.01f;
    public static final float MAX_SCALE = 4.0f;
    protected final Vector3f color;
    protected final Vec3 motion;
    protected final float scale;
    public static final Vector3f VAPOR_COLOR = new Vector3f(0.2509804f, 0.2509804f, 0.2509804f);
    public static final VaporParticleOptions VAPOR = new VaporParticleOptions(VAPOR_COLOR, 1.0f);
    public static final Codec<VaporParticleOptions> CODEC = RecordCodecBuilder.create(p_175793_ -> p_175793_.group((App)ExtraCodecs.f_252432_.fieldOf("color").forGetter(p_175797_ -> p_175797_.color), (App)Vec3.f_231074_.fieldOf("motion").forGetter(p_175797_ -> p_175797_.motion), (App)Codec.FLOAT.fieldOf("scale").forGetter(p_175795_ -> Float.valueOf(p_175795_.scale))).apply((Applicative)p_175793_, VaporParticleOptions::new));
    public static final ParticleOptions.Deserializer<VaporParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<VaporParticleOptions>(){

        public VaporParticleOptions fromCommand(ParticleType<VaporParticleOptions> p_123689_, StringReader p_123690_) throws CommandSyntaxException {
            Vector3f vector3fColor = VaporParticleOptions.readVector3f(p_123690_);
            p_123690_.expect(' ');
            Vec3 vector3fMotion = VaporParticleOptions.readVec3(p_123690_);
            p_123690_.expect(' ');
            float f = p_123690_.readFloat();
            return new VaporParticleOptions(vector3fColor, vector3fMotion, f);
        }

        public VaporParticleOptions fromNetwork(ParticleType<VaporParticleOptions> p_123692_, FriendlyByteBuf p_123693_) {
            return new VaporParticleOptions(VaporParticleOptions.readVector3f(p_123693_), VaporParticleOptions.readVec3(p_123693_), p_123693_.readFloat());
        }
    };

    public VaporParticleOptions(Vector3f pColor, Vec3 pMotion, float pScale) {
        this.color = pColor;
        this.motion = pMotion;
        this.scale = pScale;
    }

    public VaporParticleOptions(Vector3f pColor, float pScale) {
        this(pColor, Vec3.f_82478_, pScale);
    }

    public static Vector3f readVector3f(StringReader pStringInput) throws CommandSyntaxException {
        pStringInput.expect(' ');
        float f = pStringInput.readFloat();
        pStringInput.expect(' ');
        float f1 = pStringInput.readFloat();
        pStringInput.expect(' ');
        float f2 = pStringInput.readFloat();
        return new Vector3f(f, f1, f2);
    }

    public static Vec3 readVec3(StringReader pStringInput) throws CommandSyntaxException {
        pStringInput.expect(' ');
        double f = pStringInput.readDouble();
        pStringInput.expect(' ');
        double f1 = pStringInput.readDouble();
        pStringInput.expect(' ');
        double f2 = pStringInput.readDouble();
        return new Vec3(f, f1, f2);
    }

    public static Vector3f readVector3f(FriendlyByteBuf pBuffer) {
        return new Vector3f(pBuffer.readFloat(), pBuffer.readFloat(), pBuffer.readFloat());
    }

    public static Vec3 readVec3(FriendlyByteBuf pBuffer) {
        return new Vec3(pBuffer.readDouble(), pBuffer.readDouble(), pBuffer.readDouble());
    }

    public void m_7711_(FriendlyByteBuf pBuffer) {
        pBuffer.writeFloat(this.color.x());
        pBuffer.writeFloat(this.color.y());
        pBuffer.writeFloat(this.color.z());
        pBuffer.writeDouble(this.motion.m_7096_());
        pBuffer.writeDouble(this.motion.m_7098_());
        pBuffer.writeDouble(this.motion.m_7094_());
        pBuffer.writeFloat(this.scale);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %.2f %.2f", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.color.x()), Float.valueOf(this.color.y()), Float.valueOf(this.color.z()), this.motion.m_7096_(), this.motion.m_7098_(), this.motion.m_7094_(), Float.valueOf(this.scale));
    }

    public Vector3f getColor() {
        return this.color;
    }

    public Vec3 getMotion() {
        return this.motion;
    }

    public float getScale() {
        return this.scale;
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)RegistryManager.VAPOR_PARTICLE.get();
    }
}

