/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.network.message;

import com.rekindled.embers.research.ResearchManager;
import com.rekindled.embers.research.capability.IResearchCapability;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class MessageResearchTick {
    public static final int NAME_MAX_LENGTH = 64;
    public String research;
    public boolean ticked;

    public MessageResearchTick(String research, boolean ticked) {
        this.research = research;
        this.ticked = ticked;
    }

    public static void encode(MessageResearchTick msg, FriendlyByteBuf buf) {
        buf.m_130072_(msg.research, 64);
        buf.writeBoolean(msg.ticked);
    }

    public static MessageResearchTick decode(FriendlyByteBuf buf) {
        return new MessageResearchTick(buf.m_130136_(64), buf.readBoolean());
    }

    public static void handle(MessageResearchTick msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isServer()) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                IResearchCapability research = ResearchManager.getPlayerResearch((Player)player);
                if (research != null) {
                    research.setCheckmark(msg.research, msg.ticked);
                    ResearchManager.sendResearchData(player);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

