/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.item;

import com.rekindled.embers.compat.curios.CuriosCompat;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.item.IEmbersCurioItem;
import com.rekindled.embers.particle.GlowParticleOptions;
import com.rekindled.embers.particle.SmokeParticleOptions;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ExplosionCharmItem
extends Item
implements IEmbersCurioItem {
    public static final int COOLDOWN = 100;
    public static final int MERCY_TIME = 5;
    public static String ITEM_COOLDOWN_KEY = "embers:cooldown_time";

    public ExplosionCharmItem(Item.Properties properties) {
        super(properties);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static boolean hasItemCooledDown(ItemStack stack, long time, int cooldown) {
        CompoundTag nbt;
        if (stack.m_41782_() && (nbt = stack.m_41783_()).m_128441_(ITEM_COOLDOWN_KEY)) {
            return nbt.m_128454_(ITEM_COOLDOWN_KEY) + (long)cooldown < time;
        }
        return true;
    }

    public static boolean hasItemMercy(ItemStack stack, long time, int mercy) {
        CompoundTag nbt;
        if (stack.m_41782_() && (nbt = stack.m_41783_()).m_128441_(ITEM_COOLDOWN_KEY)) {
            return nbt.m_128454_(ITEM_COOLDOWN_KEY) + (long)mercy > time;
        }
        return true;
    }

    public static ItemStack setItemCooldown(ItemStack stack, long time) {
        stack.m_41784_().m_128356_(ITEM_COOLDOWN_KEY, time);
        return stack;
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Start event) {
        if (event.isCanceled()) {
            return;
        }
        Explosion explosion = event.getExplosion();
        float f3 = 4.0f;
        Vec3 explosionPos = explosion.getPosition();
        int k1 = Mth.m_14107_((double)(explosionPos.f_82479_ - (double)f3 - 1.0));
        int l1 = Mth.m_14107_((double)(explosionPos.f_82479_ + (double)f3 + 1.0));
        int i2 = Mth.m_14107_((double)(explosionPos.f_82480_ - (double)f3 - 1.0));
        int i1 = Mth.m_14107_((double)(explosionPos.f_82480_ + (double)f3 + 1.0));
        int j2 = Mth.m_14107_((double)(explosionPos.f_82481_ - (double)f3 - 1.0));
        int j1 = Mth.m_14107_((double)(explosionPos.f_82481_ + (double)f3 + 1.0));
        List entities = event.getLevel().m_6249_((Entity)null, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1), EntitySelector.f_20408_);
        for (Entity entity : entities) {
            if (event.isCanceled()) {
                return;
            }
            if (!(entity instanceof LivingEntity)) continue;
            CuriosCompat.checkForCurios((LivingEntity)entity, stack -> {
                if (stack.m_41720_() == this) {
                    long time = event.getLevel().m_46467_();
                    if (ExplosionCharmItem.hasItemCooledDown(stack, time, 100) || ExplosionCharmItem.hasItemMercy(stack, time, 5)) {
                        event.getLevel().m_6263_(null, explosionPos.f_82479_, explosionPos.f_82480_, explosionPos.f_82481_, (SoundEvent)EmbersSounds.EXPLOSION_CHARM_ABSORB.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        Level patt3297$temp = event.getLevel();
                        if (patt3297$temp instanceof ServerLevel) {
                            ServerLevel server = (ServerLevel)patt3297$temp;
                            server.m_8767_((ParticleOptions)GlowParticleOptions.EMBER, explosionPos.f_82479_, explosionPos.f_82480_, explosionPos.f_82481_, 3, 0.0, 0.0, 0.0, 0.1);
                            server.m_8767_((ParticleOptions)SmokeParticleOptions.BIG_SMOKE, explosionPos.f_82479_, explosionPos.f_82480_, explosionPos.f_82481_, 20, 0.25, 0.25, 0.25, 1.0);
                        }
                        event.setCanceled(true);
                        if (ExplosionCharmItem.hasItemCooledDown(stack, time, 100)) {
                            event.getLevel().m_6263_(null, explosionPos.f_82479_, explosionPos.f_82480_, explosionPos.f_82481_, (SoundEvent)EmbersSounds.EXPLOSION_CHARM_RECHARGE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                            ExplosionCharmItem.setItemCooldown(stack, time);
                        }
                    }
                    return true;
                }
                return false;
            });
        }
    }
}

