/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.fluidtypes;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.rekindled.embers.fluidtypes.EmbersFluidType;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import org.joml.Vector3f;

public class ViscousFluidType
extends EmbersFluidType {
    public ViscousFluidType(FluidType.Properties properties, EmbersFluidType.FluidInfo info) {
        super(properties, info);
    }

    public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
        double d8 = entity.m_20186_();
        boolean flag = entity.m_20184_().f_82480_ <= 0.0;
        entity.m_19920_(0.02f, movementVector);
        entity.m_6478_(MoverType.SELF, entity.m_20184_());
        if (entity.getFluidTypeHeight((FluidType)this) <= entity.m_20204_()) {
            entity.m_20256_(entity.m_20184_().m_82542_(0.5, (double)0.8f, 0.5));
            Vec3 vec33 = entity.m_20994_(gravity, flag, entity.m_20184_());
            entity.m_20256_(vec33);
        } else {
            entity.m_20256_(entity.m_20184_().m_82490_(0.5));
        }
        if (!entity.m_20068_()) {
            entity.m_20256_(entity.m_20184_().m_82520_(0.0, -gravity / 4.0, 0.0));
        }
        Vec3 vec34 = entity.m_20184_();
        if (entity.f_19862_ && entity.m_20229_(vec34.f_82479_, vec34.f_82480_ + (double)0.6f - entity.m_20186_() + d8, vec34.f_82481_)) {
            entity.m_20334_(vec34.f_82479_, (double)0.3f, vec34.f_82481_);
        }
        return true;
    }

    @Override
    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return ViscousFluidType.this.TEXTURE_STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return ViscousFluidType.this.TEXTURE_FLOW;
            }

            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return ViscousFluidType.this.FOG_COLOR;
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                RenderSystem.setShaderFogStart((float)ViscousFluidType.this.fogStart);
                RenderSystem.setShaderFogEnd((float)ViscousFluidType.this.fogEnd);
            }
        });
    }

    public void setItemMovement(ItemEntity entity) {
        Vec3 vec3 = entity.m_20184_();
        entity.m_20334_(vec3.f_82479_ * (double)0.95f, vec3.f_82480_ + (double)(vec3.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), vec3.f_82481_ * (double)0.95f);
    }
}

