/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.datagen;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.network.PacketHandler;
import com.rekindled.embers.network.message.MessageItemSound;
import com.rekindled.embers.util.MultiblockSoundType;
import com.rekindled.embers.util.sound.ItemUseSound;
import com.rekindled.embers.util.sound.MachineSound;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.SoundDefinition;
import net.minecraftforge.common.data.SoundDefinitionsProvider;
import net.minecraftforge.common.util.ForgeSoundType;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.RegistryObject;

public class EmbersSounds
extends SoundDefinitionsProvider {
    public static final RegistryObject<SoundEvent> ALCHEMY_FAIL = EmbersSounds.registerSound("block.alchemy.fail");
    public static final RegistryObject<SoundEvent> ALCHEMY_SUCCESS = EmbersSounds.registerSound("block.alchemy.success");
    public static final RegistryObject<SoundEvent> ALCHEMY_LOOP = EmbersSounds.registerSound("block.alchemy.loop");
    public static final RegistryObject<SoundEvent> ALCHEMY_START = EmbersSounds.registerSound("block.alchemy.start");
    public static final RegistryObject<SoundEvent> PEDESTAL_LOOP = EmbersSounds.registerSound("block.pedestal.loop");
    public static final RegistryObject<SoundEvent> BEAM_CANNON_FIRE = EmbersSounds.registerSound("block.beam_cannon.fire");
    public static final RegistryObject<SoundEvent> BEAM_CANNON_HIT = EmbersSounds.registerSound("block.beam_cannon.hit");
    public static final RegistryObject<SoundEvent> CRYSTAL_CELL_LOOP = EmbersSounds.registerSound("block.crystal_cell.loop");
    public static final RegistryObject<SoundEvent> CRYSTAL_CELL_GROW = EmbersSounds.registerSound("block.crystal_cell.grow");
    public static final RegistryObject<SoundEvent> GENERATOR_LOOP = EmbersSounds.registerSound("block.generator.loop");
    public static final RegistryObject<SoundEvent> ACTIVATOR = EmbersSounds.registerSound("block.activator.plume");
    public static final RegistryObject<SoundEvent> PRESSURE_REFINERY = EmbersSounds.registerSound("block.boiler.plume");
    public static final RegistryObject<SoundEvent> IGNEM_REACTOR = EmbersSounds.registerSound("block.ignem_reactor.plume");
    public static final RegistryObject<SoundEvent> BORE_START = EmbersSounds.registerSound("block.bore.start");
    public static final RegistryObject<SoundEvent> BORE_STOP = EmbersSounds.registerSound("block.bore.stop");
    public static final RegistryObject<SoundEvent> BORE_LOOP = EmbersSounds.registerSound("block.bore.loop");
    public static final RegistryObject<SoundEvent> BORE_LOOP_MINE = EmbersSounds.registerSound("block.bore.loop_mine");
    public static final RegistryObject<SoundEvent> BORE_LOOP_SUPERSPEED = EmbersSounds.registerSound("block.bore.loop.superspeed");
    public static final RegistryObject<SoundEvent> BORE_LOOP_MINE_SUPERSPEED = EmbersSounds.registerSound("block.bore.loop_mine.superspeed");
    public static final RegistryObject<SoundEvent> CATALYTIC_PLUG_START = EmbersSounds.registerSound("block.catalytic_plug.start");
    public static final RegistryObject<SoundEvent> CATALYTIC_PLUG_STOP = EmbersSounds.registerSound("block.catalytic_plug.stop");
    public static final RegistryObject<SoundEvent> CATALYTIC_PLUG_LOOP = EmbersSounds.registerSound("block.catalytic_plug.loop");
    public static final RegistryObject<SoundEvent> CATALYTIC_PLUG_LOOP_READY = EmbersSounds.registerSound("block.catalytic_plug.loop_ready");
    public static final RegistryObject<SoundEvent> WILDFIRE_STIRLING_START = EmbersSounds.registerSound("block.wildfire_stirling.start");
    public static final RegistryObject<SoundEvent> WILDFIRE_STIRLING_STOP = EmbersSounds.registerSound("block.wildfire_stirling.stop");
    public static final RegistryObject<SoundEvent> WILDFIRE_STIRLING_LOOP = EmbersSounds.registerSound("block.wildfire_stirling.loop");
    public static final RegistryObject<SoundEvent> WILDFIRE_STIRLING_LOOP_READY = EmbersSounds.registerSound("block.wildfire_stirling.loop_ready");
    public static final RegistryObject<SoundEvent> STAMPER_DOWN = EmbersSounds.registerSound("block.stamper.down");
    public static final RegistryObject<SoundEvent> STAMPER_UP = EmbersSounds.registerSound("block.stamper.up");
    public static final RegistryObject<SoundEvent> HEATCOIL_HIGH = EmbersSounds.registerSound("block.heat_coil.high_loop");
    public static final RegistryObject<SoundEvent> HEATCOIL_MID = EmbersSounds.registerSound("block.heat_coil.mid_loop");
    public static final RegistryObject<SoundEvent> HEATCOIL_LOW = EmbersSounds.registerSound("block.heat_coil.low_loop");
    public static final RegistryObject<SoundEvent> HEATCOIL_COOK = EmbersSounds.registerSound("block.heat_coil.cooking_loop");
    public static final RegistryObject<SoundEvent> PLINTH_LOOP = EmbersSounds.registerSound("block.melter.loopblock.plinth.loop");
    public static final RegistryObject<SoundEvent> MELTER_LOOP = EmbersSounds.registerSound("block.melter.loop");
    public static final RegistryObject<SoundEvent> MIXER_LOOP = EmbersSounds.registerSound("block.mixer.loop");
    public static final RegistryObject<SoundEvent> COPPER_CHARGER_LOOP = EmbersSounds.registerSound("block.copper_charger.loop");
    public static final RegistryObject<SoundEvent> COPPER_CHARGER_SIPHON_LOOP = EmbersSounds.registerSound("block.copper_charger_siphon.loop");
    public static final RegistryObject<SoundEvent> INJECTOR_LOOP = EmbersSounds.registerSound("block.injector.loop");
    public static final RegistryObject<SoundEvent> METAL_SEED_LOOP = EmbersSounds.registerSound("block.metal_seed.loop");
    public static final RegistryObject<SoundEvent> METAL_SEED_PING = EmbersSounds.registerSound("block.metal_seed.ping");
    public static final RegistryObject<SoundEvent> INFERNO_FORGE_FAIL = EmbersSounds.registerSound("block.inferno_forge.fail");
    public static final RegistryObject<SoundEvent> INFERNO_FORGE_SUCCESS = EmbersSounds.registerSound("block.inferno_forge.success");
    public static final RegistryObject<SoundEvent> INFERNO_FORGE_LOOP = EmbersSounds.registerSound("block.inferno_forge.loop");
    public static final RegistryObject<SoundEvent> INFERNO_FORGE_START = EmbersSounds.registerSound("block.inferno_forge.start");
    public static final RegistryObject<SoundEvent> INFERNO_FORGE_OPEN = EmbersSounds.registerSound("block.inferno_forge.open");
    public static final RegistryObject<SoundEvent> INFERNO_FORGE_CLOSE = EmbersSounds.registerSound("block.inferno_forge.close");
    public static final RegistryObject<SoundEvent> FIELD_CHART_LOOP = EmbersSounds.registerSound("block.field_chart.loop");
    public static final RegistryObject<SoundEvent> ENTROPIC_ENUMERATOR_TURN = EmbersSounds.registerSound("block.entropic_enumerator.turn");
    public static final RegistryObject<SoundEvent> EMBER_EMIT = EmbersSounds.registerSound("block.ember_transfer.emit.small");
    public static final RegistryObject<SoundEvent> EMBER_EMIT_BIG = EmbersSounds.registerSound("block.ember_transfer.emit.big");
    public static final RegistryObject<SoundEvent> EMBER_RECEIVE = EmbersSounds.registerSound("block.ember_transfer.receive.small");
    public static final RegistryObject<SoundEvent> EMBER_RECEIVE_BIG = EmbersSounds.registerSound("block.ember_transfer.receive.big");
    public static final RegistryObject<SoundEvent> EMBER_RELAY = EmbersSounds.registerSound("block.ember_transfer.relay");
    public static final RegistryObject<SoundEvent> STEAM_ENGINE_START_STEAM = EmbersSounds.registerSound("block.steam_engine.start_steam");
    public static final RegistryObject<SoundEvent> STEAM_ENGINE_START_BURN = EmbersSounds.registerSound("block.steam_engine.start_burn");
    public static final RegistryObject<SoundEvent> STEAM_ENGINE_LOOP_STEAM = EmbersSounds.registerSound("block.steam_engine.steam_loop");
    public static final RegistryObject<SoundEvent> STEAM_ENGINE_LOOP_BURN = EmbersSounds.registerSound("block.steam_engine.burn_loop");
    public static final RegistryObject<SoundEvent> STEAM_ENGINE_STOP = EmbersSounds.registerSound("block.steam_engine.stop");
    public static final RegistryObject<SoundEvent> MINI_BOILER_RUPTURE = EmbersSounds.registerSound("block.mini_boiler.rupture");
    public static final RegistryObject<SoundEvent> MINI_BOILER_LOOP_SLOW = EmbersSounds.registerSound("block.mini_boiler.loop_slow");
    public static final RegistryObject<SoundEvent> MINI_BOILER_LOOP_MID = EmbersSounds.registerSound("block.mini_boiler.loop_mid");
    public static final RegistryObject<SoundEvent> MINI_BOILER_LOOP_FAST = EmbersSounds.registerSound("block.mini_boiler.loop_fast");
    public static final RegistryObject<SoundEvent> MINI_BOILER_PRESSURE_LOW = EmbersSounds.registerSound("block.mini_boiler.pressure_loop_low");
    public static final RegistryObject<SoundEvent> MINI_BOILER_PRESSURE_MID = EmbersSounds.registerSound("block.mini_boiler.pressure_loop_mid");
    public static final RegistryObject<SoundEvent> MINI_BOILER_PRESSURE_HIGH = EmbersSounds.registerSound("block.mini_boiler.pressure_loop_high");
    public static final RegistryObject<SoundEvent> PUMP_SLOW = EmbersSounds.registerSound("block.pump.slow");
    public static final RegistryObject<SoundEvent> PUMP_MID = EmbersSounds.registerSound("block.pump.mid");
    public static final RegistryObject<SoundEvent> PUMP_FAST = EmbersSounds.registerSound("block.pump.fast");
    public static final RegistryObject<SoundEvent> PIPE_CONNECT = EmbersSounds.registerSound("block.pipe.connect");
    public static final RegistryObject<SoundEvent> PIPE_DISCONNECT = EmbersSounds.registerSound("block.pipe.disconnect");
    public static final RegistryObject<SoundEvent> PIPE_VENT_LOOP = EmbersSounds.registerSound("block.pipe.vent");
    public static final RegistryObject<SoundEvent> FIREBALL_BIG = EmbersSounds.registerSound("fireball.big.fire");
    public static final RegistryObject<SoundEvent> FIREBALL_BIG_HIT = EmbersSounds.registerSound("fireball.big.hit");
    public static final RegistryObject<SoundEvent> FIREBALL = EmbersSounds.registerSound("fireball.small.fire");
    public static final RegistryObject<SoundEvent> FIREBALL_HIT = EmbersSounds.registerSound("fireball.small.hit");
    public static final RegistryObject<SoundEvent> BLAZING_RAY_FIRE = EmbersSounds.registerSound("item.blazing_ray.fire");
    public static final RegistryObject<SoundEvent> BLAZING_RAY_EMPTY = EmbersSounds.registerSound("item.blazing_ray.empty");
    public static final RegistryObject<SoundEvent> CINDER_STAFF_CHARGE = EmbersSounds.registerSound("item.cinder_staff.charge");
    public static final RegistryObject<SoundEvent> CINDER_STAFF_FAIL = EmbersSounds.registerSound("item.cinder_staff.fail");
    public static final RegistryObject<SoundEvent> CINDER_STAFF_LOOP = EmbersSounds.registerSound("item.cinder_staff.loop");
    public static final RegistryObject<SoundEvent> ULTRASYD_7F_PATTERNS = EmbersSounds.registerSound("music_disc.7f_patterns");
    public static final RegistryObject<SoundEvent> EXPLOSION_CHARM_ABSORB = EmbersSounds.registerSound("item.explosion_charm.absorb");
    public static final RegistryObject<SoundEvent> EXPLOSION_CHARM_RECHARGE = EmbersSounds.registerSound("item.explosion_charm.recharge");
    public static final RegistryObject<SoundEvent> ASHEN_AMULET_BURN = EmbersSounds.registerSound("item.ash_amulet.burn");
    public static final RegistryObject<SoundEvent> HEATED_ITEM_LEVELUP = EmbersSounds.registerSound("item.heated.level_up");
    public static final RegistryObject<SoundEvent> RESONATING_BELL = EmbersSounds.registerSound("item.resonating_bell.ring");
    public static final RegistryObject<SoundEvent> CINDER_JET = EmbersSounds.registerSound("item.cinder_jet.boost");
    public static final RegistryObject<SoundEvent> INFLICTOR_GEM = EmbersSounds.registerSound("item.inflictor_gem.absorb");
    public static final RegistryObject<SoundEvent> METALLURGIC_DUST = EmbersSounds.registerSound("item.metallurgic_dust.convert");
    public static final RegistryObject<SoundEvent> METALLURGIC_DUST_FAIL = EmbersSounds.registerSound("item.metallurgic_dust.fail");
    public static final RegistryObject<SoundEvent> CODEX_OPEN = EmbersSounds.registerSound("item.codex.open");
    public static final RegistryObject<SoundEvent> CODEX_CLOSE = EmbersSounds.registerSound("item.codex.close");
    public static final RegistryObject<SoundEvent> CODEX_CATEGORY_OPEN = EmbersSounds.registerSound("item.codex.category.open");
    public static final RegistryObject<SoundEvent> CODEX_CATEGORY_CLOSE = EmbersSounds.registerSound("item.codex.category.close");
    public static final RegistryObject<SoundEvent> CODEX_CATEGORY_SELECT = EmbersSounds.registerSound("item.codex.category.select");
    public static final RegistryObject<SoundEvent> CODEX_CATEGORY_UNSELECT = EmbersSounds.registerSound("item.codex.category.unselect");
    public static final RegistryObject<SoundEvent> CODEX_CATEGORY_SWITCH = EmbersSounds.registerSound("item.codex.category.switch");
    public static final RegistryObject<SoundEvent> CODEX_PAGE_OPEN = EmbersSounds.registerSound("item.codex.page.open");
    public static final RegistryObject<SoundEvent> CODEX_PAGE_CLOSE = EmbersSounds.registerSound("item.codex.page.close");
    public static final RegistryObject<SoundEvent> CODEX_PAGE_SWITCH = EmbersSounds.registerSound("item.codex.page.switch");
    public static final RegistryObject<SoundEvent> CODEX_CHECK = EmbersSounds.registerSound("item.codex.check");
    public static final RegistryObject<SoundEvent> CODEX_UNCHECK = EmbersSounds.registerSound("item.codex.uncheck");
    public static final RegistryObject<SoundEvent> CODEX_LOCK = EmbersSounds.registerSound("item.codex.lock");
    public static final RegistryObject<SoundEvent> CODEX_UNLOCK = EmbersSounds.registerSound("item.codex.unlock");
    public static final RegistryObject<SoundEvent> BAUBLE_EQUIP = EmbersSounds.registerSound("item.bauble.equip");
    public static final RegistryObject<SoundEvent> BAUBLE_UNEQUIP = EmbersSounds.registerSound("item.bauble.unequip");
    public static final RegistryObject<SoundEvent> TYRFING_HIT = EmbersSounds.registerSound("item.tyrfing.hit");
    public static final RegistryObject<SoundEvent> SHIFTING_SCALES_BREAK = EmbersSounds.registerSound("item.scale.break");
    public static final RegistryObject<SoundEvent> WINDING_GEARS_SPRING = EmbersSounds.registerSound("item.windup.spring");
    public static final RegistryObject<SoundEvent> ANCIENT_GOLEM_STEP = EmbersSounds.registerSound("entity.ancient_golem.step");
    public static final RegistryObject<SoundEvent> ANCIENT_GOLEM_HURT = EmbersSounds.registerSound("entity.ancient_golem.hurt");
    public static final RegistryObject<SoundEvent> ANCIENT_GOLEM_PUNCH = EmbersSounds.registerSound("entity.ancient_golem.punch");
    public static final RegistryObject<SoundEvent> ANCIENT_GOLEM_DEATH = EmbersSounds.registerSound("entity.ancient_golem.death");
    public static final RegistryObject<SoundEvent> MULTIBLOCK_PACK = EmbersSounds.registerSound("block.multiblock.pack");
    public static final RegistryObject<SoundEvent> MULTIBLOCK_UNPACK = EmbersSounds.registerSound("block.multiblock.unpack");
    public static final RegistryObject<SoundEvent> CAMINITE_BREAK = EmbersSounds.registerSound("block.caminite.break");
    public static final RegistryObject<SoundEvent> CAMINITE_STEP = EmbersSounds.registerSound("block.caminite.step");
    public static final RegistryObject<SoundEvent> CAMINITE_PLACE = EmbersSounds.registerSound("block.caminite.place");
    public static final RegistryObject<SoundEvent> CAMINITE_HIT = EmbersSounds.registerSound("block.caminite.hit");
    public static final RegistryObject<SoundEvent> CAMINITE_FALL = EmbersSounds.registerSound("block.caminite.fall");
    public static final RegistryObject<SoundEvent> ASHEN_STONE_BREAK = EmbersSounds.registerSound("block.ashen_stone.break");
    public static final RegistryObject<SoundEvent> ASHEN_STONE_STEP = EmbersSounds.registerSound("block.ashen_stone.step");
    public static final RegistryObject<SoundEvent> ASHEN_STONE_PLACE = EmbersSounds.registerSound("block.ashen_stone.place");
    public static final RegistryObject<SoundEvent> ASHEN_STONE_HIT = EmbersSounds.registerSound("block.ashen_stone.hit");
    public static final RegistryObject<SoundEvent> ASHEN_STONE_FALL = EmbersSounds.registerSound("block.ashen_stone.fall");
    public static final RegistryObject<SoundEvent> SOLID_METAL_BREAK = EmbersSounds.registerSound("block.solid_metal.break");
    public static final RegistryObject<SoundEvent> SOLID_METAL_PLACE = EmbersSounds.registerSound("block.solid_metal.place");
    public static final RegistryObject<SoundEvent> MACHINE_BREAK = EmbersSounds.registerSound("block.machine.break");
    public static final RegistryObject<SoundEvent> MACHINE_PLACE = EmbersSounds.registerSound("block.machine.place");
    public static final SoundType CAMINITE = new ForgeSoundType(1.0f, 1.0f, CAMINITE_BREAK, CAMINITE_STEP, CAMINITE_PLACE, CAMINITE_HIT, CAMINITE_FALL);
    public static final SoundType ASHEN_STONE = new ForgeSoundType(1.0f, 1.0f, ASHEN_STONE_BREAK, ASHEN_STONE_STEP, ASHEN_STONE_PLACE, ASHEN_STONE_HIT, ASHEN_STONE_FALL);
    public static final SoundType LIGHT_METAL = new ForgeSoundType(1.0f, 1.5f, () -> SoundEvents.f_12198_, () -> SoundEvents.f_12199_, () -> SoundEvents.f_12200_, () -> SoundEvents.f_12201_, () -> SoundEvents.f_12202_);
    public static final SoundType SOLID_METAL = new ForgeSoundType(1.0f, 1.0f, SOLID_METAL_BREAK, () -> SoundEvents.f_12199_, SOLID_METAL_PLACE, () -> SoundEvents.f_12201_, () -> SoundEvents.f_12202_);
    public static final SoundType MACHINE = new ForgeSoundType(1.0f, 1.0f, MACHINE_BREAK, () -> SoundEvents.f_12199_, MACHINE_PLACE, () -> SoundEvents.f_12201_, () -> SoundEvents.f_12202_);
    public static final SoundType LIGHT_MACHINE = new ForgeSoundType(1.0f, 1.5f, MACHINE_BREAK, () -> SoundEvents.f_12199_, MACHINE_PLACE, () -> SoundEvents.f_12201_, () -> SoundEvents.f_12202_);
    public static final SoundType MULTIBLOCK_CENTER = new ForgeSoundType(1.0f, 1.0f, MULTIBLOCK_PACK, () -> SoundEvents.f_12199_, MULTIBLOCK_UNPACK, () -> SoundEvents.f_12201_, () -> SoundEvents.f_12202_);
    public static final SoundType CAMINITE_MULTIBLOCK_CENTER = new ForgeSoundType(1.0f, 1.0f, MULTIBLOCK_PACK, CAMINITE_STEP, MULTIBLOCK_UNPACK, () -> SoundEvents.f_12201_, () -> SoundEvents.f_12202_);
    public static final SoundType ARCHAIC_MULTIBLOCK_CENTER = new ForgeSoundType(1.0f, 1.0f, MULTIBLOCK_PACK, () -> SoundEvents.f_12161_, MULTIBLOCK_UNPACK, () -> SoundEvents.f_12163_, () -> SoundEvents.f_12164_);
    public static final SoundType MULTIBLOCK_EXTRA = new MultiblockSoundType(SoundType.f_56725_);
    public static final SoundType CAMINITE_MULTIBLOCK_EXTRA = new MultiblockSoundType(CAMINITE);
    public static final SoundType ARCHAIC_MULTIBLOCK_EXTRA = new MultiblockSoundType(SoundType.f_56721_);

    public static void init() {
    }

    public EmbersSounds(PackOutput generator, ExistingFileHelper helper) {
        super(generator, "embers", helper);
    }

    public static RegistryObject<SoundEvent> registerSound(String name) {
        return RegistryManager.SOUND_EVENTS.register(name, () -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("embers", name)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playMachineSound(BlockEntity tile, int id, SoundEvent soundIn, SoundSource categoryIn, boolean repeat, float volume, float pitch, float xIn, float yIn, float zIn) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new MachineSound(tile, id, soundIn, categoryIn, repeat, volume, pitch, xIn, yIn, zIn));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playItemSoundClient(LivingEntity entity, Item item, SoundEvent soundIn, SoundSource categoryIn, boolean repeat, float volume, float pitch) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new ItemUseSound(entity, item, soundIn, categoryIn, repeat, volume, pitch));
    }

    public static void playItemSound(LivingEntity entity, Item item, SoundEvent soundIn, SoundSource categoryIn, boolean repeat, float volume, float pitch) {
        PacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new MessageItemSound((Entity)entity, item, soundIn, categoryIn, repeat, volume, pitch));
    }

    public void registerSounds() {
        this.withSubtitle(ALCHEMY_FAIL, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("alchemy_tablet/fail"))));
        this.withSubtitle(ALCHEMY_SUCCESS, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("alchemy_tablet/success"))));
        this.add((Supplier)ALCHEMY_LOOP, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("alchemy_tablet/loop"))));
        this.withSubtitle(ALCHEMY_START, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("alchemy_tablet/start"))));
        this.add((Supplier)PEDESTAL_LOOP, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("pedestal_loop"))));
        this.withSubtitle(BEAM_CANNON_FIRE, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("beam_cannon/fire"))));
        this.withSubtitle(BEAM_CANNON_HIT, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("beam_cannon/hit1")), EmbersSounds.sound((ResourceLocation)this.resource("beam_cannon/hit2"))}));
        this.add((Supplier)CRYSTAL_CELL_LOOP, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("crystal_cell/loop"))));
        this.withSubtitle(CRYSTAL_CELL_GROW, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("crystal_cell/zap1")), EmbersSounds.sound((ResourceLocation)this.resource("crystal_cell/zap2")), EmbersSounds.sound((ResourceLocation)this.resource("crystal_cell/zap3")), EmbersSounds.sound((ResourceLocation)this.resource("crystal_cell/zap4"))}));
        this.add((Supplier)GENERATOR_LOOP, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("generator_hold_embers"))));
        this.withSubtitle(ACTIVATOR, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("activator/plume1")), EmbersSounds.sound((ResourceLocation)this.resource("activator/plume2"))}));
        this.withSubtitle(PRESSURE_REFINERY, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("boiler/plume1")), EmbersSounds.sound((ResourceLocation)this.resource("boiler/plume2"))}));
        this.withSubtitle(IGNEM_REACTOR, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("ignem_reactor/plume1")), EmbersSounds.sound((ResourceLocation)this.resource("ignem_reactor/plume2"))}));
        this.withSubtitle(BORE_START, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("ember_bore/start"))));
        this.withSubtitle(BORE_STOP, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("ember_bore/stop"))));
        this.add((Supplier)BORE_LOOP, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("ember_bore/run_loop"))));
        this.add((Supplier)BORE_LOOP_MINE, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("ember_bore/mine_loop"))));
        this.add((Supplier)BORE_LOOP_SUPERSPEED, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("ember_bore/superspeed_run_loop"))));
        this.add((Supplier)BORE_LOOP_MINE_SUPERSPEED, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("ember_bore/superspeed_mine_loop"))));
        this.withSubtitle(CATALYTIC_PLUG_START, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("catalytic_plug/start"))));
        this.withSubtitle(CATALYTIC_PLUG_STOP, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("catalytic_plug/stop"))));
        this.add((Supplier)CATALYTIC_PLUG_LOOP, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("catalytic_plug/run_loop"))));
        this.add((Supplier)CATALYTIC_PLUG_LOOP_READY, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("catalytic_plug/ready_loop"))));
        this.withSubtitle(WILDFIRE_STIRLING_START, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("wildfire_stirling/start"))));
        this.withSubtitle(WILDFIRE_STIRLING_STOP, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("wildfire_stirling/stop"))));
        this.add((Supplier)WILDFIRE_STIRLING_LOOP, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("wildfire_stirling/run_loop"))));
        this.add((Supplier)WILDFIRE_STIRLING_LOOP_READY, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("wildfire_stirling/ready_loop"))));
        this.withSubtitle(STAMPER_DOWN, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("stamper/down1")), EmbersSounds.sound((ResourceLocation)this.resource("stamper/down2")), EmbersSounds.sound((ResourceLocation)this.resource("stamper/down3"))}));
        this.withSubtitle(STAMPER_UP, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("stamper/up1")), EmbersSounds.sound((ResourceLocation)this.resource("stamper/up2")), EmbersSounds.sound((ResourceLocation)this.resource("stamper/up3"))}));
        this.add((Supplier)HEATCOIL_HIGH, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("heat_coil/high_loop"))));
        this.add((Supplier)HEATCOIL_MID, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("heat_coil/mid_loop"))));
        this.add((Supplier)HEATCOIL_LOW, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("heat_coil/low_loop"))));
        this.add((Supplier)HEATCOIL_COOK, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("heat_coil/cooking_loop"))));
        this.add((Supplier)PLINTH_LOOP, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("cinder_plinth_loop"))));
        this.add((Supplier)MELTER_LOOP, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("melter_loop"))));
        this.add((Supplier)MIXER_LOOP, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("mixer_loop"))));
        this.add((Supplier)COPPER_CHARGER_LOOP, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("copper_charger_loop"))));
        this.add((Supplier)COPPER_CHARGER_SIPHON_LOOP, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("charger_siphon_loop"))));
        this.add((Supplier)INJECTOR_LOOP, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("injector_loop"))));
        this.add((Supplier)METAL_SEED_LOOP, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("metal_seed/loop"))));
        this.withSubtitle(METAL_SEED_PING, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("metal_seed/ping1")), EmbersSounds.sound((ResourceLocation)this.resource("metal_seed/ping2")), EmbersSounds.sound((ResourceLocation)this.resource("metal_seed/ping3"))}));
        this.withSubtitle(INFERNO_FORGE_FAIL, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("inferno_forge/fail"))));
        this.withSubtitle(INFERNO_FORGE_SUCCESS, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("inferno_forge/success"))));
        this.add((Supplier)INFERNO_FORGE_LOOP, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("inferno_forge/loop"))));
        this.withSubtitle(INFERNO_FORGE_START, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("inferno_forge/start"))));
        this.withSubtitle(INFERNO_FORGE_OPEN, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("inferno_forge/open"))));
        this.withSubtitle(INFERNO_FORGE_CLOSE, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("inferno_forge/close"))));
        this.add((Supplier)FIELD_CHART_LOOP, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("field_chart_loop"))));
        this.withSubtitle(ENTROPIC_ENUMERATOR_TURN, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("entropic_enumerator/turn1")), EmbersSounds.sound((ResourceLocation)this.resource("entropic_enumerator/turn2")), EmbersSounds.sound((ResourceLocation)this.resource("entropic_enumerator/turn3")), EmbersSounds.sound((ResourceLocation)this.resource("entropic_enumerator/turn4")), EmbersSounds.sound((ResourceLocation)this.resource("entropic_enumerator/turn5")), EmbersSounds.sound((ResourceLocation)this.resource("entropic_enumerator/turn6")), EmbersSounds.sound((ResourceLocation)this.resource("entropic_enumerator/turn7"))}));
        this.withSubtitle(EMBER_EMIT, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("ember_transmission/emit1")), EmbersSounds.sound((ResourceLocation)this.resource("ember_transmission/emit2")), EmbersSounds.sound((ResourceLocation)this.resource("ember_transmission/emit3")), EmbersSounds.sound((ResourceLocation)this.resource("ember_transmission/emit4"))}));
        this.withSubtitle(EMBER_EMIT_BIG, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("ember_transmission/emit_big1")), EmbersSounds.sound((ResourceLocation)this.resource("ember_transmission/emit_big2")), EmbersSounds.sound((ResourceLocation)this.resource("ember_transmission/emit_big3")), EmbersSounds.sound((ResourceLocation)this.resource("ember_transmission/emit_big4"))}));
        this.withSubtitle(EMBER_RECEIVE, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("ember_transmission/recep1")), EmbersSounds.sound((ResourceLocation)this.resource("ember_transmission/recep2")), EmbersSounds.sound((ResourceLocation)this.resource("ember_transmission/recep3")), EmbersSounds.sound((ResourceLocation)this.resource("ember_transmission/recep4"))}));
        this.withSubtitle(EMBER_RECEIVE_BIG, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("ember_transmission/recep_big1")), EmbersSounds.sound((ResourceLocation)this.resource("ember_transmission/recep_big2")), EmbersSounds.sound((ResourceLocation)this.resource("ember_transmission/recep_big3")), EmbersSounds.sound((ResourceLocation)this.resource("ember_transmission/recep_big4"))}));
        this.withSubtitle(EMBER_RELAY, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("ember_transmission/relay1")), EmbersSounds.sound((ResourceLocation)this.resource("ember_transmission/relay2")), EmbersSounds.sound((ResourceLocation)this.resource("ember_transmission/relay3")), EmbersSounds.sound((ResourceLocation)this.resource("ember_transmission/relay4"))}));
        this.withSubtitle(STEAM_ENGINE_START_STEAM, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("steam_engine/start_steam"))));
        this.withSubtitle(STEAM_ENGINE_START_BURN, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("steam_engine/start_burn"))));
        this.add((Supplier)STEAM_ENGINE_LOOP_STEAM, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("steam_engine/steam_loop"))));
        this.add((Supplier)STEAM_ENGINE_LOOP_BURN, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("steam_engine/burn_loop"))));
        this.withSubtitle(STEAM_ENGINE_STOP, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("steam_engine/stop"))));
        this.withSubtitle(MINI_BOILER_RUPTURE, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("mini_boiler/rupture"))));
        this.add((Supplier)MINI_BOILER_LOOP_SLOW, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("mini_boiler/slow_loop"))));
        this.add((Supplier)MINI_BOILER_LOOP_MID, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("mini_boiler/mid_loop"))));
        this.add((Supplier)MINI_BOILER_LOOP_FAST, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("mini_boiler/fast_loop"))));
        this.add((Supplier)MINI_BOILER_PRESSURE_LOW, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("mini_boiler/pressure_loop1"))));
        this.add((Supplier)MINI_BOILER_PRESSURE_MID, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("mini_boiler/pressure_loop2"))));
        this.add((Supplier)MINI_BOILER_PRESSURE_HIGH, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("mini_boiler/pressure_loop3"))));
        this.withSubtitle(PUMP_SLOW, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("pump/slow"))));
        this.withSubtitle(PUMP_MID, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("pump/mid1")), EmbersSounds.sound((ResourceLocation)this.resource("pump/mid2")), EmbersSounds.sound((ResourceLocation)this.resource("pump/mid3"))}));
        this.withSubtitle(PUMP_FAST, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("pump/fast1")), EmbersSounds.sound((ResourceLocation)this.resource("pump/fast2")), EmbersSounds.sound((ResourceLocation)this.resource("pump/fast3"))}));
        this.withSubtitle(PIPE_CONNECT, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("pipe_connect1")), EmbersSounds.sound((ResourceLocation)this.resource("pipe_connect2"))}));
        this.withSubtitle(PIPE_DISCONNECT, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("pipe_disconnect1")), EmbersSounds.sound((ResourceLocation)this.resource("pipe_disconnect2"))}));
        this.add((Supplier)PIPE_VENT_LOOP, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("pipe_vent"))));
        this.withSubtitle(FIREBALL_BIG, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("fireball_big_launch1")), EmbersSounds.sound((ResourceLocation)this.resource("fireball_big_launch2"))}));
        this.withSubtitle(FIREBALL_BIG_HIT, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("fireball_big_hit1")), EmbersSounds.sound((ResourceLocation)this.resource("fireball_big_hit2"))}));
        this.withSubtitle(FIREBALL, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("fireball_small_launch1")), EmbersSounds.sound((ResourceLocation)this.resource("fireball_small_launch2"))}));
        this.withSubtitle(FIREBALL_HIT, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("fireball_small_hit1")), EmbersSounds.sound((ResourceLocation)this.resource("fireball_small_hit2"))}));
        this.withSubtitle(BLAZING_RAY_FIRE, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("ignition_cannon/fire1")), EmbersSounds.sound((ResourceLocation)this.resource("ignition_cannon/fire2"))}));
        this.withSubtitle(BLAZING_RAY_EMPTY, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("ignition_cannon/empty"))));
        this.withSubtitle(CINDER_STAFF_CHARGE, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("cinder_staff/charge"))));
        this.withSubtitle(CINDER_STAFF_FAIL, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("cinder_staff/fail"))));
        this.add((Supplier)CINDER_STAFF_LOOP, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("cinder_staff/loop"))));
        this.add((Supplier)ULTRASYD_7F_PATTERNS, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("7f_patterns")).stream()));
        this.withSubtitle(EXPLOSION_CHARM_ABSORB, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("explosion_charm/absorb1")), EmbersSounds.sound((ResourceLocation)this.resource("explosion_charm/absorb2"))}));
        this.add((Supplier)EXPLOSION_CHARM_RECHARGE, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("explosion_charm/recharge"))));
        this.withSubtitle(ASHEN_AMULET_BURN, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("ash_amulet/burn1")), EmbersSounds.sound((ResourceLocation)this.resource("ash_amulet/burn2"))}));
        this.withSubtitle(HEATED_ITEM_LEVELUP, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("heated_tool_level"))));
        this.withSubtitle(RESONATING_BELL, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("resonating_bell1")), EmbersSounds.sound((ResourceLocation)this.resource("resonating_bell2"))}));
        this.withSubtitle(CINDER_JET, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("cinder_jet1")), EmbersSounds.sound((ResourceLocation)this.resource("cinder_jet2"))}));
        this.withSubtitle(INFLICTOR_GEM, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("inflictor_gem_absorb"))));
        this.withSubtitle(METALLURGIC_DUST, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("metallurgic_dust/convert1")), EmbersSounds.sound((ResourceLocation)this.resource("metallurgic_dust/convert2"))}));
        this.withSubtitle(METALLURGIC_DUST_FAIL, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("metallurgic_dust/fail1")), EmbersSounds.sound((ResourceLocation)this.resource("metallurgic_dust/fail2"))}));
        this.add((Supplier)CODEX_OPEN, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("ancient_codex/open"))));
        this.add((Supplier)CODEX_CLOSE, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("ancient_codex/close"))));
        this.add((Supplier)CODEX_CATEGORY_OPEN, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("ancient_codex/category_open"))));
        this.add((Supplier)CODEX_CATEGORY_CLOSE, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("ancient_codex/category_close"))));
        this.add((Supplier)CODEX_CATEGORY_SELECT, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("ancient_codex/category_scrape_up1")), EmbersSounds.sound((ResourceLocation)this.resource("ancient_codex/category_scrape_up2")), EmbersSounds.sound((ResourceLocation)this.resource("ancient_codex/category_scrape_up3"))}));
        this.add((Supplier)CODEX_CATEGORY_UNSELECT, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("ancient_codex/category_scrape_down1")), EmbersSounds.sound((ResourceLocation)this.resource("ancient_codex/category_scrape_down2")), EmbersSounds.sound((ResourceLocation)this.resource("ancient_codex/category_scrape_down3"))}));
        this.add((Supplier)CODEX_CATEGORY_SWITCH, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("ancient_codex/flip1")), EmbersSounds.sound((ResourceLocation)this.resource("ancient_codex/flip2"))}));
        this.add((Supplier)CODEX_PAGE_OPEN, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("ancient_codex/page_open"))));
        this.add((Supplier)CODEX_PAGE_CLOSE, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("ancient_codex/page_close"))));
        this.add((Supplier)CODEX_PAGE_SWITCH, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("ancient_codex/flip1")), EmbersSounds.sound((ResourceLocation)this.resource("ancient_codex/flip2"))}));
        this.add((Supplier)CODEX_CHECK, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("ancient_codex/check"))));
        this.add((Supplier)CODEX_UNCHECK, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("ancient_codex/uncheck"))));
        this.add((Supplier)CODEX_LOCK, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("ancient_codex/lock"))));
        this.add((Supplier)CODEX_UNLOCK, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("ancient_codex/unlock"))));
        this.add((Supplier)BAUBLE_EQUIP, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("bauble_equip"))));
        this.add((Supplier)BAUBLE_UNEQUIP, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("bauble_unequip"))));
        this.add((Supplier)TYRFING_HIT, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("tyrfing_hit1")), EmbersSounds.sound((ResourceLocation)this.resource("tyrfing_hit2"))}));
        this.add((Supplier)SHIFTING_SCALES_BREAK, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("scale_heart_break1")), EmbersSounds.sound((ResourceLocation)this.resource("scale_heart_break2")), EmbersSounds.sound((ResourceLocation)this.resource("scale_heart_break3")), EmbersSounds.sound((ResourceLocation)this.resource("scale_heart_break4"))}));
        this.add((Supplier)WINDING_GEARS_SPRING, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("spring_launch1")), EmbersSounds.sound((ResourceLocation)this.resource("spring_launch2"))}));
        this.withSubtitle(ANCIENT_GOLEM_STEP, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("agolem/step1")), EmbersSounds.sound((ResourceLocation)this.resource("agolem/step2")), EmbersSounds.sound((ResourceLocation)this.resource("agolem/step3")), EmbersSounds.sound((ResourceLocation)this.resource("agolem/step4"))}));
        this.withSubtitle(ANCIENT_GOLEM_HURT, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("agolem/hit1")), EmbersSounds.sound((ResourceLocation)this.resource("agolem/hit2")), EmbersSounds.sound((ResourceLocation)this.resource("agolem/hit3")), EmbersSounds.sound((ResourceLocation)this.resource("agolem/hit4"))}));
        this.withSubtitle(ANCIENT_GOLEM_PUNCH, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("agolem/punch1")), EmbersSounds.sound((ResourceLocation)this.resource("agolem/punch2")), EmbersSounds.sound((ResourceLocation)this.resource("agolem/punch3")), EmbersSounds.sound((ResourceLocation)this.resource("agolem/punch4"))}));
        this.withSubtitle(ANCIENT_GOLEM_DEATH, EmbersSounds.definition().with(EmbersSounds.sound((ResourceLocation)this.resource("agolem/die"))));
        this.add((Supplier)MULTIBLOCK_PACK, EmbersSounds.definition().subtitle("subtitles.block.generic.break").with(EmbersSounds.sound((ResourceLocation)this.resource("multiblock_pack"))));
        this.add((Supplier)MULTIBLOCK_UNPACK, EmbersSounds.definition().subtitle("subtitles.block.generic.place").with(EmbersSounds.sound((ResourceLocation)this.resource("multiblock_unpack"))));
        this.add((Supplier)CAMINITE_BREAK, EmbersSounds.definition().subtitle("subtitles.block.generic.break").with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("block/caminite/break1")), EmbersSounds.sound((ResourceLocation)this.resource("block/caminite/break2")), EmbersSounds.sound((ResourceLocation)this.resource("block/caminite/break3")), EmbersSounds.sound((ResourceLocation)this.resource("block/caminite/break4"))}));
        this.add((Supplier)CAMINITE_STEP, EmbersSounds.definition().subtitle("subtitles.block.generic.footsteps").with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("block/caminite/step1")), EmbersSounds.sound((ResourceLocation)this.resource("block/caminite/step2")), EmbersSounds.sound((ResourceLocation)this.resource("block/caminite/step3")), EmbersSounds.sound((ResourceLocation)this.resource("block/caminite/step4"))}));
        this.add((Supplier)CAMINITE_PLACE, EmbersSounds.definition().subtitle("subtitles.block.generic.place").with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("block/caminite/break1")), EmbersSounds.sound((ResourceLocation)this.resource("block/caminite/break2")), EmbersSounds.sound((ResourceLocation)this.resource("block/caminite/break3")), EmbersSounds.sound((ResourceLocation)this.resource("block/caminite/break4"))}));
        this.add((Supplier)CAMINITE_HIT, EmbersSounds.definition().subtitle("subtitles.block.generic.hit").with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("block/caminite/step1")), EmbersSounds.sound((ResourceLocation)this.resource("block/caminite/step2")), EmbersSounds.sound((ResourceLocation)this.resource("block/caminite/step3")), EmbersSounds.sound((ResourceLocation)this.resource("block/caminite/step4"))}));
        this.add((Supplier)CAMINITE_FALL, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("block/caminite/step1")), EmbersSounds.sound((ResourceLocation)this.resource("block/caminite/step2")), EmbersSounds.sound((ResourceLocation)this.resource("block/caminite/step3")), EmbersSounds.sound((ResourceLocation)this.resource("block/caminite/step4"))}));
        this.add((Supplier)ASHEN_STONE_BREAK, EmbersSounds.definition().subtitle("subtitles.block.generic.break").with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("block/ashen_stone/break1")), EmbersSounds.sound((ResourceLocation)this.resource("block/ashen_stone/break2")), EmbersSounds.sound((ResourceLocation)this.resource("block/ashen_stone/break3")), EmbersSounds.sound((ResourceLocation)this.resource("block/ashen_stone/break4"))}));
        this.add((Supplier)ASHEN_STONE_STEP, EmbersSounds.definition().subtitle("subtitles.block.generic.footsteps").with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("block/ashen_stone/step1")), EmbersSounds.sound((ResourceLocation)this.resource("block/ashen_stone/step2")), EmbersSounds.sound((ResourceLocation)this.resource("block/ashen_stone/step3")), EmbersSounds.sound((ResourceLocation)this.resource("block/ashen_stone/step4"))}));
        this.add((Supplier)ASHEN_STONE_PLACE, EmbersSounds.definition().subtitle("subtitles.block.generic.place").with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("block/ashen_stone/break1")), EmbersSounds.sound((ResourceLocation)this.resource("block/ashen_stone/break2")), EmbersSounds.sound((ResourceLocation)this.resource("block/ashen_stone/break3")), EmbersSounds.sound((ResourceLocation)this.resource("block/ashen_stone/break4"))}));
        this.add((Supplier)ASHEN_STONE_HIT, EmbersSounds.definition().subtitle("subtitles.block.generic.hit").with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("block/ashen_stone/step1")), EmbersSounds.sound((ResourceLocation)this.resource("block/ashen_stone/step2")), EmbersSounds.sound((ResourceLocation)this.resource("block/ashen_stone/step3")), EmbersSounds.sound((ResourceLocation)this.resource("block/ashen_stone/step4"))}));
        this.add((Supplier)ASHEN_STONE_FALL, EmbersSounds.definition().with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("block/ashen_stone/step1")), EmbersSounds.sound((ResourceLocation)this.resource("block/ashen_stone/step2")), EmbersSounds.sound((ResourceLocation)this.resource("block/ashen_stone/step3")), EmbersSounds.sound((ResourceLocation)this.resource("block/ashen_stone/step4"))}));
        this.add((Supplier)SOLID_METAL_BREAK, EmbersSounds.definition().subtitle("subtitles.block.generic.break").with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("block/solid_metal/break1")), EmbersSounds.sound((ResourceLocation)this.resource("block/solid_metal/break2")), EmbersSounds.sound((ResourceLocation)this.resource("block/solid_metal/break3")), EmbersSounds.sound((ResourceLocation)this.resource("block/solid_metal/break4"))}));
        this.add((Supplier)SOLID_METAL_PLACE, EmbersSounds.definition().subtitle("subtitles.block.generic.place").with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("block/solid_metal/break1")), EmbersSounds.sound((ResourceLocation)this.resource("block/solid_metal/break2")), EmbersSounds.sound((ResourceLocation)this.resource("block/solid_metal/break3")), EmbersSounds.sound((ResourceLocation)this.resource("block/solid_metal/break4"))}));
        this.add((Supplier)MACHINE_BREAK, EmbersSounds.definition().subtitle("subtitles.block.generic.break").with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("block/machine/break1")), EmbersSounds.sound((ResourceLocation)this.resource("block/machine/break2")), EmbersSounds.sound((ResourceLocation)this.resource("block/machine/break3")), EmbersSounds.sound((ResourceLocation)this.resource("block/machine/break4"))}));
        this.add((Supplier)MACHINE_PLACE, EmbersSounds.definition().subtitle("subtitles.block.generic.place").with(new SoundDefinition.Sound[]{EmbersSounds.sound((ResourceLocation)this.resource("block/machine/break1")), EmbersSounds.sound((ResourceLocation)this.resource("block/machine/break2")), EmbersSounds.sound((ResourceLocation)this.resource("block/machine/break3")), EmbersSounds.sound((ResourceLocation)this.resource("block/machine/break4"))}));
    }

    public void withSubtitle(RegistryObject<SoundEvent> soundEvent, SoundDefinition definition) {
        this.add((Supplier)soundEvent, definition.subtitle("subtitles.embers." + soundEvent.getId().m_135815_()));
    }

    public ResourceLocation resource(String path) {
        return new ResourceLocation("embers", path);
    }
}

