/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.datagen;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.block.ChamberBlockBase;
import com.rekindled.embers.block.EmberEmitterBlock;
import com.rekindled.embers.block.FieldChartBlock;
import com.rekindled.embers.block.ItemTransferBlock;
import com.rekindled.embers.block.MechEdgeBlockBase;
import com.rekindled.embers.block.MnemonicInscriberBlock;
import com.rekindled.embers.compat.curios.CuriosCompat;
import com.rekindled.embers.render.PipeModelBuilder;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.loaders.CompositeModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class EmbersBlockStates
extends BlockStateProvider {
    public EmbersBlockStates(PackOutput gen, ExistingFileHelper exFileHelper) {
        super(gen, "embers", exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (RegistryManager.FluidStuff fluid : RegistryManager.fluidList) {
            this.fluid(fluid.FLUID_BLOCK, fluid.name);
        }
        this.blockWithItemTexture(RegistryManager.LEAD_ORE, "ore_lead");
        this.blockWithItemTexture(RegistryManager.DEEPSLATE_LEAD_ORE, "deepslate_ore_lead");
        this.blockWithItemTexture(RegistryManager.RAW_LEAD_BLOCK, "material_lead");
        this.blockWithItemTexture(RegistryManager.LEAD_BLOCK, "block_lead");
        this.blockWithItemTexture(RegistryManager.SILVER_ORE, "ore_silver");
        this.blockWithItemTexture(RegistryManager.DEEPSLATE_SILVER_ORE, "deepslate_ore_silver");
        this.blockWithItemTexture(RegistryManager.RAW_SILVER_BLOCK, "material_silver");
        this.blockWithItemTexture(RegistryManager.SILVER_BLOCK, "block_silver");
        this.blockWithItemTexture(RegistryManager.DAWNSTONE_BLOCK, "block_dawnstone");
        this.blockWithItem(RegistryManager.MITHRIL_BLOCK, "mithril_block");
        this.blockWithItem(RegistryManager.CAMINITE_BRICKS);
        this.decoBlocks(RegistryManager.CAMINITE_BRICKS_DECO);
        this.blockWithItem(RegistryManager.CAMINITE_LARGE_BRICKS);
        this.decoBlocks(RegistryManager.CAMINITE_LARGE_BRICKS_DECO);
        this.blockWithItem(RegistryManager.RAW_CAMINITE_BLOCK);
        this.blockWithItem(RegistryManager.CAMINITE_LARGE_TILE);
        this.decoBlocks(RegistryManager.CAMINITE_LARGE_TILE_DECO);
        this.blockWithItem(RegistryManager.CAMINITE_TILES);
        this.decoBlocks(RegistryManager.CAMINITE_TILES_DECO);
        this.blockWithItem(RegistryManager.ARCHAIC_BRICKS);
        this.decoBlocks(RegistryManager.ARCHAIC_BRICKS_DECO);
        this.blockWithItem(RegistryManager.ARCHAIC_EDGE, "archaic_edge");
        this.blockWithItem(RegistryManager.ARCHAIC_TILE);
        this.decoBlocks(RegistryManager.ARCHAIC_TILE_DECO);
        this.blockWithItem(RegistryManager.ARCHAIC_LARGE_BRICKS);
        this.decoBlocks(RegistryManager.ARCHAIC_LARGE_BRICKS_DECO);
        this.blockWithItem(RegistryManager.ARCHAIC_LIGHT, "archaic_light");
        this.blockWithItem(RegistryManager.ASHEN_STONE);
        this.decoBlocks(RegistryManager.ASHEN_STONE_DECO);
        this.blockWithItem(RegistryManager.ASHEN_BRICK);
        this.decoBlocks(RegistryManager.ASHEN_BRICK_DECO);
        this.blockWithItem(RegistryManager.ASHEN_TILE);
        this.decoBlocks(RegistryManager.ASHEN_TILE_DECO);
        this.blockWithItem(RegistryManager.SEALED_PLANKS);
        this.decoBlocks(RegistryManager.SEALED_PLANKS_DECO);
        this.blockWithItem(RegistryManager.REINFORCED_SEALED_PLANKS);
        this.blockWithItem(RegistryManager.SEALED_WOOD_TILE);
        this.decoBlocks(RegistryManager.SEALED_WOOD_TILE_DECO);
        this.pillarBlockWithItem(RegistryManager.SEALED_WOOD_PILLAR, "sealed_planks", "sealed_keg_top");
        this.pillarBlockWithItem(RegistryManager.SEALED_WOOD_KEG, "reinforced_sealed_planks", "sealed_keg_top");
        this.blockWithItem(RegistryManager.SOLIDIFIED_METAL);
        this.columnBlockWithItem(RegistryManager.METAL_PLATFORM, "metal_platform_side", "metal_platform");
        this.slabBlock((SlabBlock)RegistryManager.METAL_PLATFORM_DECO.slab.get(), new ResourceLocation("embers", "metal_platform"), new ResourceLocation("embers", "block/metal_platform_side"), new ResourceLocation("embers", "block/metal_platform"), new ResourceLocation("embers", "block/metal_platform"));
        this.simpleBlockItem((Block)RegistryManager.METAL_PLATFORM_DECO.slab.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("embers", "metal_platform_slab")));
        this.blockWithItem(RegistryManager.EMBER_LANTERN, "ember_lantern");
        this.blockWithItem(RegistryManager.COPPER_CELL, "copper_cell");
        this.blockWithItem(RegistryManager.CREATIVE_EMBER);
        this.dial(RegistryManager.EMBER_DIAL, "ember_dial");
        this.dial(RegistryManager.ITEM_DIAL, "item_dial");
        this.dial(RegistryManager.FLUID_DIAL, "fluid_dial");
        this.dial(RegistryManager.ATMOSPHERIC_GAUGE, "atmospheric_gauge");
        this.dial(RegistryManager.CLOCKWORK_ATTENUATOR, "clockwork_attenuator");
        ModelBuilder fluidPipeCenterModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("fluid_pipe_center", new ResourceLocation("embers", "pipe_center"))).texture("pipe", new ResourceLocation("embers", "block/fluid_pipe_tex"))).texture("particle", new ResourceLocation("embers", "block/fluid_pipe_tex"));
        ModelBuilder fluidPipeEndModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("fluid_pipe_end", new ResourceLocation("embers", "pipe_end"))).texture("pipe", new ResourceLocation("embers", "block/fluid_pipe_tex"))).texture("particle", new ResourceLocation("embers", "block/fluid_pipe_tex"));
        ModelBuilder fluidPipeConnectionModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("fluid_pipe_connection", new ResourceLocation("embers", "pipe_connection"))).texture("pipe", new ResourceLocation("embers", "block/fluid_pipe_tex"))).texture("particle", new ResourceLocation("embers", "block/fluid_pipe_tex"));
        ModelBuilder fluidPipeEndModel2 = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("fluid_pipe_end_2", new ResourceLocation("embers", "pipe_end_2"))).texture("pipe", new ResourceLocation("embers", "block/fluid_pipe_tex"))).texture("particle", new ResourceLocation("embers", "block/fluid_pipe_tex"));
        ModelBuilder fluidPipeConnectionModel2 = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("fluid_pipe_connection_2", new ResourceLocation("embers", "pipe_connection_2"))).texture("pipe", new ResourceLocation("embers", "block/fluid_pipe_tex"))).texture("particle", new ResourceLocation("embers", "block/fluid_pipe_tex"));
        ModelFile.ExistingModelFile emitterModel = this.models().getExistingFile(new ResourceLocation("embers", "ember_emitter"));
        this.simpleBlockItem((Block)RegistryManager.EMBER_EMITTER.get(), (ModelFile)emitterModel);
        MultiPartBlockStateBuilder emitterBuilder = ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)RegistryManager.EMBER_EMITTER.get()).part().modelFile((ModelFile)emitterModel).addModel()).condition((Property)BlockStateProperties.f_61372_, (Comparable[])new Direction[]{Direction.UP}).end().part().modelFile((ModelFile)emitterModel).rotationX(180).addModel()).condition((Property)BlockStateProperties.f_61372_, (Comparable[])new Direction[]{Direction.DOWN}).end().part().modelFile((ModelFile)emitterModel).rotationX(90).addModel()).condition((Property)BlockStateProperties.f_61372_, (Comparable[])new Direction[]{Direction.NORTH}).end().part().modelFile((ModelFile)emitterModel).rotationX(90).rotationY(180).addModel()).condition((Property)BlockStateProperties.f_61372_, (Comparable[])new Direction[]{Direction.SOUTH}).end().part().modelFile((ModelFile)emitterModel).rotationX(90).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61372_, (Comparable[])new Direction[]{Direction.EAST}).end().part().modelFile((ModelFile)emitterModel).rotationX(90).rotationY(270).addModel()).condition((Property)BlockStateProperties.f_61372_, (Comparable[])new Direction[]{Direction.WEST}).end();
        EmbersBlockStates.addEmitterConnections(emitterBuilder, (ModelFile)fluidPipeEndModel, (ModelFile)fluidPipeEndModel2);
        ModelFile.ExistingModelFile receiverModel = this.models().getExistingFile(new ResourceLocation("embers", "ember_receiver"));
        this.directionalBlock((Block)RegistryManager.EMBER_RECEIVER.get(), (ModelFile)receiverModel);
        this.simpleBlockItem((Block)RegistryManager.EMBER_RECEIVER.get(), (ModelFile)receiverModel);
        ModelFile.ExistingModelFile leverModel = this.models().getExistingFile(new ResourceLocation("embers", "caminite_lever"));
        this.leverBlock((Block)RegistryManager.CAMINITE_LEVER.get(), (ModelFile)leverModel, (ModelFile)this.models().getExistingFile(new ResourceLocation("embers", "caminite_lever_on")));
        this.simpleBlockItem((Block)RegistryManager.CAMINITE_LEVER.get(), (ModelFile)leverModel);
        this.buttonBlock((ButtonBlock)RegistryManager.CAMINITE_BUTTON.get(), new ResourceLocation("embers", "block/caminite_button"));
        ModelBuilder itemPipeCenterModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("item_pipe_center", new ResourceLocation("embers", "pipe_center"))).texture("pipe", new ResourceLocation("embers", "block/item_pipe_tex"))).texture("particle", new ResourceLocation("embers", "block/item_pipe_tex"));
        ModelBuilder itemPipeEndModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("item_pipe_end", new ResourceLocation("embers", "pipe_end"))).texture("pipe", new ResourceLocation("embers", "block/item_pipe_tex"))).texture("particle", new ResourceLocation("embers", "block/item_pipe_tex"));
        ModelBuilder itemPipeConnectionModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("item_pipe_connection", new ResourceLocation("embers", "pipe_connection"))).texture("pipe", new ResourceLocation("embers", "block/item_pipe_tex"))).texture("particle", new ResourceLocation("embers", "block/item_pipe_tex"));
        ModelBuilder itemPipeEndModel2 = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("item_pipe_end_2", new ResourceLocation("embers", "pipe_end_2"))).texture("pipe", new ResourceLocation("embers", "block/item_pipe_tex"))).texture("particle", new ResourceLocation("embers", "block/item_pipe_tex"));
        ModelBuilder itemPipeConnectionModel2 = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("item_pipe_connection_2", new ResourceLocation("embers", "pipe_connection_2"))).texture("pipe", new ResourceLocation("embers", "block/item_pipe_tex"))).texture("particle", new ResourceLocation("embers", "block/item_pipe_tex"));
        this.simpleBlockItem((Block)RegistryManager.ITEM_PIPE.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("item_pipe_inventory", new ResourceLocation("embers", "pipe_inventory"))).texture("pipe", new ResourceLocation("embers", "block/item_pipe_tex")));
        ModelBuilder itemPipeModel = ((PipeModelBuilder)((BlockModelBuilder)this.models().withExistingParent("item_pipe", "block")).customLoader(PipeModelBuilder::begin)).parts((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)itemPipeCenterModel), (BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)itemPipeConnectionModel), (BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)itemPipeConnectionModel2), (BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)itemPipeEndModel), (BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)itemPipeEndModel2)).end();
        this.simpleBlock((Block)RegistryManager.ITEM_PIPE.get(), (ModelFile)itemPipeModel);
        ModelBuilder itemExtractorCenterModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("item_extractor_center", new ResourceLocation("embers", "extractor_center"))).texture("pipe", new ResourceLocation("embers", "block/item_pipe_tex"))).texture("particle", new ResourceLocation("embers", "block/item_pipe_tex"));
        ModelBuilder itemExtractorModel = ((PipeModelBuilder)((BlockModelBuilder)this.models().withExistingParent("item_extractor", "block")).customLoader(PipeModelBuilder::begin)).parts((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)itemExtractorCenterModel), (BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)itemPipeConnectionModel), (BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)itemPipeConnectionModel2), (BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)itemPipeEndModel), (BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)itemPipeEndModel2)).end();
        this.simpleBlockItem((Block)RegistryManager.ITEM_EXTRACTOR.get(), (ModelFile)itemExtractorCenterModel);
        this.simpleBlock((Block)RegistryManager.ITEM_EXTRACTOR.get(), (ModelFile)itemExtractorModel);
        ModelFile.ExistingModelFile emberBoreModel = this.models().getExistingFile(new ResourceLocation("embers", "ember_bore_center"));
        this.getVariantBuilder((Block)RegistryManager.EMBER_BORE.get()).forAllStates(state -> {
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61364_);
            return ConfiguredModel.builder().modelFile((ModelFile)emberBoreModel).rotationY(axis == Direction.Axis.Z ? 90 : 0).uvLock(false).build();
        });
        this.simpleBlockItem((Block)RegistryManager.EMBER_BORE.get(), (ModelFile)this.models().cubeAll("ember_bore", new ResourceLocation("embers", "block/crate_bore")));
        ModelFile.ExistingModelFile mechEdgeModel = this.models().getExistingFile(new ResourceLocation("embers", "mech_edge_straight"));
        ModelFile.ExistingModelFile boreEdgeModel = this.models().getExistingFile(new ResourceLocation("embers", "ember_bore_edge"));
        ModelFile.ExistingModelFile mechCornerModel = this.models().getExistingFile(new ResourceLocation("embers", "mech_edge_corner"));
        this.getVariantBuilder((Block)RegistryManager.EMBER_BORE_EDGE.get()).forAllStates(state -> {
            MechEdgeBlockBase.MechEdge edge = (MechEdgeBlockBase.MechEdge)((Object)((Object)state.m_61143_(MechEdgeBlockBase.EDGE)));
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61364_);
            return ConfiguredModel.builder().modelFile((ModelFile)(edge.corner ? mechCornerModel : ((edge == MechEdgeBlockBase.MechEdge.NORTH || edge == MechEdgeBlockBase.MechEdge.SOUTH) && axis == Direction.Axis.Z || (edge == MechEdgeBlockBase.MechEdge.EAST || edge == MechEdgeBlockBase.MechEdge.WEST) && axis == Direction.Axis.X ? mechEdgeModel : boreEdgeModel))).rotationY(edge.rotation).uvLock(true).build();
        });
        ModelFile.ExistingModelFile mechCoreModel = this.models().getExistingFile(new ResourceLocation("embers", "mech_core"));
        this.betterDirectionalBlock((Block)RegistryManager.MECHANICAL_CORE.get(), $ -> mechCoreModel, 0);
        this.simpleBlockItem((Block)RegistryManager.MECHANICAL_CORE.get(), (ModelFile)mechCoreModel);
        ModelFile.ExistingModelFile activatorTopModel = this.models().getExistingFile(new ResourceLocation("embers", "activator_top"));
        this.simpleBlockItem((Block)RegistryManager.EMBER_ACTIVATOR.get(), (ModelFile)activatorTopModel);
        this.getVariantBuilder((Block)RegistryManager.EMBER_ACTIVATOR.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)(state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER ? this.models().getExistingFile(new ResourceLocation("embers", "activator_bottom")) : activatorTopModel)).uvLock(false).build());
        ModelFile.ExistingModelFile melterBottomModel = this.models().getExistingFile(new ResourceLocation("embers", "melter_bottom"));
        this.simpleBlockItem((Block)RegistryManager.MELTER.get(), (ModelFile)melterBottomModel);
        this.getVariantBuilder((Block)RegistryManager.MELTER.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)(state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER ? melterBottomModel : this.models().getExistingFile(new ResourceLocation("embers", "melter_top")))).uvLock(false).build());
        this.simpleBlockItem((Block)RegistryManager.FLUID_PIPE.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("fluid_pipe_inventory", new ResourceLocation("embers", "pipe_inventory"))).texture("pipe", new ResourceLocation("embers", "block/fluid_pipe_tex")));
        ModelBuilder fluidPipeModel = ((PipeModelBuilder)((BlockModelBuilder)this.models().withExistingParent("fluid_pipe", "block")).customLoader(PipeModelBuilder::begin)).parts((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)fluidPipeCenterModel), (BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)fluidPipeConnectionModel), (BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)fluidPipeConnectionModel2), (BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)fluidPipeEndModel), (BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)fluidPipeEndModel2)).end();
        this.simpleBlock((Block)RegistryManager.FLUID_PIPE.get(), (ModelFile)fluidPipeModel);
        ModelBuilder fluidExtractorCenterModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("fluid_extractor_center", new ResourceLocation("embers", "extractor_center"))).texture("pipe", new ResourceLocation("embers", "block/fluid_pipe_tex"))).texture("particle", new ResourceLocation("embers", "block/fluid_pipe_tex"));
        ModelBuilder fluidExtractorModel = ((PipeModelBuilder)((BlockModelBuilder)this.models().withExistingParent("fluid_extractor", "block")).customLoader(PipeModelBuilder::begin)).parts((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)fluidExtractorCenterModel), (BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)fluidPipeConnectionModel), (BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)fluidPipeConnectionModel2), (BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)fluidPipeEndModel), (BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)fluidPipeEndModel2)).end();
        this.simpleBlockItem((Block)RegistryManager.FLUID_EXTRACTOR.get(), (ModelFile)fluidExtractorCenterModel);
        this.simpleBlock((Block)RegistryManager.FLUID_EXTRACTOR.get(), (ModelFile)fluidExtractorModel);
        this.blockWithItem(RegistryManager.FLUID_VESSEL, "fluid_vessel");
        ModelFile.ExistingModelFile stamperModel = this.models().getExistingFile(new ResourceLocation("embers", "stamper"));
        this.simpleBlock((Block)RegistryManager.STAMPER.get(), (ModelFile)stamperModel);
        this.simpleBlockItem((Block)RegistryManager.STAMPER.get(), (ModelFile)stamperModel);
        this.blockWithItem(RegistryManager.STAMP_BASE, "stamp_base");
        this.blockWithItem(RegistryManager.BIN, "bin");
        ModelFile.ExistingModelFile mixerBottomModel = this.models().getExistingFile(new ResourceLocation("embers", "mixer_bottom"));
        this.simpleBlockItem((Block)RegistryManager.MIXER_CENTRIFUGE.get(), (ModelFile)mixerBottomModel);
        this.getVariantBuilder((Block)RegistryManager.MIXER_CENTRIFUGE.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)(state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER ? mixerBottomModel : this.models().getExistingFile(new ResourceLocation("embers", "mixer_top")))).uvLock(false).build());
        ModelBuilder dropperModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(RegistryManager.ITEM_DROPPER.getId().toString(), new ResourceLocation("embers", "dropper"))).texture("dropper", new ResourceLocation("embers", "block/plates_lead"))).texture("particle", new ResourceLocation("embers", "block/plates_lead"));
        this.simpleBlock((Block)RegistryManager.ITEM_DROPPER.get(), (ModelFile)dropperModel);
        this.simpleBlockItem((Block)RegistryManager.ITEM_DROPPER.get(), (ModelFile)dropperModel);
        ModelFile.ExistingModelFile refineryBottomModel = this.models().getExistingFile(new ResourceLocation("embers", "refinery_bottom"));
        this.simpleBlockItem((Block)RegistryManager.PRESSURE_REFINERY.get(), (ModelFile)refineryBottomModel);
        this.getVariantBuilder((Block)RegistryManager.PRESSURE_REFINERY.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)(state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER ? refineryBottomModel : this.models().getExistingFile(new ResourceLocation("embers", "refinery_top")))).uvLock(false).build());
        ModelFile.ExistingModelFile ejectorModel = this.models().getExistingFile(new ResourceLocation("embers", "ember_ejector"));
        this.simpleBlockItem((Block)RegistryManager.EMBER_EJECTOR.get(), (ModelFile)ejectorModel);
        MultiPartBlockStateBuilder ejectorBuilder = ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)RegistryManager.EMBER_EJECTOR.get()).part().modelFile((ModelFile)ejectorModel).addModel()).condition((Property)BlockStateProperties.f_61372_, (Comparable[])new Direction[]{Direction.UP}).end().part().modelFile((ModelFile)ejectorModel).rotationX(180).addModel()).condition((Property)BlockStateProperties.f_61372_, (Comparable[])new Direction[]{Direction.DOWN}).end().part().modelFile((ModelFile)ejectorModel).rotationX(90).addModel()).condition((Property)BlockStateProperties.f_61372_, (Comparable[])new Direction[]{Direction.NORTH}).end().part().modelFile((ModelFile)ejectorModel).rotationX(90).rotationY(180).addModel()).condition((Property)BlockStateProperties.f_61372_, (Comparable[])new Direction[]{Direction.SOUTH}).end().part().modelFile((ModelFile)ejectorModel).rotationX(90).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61372_, (Comparable[])new Direction[]{Direction.EAST}).end().part().modelFile((ModelFile)ejectorModel).rotationX(90).rotationY(270).addModel()).condition((Property)BlockStateProperties.f_61372_, (Comparable[])new Direction[]{Direction.WEST}).end();
        EmbersBlockStates.addEmitterConnections(ejectorBuilder, (ModelFile)fluidPipeEndModel, (ModelFile)fluidPipeEndModel2);
        ModelFile.ExistingModelFile funnelModel = this.models().getExistingFile(new ResourceLocation("embers", "ember_funnel"));
        this.directionalBlock((Block)RegistryManager.EMBER_FUNNEL.get(), (ModelFile)funnelModel);
        this.simpleBlockItem((Block)RegistryManager.EMBER_FUNNEL.get(), (ModelFile)funnelModel);
        ModelFile.ExistingModelFile relayModel = this.models().getExistingFile(new ResourceLocation("embers", "ember_relay"));
        this.directionalBlock((Block)RegistryManager.EMBER_RELAY.get(), (ModelFile)relayModel);
        this.simpleBlockItem((Block)RegistryManager.EMBER_RELAY.get(), (ModelFile)relayModel);
        ModelFile.ExistingModelFile mirrorModel = this.models().getExistingFile(new ResourceLocation("embers", "mirror_relay"));
        this.directionalBlock((Block)RegistryManager.MIRROR_RELAY.get(), (ModelFile)mirrorModel);
        this.simpleBlockItem((Block)RegistryManager.MIRROR_RELAY.get(), (ModelFile)mirrorModel);
        ModelFile.ExistingModelFile splitterModelX = this.models().getExistingFile(new ResourceLocation("embers", "beam_splitter_x"));
        ModelFile.ExistingModelFile splitterModelZ = this.models().getExistingFile(new ResourceLocation("embers", "beam_splitter_z"));
        this.simpleBlockItem((Block)RegistryManager.BEAM_SPLITTER.get(), (ModelFile)splitterModelZ);
        this.getVariantBuilder((Block)RegistryManager.BEAM_SPLITTER.get()).forAllStates(state -> {
            Direction face = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
            return ConfiguredModel.builder().modelFile((ModelFile)(axis == Direction.Axis.X && face.m_122434_() == Direction.Axis.Y || axis != Direction.Axis.Y && face.m_122434_() != Direction.Axis.Y ? splitterModelX : splitterModelZ)).rotationX(face == Direction.DOWN ? 180 : (face == Direction.UP ? 0 : 90)).rotationY(face == Direction.SOUTH ? 180 : (face == Direction.WEST ? 270 : (face == Direction.EAST ? 90 : 0))).uvLock(false).build();
        });
        ModelFile.ExistingModelFile vacuumModel = this.models().getExistingFile(new ResourceLocation("embers", "item_vacuum"));
        this.directionalBlock((Block)RegistryManager.ITEM_VACUUM.get(), (ModelFile)vacuumModel);
        this.simpleBlockItem((Block)RegistryManager.ITEM_VACUUM.get(), (ModelFile)vacuumModel);
        this.simpleBlock((Block)RegistryManager.HEARTH_COIL.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("embers", "hearth_coil_center")));
        this.simpleBlockItem((Block)RegistryManager.HEARTH_COIL.get(), (ModelFile)this.models().cubeAll("hearth_coil", new ResourceLocation("embers", "block/crate_coil")));
        ModelFile.ExistingModelFile coilEdgeModelX = this.models().getExistingFile(new ResourceLocation("embers", "hearth_coil_edge_x"));
        ModelFile.ExistingModelFile coilEdgeModelZ = this.models().getExistingFile(new ResourceLocation("embers", "hearth_coil_edge_z"));
        ModelFile.ExistingModelFile coilCornerModel = this.models().getExistingFile(new ResourceLocation("embers", "hearth_coil_corner"));
        this.getVariantBuilder((Block)RegistryManager.HEARTH_COIL_EDGE.get()).forAllStates(state -> {
            MechEdgeBlockBase.MechEdge edge = (MechEdgeBlockBase.MechEdge)((Object)((Object)state.m_61143_(MechEdgeBlockBase.EDGE)));
            return ConfiguredModel.builder().modelFile((ModelFile)(edge.corner ? coilCornerModel : (edge == MechEdgeBlockBase.MechEdge.EAST || edge == MechEdgeBlockBase.MechEdge.WEST ? coilEdgeModelZ : coilEdgeModelX))).rotationY(edge.rotation).uvLock(true).build();
        });
        this.simpleBlock((Block)RegistryManager.RESERVOIR.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("embers", "reservoir_center")));
        this.simpleBlockItem((Block)RegistryManager.RESERVOIR.get(), (ModelFile)this.models().cubeAll("reservoir", new ResourceLocation("embers", "block/crate_tank")));
        this.getVariantBuilder((Block)RegistryManager.RESERVOIR_EDGE.get()).forAllStates(state -> {
            MechEdgeBlockBase.MechEdge edge = (MechEdgeBlockBase.MechEdge)((Object)((Object)state.m_61143_(MechEdgeBlockBase.EDGE)));
            return ConfiguredModel.builder().modelFile((ModelFile)(edge.corner ? mechCornerModel : mechEdgeModel)).rotationY(edge.rotation).uvLock(true).build();
        });
        this.simpleBlock((Block)RegistryManager.CAMINITE_RING.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("embers", "caminite_ring_center")));
        this.flatItem(RegistryManager.CAMINITE_RING, "caminite_ring");
        ModelFile.ExistingModelFile ringEdgeModel = this.models().getExistingFile(new ResourceLocation("embers", "caminite_ring_edge"));
        ModelFile.ExistingModelFile ringCornerModel = this.models().getExistingFile(new ResourceLocation("embers", "caminite_ring_corner"));
        this.getVariantBuilder((Block)RegistryManager.CAMINITE_RING_EDGE.get()).forAllStates(state -> {
            MechEdgeBlockBase.MechEdge edge = (MechEdgeBlockBase.MechEdge)((Object)((Object)state.m_61143_(MechEdgeBlockBase.EDGE)));
            return ConfiguredModel.builder().modelFile((ModelFile)(edge.corner ? ringCornerModel : ringEdgeModel)).rotationY(edge.rotation).uvLock(false).build();
        });
        this.simpleBlock((Block)RegistryManager.CAMINITE_GAUGE.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("embers", "caminite_ring_center")));
        this.flatItem(RegistryManager.CAMINITE_GAUGE, "caminite_gauge");
        ModelBuilder gaugeEdgeModel = ((CompositeModelBuilder)((BlockModelBuilder)this.models().withExistingParent("caminite_gauge_edge", new ResourceLocation("embers", "caminite_gauge_edge_base"))).customLoader(CompositeModelBuilder::begin)).child("base", (ModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)this.models().getExistingFile(new ResourceLocation("embers", "caminite_gauge_edge_base"))))).child("glass", (ModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)this.models().getExistingFile(new ResourceLocation("embers", "caminite_gauge_edge_glass"))))).end();
        this.getVariantBuilder((Block)RegistryManager.CAMINITE_GAUGE_EDGE.get()).forAllStates(arg_0 -> EmbersBlockStates.lambda$registerStatesAndModels$11(ringCornerModel, (ModelFile)gaugeEdgeModel, arg_0));
        this.simpleBlock((Block)RegistryManager.CAMINITE_VALVE.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("embers", "caminite_ring_center")));
        this.flatItem(RegistryManager.CAMINITE_VALVE, "caminite_valve");
        ModelFile.ExistingModelFile valveEdgeModel = this.models().getExistingFile(new ResourceLocation("embers", "caminite_valve_edge"));
        this.getVariantBuilder((Block)RegistryManager.CAMINITE_VALVE_EDGE.get()).forAllStates(state -> {
            MechEdgeBlockBase.MechEdge edge = (MechEdgeBlockBase.MechEdge)((Object)((Object)state.m_61143_(MechEdgeBlockBase.EDGE)));
            return ConfiguredModel.builder().modelFile((ModelFile)(edge.corner ? ringCornerModel : valveEdgeModel)).rotationY(edge.rotation).uvLock(false).build();
        });
        this.simpleBlock((Block)RegistryManager.CRYSTAL_CELL.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("embers", "crystal_cell_center")));
        this.simpleBlockItem((Block)RegistryManager.CRYSTAL_CELL.get(), (ModelFile)this.models().cubeAll("crystal_cell", new ResourceLocation("embers", "block/crate_crystal")));
        ModelFile.ExistingModelFile cellEdgeModel = this.models().getExistingFile(new ResourceLocation("embers", "crystal_cell_edge"));
        ModelFile.ExistingModelFile cellCornerModel = this.models().getExistingFile(new ResourceLocation("embers", "crystal_cell_corner"));
        this.getVariantBuilder((Block)RegistryManager.CRYSTAL_CELL_EDGE.get()).forAllStates(state -> {
            MechEdgeBlockBase.MechEdge edge = (MechEdgeBlockBase.MechEdge)((Object)((Object)state.m_61143_(MechEdgeBlockBase.EDGE)));
            return ConfiguredModel.builder().modelFile((ModelFile)(edge.corner ? cellCornerModel : cellEdgeModel)).rotationY(edge.rotation).uvLock(false).build();
        });
        ModelFile.ExistingModelFile separatorModel = this.models().getExistingFile(new ResourceLocation("embers", "geologic_separator"));
        this.horizontalBlock((Block)RegistryManager.GEOLOGIC_SEPARATOR.get(), (ModelFile)separatorModel);
        this.simpleBlockItem((Block)RegistryManager.GEOLOGIC_SEPARATOR.get(), (ModelFile)separatorModel);
        ModelFile.ExistingModelFile chargerModel = this.models().getExistingFile(new ResourceLocation("embers", "copper_charger"));
        this.horizontalBlock((Block)RegistryManager.COPPER_CHARGER.get(), (ModelFile)chargerModel);
        this.simpleBlockItem((Block)RegistryManager.COPPER_CHARGER.get(), (ModelFile)chargerModel);
        ModelFile.ExistingModelFile siphonModel = this.models().getExistingFile(new ResourceLocation("embers", "ember_siphon"));
        this.simpleBlock((Block)RegistryManager.EMBER_SIPHON.get(), (ModelFile)siphonModel);
        this.simpleBlockItem((Block)RegistryManager.EMBER_SIPHON.get(), (ModelFile)siphonModel);
        ModelFile.ExistingModelFile itemTransferModel = this.models().getExistingFile(new ResourceLocation("embers", "item_transfer"));
        ModelFile.ExistingModelFile itemTransferFilterModel = this.models().getExistingFile(new ResourceLocation("embers", "item_transfer_filtered"));
        this.directionalBlock((Block)RegistryManager.ITEM_TRANSFER.get(), state -> (Boolean)state.m_61143_((Property)ItemTransferBlock.FILTER) != false ? itemTransferFilterModel : itemTransferModel, 180);
        this.simpleBlockItem((Block)RegistryManager.ITEM_TRANSFER.get(), (ModelFile)itemTransferModel);
        ModelBuilder fluidTransferModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("fluid_transfer", new ResourceLocation("embers", "item_transfer"))).texture("top", new ResourceLocation("embers", "block/fluid_transfer_top"))).texture("side", new ResourceLocation("embers", "block/fluid_transfer_side"))).texture("bottom", new ResourceLocation("embers", "block/fluid_transfer_bottom"))).texture("particle", new ResourceLocation("embers", "block/fluid_transfer_side"));
        ModelBuilder fluidTransferFilterModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("fluid_transfer_filtered", new ResourceLocation("embers", "item_transfer_filtered"))).texture("top", new ResourceLocation("embers", "block/fluid_transfer_top"))).texture("side", new ResourceLocation("embers", "block/fluid_transfer_side"))).texture("bottom", new ResourceLocation("embers", "block/fluid_transfer_bottom"))).texture("particle", new ResourceLocation("embers", "block/fluid_transfer_side"));
        this.directionalBlock((Block)RegistryManager.FLUID_TRANSFER.get(), arg_0 -> EmbersBlockStates.lambda$registerStatesAndModels$15((ModelFile)fluidTransferFilterModel, (ModelFile)fluidTransferModel, arg_0), 180);
        this.simpleBlockItem((Block)RegistryManager.FLUID_TRANSFER.get(), (ModelFile)fluidTransferModel);
        this.getVariantBuilder((Block)RegistryManager.ALCHEMY_PEDESTAL.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)(state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER ? this.models().getExistingFile(new ResourceLocation("embers", "alchemy_pedestal_bottom")) : this.models().getExistingFile(new ResourceLocation("embers", "alchemy_pedestal_top")))).uvLock(false).build());
        this.getVariantBuilder((Block)CuriosCompat.EXPLOSION_PEDESTAL.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)(state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER ? this.models().getExistingFile(new ResourceLocation("embers", "alchemy_pedestal_bottom")) : this.models().getExistingFile(new ResourceLocation("embers", "explosion_pedestal_top")))).uvLock(false).build());
        this.blockWithItem(RegistryManager.ALCHEMY_TABLET, "alchemy_tablet");
        ModelFile.ExistingModelFile cannonModel = this.models().getExistingFile(new ResourceLocation("embers", "beam_cannon"));
        this.simpleBlockItem((Block)RegistryManager.BEAM_CANNON.get(), (ModelFile)cannonModel);
        MultiPartBlockStateBuilder cannonBuilder = ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)RegistryManager.BEAM_CANNON.get()).part().modelFile((ModelFile)cannonModel).addModel()).condition((Property)BlockStateProperties.f_61372_, (Comparable[])new Direction[]{Direction.UP}).end().part().modelFile((ModelFile)cannonModel).rotationX(180).addModel()).condition((Property)BlockStateProperties.f_61372_, (Comparable[])new Direction[]{Direction.DOWN}).end().part().modelFile((ModelFile)cannonModel).rotationX(90).addModel()).condition((Property)BlockStateProperties.f_61372_, (Comparable[])new Direction[]{Direction.NORTH}).end().part().modelFile((ModelFile)cannonModel).rotationX(90).rotationY(180).addModel()).condition((Property)BlockStateProperties.f_61372_, (Comparable[])new Direction[]{Direction.SOUTH}).end().part().modelFile((ModelFile)cannonModel).rotationX(90).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61372_, (Comparable[])new Direction[]{Direction.EAST}).end().part().modelFile((ModelFile)cannonModel).rotationX(90).rotationY(270).addModel()).condition((Property)BlockStateProperties.f_61372_, (Comparable[])new Direction[]{Direction.WEST}).end();
        EmbersBlockStates.addEmitterConnections(cannonBuilder, (ModelFile)fluidPipeEndModel, (ModelFile)fluidPipeEndModel2);
        ModelFile.ExistingModelFile pumpBottomModel = this.models().getExistingFile(new ResourceLocation("embers", "mechanical_pump_bottom"));
        ModelFile.ExistingModelFile pumpTopModel = this.models().getExistingFile(new ResourceLocation("embers", "mechanical_pump_top"));
        this.getVariantBuilder((Block)RegistryManager.MECHANICAL_PUMP.get()).forAllStates(state -> {
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61364_);
            return ConfiguredModel.builder().modelFile((ModelFile)(state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER ? pumpBottomModel : pumpTopModel)).rotationY(axis == Direction.Axis.Z ? 0 : 90).uvLock(false).build();
        });
        this.simpleBlockItem((Block)RegistryManager.MECHANICAL_PUMP.get(), (ModelFile)pumpBottomModel);
        ModelFile.ExistingModelFile boilerModel = this.models().getExistingFile(new ResourceLocation("embers", "mini_boiler"));
        ModelBuilder boilerPipeModel = ((PipeModelBuilder)((BlockModelBuilder)this.models().withExistingParent("mini_boiler_pipes", "block")).customLoader(PipeModelBuilder::begin)).parts((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)boilerModel), (BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)fluidPipeConnectionModel), (BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)fluidPipeConnectionModel2), (BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)fluidPipeEndModel), (BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)fluidPipeEndModel2)).end();
        this.horizontalBlock((Block)RegistryManager.MINI_BOILER.get(), (ModelFile)boilerPipeModel);
        this.simpleBlockItem((Block)RegistryManager.MINI_BOILER.get(), (ModelFile)boilerModel);
        ModelBuilder catalyticPlugModel = ((CompositeModelBuilder)((BlockModelBuilder)this.models().withExistingParent("catalytic_plug", new ResourceLocation("embers", "catalytic_plug_base"))).customLoader(CompositeModelBuilder::begin)).child("base", (ModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)this.models().getExistingFile(new ResourceLocation("embers", "catalytic_plug_base"))))).child("glass", (ModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)this.models().getExistingFile(new ResourceLocation("embers", "catalytic_plug_glass"))))).end();
        this.directionalBlock((Block)RegistryManager.CATALYTIC_PLUG.get(), (ModelFile)catalyticPlugModel);
        this.simpleBlockItem((Block)RegistryManager.CATALYTIC_PLUG.get(), (ModelFile)catalyticPlugModel);
        ModelFile.ExistingModelFile stirlingModel = this.models().getExistingFile(new ResourceLocation("embers", "wildfire_stirling"));
        this.directionalBlock((Block)RegistryManager.WILDFIRE_STIRLING.get(), (ModelFile)stirlingModel);
        this.simpleBlockItem((Block)RegistryManager.WILDFIRE_STIRLING.get(), (ModelFile)stirlingModel);
        ModelFile.ExistingModelFile injectorModel = this.models().getExistingFile(new ResourceLocation("embers", "ember_injector"));
        this.directionalBlock((Block)RegistryManager.EMBER_INJECTOR.get(), (ModelFile)injectorModel);
        this.simpleBlockItem((Block)RegistryManager.EMBER_INJECTOR.get(), (ModelFile)injectorModel);
        this.metalSeed(RegistryManager.COPPER_CRYSTAL_SEED);
        this.metalSeed(RegistryManager.IRON_CRYSTAL_SEED);
        this.metalSeed(RegistryManager.GOLD_CRYSTAL_SEED);
        this.metalSeed(RegistryManager.LEAD_CRYSTAL_SEED);
        this.metalSeed(RegistryManager.SILVER_CRYSTAL_SEED);
        this.metalSeed(RegistryManager.NICKEL_CRYSTAL_SEED);
        this.metalSeed(RegistryManager.TIN_CRYSTAL_SEED);
        this.metalSeed(RegistryManager.ALUMINUM_CRYSTAL_SEED);
        this.metalSeed(RegistryManager.ZINC_CRYSTAL_SEED);
        this.metalSeed(RegistryManager.PLATINUM_CRYSTAL_SEED);
        this.metalSeed(RegistryManager.URANIUM_CRYSTAL_SEED);
        this.metalSeed(RegistryManager.DAWNSTONE_CRYSTAL_SEED);
        ModelFile.ExistingModelFile chartModel = this.models().getExistingFile(new ResourceLocation("embers", "field_chart_center"));
        ModelFile.ExistingModelFile invertedChartModel = this.models().getExistingFile(new ResourceLocation("embers", "field_chart_center_inverted"));
        this.getVariantBuilder((Block)RegistryManager.FIELD_CHART.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)((Boolean)state.m_61143_((Property)FieldChartBlock.INVERTED) != false ? invertedChartModel : chartModel)).build());
        this.simpleBlockItem((Block)RegistryManager.FIELD_CHART.get(), (ModelFile)this.models().cubeAll("field_chart", new ResourceLocation("embers", "block/crate_chart")));
        ModelFile.ExistingModelFile chartEdgeModel = this.models().getExistingFile(new ResourceLocation("embers", "field_chart_edge"));
        ModelFile.ExistingModelFile chartCornerModel = this.models().getExistingFile(new ResourceLocation("embers", "field_chart_corner"));
        this.getVariantBuilder((Block)RegistryManager.FIELD_CHART_EDGE.get()).forAllStates(state -> {
            MechEdgeBlockBase.MechEdge edge = (MechEdgeBlockBase.MechEdge)((Object)((Object)state.m_61143_(MechEdgeBlockBase.EDGE)));
            return ConfiguredModel.builder().modelFile((ModelFile)(edge.corner ? chartCornerModel : chartEdgeModel)).rotationY(edge.rotation).uvLock(false).build();
        });
        this.blockWithItem(RegistryManager.IGNEM_REACTOR, "ignem_reactor");
        ModelFile.ExistingModelFile chamberModel = this.models().getExistingFile(new ResourceLocation("embers", "chamber_top"));
        ModelFile.ExistingModelFile chamberConnectionModel = this.models().getExistingFile(new ResourceLocation("embers", "chamber_top_connection"));
        ModelFile.ExistingModelFile catalysisChamberModel = this.models().getExistingFile(new ResourceLocation("embers", "catalysis_chamber"));
        this.simpleBlockItem((Block)RegistryManager.CATALYSIS_CHAMBER.get(), (ModelFile)catalysisChamberModel);
        this.getVariantBuilder((Block)RegistryManager.CATALYSIS_CHAMBER.get()).forAllStates(state -> {
            ChamberBlockBase.ChamberConnection connection = (ChamberBlockBase.ChamberConnection)((Object)((Object)state.m_61143_(ChamberBlockBase.CONNECTION)));
            return ConfiguredModel.builder().modelFile((ModelFile)(connection == ChamberBlockBase.ChamberConnection.BOTTOM ? catalysisChamberModel : (connection == ChamberBlockBase.ChamberConnection.TOP ? chamberModel : chamberConnectionModel))).rotationY(((int)connection.direction.m_122435_() + 180) % 360).uvLock(false).build();
        });
        ModelFile.ExistingModelFile combustionChamberModel = this.models().getExistingFile(new ResourceLocation("embers", "combustion_chamber"));
        this.simpleBlockItem((Block)RegistryManager.COMBUSTION_CHAMBER.get(), (ModelFile)combustionChamberModel);
        this.getVariantBuilder((Block)RegistryManager.COMBUSTION_CHAMBER.get()).forAllStates(state -> {
            ChamberBlockBase.ChamberConnection connection = (ChamberBlockBase.ChamberConnection)((Object)((Object)state.m_61143_(ChamberBlockBase.CONNECTION)));
            return ConfiguredModel.builder().modelFile((ModelFile)(connection == ChamberBlockBase.ChamberConnection.BOTTOM ? combustionChamberModel : (connection == ChamberBlockBase.ChamberConnection.TOP ? chamberModel : chamberConnectionModel))).rotationY(((int)connection.direction.m_122435_() + 180) % 360).uvLock(false).build();
        });
        ModelFile.ExistingModelFile emptyModel = this.models().getExistingFile(new ResourceLocation("embers", "empty"));
        this.simpleBlock((Block)RegistryManager.GLIMMER.get(), (ModelFile)emptyModel);
        this.blockWithItem(RegistryManager.CINDER_PLINTH, "cinder_plinth");
        ModelFile.ExistingModelFile anvilModel = this.models().getExistingFile(new ResourceLocation("embers", "dawnstone_anvil"));
        this.horizontalBlock((Block)RegistryManager.DAWNSTONE_ANVIL.get(), (ModelFile)anvilModel, 90);
        this.simpleBlockItem((Block)RegistryManager.DAWNSTONE_ANVIL.get(), (ModelFile)anvilModel);
        ModelFile.ExistingModelFile hammerModel = this.models().getExistingFile(new ResourceLocation("embers", "automatic_hammer"));
        ModelFile.ExistingModelFile hammerItemModel = this.models().getExistingFile(new ResourceLocation("embers", "automatic_hammer_item"));
        this.horizontalBlock((Block)RegistryManager.AUTOMATIC_HAMMER.get(), (ModelFile)hammerModel);
        this.simpleBlockItem((Block)RegistryManager.AUTOMATIC_HAMMER.get(), (ModelFile)hammerItemModel);
        ModelFile.ExistingModelFile infernoForgeModel = this.models().getExistingFile(new ResourceLocation("embers", "inferno_forge"));
        this.getVariantBuilder((Block)RegistryManager.INFERNO_FORGE.get()).forAllStates(state -> {
            DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)BlockStateProperties.f_61401_);
            return ConfiguredModel.builder().modelFile((ModelFile)(half == DoubleBlockHalf.LOWER ? infernoForgeModel : emptyModel)).build();
        });
        this.simpleBlockItem((Block)RegistryManager.INFERNO_FORGE.get(), (ModelFile)this.models().cubeAll("crate_inferno_forge", new ResourceLocation("embers", "block/crate_inferno_forge")));
        ModelFile.ExistingModelFile forgeEdgeModel = this.models().getExistingFile(new ResourceLocation("embers", "inferno_forge_edge_bottom"));
        ModelFile.ExistingModelFile forgeTopEdgeModel = this.models().getExistingFile(new ResourceLocation("embers", "inferno_forge_edge_top"));
        ModelFile.ExistingModelFile forgeCornerModel = this.models().getExistingFile(new ResourceLocation("embers", "inferno_forge_corner_bottom"));
        ModelFile.ExistingModelFile forgeTopCornerModel = this.models().getExistingFile(new ResourceLocation("embers", "inferno_forge_corner_top"));
        this.getVariantBuilder((Block)RegistryManager.INFERNO_FORGE_EDGE.get()).forAllStates(state -> {
            MechEdgeBlockBase.MechEdge edge = (MechEdgeBlockBase.MechEdge)((Object)((Object)state.m_61143_(MechEdgeBlockBase.EDGE)));
            ConfiguredModel.Builder builder = ConfiguredModel.builder().rotationY(edge.rotation);
            if (state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER) {
                return builder.modelFile((ModelFile)(edge.corner ? forgeCornerModel : forgeEdgeModel)).build();
            }
            return builder.modelFile((ModelFile)(edge.corner ? forgeTopCornerModel : forgeTopEdgeModel)).build();
        });
        ModelFile.ExistingModelFile inscriberModel = this.models().getExistingFile(new ResourceLocation("embers", "mnemonic_inscriber"));
        ModelBuilder inscriberActiveModel = ((BlockModelBuilder)this.models().withExistingParent("embers:mnemonic_inscriber_active", new ResourceLocation("embers", "mnemonic_inscriber"))).texture("4", new ResourceLocation("embers", "block/mnemonic_on"));
        this.getVariantBuilder((Block)RegistryManager.MNEMONIC_INSCRIBER.get()).forAllStates(arg_0 -> EmbersBlockStates.lambda$registerStatesAndModels$25((ModelFile)inscriberActiveModel, inscriberModel, arg_0));
        this.simpleBlockItem((Block)RegistryManager.MNEMONIC_INSCRIBER.get(), (ModelFile)inscriberModel);
        ModelFile.ExistingModelFile instillerModel = this.models().getExistingFile(new ResourceLocation("embers", "char_instiller"));
        this.horizontalBlock((Block)RegistryManager.CHAR_INSTILLER.get(), (ModelFile)instillerModel);
        this.simpleBlockItem((Block)RegistryManager.CHAR_INSTILLER.get(), (ModelFile)instillerModel);
        this.horizontalBlock((Block)RegistryManager.ATMOSPHERIC_BELLOWS.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("embers", "atmospheric_bellows_bottom")));
        this.simpleBlockItem((Block)RegistryManager.ATMOSPHERIC_BELLOWS.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("embers", "atmospheric_bellows")));
        this.directionalBlock((Block)RegistryManager.ENTROPIC_ENUMERATOR.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("embers", "entropic_enumerator_base")));
        this.simpleBlockItem((Block)RegistryManager.ENTROPIC_ENUMERATOR.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("embers", "entropic_enumerator")));
        ModelFile.ExistingModelFile exchangererModel = this.models().getExistingFile(new ResourceLocation("embers", "heat_exchanger"));
        this.horizontalBlock((Block)RegistryManager.HEAT_EXCHANGER.get(), (ModelFile)exchangererModel);
        this.simpleBlockItem((Block)RegistryManager.HEAT_EXCHANGER.get(), (ModelFile)exchangererModel);
        ModelFile.ExistingModelFile insulationModel = this.models().getExistingFile(new ResourceLocation("embers", "heat_insulation"));
        this.directionalBlock((Block)RegistryManager.HEAT_INSULATION.get(), (ModelFile)insulationModel);
        this.simpleBlockItem((Block)RegistryManager.HEAT_INSULATION.get(), (ModelFile)insulationModel);
        this.directionalBlock((Block)RegistryManager.EXCAVATION_BUCKETS.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("embers", "excavation_buckets")));
        this.simpleBlockItem((Block)RegistryManager.EXCAVATION_BUCKETS.get(), (ModelFile)this.models().getExistingFile(new ResourceLocation("embers", "excavation_buckets_inventory")));
    }

    public void blockWithItem(RegistryObject<? extends Block> registryObject) {
        this.simpleBlock((Block)registryObject.get());
        this.simpleBlockItem((Block)registryObject.get(), this.cubeAll((Block)registryObject.get()));
    }

    public ModelFile columnBlockWithItem(RegistryObject<? extends Block> registryObject, String sideTex, String topTex) {
        ResourceLocation side = new ResourceLocation("embers", "block/" + sideTex);
        ResourceLocation end = new ResourceLocation("embers", "block/" + topTex);
        ModelBuilder model = this.models().cubeColumn(registryObject.getId().m_135815_(), side, end);
        this.simpleBlock((Block)registryObject.get(), (ModelFile)model);
        this.simpleBlockItem((Block)registryObject.get(), (ModelFile)model);
        return model;
    }

    public ModelFile pillarBlockWithItem(RegistryObject<? extends RotatedPillarBlock> registryObject, String sideTex, String topTex) {
        ResourceLocation side = new ResourceLocation("embers", "block/" + sideTex);
        ResourceLocation end = new ResourceLocation("embers", "block/" + topTex);
        ModelBuilder model = this.models().cubeColumn(registryObject.getId().m_135815_(), side, end);
        this.axisBlock((RotatedPillarBlock)registryObject.get(), (ModelFile)model, (ModelFile)model);
        this.simpleBlockItem((Block)registryObject.get(), (ModelFile)model);
        return model;
    }

    public void blockWithItem(RegistryObject<? extends Block> registryObject, String model) {
        ModelFile.ExistingModelFile modelFile = this.models().getExistingFile(new ResourceLocation("embers", model));
        this.simpleBlock((Block)registryObject.get(), (ModelFile)modelFile);
        this.simpleBlockItem((Block)registryObject.get(), (ModelFile)modelFile);
    }

    public void blockWithItemTexture(RegistryObject<? extends Block> registryObject, String texture) {
        ModelBuilder modelFile = this.models().cubeAll(ForgeRegistries.BLOCKS.getKey((Object)((Block)registryObject.get())).m_135815_(), new ResourceLocation("embers", "block/" + texture));
        this.simpleBlock((Block)registryObject.get(), (ModelFile)modelFile);
        this.simpleBlockItem((Block)registryObject.get(), (ModelFile)modelFile);
    }

    public void dial(RegistryObject<? extends Block> registryObject, String texture) {
        ResourceLocation loc = ForgeRegistries.BLOCKS.getKey((Object)((Block)registryObject.get()));
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(loc.toString(), new ResourceLocation("embers", "dial"))).texture("dial", new ResourceLocation("embers", "block/" + texture))).texture("particle", new ResourceLocation("embers", "block/" + texture));
        this.directionalBlock((Block)registryObject.get(), (ModelFile)model);
        this.flatItem(registryObject, texture);
    }

    public void flatItem(RegistryObject<? extends Block> registryObject, String texture) {
        ResourceLocation loc = ForgeRegistries.BLOCKS.getKey((Object)((Block)registryObject.get()));
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(loc.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", new ResourceLocation(loc.m_135827_(), "item/" + texture));
    }

    public void betterDirectionalBlock(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.getVariantBuilder(block).forAllStates(state -> {
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(dir == Direction.DOWN ? 180 : (dir.m_122434_().m_122479_() ? 270 : 0)).rotationY(dir.m_122434_().m_122478_() ? 0 : ((int)dir.m_122435_() + angleOffset) % 360).build();
        });
    }

    public void leverBlock(Block block, ModelFile lever, ModelFile leverFlipped) {
        this.getVariantBuilder(block).forAllStates(state -> {
            Direction facing = (Direction)state.m_61143_((Property)ButtonBlock.f_54117_);
            AttachFace face = (AttachFace)state.m_61143_((Property)ButtonBlock.f_53179_);
            boolean powered = (Boolean)state.m_61143_((Property)ButtonBlock.f_51045_);
            return ConfiguredModel.builder().modelFile(powered ? leverFlipped : lever).rotationX(face == AttachFace.FLOOR ? 0 : (face == AttachFace.WALL ? 90 : 180)).rotationY((int)(face == AttachFace.CEILING ? facing : facing.m_122424_()).m_122435_()).uvLock(false).build();
        });
    }

    public void fluid(RegistryObject<? extends Block> fluid, String name) {
        this.simpleBlock((Block)fluid.get(), (ModelFile)this.models().cubeAll(name, new ResourceLocation("embers", "block/fluid/" + name + "_still")));
    }

    public void decoBlocks(RegistryManager.StoneDecoBlocks deco) {
        ResourceLocation resourceLocation = this.blockTexture((Block)deco.block.get());
        if (deco.stairs != null) {
            this.stairsBlock((StairBlock)deco.stairs.get(), resourceLocation);
            this.itemModels().stairs(deco.stairs.getId().m_135815_(), resourceLocation, resourceLocation, resourceLocation);
        }
        if (deco.slab != null) {
            this.slabBlock((SlabBlock)deco.slab.get(), deco.block.getId(), resourceLocation);
            this.itemModels().slab(deco.slab.getId().m_135815_(), resourceLocation, resourceLocation, resourceLocation);
        }
        if (deco.wall != null) {
            this.wallBlock((WallBlock)deco.wall.get(), resourceLocation);
            this.itemModels().wallInventory(deco.wall.getId().m_135815_(), resourceLocation);
        }
    }

    public void metalSeed(RegistryManager.MetalCrystalSeed seed) {
        this.simpleBlock((Block)seed.BLOCK.get(), (ModelFile)this.models().cubeAll(seed.name, new ResourceLocation("embers", "block/material_" + seed.name)));
        this.flatItem(seed.BLOCK, "seed_" + seed.name);
    }

    public static void addEmitterConnections(MultiPartBlockStateBuilder builder, ModelFile pipe1, ModelFile pipe2) {
        for (Direction direction : Direction.values()) {
            Direction.Axis axis1;
            Direction.Axis axis2 = switch (direction.m_122434_()) {
                case Direction.Axis.X -> {
                    axis1 = Direction.Axis.Y;
                    yield Direction.Axis.Z;
                }
                case Direction.Axis.Y -> {
                    axis1 = Direction.Axis.X;
                    yield Direction.Axis.Z;
                }
                default -> {
                    axis1 = Direction.Axis.X;
                    yield Direction.Axis.Y;
                }
            };
            ((MultiPartBlockStateBuilder.PartBuilder)EmbersBlockStates.rotationsForDirection(builder.part().modelFile(direction.m_122421_() == Direction.AxisDirection.POSITIVE ? pipe2 : pipe1), direction).addModel()).nestedGroup().useOr().nestedGroup().condition((Property)BlockStateProperties.f_61372_, (Comparable[])new Direction[]{Direction.m_122387_((Direction.Axis)axis1, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE), Direction.m_122387_((Direction.Axis)axis1, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE)}).condition((Property)EmberEmitterBlock.DIRECTIONS[EmberEmitterBlock.getIndexForDirection(axis1, direction)], (Comparable[])new Boolean[]{true}).endNestedGroup().nestedGroup().condition((Property)BlockStateProperties.f_61372_, (Comparable[])new Direction[]{Direction.m_122387_((Direction.Axis)axis2, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE), Direction.m_122387_((Direction.Axis)axis2, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE)}).condition((Property)EmberEmitterBlock.DIRECTIONS[EmberEmitterBlock.getIndexForDirection(axis2, direction)], (Comparable[])new Boolean[]{true}).endNestedGroup().end();
        }
    }

    public static <T> ConfiguredModel.Builder<T> rotationsForDirection(ConfiguredModel.Builder<T> builder, Direction direction) {
        switch (direction) {
            default: {
                return builder;
            }
            case UP: {
                return builder.rotationX(180);
            }
            case EAST: {
                return builder.rotationX(90).rotationY(270);
            }
            case WEST: {
                return builder.rotationX(90).rotationY(90);
            }
            case SOUTH: {
                return builder.rotationX(90);
            }
            case NORTH: 
        }
        return builder.rotationX(90).rotationY(180);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerStatesAndModels$25(ModelFile inscriberActiveModel, ModelFile.ExistingModelFile inscriberModel, BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        return ConfiguredModel.builder().modelFile((ModelFile)((Boolean)state.m_61143_((Property)MnemonicInscriberBlock.ACTIVE) != false ? inscriberActiveModel : inscriberModel)).rotationX(dir == Direction.DOWN ? 180 : (dir.m_122434_().m_122479_() ? 90 : 0)).rotationY(dir.m_122434_().m_122478_() ? 0 : ((int)dir.m_122435_() + 180) % 360).build();
    }

    private static /* synthetic */ ModelFile lambda$registerStatesAndModels$15(ModelFile fluidTransferFilterModel, ModelFile fluidTransferModel, BlockState state) {
        return (Boolean)state.m_61143_((Property)ItemTransferBlock.FILTER) != false ? fluidTransferFilterModel : fluidTransferModel;
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerStatesAndModels$11(ModelFile.ExistingModelFile ringCornerModel, ModelFile gaugeEdgeModel, BlockState state) {
        MechEdgeBlockBase.MechEdge edge = (MechEdgeBlockBase.MechEdge)((Object)state.m_61143_(MechEdgeBlockBase.EDGE));
        return ConfiguredModel.builder().modelFile((ModelFile)(edge.corner ? ringCornerModel : gaugeEdgeModel)).rotationY(edge.rotation).uvLock(false).build();
    }
}

