/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.rekindled.embers.blockentity.CrystalSeedBlockEntity;
import com.rekindled.embers.render.EmbersRenderTypes;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CrystalSeedBlockEntityRenderer
implements BlockEntityRenderer<CrystalSeedBlockEntity> {
    public CrystalSeedBlockEntityRenderer(BlockEntityRendererProvider.Context pContext) {
    }

    public void render(CrystalSeedBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (blockEntity != null) {
            VertexConsumer buffer = bufferSource.m_6299_(EmbersRenderTypes.CRYSTAL_SEED.apply(blockEntity.texture));
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(15.0f * (float)Math.sin(Math.toRadians((float)blockEntity.ticksExisted + partialTick))));
            this.drawCrystal(buffer, poseStack.m_85850_().m_252922_(), poseStack.m_85850_().m_252943_(), 0.0f, 0.0f, 0.0f, ((float)blockEntity.ticksExisted + partialTick) * 6.0f, 1.0f, 0.25f, 0.0f, 0.75f, 1.0f, packedLight, packedOverlay);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-15.0f * (float)Math.sin(Math.toRadians((float)blockEntity.ticksExisted + partialTick))));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-15.0f * (float)Math.sin(Math.toRadians(2.5f * ((float)blockEntity.ticksExisted + partialTick)))));
            float oneAng = 360.0f / (float)blockEntity.willSpawn.length;
            Random crystalRandom = new Random(blockEntity.m_58899_().m_121878_());
            for (int i = 0; i < blockEntity.willSpawn.length; ++i) {
                if (!blockEntity.willSpawn[i]) continue;
                float distVariation = 1.0f;
                if (blockEntity.willSpawn.length > 12) {
                    distVariation += crystalRandom.nextFloat() * 0.5f;
                }
                float offX = distVariation * 0.4f * (float)Math.sin(Math.toRadians(oneAng * (float)i + ((float)blockEntity.ticksExisted + partialTick) * 2.0f));
                float offZ = distVariation * 0.4f * (float)Math.cos(Math.toRadians(oneAng * (float)i + ((float)blockEntity.ticksExisted + partialTick) * 2.0f));
                float texWidth = 0.25f * (float)blockEntity.size / 1000.0f;
                float texHeight = 0.5f * (float)blockEntity.size / 1000.0f;
                float texX = crystalRandom.nextFloat() * (1.0f - texWidth);
                float texY = crystalRandom.nextFloat() * (1.0f - texHeight);
                float sizeVariation = 0.5f + crystalRandom.nextFloat() * 0.5f;
                this.drawCrystal(buffer, poseStack.m_85850_().m_252922_(), poseStack.m_85850_().m_252943_(), offX, 0.0f, offZ, ((float)blockEntity.ticksExisted + partialTick) * 2.0f, sizeVariation * 0.4f * ((float)blockEntity.size / 1000.0f), texX, texY, texX + texWidth, texY + texHeight, packedLight, packedOverlay);
            }
            poseStack.m_85849_();
        }
    }

    public void drawCrystal(VertexConsumer b, Matrix4f matrix4f, Matrix3f normal, float x, float y, float z, float rotation, float size, float minU, float minV, float maxU, float maxV, int packedLight, int packedOverlay) {
        float offX1 = size * 0.25f * (float)Math.sin(Math.toRadians(rotation));
        float offZ1 = size * 0.25f * (float)Math.cos(Math.toRadians(rotation));
        float offX2 = size * 0.25f * (float)Math.sin(Math.toRadians(rotation + 90.0f));
        float offZ2 = size * 0.25f * (float)Math.cos(Math.toRadians(rotation + 90.0f));
        float pos1X = x;
        float pos1Y = y - size * 0.5f;
        float pos1Z = z;
        float pos2X = x + offX1;
        float pos2Y = y;
        float pos2Z = z + offZ1;
        float pos3X = x + offX2;
        float pos3Y = y;
        float pos3Z = z + offZ2;
        float pos4X = x - offX1;
        float pos4Y = y;
        float pos4Z = z - offZ1;
        float pos5X = x - offX2;
        float pos5Y = y;
        float pos5Z = z - offZ2;
        float pos6X = x;
        float pos6Y = y + size * 0.5f;
        float pos6Z = z;
        Vector3f bottom = new Vector3f(pos1X, pos1Y, pos1Z);
        Vector3f normal1 = new Vector3f(pos5X, pos5Y, pos5Z).sub((Vector3fc)bottom).cross((Vector3fc)new Vector3f(pos4X, pos4Y, pos4Z).sub((Vector3fc)bottom)).normalize().mul(-1.0f);
        Vector3f normal2 = new Vector3f(pos2X, pos2Y, pos2Z).sub((Vector3fc)bottom).cross((Vector3fc)new Vector3f(pos5X, pos5Y, pos5Z).sub((Vector3fc)bottom)).normalize().mul(-1.0f);
        Vector3f normal3 = new Vector3f(pos3X, pos3Y, pos3Z).sub((Vector3fc)bottom).cross((Vector3fc)new Vector3f(pos2X, pos2Y, pos2Z).sub((Vector3fc)bottom)).normalize().mul(-1.0f);
        Vector3f normal4 = new Vector3f(pos4X, pos4Y, pos4Z).sub((Vector3fc)bottom).cross((Vector3fc)new Vector3f(pos3X, pos3Y, pos3Z).sub((Vector3fc)bottom)).normalize().mul(-1.0f);
        Vector3f normal5 = new Vector3f((Vector3fc)normal3).mul(-1.0f);
        Vector3f normal6 = new Vector3f((Vector3fc)normal4).mul(-1.0f);
        Vector3f normal7 = new Vector3f((Vector3fc)normal1).mul(-1.0f);
        Vector3f normal8 = new Vector3f((Vector3fc)normal2).mul(-1.0f);
        b.m_252986_(matrix4f, pos1X, pos1Y, pos1Z).m_6122_(255, 255, 255, 255).m_7421_((minU + maxU) / 2.0f, maxV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, normal1.x, -normal1.y, normal1.z).m_5752_();
        b.m_252986_(matrix4f, pos3X, pos3Y, pos3Z).m_6122_(255, 255, 255, 255).m_7421_(maxU, minV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, normal1.x, -normal1.y, normal1.z).m_5752_();
        b.m_252986_(matrix4f, pos2X, pos2Y, pos2Z).m_6122_(255, 255, 255, 255).m_7421_(minU, minV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, normal1.x, -normal1.y, normal1.z).m_5752_();
        b.m_252986_(matrix4f, pos1X, pos1Y, pos1Z).m_6122_(255, 255, 255, 255).m_7421_((minU + maxU) / 2.0f, maxV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, normal2.x, -normal2.y, normal2.z).m_5752_();
        b.m_252986_(matrix4f, pos4X, pos4Y, pos4Z).m_6122_(255, 255, 255, 255).m_7421_(maxU, minV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, normal2.x, -normal2.y, normal2.z).m_5752_();
        b.m_252986_(matrix4f, pos3X, pos3Y, pos3Z).m_6122_(255, 255, 255, 255).m_7421_(minU, minV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, normal2.x, -normal2.y, normal2.z).m_5752_();
        b.m_252986_(matrix4f, pos1X, pos1Y, pos1Z).m_6122_(255, 255, 255, 255).m_7421_((minU + maxU) / 2.0f, maxV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, normal3.x, -normal3.y, normal3.z).m_5752_();
        b.m_252986_(matrix4f, pos5X, pos5Y, pos5Z).m_6122_(255, 255, 255, 255).m_7421_(maxU, minV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, normal3.x, -normal3.y, normal3.z).m_5752_();
        b.m_252986_(matrix4f, pos4X, pos4Y, pos4Z).m_6122_(255, 255, 255, 255).m_7421_(minU, minV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, normal3.x, -normal3.y, normal3.z).m_5752_();
        b.m_252986_(matrix4f, pos1X, pos1Y, pos1Z).m_6122_(255, 255, 255, 255).m_7421_((minU + maxU) / 2.0f, maxV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, normal4.x, -normal4.y, normal4.z).m_5752_();
        b.m_252986_(matrix4f, pos2X, pos2Y, pos2Z).m_6122_(255, 255, 255, 255).m_7421_(maxU, minV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, normal4.x, -normal4.y, normal4.z).m_5752_();
        b.m_252986_(matrix4f, pos5X, pos5Y, pos5Z).m_6122_(255, 255, 255, 255).m_7421_(minU, minV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, normal4.x, -normal4.y, normal4.z).m_5752_();
        b.m_252986_(matrix4f, pos6X, pos6Y, pos6Z).m_6122_(255, 255, 255, 255).m_7421_((minU + maxU) / 2.0f, minV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, normal5.x, -normal5.y, normal5.z).m_5752_();
        b.m_252986_(matrix4f, pos2X, pos2Y, pos2Z).m_6122_(255, 255, 255, 255).m_7421_(minU, maxV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, normal5.x, -normal5.y, normal5.z).m_5752_();
        b.m_252986_(matrix4f, pos3X, pos3Y, pos3Z).m_6122_(255, 255, 255, 255).m_7421_(maxU, maxV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, normal5.x, -normal5.y, normal5.z).m_5752_();
        b.m_252986_(matrix4f, pos6X, pos6Y, pos6Z).m_6122_(255, 255, 255, 255).m_7421_((minU + maxU) / 2.0f, minV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, normal6.x, -normal6.y, normal6.z).m_5752_();
        b.m_252986_(matrix4f, pos3X, pos3Y, pos3Z).m_6122_(255, 255, 255, 255).m_7421_(minU, maxV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, normal6.x, -normal6.y, normal6.z).m_5752_();
        b.m_252986_(matrix4f, pos4X, pos4Y, pos4Z).m_6122_(255, 255, 255, 255).m_7421_(maxU, maxV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, normal6.x, -normal6.y, normal6.z).m_5752_();
        b.m_252986_(matrix4f, pos6X, pos6Y, pos6Z).m_6122_(255, 255, 255, 255).m_7421_((minU + maxU) / 2.0f, minV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, normal7.x, -normal7.y, normal7.z).m_5752_();
        b.m_252986_(matrix4f, pos4X, pos4Y, pos4Z).m_6122_(255, 255, 255, 255).m_7421_(minU, maxV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, normal7.x, -normal7.y, normal7.z).m_5752_();
        b.m_252986_(matrix4f, pos5X, pos5Y, pos5Z).m_6122_(255, 255, 255, 255).m_7421_(maxU, maxV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, normal7.x, -normal7.y, normal7.z).m_5752_();
        b.m_252986_(matrix4f, pos6X, pos6Y, pos6Z).m_6122_(255, 255, 255, 255).m_7421_((minU + maxU) / 2.0f, minV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, normal8.x, -normal8.y, normal8.z).m_5752_();
        b.m_252986_(matrix4f, pos5X, pos5Y, pos5Z).m_6122_(255, 255, 255, 255).m_7421_(minU, maxV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, normal8.x, -normal8.y, normal8.z).m_5752_();
        b.m_252986_(matrix4f, pos2X, pos2Y, pos2Z).m_6122_(255, 255, 255, 255).m_7421_(maxU, maxV).m_86008_(packedOverlay).m_85969_(packedLight).m_252939_(normal, normal8.x, -normal8.y, normal8.z).m_5752_();
    }
}

