/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidHandlerBlockEntity;
import org.jetbrains.annotations.NotNull;

public abstract class OpenTankBlockEntity
extends FluidHandlerBlockEntity {
    FluidStack lastEscaped = null;
    long lastEscapedTickServer;
    long lastEscapedTickClient;

    public OpenTankBlockEntity(@NotNull BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("lastEscaped")) {
            this.lastEscaped = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("lastEscaped"));
            this.lastEscapedTickServer = nbt.m_128454_("lastEscapedTick");
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.lastEscaped != null) {
            nbt.m_128365_("lastEscaped", (Tag)this.lastEscaped.writeToNBT(new CompoundTag()));
            nbt.m_128356_("lastEscapedTick", this.lastEscapedTickServer);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.tank.writeToNBT(nbt);
        if (this.lastEscaped != null) {
            nbt.m_128365_("lastEscaped", (Tag)this.lastEscaped.writeToNBT(new CompoundTag()));
            nbt.m_128356_("lastEscapedTick", this.lastEscapedTickServer);
        }
        return nbt;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
        }
    }

    public void setEscapedFluid(FluidStack stack) {
        if (stack != null && !stack.isEmpty()) {
            this.lastEscaped = stack.copy();
            this.lastEscapedTickServer = this.f_58857_.m_6106_().m_6793_();
            this.m_6596_();
        }
    }

    protected boolean shouldEmitParticles() {
        if (this.lastEscaped == null || this.lastEscaped.isEmpty()) {
            return false;
        }
        if (this.lastEscapedTickClient < this.lastEscapedTickServer) {
            this.lastEscapedTickClient = this.lastEscapedTickServer;
            return true;
        }
        long dTime = this.f_58857_.m_6106_().m_6793_() - this.lastEscapedTickClient;
        return dTime < (long)(this.lastEscaped.getAmount() + 5);
    }

    protected abstract void updateEscapeParticles();
}

