/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.event.DialInformationEvent;
import com.rekindled.embers.api.event.EmberEvent;
import com.rekindled.embers.api.power.IEmberCapability;
import com.rekindled.embers.api.tile.IExtraDialInformation;
import com.rekindled.embers.api.tile.IMechanicallyPowered;
import com.rekindled.embers.api.tile.IUpgradeable;
import com.rekindled.embers.api.upgrades.UpgradeContext;
import com.rekindled.embers.api.upgrades.UpgradeUtil;
import com.rekindled.embers.blockentity.MechanicalPumpTopBlockEntity;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.power.DefaultEmberCapability;
import com.rekindled.embers.util.Misc;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MechanicalPumpBottomBlockEntity
extends BlockEntity
implements IMechanicallyPowered,
IExtraDialInformation,
IUpgradeable {
    public IEmberCapability capability = new DefaultEmberCapability(){

        @Override
        public void onContentsChanged() {
            super.onContentsChanged();
            MechanicalPumpBottomBlockEntity.this.m_6596_();
        }
    };
    public static final double EMBER_COST = 0.5;
    public int progress;
    public int totalProgress;
    public int lastProgress;
    private List<UpgradeContext> upgrades;

    public MechanicalPumpBottomBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.MECHANICAL_PUMP_BOTTOM_ENTITY.get(), pPos, pBlockState);
        this.capability.setEmberCapacity(1000.0);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_7918_(0, 1, 0), this.f_58858_.m_7918_(1, 3, 1));
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.capability.deserializeNBT((Tag)nbt);
        if (nbt.m_128441_("progress")) {
            this.progress = nbt.m_128451_("progress");
        }
        this.totalProgress = nbt.m_128451_("totalProgress");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.capability.writeToNBT(nbt);
        nbt.m_128405_("progress", this.progress);
        nbt.m_128405_("totalProgress", this.totalProgress);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128405_("totalProgress", this.totalProgress);
        return nbt;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == EmbersCapabilities.EMBER_CAPABILITY) {
            return this.capability.getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, MechanicalPumpBottomBlockEntity blockEntity) {
        boolean cancel;
        blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, Misc.horizontals);
        UpgradeUtil.verifyUpgrades(blockEntity, blockEntity.upgrades);
        if (UpgradeUtil.doTick(blockEntity, blockEntity.upgrades)) {
            return;
        }
        double emberCost = UpgradeUtil.getTotalEmberConsumption(blockEntity, 0.5, blockEntity.upgrades);
        if (blockEntity.capability.getEmber() >= emberCost && !(cancel = UpgradeUtil.doWork(blockEntity, blockEntity.upgrades))) {
            int speed = (int)UpgradeUtil.getTotalSpeedModifier(blockEntity, blockEntity.upgrades);
            blockEntity.progress += speed;
            blockEntity.totalProgress += speed;
            UpgradeUtil.throwEvent(blockEntity, new EmberEvent(blockEntity, EmberEvent.EnumType.CONSUME, emberCost), blockEntity.upgrades);
            blockEntity.capability.removeAmount(emberCost, true);
            if (blockEntity.progress > 400) {
                blockEntity.progress -= 400;
                blockEntity.attemptPump(pos.m_7495_());
                blockEntity.playSound(speed);
            }
            blockEntity.m_6596_();
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, MechanicalPumpBottomBlockEntity blockEntity) {
        blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, Misc.horizontals);
        UpgradeUtil.verifyUpgrades(blockEntity, blockEntity.upgrades);
        blockEntity.lastProgress = blockEntity.totalProgress;
    }

    public boolean attemptPump(BlockPos pos) {
        MechanicalPumpTopBlockEntity t;
        int filled;
        FluidStack stack;
        BlockState state = this.f_58857_.m_8055_(pos);
        if (state.m_60734_() instanceof BucketPickup && !state.m_60819_().m_76178_() && state.m_60819_().m_76170_() && (stack = new FluidStack((Fluid)state.m_60819_().m_205074_().get(), 1000)) != null && (filled = (t = (MechanicalPumpTopBlockEntity)this.f_58857_.m_7702_(this.f_58858_.m_7494_())).getTank().fill(stack, IFluidHandler.FluidAction.SIMULATE)) == stack.getAmount()) {
            t.getTank().fill(stack, IFluidHandler.FluidAction.EXECUTE);
            ((BucketPickup)state.m_60734_()).m_142598_((LevelAccessor)this.f_58857_, pos, state);
            return false;
        }
        return true;
    }

    public void playSound(int speed) {
        float pitch;
        SoundEvent sound;
        if (speed >= 20) {
            sound = (SoundEvent)EmbersSounds.PUMP_FAST.get();
            pitch = (float)speed / 20.0f;
        } else if (speed >= 10) {
            sound = (SoundEvent)EmbersSounds.PUMP_MID.get();
            pitch = (float)speed / 10.0f;
        } else {
            sound = (SoundEvent)EmbersSounds.PUMP_SLOW.get();
            pitch = speed;
        }
        this.f_58857_.m_5594_(null, this.f_58858_.m_7494_(), sound, SoundSource.BLOCKS, 1.0f, pitch);
    }

    @Override
    public double getMechanicalSpeed(double power) {
        return Math.min(power / 2.0, 100.0);
    }

    @Override
    public double getMinimumPower() {
        return 2.0;
    }

    @Override
    public double getNominalSpeed() {
        return 10.0;
    }

    @Override
    public void addDialInformation(Direction facing, List<Component> information, String dialType) {
        UpgradeUtil.throwEvent(this, new DialInformationEvent(this, information, dialType), this.upgrades);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.capability.invalidate();
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
        }
    }

    @Override
    public boolean isSideUpgradeSlot(Direction face) {
        return face.m_122434_() != Direction.Axis.Y;
    }
}

