/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.blockentity.IItemPipePriority;
import com.rekindled.embers.blockentity.PipeBlockEntityBase;
import com.rekindled.embers.util.PipePriorityMap;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class ItemPipeBlockEntityBase
extends PipeBlockEntityBase
implements IItemPipePriority {
    public ItemStackHandler inventory;
    public LazyOptional<IItemHandler> holder = LazyOptional.of(() -> this.inventory);

    public ItemPipeBlockEntityBase(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.initInventory();
    }

    protected void initInventory() {
        this.inventory = new ItemStackHandler(1){

            public int getSlotLimit(int slot) {
                return ItemPipeBlockEntityBase.this.getCapacity();
            }

            protected void onContentsChanged(int slot) {
                ItemPipeBlockEntityBase.this.m_6596_();
            }
        };
    }

    public abstract int getCapacity();

    @Override
    public int getPriority(Direction facing) {
        return 0;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ItemPipeBlockEntityBase blockEntity) {
        if (!blockEntity.loaded) {
            blockEntity.initConnections();
        }
        ++blockEntity.ticksExisted;
        boolean itemsMoved = false;
        ItemStack passStack = blockEntity.inventory.extractItem(0, 1, true);
        if (!passStack.m_41619_()) {
            IItemHandler handler;
            PipePriorityMap<Integer, Direction> possibleDirections = new PipePriorityMap<Integer, Direction>();
            IItemHandler[] itemHandlers = new IItemHandler[Direction.values().length];
            for (Direction facing : Direction.values()) {
                BlockEntity tile;
                if (!blockEntity.getConnection((Direction)facing).transfer || blockEntity.isFrom(facing) || (tile = level.m_7702_(pos.m_121945_(facing))) == null || (handler = (IItemHandler)tile.getCapability(ForgeCapabilities.ITEM_HANDLER, facing.m_122424_()).orElse(null)) == null) continue;
                int priority = 0;
                if (tile instanceof IItemPipePriority) {
                    priority = ((IItemPipePriority)tile).getPriority(facing.m_122424_());
                }
                if (blockEntity.isFrom(facing.m_122424_())) {
                    priority -= 5;
                }
                possibleDirections.put(priority, facing);
                itemHandlers[facing.m_122411_()] = handler;
            }
            Iterator iterator = possibleDirections.keySet().iterator();
            while (iterator.hasNext()) {
                int key = (Integer)iterator.next();
                ArrayList list = possibleDirections.get(key);
                for (int i = 0; i < list.size(); ++i) {
                    Direction facing = (Direction)list.get((i + blockEntity.lastRobin) % list.size());
                    handler = itemHandlers[facing.m_122411_()];
                    itemsMoved = blockEntity.pushStack(passStack, facing, handler);
                    if (blockEntity.lastTransfer != facing) {
                        blockEntity.lastTransfer = facing;
                        blockEntity.syncTransfer = true;
                        blockEntity.m_6596_();
                    }
                    if (!itemsMoved) continue;
                    ++blockEntity.lastRobin;
                    break;
                }
                if (!itemsMoved) continue;
                break;
            }
        }
        if (blockEntity.inventory.getStackInSlot(0).m_41619_()) {
            if (blockEntity.lastTransfer != null && !itemsMoved) {
                blockEntity.lastTransfer = null;
                blockEntity.syncTransfer = true;
                blockEntity.m_6596_();
            }
            itemsMoved = true;
            blockEntity.resetFrom();
        }
        if (blockEntity.clogged == itemsMoved) {
            blockEntity.clogged = !itemsMoved;
            blockEntity.syncCloggedFlag = true;
            blockEntity.m_6596_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientTick(Level level, BlockPos pos, BlockState state, ItemPipeBlockEntityBase blockEntity) {
        PipeBlockEntityBase.clientTick(level, pos, state, blockEntity);
    }

    private boolean pushStack(ItemStack passStack, Direction facing, IItemHandler handler) {
        ItemStack added;
        int slot = -1;
        for (int j = 0; j < handler.getSlots() && slot == -1; ++j) {
            if (!handler.insertItem(j, passStack, true).m_41619_()) continue;
            slot = j;
        }
        if (slot != -1 && (added = handler.insertItem(slot, passStack, false)).m_41619_()) {
            this.inventory.extractItem(0, 1, false);
            return true;
        }
        if (this.isFrom(facing)) {
            this.setFrom(facing, false);
        }
        return false;
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("inventory")) {
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
        }
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.writeInventory(nbt);
    }

    public void writeInventory(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.holder);
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.holder.invalidate();
    }
}

