/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.blockentity.FluidPipeBlockEntityBase;
import com.rekindled.embers.particle.VaporParticleOptions;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class FluidPipeBlockEntity
extends FluidPipeBlockEntityBase {
    IFluidHandler[] sideHandlers;

    public FluidPipeBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.FLUID_PIPE_ENTITY.get(), pPos, pBlockState);
    }

    @Override
    protected void initFluidTank() {
        super.initFluidTank();
        this.sideHandlers = new IFluidHandler[Direction.values().length];
        for (final Direction facing : Direction.values()) {
            this.sideHandlers[facing.m_122411_()] = new IFluidHandler(){

                public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                    if (action.execute()) {
                        FluidPipeBlockEntity.this.setFrom(facing, true);
                    }
                    return FluidPipeBlockEntity.this.tank.fill(resource, action);
                }

                @Nullable
                public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                    return FluidPipeBlockEntity.this.tank.drain(resource, action);
                }

                @Nullable
                public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                    return FluidPipeBlockEntity.this.tank.drain(maxDrain, action);
                }

                public int getTanks() {
                    return FluidPipeBlockEntity.this.tank.getTanks();
                }

                @NotNull
                public FluidStack getFluidInTank(int tankNum) {
                    return FluidPipeBlockEntity.this.tank.getFluidInTank(tankNum);
                }

                public int getTankCapacity(int tankNum) {
                    return FluidPipeBlockEntity.this.tank.getTankCapacity(tankNum);
                }

                public boolean isFluidValid(int tankNum, @NotNull FluidStack stack) {
                    return FluidPipeBlockEntity.this.tank.isFluidValid(tankNum, stack);
                }
            };
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, FluidPipeBlockEntity blockEntity) {
        if (level instanceof ServerLevel && blockEntity.clogged && blockEntity.isAnySideUnclogged()) {
            Random posRand = new Random(pos.m_121878_());
            double angleA = posRand.nextDouble() * Math.PI * 2.0;
            double angleB = posRand.nextDouble() * Math.PI * 2.0;
            float xOffset = (float)(Math.cos(angleA) * Math.cos(angleB));
            float yOffset = (float)(Math.sin(angleA) * Math.cos(angleB));
            float zOffset = (float)Math.sin(angleB);
            float speed = 0.1f;
            float vx = xOffset * speed + posRand.nextFloat() * speed * 0.3f;
            float vy = yOffset * speed + posRand.nextFloat() * speed * 0.3f;
            float vz = zOffset * speed + posRand.nextFloat() * speed * 0.3f;
            ((ServerLevel)level).m_8767_((ParticleOptions)new VaporParticleOptions(new Vector3f(0.2509804f, 0.2509804f, 0.2509804f), new Vec3((double)vx, (double)vy, (double)vz), 1.0f), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 4, 0.0, 0.0, 0.0, 1.0);
        }
        FluidPipeBlockEntityBase.serverTick(level, pos, state, blockEntity);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.FLUID_HANDLER) {
            if (side == null) {
                return ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, this.holder);
            }
            if (this.getConnection((Direction)side).transfer) {
                return ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, LazyOptional.of(() -> this.sideHandlers[side.m_122411_()]));
            }
        }
        return super.getCapability(cap, side);
    }

    @Override
    public int getCapacity() {
        return 240;
    }
}

