/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.tile.IDialEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidDialBlockEntity
extends BlockEntity
implements IDialEntity {
    public FluidStack[] fluids = new FluidStack[0];
    public int[] capacities = new int[0];
    public int extraLines = 0;
    public boolean display = false;

    public FluidDialBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.FLUID_DIAL_ENTITY.get(), pPos, pBlockState);
    }

    public void m_142466_(CompoundTag nbt) {
        ListTag tanks = nbt.m_128437_("tanks", 10);
        this.fluids = new FluidStack[tanks.size()];
        this.capacities = new int[tanks.size()];
        if (tanks.size() > 0) {
            for (int i = 0; i < tanks.size(); ++i) {
                CompoundTag tank = tanks.m_128728_(i);
                this.fluids[i] = FluidStack.loadFluidStackFromNBT((CompoundTag)tank);
                this.capacities[i] = tank.m_128451_("capacity");
            }
        }
        if (nbt.m_128441_("more_lines")) {
            this.extraLines = nbt.m_128451_("more_lines");
        }
        if (nbt.m_128441_("display")) {
            this.display = nbt.m_128471_("display");
        }
    }

    public CompoundTag m_5995_() {
        return this.getUpdateTag(100);
    }

    public CompoundTag getUpdateTag(int maxLines) {
        IFluidHandler cap;
        Direction facing;
        BlockEntity blockEntity;
        CompoundTag nbt = super.m_5995_();
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        boolean display = false;
        if (state.m_61138_((Property)BlockStateProperties.f_61372_) && (blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_5484_(facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_), -1))) != null && (cap = (IFluidHandler)blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, facing.m_122424_()).orElse((Object)((IFluidHandler)blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, null).orElse(null)))) != null) {
            ListTag tanks = new ListTag();
            for (int i = 0; i < cap.getTanks() && i + this.extraLines < maxLines; ++i) {
                FluidStack contents = cap.getFluidInTank(i);
                CompoundTag tank = new CompoundTag();
                contents.writeToNBT(tank);
                tank.m_128405_("capacity", cap.getTankCapacity(i));
                tanks.add((Object)tank);
            }
            nbt.m_128365_("tanks", (Tag)tanks);
            if (cap.getTanks() > maxLines) {
                nbt.m_128405_("more_lines", cap.getTanks() - maxLines);
            } else {
                nbt.m_128405_("more_lines", 0);
            }
            display = true;
        }
        nbt.m_128379_("display", display);
        return nbt;
    }

    @Override
    public Packet<ClientGamePacketListener> getUpdatePacket(int maxLines) {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BE -> this.getUpdateTag(maxLines));
    }
}

