/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.power.IEmberCapability;
import com.rekindled.embers.blockentity.EmberReceiverBlockEntity;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.entity.EmberPacketEntity;
import com.rekindled.embers.particle.GlowParticleOptions;
import com.rekindled.embers.particle.SmokeParticleOptions;
import com.rekindled.embers.particle.SparkParticleOptions;
import com.rekindled.embers.particle.StarParticleOptions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class EmberFunnelBlockEntity
extends EmberReceiverBlockEntity {
    public static final int TRANSFER_RATE = 100;

    public EmberFunnelBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.EMBER_FUNNEL_ENTITY.get(), pPos, pBlockState);
        this.capability.setEmberCapacity(2000.0);
        this.capability.setEmber(0.0);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, EmberFunnelBlockEntity blockEntity) {
        IEmberCapability cap;
        ++blockEntity.ticksExisted;
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        BlockEntity attachedTile = level.m_7702_(pos.m_5484_(facing, -1));
        if (blockEntity.ticksExisted % 2L == 0L && attachedTile != null && (cap = (IEmberCapability)attachedTile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, facing).orElse(null)) != null && cap.getEmber() < cap.getEmberCapacity() && blockEntity.capability.getEmber() > 0.0) {
            double added = cap.addAmount(Math.min(100.0, blockEntity.capability.getEmber()), true);
            blockEntity.capability.removeAmount(added, true);
        }
    }

    @Override
    public boolean onReceive(EmberPacketEntity packet) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Direction facing = (Direction)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BlockStateProperties.f_61372_);
            double offX = 0.5 + (double)facing.m_122429_() * 0.5;
            double offY = 0.5 + (double)facing.m_122430_() * 0.5;
            double offZ = 0.5 + (double)facing.m_122431_() * 0.5;
            if (this.capability.getEmber() + packet.value > this.capability.getEmberCapacity()) {
                serverLevel.m_8767_((ParticleOptions)new SparkParticleOptions(GlowParticleOptions.EMBER_COLOR, this.random.nextFloat() * 0.75f + 0.45f), (double)this.m_58899_().m_123341_() + offX, (double)this.m_58899_().m_123342_() + offY, (double)this.m_58899_().m_123343_() + offZ, 5, (double)(0.125f * (this.random.nextFloat() - 0.5f)), (double)(0.125f * this.random.nextFloat()), (double)(0.125f * (this.random.nextFloat() - 0.5f)), 1.0);
                serverLevel.m_8767_((ParticleOptions)new SmokeParticleOptions(SmokeParticleOptions.SMOKE_COLOR, 2.0f + this.random.nextFloat() * 2.0f), (double)this.m_58899_().m_123341_() + offX, (double)this.m_58899_().m_123342_() + offY, (double)this.m_58899_().m_123343_() + offZ, 15, (double)(0.0625f * (this.random.nextFloat() - 0.5f)), (double)(0.0625f + 0.0625f * (this.random.nextFloat() - 0.5f)), (double)(0.0625f * (this.random.nextFloat() - 0.5f)), 1.0);
            } else {
                serverLevel.m_8767_((ParticleOptions)new StarParticleOptions(GlowParticleOptions.EMBER_COLOR, 3.5f + 0.5f * this.random.nextFloat()), (double)this.m_58899_().m_123341_() + offX, (double)this.m_58899_().m_123342_() + offY, (double)this.m_58899_().m_123343_() + offZ, 12, (double)(0.0125f * (this.random.nextFloat() - 0.5f)), (double)(0.0125f * (this.random.nextFloat() - 0.5f)), (double)(0.0125f * (this.random.nextFloat() - 0.5f)), 0.0);
            }
        }
        this.f_58857_.m_7785_(packet.m_20185_(), packet.m_20186_(), packet.m_20189_(), packet.value >= 100.0 ? (SoundEvent)EmbersSounds.EMBER_RECEIVE_BIG.get() : (SoundEvent)EmbersSounds.EMBER_RECEIVE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        return true;
    }
}

