/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.blockentity;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.event.DialInformationEvent;
import com.rekindled.embers.api.power.IEmberCapability;
import com.rekindled.embers.api.tile.IExtraCapabilityInformation;
import com.rekindled.embers.api.tile.IExtraDialInformation;
import com.rekindled.embers.api.tile.IUpgradeable;
import com.rekindled.embers.api.upgrades.UpgradeContext;
import com.rekindled.embers.api.upgrades.UpgradeUtil;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.network.PacketHandler;
import com.rekindled.embers.network.message.MessageCrystalCellGrowFX;
import com.rekindled.embers.particle.GlowParticleOptions;
import com.rekindled.embers.power.DefaultEmberCapability;
import com.rekindled.embers.recipe.IEmberActivationRecipe;
import com.rekindled.embers.recipe.SingleItemContainer;
import com.rekindled.embers.util.Misc;
import com.rekindled.embers.util.sound.ISoundController;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.network.PacketDistributor;

public class CrystalCellBlockEntity
extends BlockEntity
implements ISoundController,
IExtraDialInformation,
IExtraCapabilityInformation,
IUpgradeable {
    public static final int MAX_CAPACITY = 1440000;
    Random random = new Random();
    public long ticksExisted = 0L;
    public float angle = 0.0f;
    public long seed = 0L;
    public double renderCapacity;
    public double renderCapacityLast;
    public IEmberCapability capability = new DefaultEmberCapability(){

        @Override
        public void onContentsChanged() {
            super.onContentsChanged();
            CrystalCellBlockEntity.this.m_6596_();
        }

        @Override
        public boolean acceptsVolatile() {
            return true;
        }
    };
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            CrystalCellBlockEntity.this.m_6596_();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (Misc.getRecipe(CrystalCellBlockEntity.this.cachedRecipe, (RecipeType)RegistryManager.EMBER_ACTIVATION.get(), new SingleItemContainer(stack), CrystalCellBlockEntity.this.f_58857_) != null) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    };
    public LazyOptional<IItemHandler> holder = LazyOptional.of(() -> this.inventory);
    public IEmberActivationRecipe cachedRecipe = null;
    protected List<UpgradeContext> upgrades;
    public static final int SOUND_AMBIENT = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();

    public CrystalCellBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)RegistryManager.CRYSTAL_CELL_ENTITY.get(), pPos, pBlockState);
        this.capability.setEmberCapacity(64000.0);
        this.seed = this.random.nextLong();
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_7918_(-1, 1, -1), this.f_58858_.m_7918_(2, 5, 2));
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.seed = nbt.m_128454_("seed");
        if (nbt.m_128441_("inventory")) {
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
        }
        this.capability.deserializeNBT((Tag)nbt);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128356_("seed", this.seed);
        nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        this.capability.writeToNBT(nbt);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128356_("seed", this.seed);
        this.capability.writeToNBT(nbt);
        return nbt;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void commonTick(Level level, BlockPos pos, BlockState state, CrystalCellBlockEntity blockEntity) {
        boolean cancel;
        blockEntity.upgrades = UpgradeUtil.getUpgrades(level, pos, new Direction[]{Direction.DOWN});
        UpgradeUtil.verifyUpgrades(blockEntity, blockEntity.upgrades);
        if (UpgradeUtil.doTick(blockEntity, blockEntity.upgrades)) {
            return;
        }
        if (level.f_46443_) {
            blockEntity.handleSound();
        }
        ++blockEntity.ticksExisted;
        blockEntity.renderCapacityLast = blockEntity.renderCapacity;
        blockEntity.renderCapacity = blockEntity.renderCapacity < blockEntity.capability.getEmberCapacity() ? (blockEntity.renderCapacity += Math.min(10000.0, blockEntity.capability.getEmberCapacity() - blockEntity.renderCapacity)) : (blockEntity.renderCapacity -= Math.min(10000.0, blockEntity.renderCapacity - blockEntity.capability.getEmberCapacity()));
        if (!blockEntity.inventory.getStackInSlot(0).m_41619_() && blockEntity.ticksExisted % 4L == 0L && !(cancel = UpgradeUtil.doWork(blockEntity, blockEntity.upgrades))) {
            RecipeWrapper wrapper = new RecipeWrapper((IItemHandlerModifiable)blockEntity.inventory);
            blockEntity.cachedRecipe = Misc.getRecipe(blockEntity.cachedRecipe, (RecipeType)RegistryManager.EMBER_ACTIVATION.get(), wrapper, level);
            if (blockEntity.cachedRecipe != null) {
                double emberValue = blockEntity.cachedRecipe.process((Container)wrapper);
                if (!level.f_46443_) {
                    blockEntity.inventory.extractItem(0, 1, false);
                    int maxCapacity = UpgradeUtil.getOtherParameter((BlockEntity)blockEntity, "max_capacity", 1440000, blockEntity.upgrades);
                    if (blockEntity.capability.getEmberCapacity() < (double)maxCapacity) {
                        blockEntity.capability.setEmberCapacity(Math.min((double)maxCapacity, blockEntity.capability.getEmberCapacity() + emberValue * 10.0));
                        blockEntity.m_6596_();
                    }
                    PacketHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(pos)), (Object)new MessageCrystalCellGrowFX(pos, blockEntity.capability.getEmberCapacity()));
                }
            }
        }
        float numLayers = 2.0f + (float)Math.floor(blockEntity.capability.getEmberCapacity() / 120000.0);
        if (level.f_46443_) {
            int i = 0;
            while ((float)i < numLayers / 2.0f) {
                float layerHeight = 0.25f;
                float height = layerHeight * numLayers;
                float xDest = (float)pos.m_123341_() + 0.5f;
                float yDest = (float)pos.m_123342_() + height / 2.0f + 1.5f;
                float zDest = (float)pos.m_123343_() + 0.5f;
                float x = (float)pos.m_123341_() + 0.5f + 2.0f * (blockEntity.random.nextFloat() - 0.5f);
                float z = (float)pos.m_123343_() + 0.5f + 2.0f * (blockEntity.random.nextFloat() - 0.5f);
                float y = (float)pos.m_123342_() + 1.0f;
                level.m_7106_((ParticleOptions)new GlowParticleOptions(GlowParticleOptions.EMBER_COLOR, new Vec3((double)((xDest - x) / 1.0f * blockEntity.random.nextFloat()), (double)((yDest - y) / 1.0f * blockEntity.random.nextFloat()), (double)((zDest - z) / 1.0f * blockEntity.random.nextFloat())), 2.0f), (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
                ++i;
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!(this.f_58859_ || side != null && side != Direction.DOWN)) {
            if (cap == EmbersCapabilities.EMBER_CAPABILITY) {
                return this.capability.getCapability(cap, side);
            }
            if (cap == ForgeCapabilities.ITEM_HANDLER) {
                return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.holder);
            }
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.capability.invalidate();
        this.holder.invalidate();
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_7726_().m_8450_(this.f_58858_);
        }
    }

    @Override
    public void playSound(int id) {
        switch (id) {
            case 1: {
                EmbersSounds.playMachineSound(this, 1, (SoundEvent)EmbersSounds.CRYSTAL_CELL_LOOP.get(), SoundSource.BLOCKS, true, 1.0f, 1.0f, (float)this.f_58858_.m_123341_() + 0.5f, (float)this.f_58858_.m_123342_() - 0.5f, (float)this.f_58858_.m_123343_() + 0.5f);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1;
    }

    @Override
    public void addDialInformation(Direction facing, List<Component> information, String dialType) {
        UpgradeUtil.throwEvent(this, new DialInformationEvent(this, information, dialType), this.upgrades);
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == ForgeCapabilities.ITEM_HANDLER;
    }

    @Override
    public void addCapabilityDescription(List<Component> strings, Capability<?> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.item", (Component)Component.m_237115_((String)"embers.tooltip.goggles.item.ember")));
        }
    }

    @Override
    public boolean isSideUpgradeSlot(Direction face) {
        return face == Direction.DOWN;
    }
}

