/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.block;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.block.PipeBlockBase;
import com.rekindled.embers.blockentity.ItemPipeBlockEntity;
import com.rekindled.embers.blockentity.ItemPipeBlockEntityBase;
import com.rekindled.embers.datagen.EmbersBlockTags;
import com.rekindled.embers.util.Misc;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemPipeBlock
extends PipeBlockBase {
    public ItemPipeBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public boolean connected(Direction direction, BlockState state) {
        return false;
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)RegistryManager.ITEM_PIPE_ENTITY.get()).m_155264_(pPos, pState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? ItemPipeBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)RegistryManager.ITEM_PIPE_ENTITY.get()), ItemPipeBlockEntityBase::clientTick) : ItemPipeBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)RegistryManager.ITEM_PIPE_ENTITY.get()), ItemPipeBlockEntity::serverTick);
    }

    @Override
    public TagKey<Block> getConnectionTag() {
        return EmbersBlockTags.ITEM_PIPE_CONNECTION;
    }

    @Override
    public TagKey<Block> getToggleConnectionTag() {
        return EmbersBlockTags.ITEM_PIPE_CONNECTION_TOGGLEABLE;
    }

    @Override
    public boolean connectToTile(BlockEntity blockEntity, Direction direction) {
        return blockEntity != null && blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).isPresent();
    }

    @Override
    public boolean unclog(BlockEntity blockEntity, Level level, BlockPos pos) {
        if (blockEntity instanceof ItemPipeBlockEntityBase) {
            IItemHandler handler;
            ItemPipeBlockEntityBase pipeEntity = (ItemPipeBlockEntityBase)blockEntity;
            if (pipeEntity.clogged && (handler = (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElse(null)) instanceof IItemHandlerModifiable) {
                Misc.spawnInventoryInWorld(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, handler);
                level.m_46717_(pos, (Block)this);
                ((IItemHandlerModifiable)handler).setStackInSlot(0, ItemStack.f_41583_);
                return true;
            }
        }
        return false;
    }
}

