/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.block;

import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.power.IEmberCapability;
import com.rekindled.embers.block.DialBaseBlock;
import com.rekindled.embers.blockentity.EmberDialBlockEntity;
import com.rekindled.embers.util.DecimalFormats;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EmberDialBlock
extends DialBaseBlock {
    public static final String DIAL_TYPE = "ember";

    public EmberDialBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        IEmberCapability cap;
        BlockEntity blockEntity = level.m_7702_(pos.m_5484_((Direction)state.m_61143_((Property)f_52588_), -1));
        if (blockEntity != null && (cap = (IEmberCapability)blockEntity.getCapability(EmbersCapabilities.EMBER_CAPABILITY, ((Direction)state.m_61143_((Property)f_52588_)).m_122424_()).orElse((Object)((IEmberCapability)blockEntity.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null).orElse(null)))) != null) {
            if (cap.getEmber() >= cap.getEmberCapacity()) {
                return 15;
            }
            return (int)Math.ceil(14.0 * cap.getEmber() / cap.getEmberCapacity());
        }
        return 0;
    }

    @Override
    protected void getBEData(Direction facing, ArrayList<Component> text, BlockEntity blockEntity, int maxLines) {
        if (blockEntity instanceof EmberDialBlockEntity) {
            EmberDialBlockEntity dial = (EmberDialBlockEntity)blockEntity;
            if (dial.display) {
                text.add((Component)EmberDialBlock.formatEmber(dial.ember, dial.capacity));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static MutableComponent formatEmber(double ember, double emberCapacity) {
        DecimalFormat emberFormat = DecimalFormats.getDecimalFormat("embers.decimal_format.ember");
        return Component.m_237110_((String)"embers.tooltip.emberdial.ember", (Object[])new Object[]{emberFormat.format(ember), emberFormat.format(emberCapacity)});
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)RegistryManager.EMBER_DIAL_ENTITY.get()).m_155264_(pPos, pState);
    }

    @Override
    public String getDialType() {
        return DIAL_TYPE;
    }
}

