/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.block;

import com.rekindled.embers.datagen.EmbersBlockTags;
import com.rekindled.embers.util.Misc;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public abstract class ChamberBlockBase
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public SoundType topSound;
    public static final EnumProperty<ChamberConnection> CONNECTION = EnumProperty.m_61587_((String)"connection", ChamberConnection.class);
    protected static final VoxelShape TOP_AABB = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), Block.m_49796_((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0)});

    public ChamberBlockBase(BlockBehaviour.Properties properties, SoundType topSound) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(CONNECTION, (Comparable)((Object)ChamberConnection.BOTTOM))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
        this.topSound = topSound;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            IItemHandler handler;
            if (state.m_61143_(CONNECTION) == ChamberConnection.BOTTOM) {
                BlockState above = level.m_8055_(pos.m_7494_());
                if (above.m_60734_() == this && above.m_61143_(CONNECTION) != ChamberConnection.BOTTOM) {
                    level.m_46961_(pos.m_7494_(), false);
                }
            } else {
                BlockState below = level.m_8055_(pos.m_7495_());
                if (below.m_60734_() == this && below.m_61143_(CONNECTION) == ChamberConnection.BOTTOM) {
                    level.m_46961_(pos.m_7495_(), false);
                }
            }
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity != null && (handler = (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElse(null)) != null) {
                Misc.spawnInventoryInWorld(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, handler);
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public SoundType m_49962_(BlockState state) {
        return state.m_61143_(CONNECTION) == ChamberConnection.BOTTOM ? super.m_49962_(state) : this.topSound;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43725_().m_8055_(context.m_8083_().m_7494_()).m_60629_(context)) {
            return (BlockState)super.m_5573_(context).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.m_61143_(CONNECTION) == ChamberConnection.BOTTOM) {
            BlockState topState = (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(level.m_6425_(pos.m_7494_()).m_76152_() == Fluids.f_76193_));
            ChamberConnection connection = ChamberConnection.TOP;
            for (Direction direction : Misc.horizontals) {
                if (!level.m_8055_(pos.m_7494_().m_121945_(direction)).m_204336_(EmbersBlockTags.CHAMBER_CONNECTION)) continue;
                connection = ChamberConnection.getConnection(direction);
                break;
            }
            level.m_7731_(pos.m_7494_(), (BlockState)topState.m_61124_(CONNECTION, (Comparable)((Object)connection)), 3);
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (state.m_61143_(CONNECTION) != ChamberConnection.BOTTOM && facing.m_122434_() != Direction.Axis.Y) {
            if (((ChamberConnection)((Object)state.m_61143_(ChamberBlockBase.CONNECTION))).direction == facing && !facingState.m_204336_(EmbersBlockTags.CHAMBER_CONNECTION)) {
                return (BlockState)state.m_61124_(CONNECTION, (Comparable)((Object)ChamberConnection.TOP));
            }
            if (facingState.m_204336_(EmbersBlockTags.CHAMBER_CONNECTION)) {
                return (BlockState)state.m_61124_(CONNECTION, (Comparable)((Object)ChamberConnection.getConnection(facing)));
            }
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{BlockStateProperties.f_61362_}).m_61104_(new Property[]{CONNECTION});
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public static enum ChamberConnection implements StringRepresentable
    {
        BOTTOM("bottom", Direction.DOWN),
        TOP("top_none", Direction.UP),
        NORTH("top_north", Direction.NORTH),
        SOUTH("top_south", Direction.SOUTH),
        WEST("top_west", Direction.WEST),
        EAST("top_east", Direction.EAST);

        private final String name;
        public Direction direction;

        private ChamberConnection(String name, Direction direction) {
            this.name = name;
            this.direction = direction;
        }

        public static ChamberConnection getConnection(Direction direction) {
            return ChamberConnection.values()[direction.m_122411_()];
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

