/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers.augment;

import com.rekindled.embers.api.augment.AugmentUtil;
import com.rekindled.embers.augment.AugmentBase;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.particle.SmokeParticleOptions;
import com.rekindled.embers.util.EmberInventoryUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CinderJetAugment
extends AugmentBase {
    public static Map<UUID, Boolean> sprintingClient = new HashMap<UUID, Boolean>();
    public static Map<UUID, Boolean> sprintingServer = new HashMap<UUID, Boolean>();

    public CinderJetAugment(ResourceLocation id) {
        super(id, 2.0);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static Map<UUID, Boolean> getSprinting(Level level) {
        if (level.m_5776_()) {
            return sprintingClient;
        }
        return sprintingServer;
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!entity.m_9236_().m_5776_() || entity == Minecraft.m_91087_().f_91074_) {
                UUID id = entity.m_20148_();
                if (CinderJetAugment.getSprinting(entity.m_9236_()).containsKey(id)) {
                    int level;
                    float dashStrength;
                    if (entity.m_20142_() && !CinderJetAugment.getSprinting(entity.m_9236_()).get(id).booleanValue() && (dashStrength = (float)(2.0 * (Math.atan(0.6 * (double)(level = AugmentUtil.getArmorAugmentLevel((LivingEntity)player, this))) / 1.25))) > 0.0f && entity.m_20096_() && EmberInventoryUtil.getEmberTotal(player) > this.cost) {
                        EmberInventoryUtil.removeEmber(player, this.cost);
                        entity.m_20256_(entity.m_20184_().m_82549_(new Vec3(2.0 * entity.m_20154_().f_82479_ * (double)dashStrength, 0.4, 2.0 * entity.m_20154_().f_82481_ * (double)dashStrength)));
                        entity.m_9236_().m_6269_(player, (Entity)entity, (SoundEvent)EmbersSounds.CINDER_JET.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        Level level2 = entity.m_9236_();
                        if (level2 instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level2;
                            serverLevel.m_8767_((ParticleOptions)SmokeParticleOptions.BIG_SMOKE, entity.m_20185_() - entity.m_20154_().f_82479_ * 0.5, entity.m_20186_() + (double)(entity.m_20206_() / 4.0f), entity.m_20189_() - (double)((float)entity.m_20154_().f_82481_ * 0.5f), 40, 0.1, 0.1, 0.1, 1.0);
                        }
                    }
                    CinderJetAugment.getSprinting(entity.m_9236_()).replace(id, entity.m_20142_());
                } else {
                    CinderJetAugment.getSprinting(entity.m_9236_()).put(id, entity.m_20142_());
                }
            }
        }
    }
}

