/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.logging.LogUtils;
import com.rekindled.embers.ConfigManager;
import com.rekindled.embers.EmbersClientEvents;
import com.rekindled.embers.EmbersEvents;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.power.IEmberCapability;
import com.rekindled.embers.apiimpl.EmbersAPIImpl;
import com.rekindled.embers.augment.ShiftingScalesAugment;
import com.rekindled.embers.augment.WindingGearsAugment;
import com.rekindled.embers.blockentity.render.AlchemyPedestalBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.AlchemyPedestalTopBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.AlchemyTabletBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.AtmosphericBellowsBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.AutomaticHammerBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.BinBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.CatalyticPlugBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.CinderPlinthBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.CopperChargerBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.CrystalCellBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.CrystalSeedBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.DawnstoneAnvilBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.EmberBoreBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.EntropicEnumeratorBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.ExcavationBucketsBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.FieldChartBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.FluidTransferBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.FluidVesselBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.GeologicSeparatorBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.InfernoForgeTopBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.ItemTransferBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.MechanicalPumpBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.MelterTopBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.MithrilBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.MixerCentrifugeBottomBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.MixerCentrifugeTopBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.MnemonicInscriberBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.ReservoirBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.StampBaseBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.StamperBlockEntityRenderer;
import com.rekindled.embers.compat.curios.CuriosCompat;
import com.rekindled.embers.datagen.EmbersBiomeModifiers;
import com.rekindled.embers.datagen.EmbersBlockStates;
import com.rekindled.embers.datagen.EmbersBlockTags;
import com.rekindled.embers.datagen.EmbersConfiguredFeatures;
import com.rekindled.embers.datagen.EmbersDamageTypeTags;
import com.rekindled.embers.datagen.EmbersDamageTypes;
import com.rekindled.embers.datagen.EmbersFluidTags;
import com.rekindled.embers.datagen.EmbersItemModels;
import com.rekindled.embers.datagen.EmbersItemTags;
import com.rekindled.embers.datagen.EmbersLang;
import com.rekindled.embers.datagen.EmbersLootModifiers;
import com.rekindled.embers.datagen.EmbersLootTables;
import com.rekindled.embers.datagen.EmbersPlacedFeatures;
import com.rekindled.embers.datagen.EmbersRecipes;
import com.rekindled.embers.datagen.EmbersSounds;
import com.rekindled.embers.datagen.EmbersStructures;
import com.rekindled.embers.entity.AncientGolemEntity;
import com.rekindled.embers.entity.render.AncientGolemRenderer;
import com.rekindled.embers.entity.render.EmberPacketRenderer;
import com.rekindled.embers.entity.render.EmberProjectileRenderer;
import com.rekindled.embers.entity.render.GlimmerProjectileRenderer;
import com.rekindled.embers.gui.SlateScreen;
import com.rekindled.embers.item.EmberStorageItem;
import com.rekindled.embers.item.TyrfingItem;
import com.rekindled.embers.model.AncientGolemModel;
import com.rekindled.embers.model.AshenArmorModel;
import com.rekindled.embers.network.PacketHandler;
import com.rekindled.embers.particle.AlchemyCircleParticle;
import com.rekindled.embers.particle.GlowParticle;
import com.rekindled.embers.particle.SmokeParticle;
import com.rekindled.embers.particle.SparkParticle;
import com.rekindled.embers.particle.StarParticle;
import com.rekindled.embers.particle.TyrfingParticle;
import com.rekindled.embers.particle.VaporParticle;
import com.rekindled.embers.particle.XRayGlowParticle;
import com.rekindled.embers.recipe.AugmentIngredient;
import com.rekindled.embers.recipe.HeatIngredient;
import com.rekindled.embers.render.EmbersRenderTypes;
import com.rekindled.embers.render.PipeModel;
import com.rekindled.embers.research.ResearchManager;
import com.rekindled.embers.research.capability.IResearchCapability;
import com.rekindled.embers.util.AugmentPredicate;
import com.rekindled.embers.util.DecimalFormats;
import com.rekindled.embers.util.GlowingTextTooltip;
import com.rekindled.embers.util.HeatBarTooltip;
import com.rekindled.embers.util.MatchCurioLootCondition;
import com.rekindled.embers.util.Misc;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterNamedRenderTypesEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.slf4j.Logger;

@Mod(value="embers")
public class Embers {
    public static final String MODID_OLD = "embersrekindled";
    public static final String MODID = "embers";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Embers() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::registerCaps);
        modEventBus.addListener(this::entityAttributes);
        modEventBus.addListener(this::spawnPlacements);
        modEventBus.addListener(this::registerRecipeSerializers);
        EmbersAPIImpl.init();
        RegistryManager.BLOCKS.register(modEventBus);
        RegistryManager.ITEMS.register(modEventBus);
        RegistryManager.FLUIDTYPES.register(modEventBus);
        RegistryManager.FLUIDS.register(modEventBus);
        RegistryManager.ENTITY_TYPES.register(modEventBus);
        RegistryManager.BLOCK_ENTITY_TYPES_NEW.register(modEventBus);
        RegistryManager.BLOCK_ENTITY_TYPES_OLD.register(modEventBus);
        RegistryManager.CREATIVE_TABS.register(modEventBus);
        RegistryManager.PARTICLE_TYPES.register(modEventBus);
        RegistryManager.SOUND_EVENTS.register(modEventBus);
        RegistryManager.RECIPE_TYPES.register(modEventBus);
        RegistryManager.RECIPE_SERIALIZERS.register(modEventBus);
        RegistryManager.LOOT_MODIFIERS.register(modEventBus);
        RegistryManager.MENU_TYPES.register(modEventBus);
        RegistryManager.STRUCTURE_TYPES.register(modEventBus);
        RegistryManager.STRUCTURE_PROCESSOR_TYPES.register(modEventBus);
        EmbersSounds.init();
        ConfigManager.register();
        if (ModList.get().isLoaded("curios")) {
            CuriosCompat.init();
        }
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        PacketHandler.init();
        RegistryManager.init(event);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, ResearchManager::attachCapability);
        MinecraftForge.EVENT_BUS.addListener(ResearchManager::onClone);
        ResearchManager.initResearches();
        MinecraftForge.EVENT_BUS.addListener(EmbersEvents::fixMappings);
        MinecraftForge.EVENT_BUS.addListener(EmbersEvents::onJoin);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, EmbersEvents::onEntityDamaged);
        MinecraftForge.EVENT_BUS.addListener(EmbersEvents::onBlockBreak);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, EmbersEvents::onProjectileFired);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, EmbersEvents::onArrowLoose);
        MinecraftForge.EVENT_BUS.addListener(EmbersEvents::onAnvilUpdate);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, TagsUpdatedEvent.class, e -> Misc.tagItems.clear());
        MinecraftForge.EVENT_BUS.addListener(EmbersEvents::onLevelLoad);
        MinecraftForge.EVENT_BUS.addListener(EmbersEvents::onServerTick);
        MinecraftForge.EVENT_BUS.addListener(EmbersEvents::onExplosion);
    }

    public void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(IEmberCapability.class);
        event.register(IResearchCapability.class);
        event.register(ShiftingScalesAugment.IScalesCapability.class);
    }

    public void entityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)RegistryManager.ANCIENT_GOLEM.get(), AncientGolemEntity.createAttributes().m_22265_());
    }

    public void spawnPlacements(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)RegistryManager.ANCIENT_GOLEM.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.AND);
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        if (event.includeClient()) {
            gen.addProvider(true, (DataProvider)new EmbersLang(output));
            EmbersItemModels itemModels = new EmbersItemModels(output, existingFileHelper);
            gen.addProvider(true, (DataProvider)itemModels);
            gen.addProvider(true, (DataProvider)new EmbersBlockStates(output, existingFileHelper));
            gen.addProvider(true, (DataProvider)new EmbersSounds(output, existingFileHelper));
        }
        if (event.includeServer()) {
            gen.addProvider(true, (DataProvider)new EmbersLootTables(output));
            gen.addProvider(true, (DataProvider)new EmbersRecipes(output));
            EmbersBlockTags blockTags = new EmbersBlockTags(output, lookupProvider, existingFileHelper);
            gen.addProvider(true, (DataProvider)blockTags);
            gen.addProvider(true, (DataProvider)new EmbersItemTags(output, lookupProvider, blockTags.m_274426_(), existingFileHelper));
            gen.addProvider(true, (DataProvider)new EmbersFluidTags(output, lookupProvider, existingFileHelper));
            gen.addProvider(true, (DataProvider)new DatapackBuiltinEntriesProvider(output, lookupProvider, new RegistrySetBuilder().m_254916_(Registries.f_256911_, bootstrap -> EmbersConfiguredFeatures.generate(bootstrap)).m_254916_(Registries.f_256988_, EmbersPlacedFeatures::generate).m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, EmbersBiomeModifiers::generate).m_254916_(Registries.f_268580_, EmbersDamageTypes::generate).m_254916_(Registries.f_257011_, EmbersStructures::generateProcessors).m_254916_(Registries.f_256948_, EmbersStructures::generatePools).m_254916_(Registries.f_256944_, EmbersStructures::generateStructures).m_254916_(Registries.f_256998_, EmbersStructures::generateSets), Set.of(MODID)));
            gen.addProvider(true, (DataProvider)new EmbersDamageTypeTags(output, lookupProvider, existingFileHelper));
            gen.addProvider(true, (DataProvider)new EmbersLootModifiers(output));
        }
    }

    public void registerRecipeSerializers(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.RECIPE_SERIALIZERS)) {
            ItemPredicate.register((ResourceLocation)AugmentPredicate.ID, AugmentPredicate::deserialize);
            CraftingHelper.register((ResourceLocation)new ResourceLocation(MODID, "has_heat"), HeatIngredient.Serializer.INSTANCE);
            CraftingHelper.register((ResourceLocation)new ResourceLocation(MODID, "has_augment"), AugmentIngredient.Serializer.INSTANCE);
        }
        if (event.getRegistryKey().equals((Object)Registries.f_256976_)) {
            event.register(Registries.f_256976_, new ResourceLocation(MODID, "match_curio"), () -> MatchCurioLootCondition.LOOT_CONDITION_TYPE);
        }
    }

    @Mod.EventBusSubscriber(modid="embers", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModEvents {
        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
            modEventBus.addListener(EmbersClientEvents::afterModelBake);
            MinecraftForge.EVENT_BUS.addListener(EmbersClientEvents::onLevelLoad);
            MinecraftForge.EVENT_BUS.addListener(EmbersClientEvents::onClientTick);
            MinecraftForge.EVENT_BUS.addListener(EmbersClientEvents::onMovementInput);
            MinecraftForge.EVENT_BUS.addListener(EmbersClientEvents::onBlockHighlight);
            MinecraftForge.EVENT_BUS.addListener(EmbersClientEvents::onLevelRender);
            MinecraftForge.EVENT_BUS.addListener(EmbersClientEvents::onTooltip);
            event.enqueueWork(() -> MenuScreens.m_96206_((MenuType)((MenuType)RegistryManager.SLATE_MENU.get()), SlateScreen::new));
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)RegistryManager.STEAM.FLUID.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)RegistryManager.STEAM.FLUID_FLOW.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)RegistryManager.DWARVEN_OIL.FLUID.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)RegistryManager.DWARVEN_OIL.FLUID_FLOW.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)RegistryManager.DWARVEN_GAS.FLUID.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)RegistryManager.DWARVEN_GAS.FLUID_FLOW.get()), (RenderType)RenderType.m_110466_());
            event.enqueueWork(() -> ItemProperties.register((Item)((Item)RegistryManager.INFLICTOR_GEM.get()), (ResourceLocation)new ResourceLocation(Embers.MODID, "charged"), (stack, level, entity, seed) -> stack.m_41784_().m_128441_("type") ? 1.0f : 0.0f));
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void overlayRegister(RegisterGuiOverlaysEvent event) {
            event.registerAboveAll("embers_ingame_overlay", EmbersClientEvents.INGAME_OVERLAY);
            event.registerAboveAll("shifting_scales_particles", ShiftingScalesAugment::renderIngameOverlay);
            event.registerAbove(VanillaGuiOverlay.PLAYER_HEALTH.id(), "shifting_scales_hearts", ShiftingScalesAugment::renderHeartsOverlay);
            event.registerBelow(VanillaGuiOverlay.JUMP_BAR.id(), "winding_gears_spring_bottom", WindingGearsAugment::renderSpringUnderlay);
            event.registerAbove(VanillaGuiOverlay.EXPERIENCE_BAR.id(), "winding_gears_spring_top", WindingGearsAugment::renderSpringOverlay);
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        static void addResourceListener(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)new DecimalFormats());
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        static void addParticleProvider(RegisterParticleProvidersEvent event) {
            event.registerSprite((ParticleType)RegistryManager.GLOW_PARTICLE.get(), (ParticleProvider.Sprite)new GlowParticle.Provider());
            event.registerSprite((ParticleType)RegistryManager.STAR_PARTICLE.get(), (ParticleProvider.Sprite)new StarParticle.Provider());
            event.registerSprite((ParticleType)RegistryManager.SPARK_PARTICLE.get(), (ParticleProvider.Sprite)new SparkParticle.Provider());
            event.registerSprite((ParticleType)RegistryManager.SMOKE_PARTICLE.get(), (ParticleProvider.Sprite)new SmokeParticle.Provider());
            event.registerSprite((ParticleType)RegistryManager.VAPOR_PARTICLE.get(), (ParticleProvider.Sprite)new VaporParticle.Provider());
            event.registerSprite((ParticleType)RegistryManager.ALCHEMY_CIRCLE_PARTICLE.get(), (ParticleProvider.Sprite)new AlchemyCircleParticle.Provider());
            event.registerSprite((ParticleType)RegistryManager.TYRFING_PARTICLE.get(), (ParticleProvider.Sprite)new TyrfingParticle.Provider());
            event.registerSprite((ParticleType)RegistryManager.XRAY_GLOW_PARTICLE.get(), (ParticleProvider.Sprite)new XRayGlowParticle.Provider());
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)RegistryManager.EMBER_PACKET.get(), EmberPacketRenderer::new);
            event.registerEntityRenderer((EntityType)RegistryManager.EMBER_PROJECTILE.get(), EmberProjectileRenderer::new);
            event.registerEntityRenderer((EntityType)RegistryManager.GLIMMER_PROJECTILE.get(), GlimmerProjectileRenderer::new);
            event.registerEntityRenderer((EntityType)RegistryManager.ANCIENT_GOLEM.get(), AncientGolemRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.EMBER_BORE_ENTITY.get(), EmberBoreBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.MELTER_TOP_ENTITY.get(), MelterTopBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.FLUID_VESSEL_ENTITY.get(), FluidVesselBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.STAMPER_ENTITY.get(), StamperBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.STAMP_BASE_ENTITY.get(), StampBaseBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.BIN_ENTITY.get(), BinBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.MIXER_CENTRIFUGE_BOTTOM_ENTITY.get(), MixerCentrifugeBottomBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.MIXER_CENTRIFUGE_TOP_ENTITY.get(), MixerCentrifugeTopBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.RESERVOIR_ENTITY.get(), ReservoirBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.CRYSTAL_CELL_ENTITY.get(), CrystalCellBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.GEOLOGIC_SEPARATOR_ENTITY.get(), GeologicSeparatorBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.COPPER_CHARGER_ENTITY.get(), CopperChargerBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.ITEM_TRANSFER_ENTITY.get(), ItemTransferBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.FLUID_TRANSFER_ENTITY.get(), FluidTransferBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.ALCHEMY_PEDESTAL_TOP_ENTITY.get(), AlchemyPedestalTopBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.ALCHEMY_PEDESTAL_ENTITY.get(), AlchemyPedestalBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.ALCHEMY_TABLET_ENTITY.get(), AlchemyTabletBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.MECHANICAL_PUMP_BOTTOM_ENTITY.get(), MechanicalPumpBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.CATALYTIC_PLUG_ENTITY.get(), CatalyticPlugBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.COPPER_CRYSTAL_SEED.BLOCKENTITY.get(), CrystalSeedBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.IRON_CRYSTAL_SEED.BLOCKENTITY.get(), CrystalSeedBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.GOLD_CRYSTAL_SEED.BLOCKENTITY.get(), CrystalSeedBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.LEAD_CRYSTAL_SEED.BLOCKENTITY.get(), CrystalSeedBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.SILVER_CRYSTAL_SEED.BLOCKENTITY.get(), CrystalSeedBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.NICKEL_CRYSTAL_SEED.BLOCKENTITY.get(), CrystalSeedBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.TIN_CRYSTAL_SEED.BLOCKENTITY.get(), CrystalSeedBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.ALUMINUM_CRYSTAL_SEED.BLOCKENTITY.get(), CrystalSeedBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.ZINC_CRYSTAL_SEED.BLOCKENTITY.get(), CrystalSeedBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.PLATINUM_CRYSTAL_SEED.BLOCKENTITY.get(), CrystalSeedBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.URANIUM_CRYSTAL_SEED.BLOCKENTITY.get(), CrystalSeedBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.DAWNSTONE_CRYSTAL_SEED.BLOCKENTITY.get(), CrystalSeedBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.FIELD_CHART_ENTITY.get(), FieldChartBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.CINDER_PLINTH_ENTITY.get(), CinderPlinthBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.DAWNSTONE_ANVIL_ENTITY.get(), DawnstoneAnvilBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.AUTOMATIC_HAMMER_ENTITY.get(), AutomaticHammerBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.INFERNO_FORGE_TOP_ENTITY.get(), InfernoForgeTopBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.MNEMONIC_INSCRIBER_ENTITY.get(), MnemonicInscriberBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.ATMOSPHERIC_BELLOWS_ENTITY.get(), AtmosphericBellowsBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.ENTROPIC_ENUMERATOR_ENTITY.get(), EntropicEnumeratorBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.MITHRIL_BLOCK_ENTITY.get(), MithrilBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)RegistryManager.EXCAVATION_BUCKETS_ENTITY.get(), ExcavationBucketsBlockEntityRenderer::new);
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(AncientGolemRenderer.LAYER_LOCATION, AncientGolemModel::createLayer);
            event.registerLayerDefinition(AshenArmorModel.ASHEN_ARMOR_HEAD, () -> LayerDefinition.m_171565_((MeshDefinition)AshenArmorModel.createHeadMesh(), (int)64, (int)64));
            event.registerLayerDefinition(AshenArmorModel.ASHEN_ARMOR_CHEST, () -> LayerDefinition.m_171565_((MeshDefinition)AshenArmorModel.createChestMesh(), (int)64, (int)64));
            event.registerLayerDefinition(AshenArmorModel.ASHEN_ARMOR_LEGS, () -> LayerDefinition.m_171565_((MeshDefinition)AshenArmorModel.createLegsMesh(), (int)64, (int)64));
            event.registerLayerDefinition(AshenArmorModel.ASHEN_ARMOR_FEET, () -> LayerDefinition.m_171565_((MeshDefinition)AshenArmorModel.createFeetMesh(), (int)64, (int)64));
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        static void registerItemColorHandlers(RegisterColorHandlersEvent.Item event) {
            EmberStorageItem.ColorHandler emberContainerColor = new EmberStorageItem.ColorHandler();
            if (ModList.get().isLoaded("curios")) {
                CuriosCompat.registerColorHandler(event, emberContainerColor);
            }
            event.register((ItemColor)emberContainerColor, new ItemLike[]{(ItemLike)RegistryManager.EMBER_JAR.get(), (ItemLike)RegistryManager.EMBER_CARTRIDGE.get()});
            event.register((ItemColor)new TyrfingItem.ColorHandler(), new ItemLike[]{(ItemLike)RegistryManager.TYRFING.get()});
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        static void registerGeometryLoaders(ModelEvent.RegisterGeometryLoaders event) {
            event.register("pipe", (IGeometryLoader)PipeModel.Loader.INSTANCE);
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        static void registerTooltipComponents(RegisterClientTooltipComponentFactoriesEvent event) {
            event.register(GlowingTextTooltip.class, GlowingTextTooltip.GlowingTextClientTooltip::new);
            event.register(HeatBarTooltip.class, HeatBarTooltip.HeatBarClientTooltip::new);
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void shaderRegistry(RegisterShadersEvent event) throws IOException {
            event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation(Embers.MODID, "position_tex_color_additive"), DefaultVertexFormat.f_85819_), shaderInstance -> {
                EmbersRenderTypes.additiveShader = shaderInstance;
            });
            event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation(Embers.MODID, "rendertype_entity_solid_mithril"), DefaultVertexFormat.f_85812_), shaderInstance -> {
                EmbersRenderTypes.mithrilShader = shaderInstance;
            });
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void renderTypeRegistry(RegisterNamedRenderTypesEvent event) {
            event.register("mithril", RenderType.m_110451_(), EmbersRenderTypes.MITHRIL);
        }
    }
}

