/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.GummyBearModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.client.render.entity.CustomBookEntityRenderer;
import com.github.alexmodguy.alexscaves.client.render.entity.layer.GummyBearHeldMobLayer;
import com.github.alexmodguy.alexscaves.client.render.entity.layer.LicowitchPossessionLayer;
import com.github.alexmodguy.alexscaves.server.entity.living.GummyBearEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class GummyBearRenderer
extends MobRenderer<GummyBearEntity, GummyBearModel>
implements CustomBookEntityRenderer {
    public static final GummyBearModel OUTSIDE_MODEL = new GummyBearModel(0.0f);
    private static final ResourceLocation TEXTURE_RED = new ResourceLocation("alexscaves:textures/entity/gummy_bear_red.png");
    private static final ResourceLocation TEXTURE_GREEN = new ResourceLocation("alexscaves:textures/entity/gummy_bear_green.png");
    private static final ResourceLocation TEXTURE_YELLOW = new ResourceLocation("alexscaves:textures/entity/gummy_bear_yellow.png");
    private static final ResourceLocation TEXTURE_BLUE = new ResourceLocation("alexscaves:textures/entity/gummy_bear_blue.png");
    private static final ResourceLocation TEXTURE_PINK = new ResourceLocation("alexscaves:textures/entity/gummy_bear_pink.png");
    private static final ResourceLocation TEXTURE_INNARDS = new ResourceLocation("alexscaves:textures/entity/gummy_bear_innards.png");
    private boolean sepia = false;

    public GummyBearRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new GummyBearModel(-1.8f), 0.85f);
        this.m_115326_(new LayerOutside());
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, renderManagerIn.m_234598_()));
        this.m_115326_(new GummyBearHeldMobLayer(this));
        this.m_115326_(new LicowitchPossessionLayer(this, new GummyBearModel(0.0f), this::getOutsideTextureLocation));
    }

    protected void scale(GummyBearEntity mob, PoseStack matrixStackIn, float partialTicks) {
        float r = mob.getStomachRed();
        float g = mob.getStomachGreen();
        float b = mob.getStomachBlue();
        float alpha = mob.getStomachAlpha(partialTicks);
        ((GummyBearModel)this.f_115290_).setColor(r, g, b, alpha);
    }

    public ResourceLocation getTextureLocation(GummyBearEntity entity) {
        return TEXTURE_INNARDS;
    }

    @Nullable
    protected RenderType getRenderType(GummyBearEntity gummyBearEntity, boolean notInvisible, boolean renderAsItemCull, boolean outline) {
        ResourceLocation resourcelocation = this.getTextureLocation(gummyBearEntity);
        if (renderAsItemCull) {
            return RenderType.m_110467_((ResourceLocation)resourcelocation);
        }
        if (notInvisible) {
            return this.sepia ? ACRenderTypes.getBookWidget(resourcelocation, true) : RenderType.m_110473_((ResourceLocation)resourcelocation);
        }
        return outline ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }

    public ResourceLocation getOutsideTextureLocation(GummyBearEntity entity) {
        switch (entity.getGummyColor()) {
            case RED: {
                return TEXTURE_RED;
            }
            case GREEN: {
                return TEXTURE_GREEN;
            }
            case YELLOW: {
                return TEXTURE_YELLOW;
            }
            case BLUE: {
                return TEXTURE_BLUE;
            }
            case PINK: {
                return TEXTURE_PINK;
            }
        }
        return TEXTURE_RED;
    }

    @Override
    public void setSepiaFlag(boolean sepiaFlag) {
        this.sepia = sepiaFlag;
    }

    class LayerOutside
    extends RenderLayer<GummyBearEntity, GummyBearModel> {
        public LayerOutside() {
            super((RenderLayerParent)GummyBearRenderer.this);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, GummyBearEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!entitylivingbaseIn.m_20145_()) {
                ((GummyBearModel)this.m_117386_()).m_102624_((EntityModel)OUTSIDE_MODEL);
                OUTSIDE_MODEL.setupAnim(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                OUTSIDE_MODEL.m_7695_(matrixStackIn, bufferIn.m_6299_(GummyBearRenderer.this.sepia ? ACRenderTypes.getBookWidget(GummyBearRenderer.this.getOutsideTextureLocation(entitylivingbaseIn), true) : RenderType.m_110473_((ResourceLocation)GummyBearRenderer.this.getOutsideTextureLocation(entitylivingbaseIn))), packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }
}

